/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.command.argument;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class TitleLandTypeArgument
implements ArgumentType<TitleLandType> {
    private static final List<String> EXAMPLES = Arrays.asList("minestuck:frost", "minestuck:shade");
    public static final String INVALID = "argument.title_land_type.invalid";
    public static final DynamicCommandExceptionType INVALID_TYPE = new DynamicCommandExceptionType(o -> Component.translatable((String)INVALID, (Object[])new Object[]{o}));

    public static TitleLandTypeArgument titleLandType() {
        return new TitleLandTypeArgument();
    }

    public TitleLandType parse(StringReader reader) throws CommandSyntaxException {
        int start2 = reader.getCursor();
        ResourceLocation gristName = ResourceLocation.read((StringReader)reader);
        if (!LandTypes.TITLE_REGISTRY.containsKey(gristName)) {
            reader.setCursor(start2);
            throw INVALID_TYPE.createWithContext((ImmutableStringReader)reader, (Object)gristName.toString());
        }
        return (TitleLandType)LandTypes.TITLE_REGISTRY.get(gristName);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggestResource((Iterable)LandTypes.TITLE_REGISTRY.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static TitleLandType get(CommandContext<CommandSourceStack> context, String id) {
        return (TitleLandType)context.getArgument(id, TitleLandType.class);
    }
}

