/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.computer.ComputerReference;
import com.mraof.minestuck.computer.ISburbComputer;
import java.util.Objects;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

final class BEComputerReference
implements ComputerReference {
    static final MapCodec<BEComputerReference> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GlobalPos.CODEC.fieldOf("pos").forGetter(reference -> reference.location)).apply((Applicative)instance, BEComputerReference::new));
    private final GlobalPos location;

    BEComputerReference(GlobalPos location) {
        this.location = Objects.requireNonNull(location);
    }

    @Override
    public ISburbComputer getComputer(MinecraftServer server) {
        ServerLevel level = server.getLevel(this.location.dimension());
        if (level == null) {
            return null;
        }
        BlockEntity be = level.getBlockEntity(this.location.pos());
        if (be instanceof ISburbComputer) {
            return (ISburbComputer)be;
        }
        return null;
    }

    @Override
    public boolean matches(ISburbComputer computer) {
        if (computer instanceof ComputerBlockEntity) {
            ComputerBlockEntity be = (ComputerBlockEntity)computer;
            return this.location.dimension() == Objects.requireNonNull(be.getLevel()).dimension() && this.location.pos().equals((Object)be.getBlockPos());
        }
        return false;
    }

    @Override
    public boolean isInNether() {
        return this.location.dimension() == Level.NETHER;
    }

    @Override
    public GlobalPos getPosForEditmode() {
        return this.location;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BEComputerReference that = (BEComputerReference)o;
        return this.location.equals((Object)that.location);
    }

    public int hashCode() {
        return Objects.hash(this.location);
    }
}

