/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer;

import com.mraof.minestuck.computer.ProgramType;
import com.mraof.minestuck.util.MSTags;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;

public final class DiskBurnerData
implements ProgramType.Data {
    private final Runnable markDirty;
    private Set<Block> hieroglyphsStored = new HashSet<Block>();
    private boolean hasParadoxInfoStored = false;

    public DiskBurnerData(Runnable markDirty) {
        this.markDirty = markDirty;
    }

    @Override
    public void read(CompoundTag tag) {
        this.hieroglyphsStored = DiskBurnerData.readBlockSet(tag, "hieroglyphsStored");
        this.hasParadoxInfoStored = tag.getBoolean("hasParadoxInfoStored");
    }

    @Override
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        DiskBurnerData.writeBlockSet(tag, "hieroglyphsStored", this.hieroglyphsStored);
        tag.putBoolean("hasParadoxInfoStored", this.hasParadoxInfoStored);
        return tag;
    }

    private static Set<Block> readBlockSet(CompoundTag nbt, String key) {
        return nbt.getList(key, 8).stream().map(Tag::getAsString).flatMap(blockName -> Stream.ofNullable(ResourceLocation.tryParse((String)blockName))).flatMap(blockId -> Stream.ofNullable((Block)BuiltInRegistries.BLOCK.get(blockId))).collect(Collectors.toSet());
    }

    private static void writeBlockSet(CompoundTag nbt, String key, @Nonnull Set<Block> blocks) {
        ListTag listTag = new ListTag();
        for (Block blockIterate : blocks) {
            String blockName = String.valueOf(BuiltInRegistries.BLOCK.getKey((Object)blockIterate));
            listTag.add((Object)StringTag.valueOf((String)blockName));
        }
        nbt.put(key, (Tag)listTag);
    }

    public Set<Block> getHieroglyphsStored() {
        return this.hieroglyphsStored;
    }

    public boolean isHasParadoxInfoStored() {
        return this.hasParadoxInfoStored;
    }

    public boolean hasAllCode() {
        return this.isHasParadoxInfoStored() && this.getHieroglyphsStored().containsAll(MSTags.getBlocksFromTag(MSTags.Blocks.GREEN_HIEROGLYPHS));
    }

    public boolean recordNewInfo(boolean paradoxInfo, Set<Block> recordedBlocks) {
        boolean changed = false;
        if (paradoxInfo && !this.isHasParadoxInfoStored()) {
            this.hasParadoxInfoStored = true;
            changed = true;
        }
        for (Block iterateBlock : recordedBlocks) {
            if (!iterateBlock.defaultBlockState().is(MSTags.Blocks.GREEN_HIEROGLYPHS)) continue;
            changed |= this.getHieroglyphsStored().add(iterateBlock);
        }
        if (changed) {
            this.markDirty.run();
        }
        return changed;
    }
}

