/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer;

import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.computer.ISburbComputer;
import com.mraof.minestuck.computer.ProgramTypes;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public final class ProgramType<D extends Data> {
    private final EventHandler eventHandler;
    private final Function<Runnable, D> dataConstructor;

    public ProgramType(EventHandler eventHandler, Function<Runnable, D> dataConstructor) {
        this.eventHandler = eventHandler;
        this.dataConstructor = dataConstructor;
    }

    public EventHandler eventHandler() {
        return this.eventHandler;
    }

    public D newDataInstance(Runnable markDirty) {
        return (D)((Data)this.dataConstructor.apply(markDirty));
    }

    public String toString() {
        ResourceLocation key = ProgramTypes.REGISTRY.getKey((Object)this);
        return key != null ? key.toString() : "unknown";
    }

    public MutableComponent name() {
        ResourceLocation key = ProgramTypes.REGISTRY.getKey((Object)this);
        return key != null ? Component.translatable((String)("minestuck.program." + key.getPath())) : Component.literal((String)"Unknown Program");
    }

    public static interface EventHandler {
        default public void onDiskInserted(ComputerBlockEntity computer) {
        }

        default public void onLoad(ComputerBlockEntity computer) {
        }

        default public void onClosed(ComputerBlockEntity computer) {
        }
    }

    public static interface Data {
        public void read(CompoundTag var1);

        public CompoundTag write();

        default public CompoundTag writeForSync(ISburbComputer computer, MinecraftServer mcServer) {
            return this.write();
        }
    }

    public static enum EmptyData implements Data
    {
        INSTANCE;


        @Override
        public void read(CompoundTag tag) {
        }

        @Override
        public CompoundTag write() {
            return new CompoundTag();
        }
    }
}

