/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.computer.DiskBurnerData;
import com.mraof.minestuck.computer.ProgramType;
import com.mraof.minestuck.computer.SburbClientData;
import com.mraof.minestuck.computer.SburbServerData;
import com.mraof.minestuck.computer.editmode.EditmodeLocations;
import com.mraof.minestuck.skaianet.ComputerInteractions;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class ProgramTypes {
    public static final ResourceKey<Registry<ProgramType<?>>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)Minestuck.id("program_type"));
    public static final DeferredRegister<ProgramType<?>> REGISTER = DeferredRegister.create(REGISTRY_KEY, (String)"minestuck");
    public static final Registry<ProgramType<?>> REGISTRY = REGISTER.makeRegistry(builder -> builder.sync(true));
    public static final Supplier<ProgramType<ProgramType.EmptyData>> SETTINGS = REGISTER.register("settings", () -> new ProgramType<ProgramType.EmptyData>(Handlers.EMPTY, ignored -> ProgramType.EmptyData.INSTANCE));
    public static final Supplier<ProgramType<DiskBurnerData>> DISK_BURNER = REGISTER.register("disk_burner", () -> new ProgramType<DiskBurnerData>(Handlers.EMPTY, DiskBurnerData::new));
    public static final DeferredHolder<ProgramType<?>, ProgramType<SburbServerData>> SBURB_SERVER = REGISTER.register("sburb_server", () -> new ProgramType<SburbServerData>(Handlers.SERVER, SburbServerData::new));
    public static final DeferredHolder<ProgramType<?>, ProgramType<SburbClientData>> SBURB_CLIENT = REGISTER.register("sburb_client", () -> new ProgramType<SburbClientData>(Handlers.CLIENT, SburbClientData::new));
    public static final Comparator<ProgramType<?>> DISPLAY_ORDER_SORTER = Comparator.comparing(arg_0 -> REGISTRY.getId(arg_0));

    private static final class Handlers {
        static final ProgramType.EventHandler EMPTY = new ProgramType.EventHandler(){};
        static final ProgramType.EventHandler CLIENT = new ProgramType.EventHandler(){

            @Override
            public void onDiskInserted(ComputerBlockEntity computer) {
                EditmodeLocations.addBlockSourceIfValid(computer);
            }

            @Override
            public void onLoad(ComputerBlockEntity computer) {
                EditmodeLocations.addBlockSourceIfValid(computer);
            }

            @Override
            public void onClosed(ComputerBlockEntity computer) {
                Level level = computer.getLevel();
                if (level instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    if (computer.getOwner() != null) {
                        ComputerInteractions.get(level2.getServer()).closeClientConnection(computer);
                        EditmodeLocations.removeBlockSource(level2.getServer(), computer.getOwner(), (ResourceKey<Level>)level2.dimension(), computer.getBlockPos());
                    }
                }
            }
        };
        static final ProgramType.EventHandler SERVER = new ProgramType.EventHandler(){

            @Override
            public void onClosed(ComputerBlockEntity computer) {
                Objects.requireNonNull(computer.getLevel());
                MinecraftServer mcServer = Objects.requireNonNull(computer.getLevel().getServer());
                ComputerInteractions.get(mcServer).closeServerConnection(computer);
            }
        };

        private Handlers() {
        }
    }
}

