/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer;

import com.mraof.minestuck.computer.ISburbComputer;
import com.mraof.minestuck.computer.ProgramType;
import com.mraof.minestuck.skaianet.SburbConnections;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;

public final class SburbServerData
implements ProgramType.Data {
    private final Runnable markDirty;
    @Nullable
    private String eventMessage = null;
    private boolean isOpen;
    private int connectedClient = -1;

    public SburbServerData(Runnable markDirty) {
        this.markDirty = markDirty;
    }

    @Override
    public void read(CompoundTag tag) {
        this.eventMessage = tag.contains("message", 8) ? tag.getString("message") : null;
        this.isOpen = tag.getBoolean("isOpen");
        if (tag.contains("connectedClient", 3)) {
            this.connectedClient = tag.getInt("connectedClient");
        }
    }

    @Override
    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        if (this.eventMessage != null) {
            tag.putString("message", this.eventMessage);
        }
        tag.putBoolean("isOpen", this.isOpen);
        return tag;
    }

    @Override
    public CompoundTag writeForSync(ISburbComputer computer, MinecraftServer mcServer) {
        CompoundTag tag = this.write();
        SburbConnections.get(mcServer).getServerConnection(computer).ifPresent(c -> tag.putInt("connectedClient", c.client().getId()));
        return tag;
    }

    public Optional<String> getEventMessage() {
        return Optional.ofNullable(this.eventMessage);
    }

    public void setEventMessage(String message) {
        this.eventMessage = message;
        this.markDirty.run();
    }

    public void clearEventMessage() {
        this.eventMessage = null;
        this.markDirty.run();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setIsOpen(boolean isOpen) {
        this.isOpen = isOpen;
        this.markDirty.run();
    }

    public OptionalInt getConnectedClientId() {
        if (this.connectedClient != -1) {
            return OptionalInt.of(this.connectedClient);
        }
        return OptionalInt.empty();
    }

    public void setIsConnected() {
        this.markDirty.run();
    }

    public void handleBeingDuplicated() {
        this.eventMessage = null;
        this.isOpen = false;
        this.connectedClient = -1;
        this.markDirty.run();
    }
}

