/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.editmode;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.computer.editmode.DeployList;
import com.mraof.minestuck.network.editmode.ServerEditPackets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public final class ClientDeployList {
    private static List<Entry> entryList;

    public static void load(ServerEditPackets.UpdateDeployList packet, HolderLookup.Provider provider) {
        if (entryList == null) {
            entryList = new ArrayList<Entry>();
        } else {
            entryList.clear();
        }
        ListTag list = packet.data().getList("l", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag tag = list.getCompound(i);
            Entry entry = new Entry();
            entry.item = (ItemStack)ItemStack.parse((HolderLookup.Provider)provider, (Tag)Objects.requireNonNull(tag.get("item"))).orElseThrow();
            entry.index = tag.getInt("i");
            entry.cost = (GristSet.Immutable)GristSet.Codecs.LIST_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("cost")).getOrThrow();
            entry.category = DeployList.EntryLists.values()[tag.getInt("cat")];
            entryList.add(entry);
        }
    }

    public static Entry getEntry(ItemStack stack) {
        stack = DeployList.cleanStack(stack);
        for (Entry entry : entryList) {
            if (!ItemStack.matches((ItemStack)entry.item, (ItemStack)stack)) continue;
            return entry;
        }
        return null;
    }

    public static class Entry {
        private ItemStack item;
        private GristSet.Immutable cost;
        private int index;
        private DeployList.EntryLists category;

        public GristSet getCost() {
            return this.cost;
        }

        public DeployList.EntryLists getCategory() {
            return this.category;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

