/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.editmode;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mraof.minestuck.block.machine.EditmodeDestroyable;
import com.mraof.minestuck.block.machine.MachineBlock;
import com.mraof.minestuck.computer.editmode.ClientDeployList;
import com.mraof.minestuck.computer.editmode.ClientEditHandler;
import com.mraof.minestuck.computer.editmode.ClientEditmodeData;
import com.mraof.minestuck.computer.editmode.EditTools;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.network.editmode.EditmodeDragPackets;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.util.MSAttachments;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.util.MSTags;
import net.minecraft.client.Camera;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4f;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientEditToolDrag {
    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || !player.isAlive() || !ClientEditmodeData.isInEditmode()) {
            return;
        }
        EditTools cap = (EditTools)player.getData(MSAttachments.EDIT_TOOLS);
        ClientEditToolDrag.doRecycleCode(mc, (Player)player, cap);
        ClientEditToolDrag.doReviseCode(mc, (Player)player, cap);
    }

    @SubscribeEvent
    public static void renderWorld(RenderLevelStageEvent event) {
        ClientEditToolDrag.renderOutlines(event);
    }

    private static void cancelDrag(EditTools cap) {
        PacketDistributor.sendToServer((CustomPacketPayload)new EditmodeDragPackets.Reset(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        cap.resetDragTools();
    }

    private static boolean tryBeginDrag(EditTools.ToolMode targetTool, EditTools cap, Player player) {
        BlockHitResult blockHit = ClientEditToolDrag.getPlayerPOVHitResult(player.level(), player);
        if (blockHit.getType() == HitResult.Type.BLOCK) {
            cap.beginDragTools(targetTool, blockHit, player);
            return true;
        }
        return false;
    }

    private static void updateDragPosition(EditTools.ToolMode targetTool, EditTools cap, Player player, KeyMapping toolKey) {
        cap.setEditPos2(ClientEditToolDrag.getSelectionEndPoint(player, cap.getEditReachDistance(), targetTool == EditTools.ToolMode.REVISE));
        PacketDistributor.sendToServer((CustomPacketPayload)new EditmodeDragPackets.Cursor(toolKey.isDown(), cap.getEditPos1(), cap.getEditPos2()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void finishDragging(EditTools.ToolMode targetTool, EditTools cap, Player player) {
        if (targetTool == EditTools.ToolMode.REVISE) {
            PacketDistributor.sendToServer((CustomPacketPayload)new EditmodeDragPackets.Fill(false, cap.getEditPos1(), cap.getEditPos2(), cap.getEditTraceHit(), cap.getEditTraceDirection()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)new EditmodeDragPackets.Destroy(false, cap.getEditPos1(), cap.getEditPos2(), cap.getEditTraceHit(), cap.getEditTraceDirection()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        ClientEditToolDrag.playSoundAndSetParticles(player, targetTool == EditTools.ToolMode.REVISE, cap.getEditPos1(), cap.getEditPos2());
        cap.resetDragTools();
    }

    public static boolean isValidDragToolOrNull(EditTools.ToolMode toolMode) {
        return toolMode == null || ClientEditToolDrag.isValidDragTool(toolMode);
    }

    public static boolean isValidDragTool(EditTools.ToolMode toolMode) {
        return toolMode == EditTools.ToolMode.REVISE || toolMode == EditTools.ToolMode.RECYCLE;
    }

    public static void doReviseCode(Minecraft mc, Player player, EditTools cap) {
        if (cap.getToolMode() != null && cap.getToolMode() != EditTools.ToolMode.REVISE) {
            return;
        }
        KeyMapping toolKey = mc.options.keyUse;
        if (toolKey.isDown() && !ClientEditToolDrag.canEditRevise(player) && (cap.getToolMode() == null || cap.getToolMode() == EditTools.ToolMode.REVISE)) {
            ClientEditToolDrag.cancelDrag(cap);
            return;
        }
        if (toolKey.isDown() && cap.getEditPos1() == null && !ClientEditToolDrag.tryBeginDrag(EditTools.ToolMode.REVISE, cap, player)) {
            return;
        }
        if (cap.getEditPos1() != null) {
            ClientEditToolDrag.updateDragPosition(EditTools.ToolMode.REVISE, cap, player, toolKey);
        }
        if (!toolKey.isDown() && cap.getEditPos1() != null) {
            ClientEditToolDrag.finishDragging(EditTools.ToolMode.REVISE, cap, player);
        }
    }

    public static boolean canEditRevise(Player player) {
        return ClientEditmodeData.isInEditmode() && !Minecraft.getInstance().isPaused() && !player.getMainHandItem().isEmpty() && player.getMainHandItem().getItem() instanceof BlockItem && !ClientEditToolDrag.isBlockDeployable(player);
    }

    public static void doRecycleCode(Minecraft mc, Player player, EditTools cap) {
        if (cap.getToolMode() != null && cap.getToolMode() != EditTools.ToolMode.RECYCLE) {
            return;
        }
        KeyMapping toolKey = mc.options.keyAttack;
        if (toolKey.isDown() && !ClientEditToolDrag.canEditRecycle(player) && (cap.getToolMode() == null || cap.getToolMode() == EditTools.ToolMode.RECYCLE)) {
            ClientEditToolDrag.cancelDrag(cap);
            return;
        }
        if (toolKey.isDown() && cap.getEditPos1() == null && !ClientEditToolDrag.tryBeginDrag(EditTools.ToolMode.RECYCLE, cap, player)) {
            return;
        }
        if (cap.getEditPos1() != null) {
            ClientEditToolDrag.updateDragPosition(EditTools.ToolMode.RECYCLE, cap, player, toolKey);
        }
        if (!toolKey.isDown() && cap.getEditPos1() != null) {
            ClientEditToolDrag.finishDragging(EditTools.ToolMode.RECYCLE, cap, player);
        }
    }

    public static boolean canEditRecycle(Player player) {
        BlockHitResult blockHit = ClientEditToolDrag.getPlayerPOVHitResult(player.level(), player);
        BlockState block = player.level().getBlockState(blockHit.getBlockPos());
        return ClientEditmodeData.isInEditmode() && !Minecraft.getInstance().isPaused() && !(block.getDestroySpeed((BlockGetter)player.level(), blockHit.getBlockPos()) < 0.0f) && !block.is(MSTags.Blocks.EDITMODE_BREAK_BLACKLIST) && !ClientEditToolDrag.isMultiblock(player);
    }

    private static void playSoundAndSetParticles(Player player, boolean fill, BlockPos positionStart, BlockPos positionEnd) {
        ItemStack stack = player.getMainHandItem().isEmpty() ? player.getOffhandItem() : player.getMainHandItem();
        boolean anyBlockEdited = false;
        for (int x = Math.min(positionStart.getX(), positionEnd.getX()); x <= Math.max(positionStart.getX(), positionEnd.getX()); ++x) {
            for (int y = Math.min(positionStart.getY(), positionEnd.getY()); y <= Math.max(positionStart.getY(), positionEnd.getY()); ++y) {
                for (int z = Math.min(positionStart.getZ(), positionEnd.getZ()); z <= Math.max(positionStart.getZ(), positionEnd.getZ()); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!(fill || player.level().getBlockState(pos).isAir() || !ClientPlayerData.getGristCache(ClientPlayerData.CacheSource.EDITMODE).canAfford(ServerEditHandler.blockBreakCost()) && ClientDeployList.getEntry(player.level().getBlockState(pos).getCloneItemStack(null, (LevelReader)player.level(), pos, player)) == null)) {
                        anyBlockEdited = true;
                        player.level().addDestroyBlockEffect(pos, player.level().getBlockState(pos));
                        continue;
                    }
                    if (!fill || !player.level().getBlockState(pos).canBeReplaced() || !ClientPlayerData.getGristCache(ClientPlayerData.CacheSource.EDITMODE).canAfford(ClientEditHandler.itemCost(stack, player.level()))) continue;
                    anyBlockEdited = true;
                }
            }
        }
        if (anyBlockEdited) {
            player.level().playSound(player, positionEnd, fill ? MSSoundEvents.EVENT_EDIT_TOOL_REVISE.get() : MSSoundEvents.EVENT_EDIT_TOOL_RECYCLE.get(), SoundSource.AMBIENT, 1.0f, fill ? 1.0f : 0.85f);
        }
    }

    private static BlockPos getSelectionEndPoint(Player player, double reachDistance, boolean shouldBlockOffset) {
        BlockHitResult blockHit = ClientEditToolDrag.getPlayerPOVHitResult(player.level(), player);
        if (blockHit.getType() == HitResult.Type.MISS) {
            Vec3 eyePosition = player.getEyePosition();
            Vec3 lookDirection = player.getLookAngle();
            Vec3 selectionPosition = eyePosition.add(lookDirection.x * reachDistance, lookDirection.y * reachDistance, lookDirection.z * reachDistance);
            return BlockPos.containing((double)selectionPosition.x, (double)selectionPosition.y, (double)selectionPosition.z);
        }
        if (shouldBlockOffset) {
            return player.level().getBlockState(blockHit.getBlockPos()).canBeReplaced() ? blockHit.getBlockPos() : blockHit.getBlockPos().offset(blockHit.getDirection().getNormal());
        }
        return blockHit.getBlockPos();
    }

    private static boolean isBlockDeployable(Player player) {
        BlockItem blockItem;
        Item item;
        ItemStack stack = player.getMainHandItem();
        return ClientDeployList.getEntry(stack) != null && (item = stack.getItem()) instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof MachineBlock;
    }

    private static boolean isMultiblock(Player player) {
        BlockPos blockLookingAt = ClientEditToolDrag.getPlayerPOVHitResult(player.level(), player).getBlockPos();
        return player.level().getBlockState(blockLookingAt).getBlock() instanceof EditmodeDestroyable;
    }

    private static BlockHitResult getPlayerPOVHitResult(Level level, Player player) {
        float xRot = player.getXRot();
        float yRot = player.getYRot();
        Vec3 eyeVec = player.getEyePosition(1.0f);
        float f2 = Mth.cos((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.sin((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.cos((float)(-xRot * ((float)Math.PI / 180)));
        float yComponent = Mth.sin((float)(-xRot * ((float)Math.PI / 180)));
        float xComponent = f3 * f4;
        float zComponent = f2 * f4;
        double reachDistance = player.getAttributeValue(Attributes.BLOCK_INTERACTION_RANGE);
        Vec3 endVec = eyeVec.add((double)xComponent * reachDistance, (double)yComponent * reachDistance, (double)zComponent * reachDistance);
        return level.clip(new ClipContext(eyeVec, endVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
    }

    public static void renderOutlines(RenderLevelStageEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS && mc.player != null && mc.getCameraEntity() == mc.player && mc.player.isAlive() && ClientEditmodeData.isInEditmode()) {
            LocalPlayer player = mc.player;
            Camera info = event.getCamera();
            EditTools cap = (EditTools)player.getData(MSAttachments.EDIT_TOOLS);
            double d1 = info.getPosition().x;
            double d2 = info.getPosition().y;
            double d3 = info.getPosition().z;
            if (ClientEditToolDrag.isValidDragTool(cap.getToolMode()) && cap.getEditPos1() != null) {
                BlockPos posA = cap.getEditPos1();
                BlockPos posB = cap.getEditPos2();
                if (posB != null) {
                    AABB boundingBox = new AABB((double)Math.min(posA.getX(), posB.getX()), (double)Math.min(posA.getY(), posB.getY()), (double)Math.min(posA.getZ(), posB.getZ()), (double)(Math.max(posA.getX(), posB.getX()) + 1), (double)(Math.max(posA.getY(), posB.getY()) + 1), (double)(Math.max(posA.getZ(), posB.getZ()) + 1)).move(-d1, -d2, -d3).deflate(0.002);
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.lineWidth((float)2.0f);
                    RenderSystem.depthMask((boolean)false);
                    MultiBufferSource.BufferSource renderTypeBuffer = MultiBufferSource.immediate((ByteBufferBuilder)new ByteBufferBuilder(1536));
                    ClientEditToolDrag.drawReviseToolOutline(event.getPoseStack(), renderTypeBuffer.getBuffer((RenderType)RenderType.LINES), Shapes.create((AABB)boundingBox), 0.0, 0.0, 0.0, cap.getToolMode() == EditTools.ToolMode.RECYCLE ? 1.0f : 0.0f, cap.getToolMode() == EditTools.ToolMode.REVISE ? 1.0f : 0.0f, 0.0f, 1.0f);
                    renderTypeBuffer.endBatch();
                    RenderSystem.depthMask((boolean)true);
                    RenderSystem.disableBlend();
                }
            }
        }
    }

    private static void drawReviseToolOutline(PoseStack poseStack, VertexConsumer bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
        PoseStack.Pose pose = poseStack.last();
        Matrix4f matrix4f = pose.pose();
        shapeIn.forAllEdges((startX, startY, startZ, endX, endY, endZ) -> {
            float dX = (float)(endX - startX);
            float dY = (float)(endY - startY);
            float dZ = (float)(endZ - startZ);
            float length = Mth.sqrt((float)(dX * dX + dY * dY + dZ * dZ));
            bufferIn.addVertex(matrix4f, (float)(startX + xIn), (float)(startY + yIn), (float)(startZ + zIn)).setColor(red, green, blue, alpha).setNormal(pose, dX /= length, dY /= length, dZ /= length);
            bufferIn.addVertex(matrix4f, (float)(endX + xIn), (float)(endY + yIn), (float)(endZ + zIn)).setColor(red, green, blue, alpha).setNormal(pose, dX, dY, dZ);
        });
    }
}

