/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.editmode;

import com.mraof.minestuck.client.gui.EditmodeSettingsScreen;
import com.mraof.minestuck.client.util.MSKeyHandler;
import com.mraof.minestuck.computer.editmode.EditmodeLocations;
import com.mraof.minestuck.network.editmode.EditmodeLocationsPacket;
import com.mraof.minestuck.network.editmode.ServerEditPackets;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public final class ClientEditmodeData {
    public static final String ENTERED = "minestuck.editmode.entered";
    private static boolean activated;
    @Nullable
    private static EditmodeLocations locations;
    @Nullable
    private static ResourceKey<Level> clientLand;

    public static boolean isInEditmode() {
        return activated;
    }

    @Nullable
    public static EditmodeLocations getLocations() {
        return locations;
    }

    @Nullable
    public static ResourceKey<Level> getClientLand() {
        return clientLand;
    }

    private static void disable() {
        activated = false;
        locations = null;
        clientLand = null;
    }

    public static void onActivatePacket() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.sendSystemMessage((Component)Component.translatable((String)ENTERED, (Object[])new Object[]{MSKeyHandler.editKey.getTranslatedKeyMessage()}));
        }
        activated = true;
    }

    public static void onExitPacket(ServerEditPackets.Exit ignored) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            player.fallDistance = 0.0f;
        }
        ClientEditmodeData.disable();
    }

    public static void onLocationsPacket(EditmodeLocationsPacket packet) {
        locations = packet.locations();
        clientLand = packet.land().orElse(null);
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof EditmodeSettingsScreen) {
            EditmodeSettingsScreen screen2 = (EditmodeSettingsScreen)screen;
            screen2.recreateTeleportButtons();
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            ClientEditmodeData.disable();
        }
    }
}

