/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.editmode;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.computer.editmode.DeployList;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DeployEntry {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String name;
    private final int tier;
    private final DeployList.IAvailabilityCondition condition;
    private final BiFunction<SburbPlayerData, Level, ItemStack> item;
    private final BiFunction<Boolean, SburbPlayerData, GristSet> grist;
    private final DeployList.EntryLists category;

    DeployEntry(String name, int tier, DeployList.IAvailabilityCondition condition, BiFunction<SburbPlayerData, Level, ItemStack> item, BiFunction<Boolean, SburbPlayerData, GristSet> grist, DeployList.EntryLists entryList) {
        this.name = name;
        this.tier = tier;
        this.condition = condition;
        this.item = item;
        this.grist = grist;
        this.category = entryList;
    }

    public String getName() {
        return this.name;
    }

    public int getTier() {
        return this.tier;
    }

    public DeployList.EntryLists getCategory() {
        return this.category;
    }

    public boolean isAvailable(SburbPlayerData playerData, int tier) {
        return (this.condition == null || this.condition.test(playerData)) && this.tier <= tier && this.getCurrentCost(playerData) != null;
    }

    public ItemStack getItemStack(SburbPlayerData playerData, Level level) {
        return this.item.apply(playerData, level).copy();
    }

    @Nullable
    public GristSet getCurrentCost(SburbPlayerData playerData) {
        boolean usePrimaryCost = !playerData.hasGivenItem(this);
        return this.grist.apply(usePrimaryCost, playerData);
    }

    void tryAddDeployTag(SburbPlayerData playerData, Level level, int tier, ListTag list, int i) {
        if (this.isAvailable(playerData, tier)) {
            ItemStack stack = this.getItemStack(playerData, level);
            GristSet cost = this.getCurrentCost(playerData);
            CompoundTag tag = new CompoundTag();
            tag.put("item", stack.save((HolderLookup.Provider)level.registryAccess()));
            tag.putInt("i", i);
            tag.put("cost", (Tag)GristSet.Codecs.LIST_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)cost.asImmutable()).getOrThrow());
            tag.putInt("cat", this.category.ordinal());
            list.add((Object)tag);
        }
    }
}

