/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.editmode;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.computer.editmode.DeployEntry;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.item.CaptchaCardItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.block.MiniCruxtruderItem;
import com.mraof.minestuck.skaianet.SburbHandler;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.skaianet.SkaianetData;
import com.mraof.minestuck.util.ColorHandler;
import com.mraof.minestuck.world.storage.MSExtraData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class DeployList {
    public static final IAvailabilityCondition HAS_NOT_ENTERED = playerData -> !playerData.hasEntered();
    private static final ArrayList<DeployEntry> allList = new ArrayList();
    private static final ArrayList<DeployEntry> deployList = new ArrayList();
    private static final ArrayList<DeployEntry> atheneumList = new ArrayList();
    private static long lastDay;

    public static void registerItems() {
        DeployList.registerItem("cruxtruder", new ItemStack((ItemLike)MSBlocks.CRUXTRUDER), GristSet.EMPTY, GristTypes.BUILD.get().amount(100L), 0, EntryLists.DEPLOY);
        DeployList.registerItem("totem_lathe", new ItemStack((ItemLike)MSBlocks.TOTEM_LATHE), GristSet.EMPTY, GristTypes.BUILD.get().amount(100L), 0, EntryLists.DEPLOY);
        DeployList.registerItem("artifact_card", GristSet.EMPTY, null, 0, HAS_NOT_ENTERED, (playerData, level) -> CaptchaCardItem.createPunchedCard(SburbHandler.getEntryItem(level, playerData).getItem()), EntryLists.DEPLOY);
        DeployList.registerItem("alchemiter", new ItemStack((ItemLike)MSBlocks.ALCHEMITER), GristSet.EMPTY, GristTypes.BUILD.get().amount(100L), 0, EntryLists.DEPLOY);
        DeployList.registerItem("punch_designix", 0, null, DeployList.item(MSBlocks.PUNCH_DESIGNIX), (Boolean isPrimary, SburbPlayerData playerData) -> playerData.getBaseGrist().amount(4L), EntryLists.DEPLOY);
        DeployList.registerItem("portable_cruxtruder", GristTypes.BUILD.get().amount(200L), 1, DeployList.config(MinestuckConfig.SERVER.portableMachines), (SburbPlayerData playerData, Level level) -> MiniCruxtruderItem.getCruxtruderWithColor(ColorHandler.getColorForPlayer(playerData.playerId(), level)), EntryLists.DEPLOY);
        DeployList.registerItem("portable_punch_designix", GristTypes.BUILD.get().amount(200L), 1, DeployList.config(MinestuckConfig.SERVER.portableMachines), DeployList.item((ItemLike)MSBlocks.MINI_PUNCH_DESIGNIX.get()), EntryLists.DEPLOY);
        DeployList.registerItem("portable_totem_lathe", GristTypes.BUILD.get().amount(200L), 1, DeployList.config(MinestuckConfig.SERVER.portableMachines), DeployList.item((ItemLike)MSBlocks.MINI_TOTEM_LATHE.get()), EntryLists.DEPLOY);
        DeployList.registerItem("portable_alchemiter", GristTypes.BUILD.get().amount(300L), 1, DeployList.config(MinestuckConfig.SERVER.portableMachines), DeployList.item((ItemLike)MSBlocks.MINI_ALCHEMITER.get()), EntryLists.DEPLOY);
        DeployList.registerItem("holopad", new ItemStack((ItemLike)MSBlocks.HOLOPAD.get()), GristTypes.BUILD.get().amount(4000L), 2, EntryLists.DEPLOY);
        DeployList.registerItem("intellibeam_laserstation", new ItemStack((ItemLike)MSBlocks.INTELLIBEAM_LASERSTATION.get()), GristTypes.BUILD.get().amount(100000L), 2, EntryLists.DEPLOY);
        DeployList.registerItem("card_punched_card", GristTypes.BUILD.get().amount(25L), null, 0, DeployList.config(MinestuckConfig.SERVER.deployCard), (playerData, world) -> CaptchaCardItem.createPunchedCard((Item)MSItems.CAPTCHA_CARD.get()), EntryLists.DEPLOY);
        DeployList.registerItem("cobblestone", new ItemStack((ItemLike)Blocks.COBBLESTONE), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("mossy_cobblestone", new ItemStack((ItemLike)Blocks.MOSSY_COBBLESTONE), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("smooth_stone", new ItemStack((ItemLike)Blocks.SMOOTH_STONE), GristTypes.BUILD.get().amount(1L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("stone_bricks", new ItemStack((ItemLike)Blocks.STONE_BRICKS), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("chiseled_stone_bricks", new ItemStack((ItemLike)Blocks.CHISELED_STONE_BRICKS), GristTypes.BUILD.get().amount(1L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("nether_bricks", new ItemStack((ItemLike)Blocks.NETHER_BRICKS), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.TAR.get().amount(1L)), 3, EntryLists.ATHENEUM);
        DeployList.registerItem("chiseled_nether_bricks", new ItemStack((ItemLike)Blocks.CHISELED_NETHER_BRICKS), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.TAR.get().amount(1L)), 4, EntryLists.ATHENEUM);
        DeployList.registerItem("oak_planks", new ItemStack((ItemLike)Blocks.OAK_PLANKS), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("birch_planks", new ItemStack((ItemLike)Blocks.BIRCH_PLANKS), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("spruce_planks", new ItemStack((ItemLike)Blocks.SPRUCE_PLANKS), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("dark_oak_planks", new ItemStack((ItemLike)Blocks.DARK_OAK_PLANKS), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("acacia_planks", new ItemStack((ItemLike)Blocks.ACACIA_PLANKS), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("jungle_planks", new ItemStack((ItemLike)Blocks.JUNGLE_PLANKS), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("torch", new ItemStack((ItemLike)Blocks.TORCH), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("ladder", new ItemStack((ItemLike)Blocks.LADDER), GristTypes.BUILD.get().amount(16L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("oak_door", new ItemStack((ItemLike)Blocks.OAK_DOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("birch_door", new ItemStack((ItemLike)Blocks.BIRCH_DOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("spruce_door", new ItemStack((ItemLike)Blocks.SPRUCE_DOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("dark_oak_door", new ItemStack((ItemLike)Blocks.DARK_OAK_DOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("acacia_door", new ItemStack((ItemLike)Blocks.ACACIA_DOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("jungle_door", new ItemStack((ItemLike)Blocks.JUNGLE_DOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("oak_trapdoor", new ItemStack((ItemLike)Blocks.OAK_TRAPDOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("birch_trapdoor", new ItemStack((ItemLike)Blocks.BIRCH_TRAPDOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("spruce_trapdoor", new ItemStack((ItemLike)Blocks.SPRUCE_TRAPDOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("dark_oak_trapdoor", new ItemStack((ItemLike)Blocks.DARK_OAK_TRAPDOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("acacia_trapdoor", new ItemStack((ItemLike)Blocks.ACACIA_TRAPDOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("jungle_trapdoor", new ItemStack((ItemLike)Blocks.JUNGLE_TRAPDOOR), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("glass", new ItemStack((ItemLike)Blocks.GLASS), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("white_stained_glass", new ItemStack((ItemLike)Blocks.WHITE_STAINED_GLASS), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("orange_stained_glass", new ItemStack((ItemLike)Blocks.ORANGE_STAINED_GLASS), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("magenta_stained_glass", new ItemStack((ItemLike)Blocks.MAGENTA_STAINED_GLASS), GristTypes.BUILD.get().amount(4L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("light_blue_stained_glass", new ItemStack((ItemLike)Blocks.LIGHT_BLUE_STAINED_GLASS), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("yellow_stained_glass", new ItemStack((ItemLike)Blocks.YELLOW_STAINED_GLASS), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("lime_stained_glass", new ItemStack((ItemLike)Blocks.LIME_STAINED_GLASS), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("pink_stained_glass", new ItemStack((ItemLike)Blocks.PINK_STAINED_GLASS), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("gray_stained_glass", new ItemStack((ItemLike)Blocks.GRAY_STAINED_GLASS), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("light_gray_stained_glass", new ItemStack((ItemLike)Blocks.LIGHT_GRAY_STAINED_GLASS), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("cyan_stained_glass", new ItemStack((ItemLike)Blocks.CYAN_STAINED_GLASS), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("purple_stained_glass", new ItemStack((ItemLike)Blocks.PURPLE_STAINED_GLASS), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("blue_stained_glass", new ItemStack((ItemLike)Blocks.BLUE_STAINED_GLASS), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("brown_stained_glass", new ItemStack((ItemLike)Blocks.BROWN_STAINED_GLASS), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("green_stained_glass", new ItemStack((ItemLike)Blocks.GREEN_STAINED_GLASS), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("red_stained_glass", new ItemStack((ItemLike)Blocks.RED_STAINED_GLASS), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("black_stained_glass", new ItemStack((ItemLike)Blocks.BLACK_STAINED_GLASS), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("glass_pane", new ItemStack((ItemLike)Blocks.GLASS_PANE), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("white_stained_glass_pane", new ItemStack((ItemLike)Blocks.WHITE_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("orange_stained_glass_pane", new ItemStack((ItemLike)Blocks.ORANGE_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("magenta_stained_glass_pane", new ItemStack((ItemLike)Blocks.MAGENTA_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(4L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("light_blue_stained_glass_pane", new ItemStack((ItemLike)Blocks.LIGHT_BLUE_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("yellow_stained_glass_pane", new ItemStack((ItemLike)Blocks.YELLOW_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("lime_stained_glass_pane", new ItemStack((ItemLike)Blocks.LIME_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("pink_stained_glass_pane", new ItemStack((ItemLike)Blocks.PINK_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("gray_stained_glass_pane", new ItemStack((ItemLike)Blocks.GRAY_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("light_gray_stained_glass_pane", new ItemStack((ItemLike)Blocks.LIGHT_GRAY_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("cyan_stained_glass_pane", new ItemStack((ItemLike)Blocks.CYAN_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("purple_stained_glass_pane", new ItemStack((ItemLike)Blocks.PURPLE_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("blue_stained_glass_pane", new ItemStack((ItemLike)Blocks.BLUE_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("brown_stained_glass_pane", new ItemStack((ItemLike)Blocks.BROWN_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(3L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("green_stained_glass_pane", new ItemStack((ItemLike)Blocks.GREEN_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("red_stained_glass_pane", new ItemStack((ItemLike)Blocks.RED_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("black_stained_glass_pane", new ItemStack((ItemLike)Blocks.BLACK_STAINED_GLASS_PANE), GristTypes.BUILD.get().amount(2L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("cobblestone_slab", new ItemStack((ItemLike)Blocks.COBBLESTONE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("mossy_cobblestone_slab", new ItemStack((ItemLike)Blocks.MOSSY_COBBLESTONE_SLAB), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("smooth_stone_slab", new ItemStack((ItemLike)Blocks.SMOOTH_STONE_SLAB), GristTypes.BUILD.get().amount(1L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("stone_slab", new ItemStack((ItemLike)Blocks.STONE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("stone_brick_slab", new ItemStack((ItemLike)Blocks.STONE_BRICK_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("nether_brick_slab", new ItemStack((ItemLike)Blocks.NETHER_BRICK_SLAB), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.TAR.get().amount(1L)), 3, EntryLists.ATHENEUM);
        DeployList.registerItem("cobblestone_stairs", new ItemStack((ItemLike)Blocks.COBBLESTONE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("mossy_cobblestone_stairs", new ItemStack((ItemLike)Blocks.MOSSY_COBBLESTONE_STAIRS), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("stone_stairs", new ItemStack((ItemLike)Blocks.STONE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("stone_brick_stairs", new ItemStack((ItemLike)Blocks.STONE_BRICK_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("nether_brick_stairs", new ItemStack((ItemLike)Blocks.NETHER_BRICK_STAIRS), GristSet.of(GristTypes.BUILD.get().amount(2L), GristTypes.TAR.get().amount(2L)), 3, EntryLists.ATHENEUM);
        DeployList.registerItem("cobblestone_wall", new ItemStack((ItemLike)Blocks.COBBLESTONE_WALL), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("mossy_cobblestone_wall", new ItemStack((ItemLike)Blocks.MOSSY_COBBLESTONE_WALL), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("stone_brick_wall", new ItemStack((ItemLike)Blocks.STONE_BRICK_WALL), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("nether_brick_wall", new ItemStack((ItemLike)Blocks.NETHER_BRICK_WALL), GristSet.of(GristTypes.BUILD.get().amount(2L), GristTypes.TAR.get().amount(2L)), 3, EntryLists.ATHENEUM);
        DeployList.registerItem("nether_brick_fence", new ItemStack((ItemLike)Blocks.NETHER_BRICK_FENCE), GristSet.of(GristTypes.BUILD.get().amount(2L), GristTypes.TAR.get().amount(2L)), 3, EntryLists.ATHENEUM);
        DeployList.registerItem("oak_slab", new ItemStack((ItemLike)Blocks.OAK_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("birch_slab", new ItemStack((ItemLike)Blocks.BIRCH_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("spruce_slab", new ItemStack((ItemLike)Blocks.SPRUCE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("dark_oak_slab", new ItemStack((ItemLike)Blocks.DARK_OAK_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("acacia_slab", new ItemStack((ItemLike)Blocks.ACACIA_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("jungle_slab", new ItemStack((ItemLike)Blocks.JUNGLE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("oak_stairs", new ItemStack((ItemLike)Blocks.OAK_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("birch_stairs", new ItemStack((ItemLike)Blocks.BIRCH_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("spruce_stairs", new ItemStack((ItemLike)Blocks.SPRUCE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("dark_oak_stairs", new ItemStack((ItemLike)Blocks.DARK_OAK_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("acacia_stairs", new ItemStack((ItemLike)Blocks.ACACIA_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("jungle_stairs", new ItemStack((ItemLike)Blocks.JUNGLE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("oak_fence", new ItemStack((ItemLike)Blocks.OAK_FENCE), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("birch_fence", new ItemStack((ItemLike)Blocks.BIRCH_FENCE), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("spruce_fence", new ItemStack((ItemLike)Blocks.SPRUCE_FENCE), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("acacia_fence", new ItemStack((ItemLike)Blocks.ACACIA_FENCE), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("dark_oak_fence", new ItemStack((ItemLike)Blocks.DARK_OAK_FENCE), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("jungle_fence", new ItemStack((ItemLike)Blocks.JUNGLE_FENCE), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("oak_log", new ItemStack((ItemLike)Blocks.OAK_LOG), GristTypes.BUILD.get().amount(4L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("birch_log", new ItemStack((ItemLike)Blocks.BIRCH_LOG), GristTypes.BUILD.get().amount(4L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("spruce_log", new ItemStack((ItemLike)Blocks.SPRUCE_LOG), GristTypes.BUILD.get().amount(4L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("dark_oak_log", new ItemStack((ItemLike)Blocks.DARK_OAK_LOG), GristTypes.BUILD.get().amount(4L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("acacia_log", new ItemStack((ItemLike)Blocks.ACACIA_LOG), GristTypes.BUILD.get().amount(4L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("jungle_log", new ItemStack((ItemLike)Blocks.JUNGLE_LOG), GristTypes.BUILD.get().amount(4L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("andesite", new ItemStack((ItemLike)Blocks.ANDESITE), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("diorite", new ItemStack((ItemLike)Blocks.DIORITE), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("granite", new ItemStack((ItemLike)Blocks.GRANITE), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("cobbled_deepslate", new ItemStack((ItemLike)Blocks.COBBLED_DEEPSLATE), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_andesite", new ItemStack((ItemLike)Blocks.POLISHED_ANDESITE), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_diorite", new ItemStack((ItemLike)Blocks.POLISHED_DIORITE), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_granite", new ItemStack((ItemLike)Blocks.POLISHED_GRANITE), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_deepslate", new ItemStack((ItemLike)Blocks.POLISHED_DEEPSLATE), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("deepslate_bricks", new ItemStack((ItemLike)Blocks.DEEPSLATE_BRICKS), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("deepslate_tiles", new ItemStack((ItemLike)Blocks.DEEPSLATE_TILES), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("chiseled_deepslate", new ItemStack((ItemLike)Blocks.CHISELED_DEEPSLATE), GristTypes.BUILD.get().amount(1L), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("andesite_slab", new ItemStack((ItemLike)Blocks.ANDESITE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("diorite_slab", new ItemStack((ItemLike)Blocks.DIORITE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("granite_slab", new ItemStack((ItemLike)Blocks.GRANITE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("cobbled_deepslate_slab", new ItemStack((ItemLike)Blocks.COBBLED_DEEPSLATE_SLAB), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_andesite_slab", new ItemStack((ItemLike)Blocks.POLISHED_ANDESITE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_diorite_slab", new ItemStack((ItemLike)Blocks.POLISHED_DIORITE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_granite_slab", new ItemStack((ItemLike)Blocks.POLISHED_GRANITE_SLAB), GristTypes.BUILD.get().amount(1L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_deepslate_slab", new ItemStack((ItemLike)Blocks.POLISHED_DEEPSLATE_SLAB), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("deepslate_brick_slab", new ItemStack((ItemLike)Blocks.DEEPSLATE_BRICK_SLAB), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("deepslate_tile_slab", new ItemStack((ItemLike)Blocks.DEEPSLATE_TILE_SLAB), GristTypes.BUILD.get().amount(1L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("andesite_stairs", new ItemStack((ItemLike)Blocks.ANDESITE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("diorite_stairs", new ItemStack((ItemLike)Blocks.DIORITE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("granite_stairs", new ItemStack((ItemLike)Blocks.GRANITE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("cobbled_deepslate_stairs", new ItemStack((ItemLike)Blocks.COBBLED_DEEPSLATE_STAIRS), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_andesite_stairs", new ItemStack((ItemLike)Blocks.POLISHED_ANDESITE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_diorite_stairs", new ItemStack((ItemLike)Blocks.POLISHED_DIORITE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_granite_stairs", new ItemStack((ItemLike)Blocks.POLISHED_GRANITE_STAIRS), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_deepslate_stairs", new ItemStack((ItemLike)Blocks.POLISHED_DEEPSLATE_STAIRS), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("deepslate_brick_stairs", new ItemStack((ItemLike)Blocks.DEEPSLATE_BRICK_STAIRS), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("deepslate_tile_stairs", new ItemStack((ItemLike)Blocks.DEEPSLATE_TILE_STAIRS), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("andesite_wall", new ItemStack((ItemLike)Blocks.ANDESITE_WALL), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("diorite_wall", new ItemStack((ItemLike)Blocks.DIORITE_WALL), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("granite_wall", new ItemStack((ItemLike)Blocks.GRANITE_WALL), GristTypes.BUILD.get().amount(2L), 0, EntryLists.ATHENEUM);
        DeployList.registerItem("cobbled_deepslate_wall", new ItemStack((ItemLike)Blocks.COBBLED_DEEPSLATE_WALL), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("polished_deepslate_wall", new ItemStack((ItemLike)Blocks.POLISHED_DEEPSLATE_WALL), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("deepslate_brick_wall", new ItemStack((ItemLike)Blocks.DEEPSLATE_BRICK_WALL), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("deepslate_tile_wall", new ItemStack((ItemLike)Blocks.DEEPSLATE_TILE_WALL), GristTypes.BUILD.get().amount(2L), 1, EntryLists.ATHENEUM);
        DeployList.registerItem("white_concrete", new ItemStack((ItemLike)Blocks.WHITE_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.CHALK.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("orange_concrete", new ItemStack((ItemLike)Blocks.ORANGE_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.AMBER.get().amount(1L), GristTypes.GARNET.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("magenta_concrete", new ItemStack((ItemLike)Blocks.MAGENTA_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.AMETHYST.get().amount(1L), GristTypes.GARNET.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("light_blue_concrete", new ItemStack((ItemLike)Blocks.LIGHT_BLUE_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.CHALK.get().amount(1L), GristTypes.AMETHYST.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("yellow_concrete", new ItemStack((ItemLike)Blocks.YELLOW_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.AMBER.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("lime_concrete", new ItemStack((ItemLike)Blocks.LIME_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.CHALK.get().amount(1L), GristTypes.AMBER.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("pink_concrete", new ItemStack((ItemLike)Blocks.PINK_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.CHALK.get().amount(1L), GristTypes.GARNET.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("gray_concrete", new ItemStack((ItemLike)Blocks.GRAY_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.CHALK.get().amount(1L), GristTypes.TAR.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("light_gray_concrete", new ItemStack((ItemLike)Blocks.LIGHT_GRAY_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.CHALK.get().amount(1L), GristTypes.TAR.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("cyan_concrete", new ItemStack((ItemLike)Blocks.CYAN_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.AMBER.get().amount(1L), GristTypes.AMETHYST.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("purple_concrete", new ItemStack((ItemLike)Blocks.PURPLE_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.GARNET.get().amount(1L), GristTypes.AMETHYST.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("blue_concrete", new ItemStack((ItemLike)Blocks.BLUE_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.AMETHYST.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("brown_concrete", new ItemStack((ItemLike)Blocks.BROWN_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.AMBER.get().amount(1L), GristTypes.IODINE.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("green_concrete", new ItemStack((ItemLike)Blocks.GREEN_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.AMBER.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("red_concrete", new ItemStack((ItemLike)Blocks.RED_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.GARNET.get().amount(1L)), 2, EntryLists.ATHENEUM);
        DeployList.registerItem("black_concrete", new ItemStack((ItemLike)Blocks.BLACK_CONCRETE), GristSet.of(GristTypes.BUILD.get().amount(1L), GristTypes.COBALT.get().amount(1L), GristTypes.TAR.get().amount(1L)), 2, EntryLists.ATHENEUM);
    }

    public static void registerItem(String name, ItemStack stack, GristSet.Immutable cost, int tier, EntryLists entryList) {
        DeployList.registerItem(name, stack, cost, cost, tier, entryList);
    }

    public static void registerItem(String name, ItemStack stack, GristSet.Immutable cost1, GristSet.Immutable cost2, int tier, EntryLists entryList) {
        DeployList.registerItem(name, cost1, cost2, tier, null, (connection, world) -> stack, entryList);
    }

    public static void registerItem(String name, GristSet.Immutable cost, int tier, IAvailabilityCondition condition, BiFunction<SburbPlayerData, Level, ItemStack> item, EntryLists entryList) {
        DeployList.registerItem(name, tier, condition, item, (Boolean isPrimary, SburbPlayerData playerData) -> cost, entryList);
    }

    public static void registerItem(String name, GristSet.Immutable cost1, GristSet.Immutable cost2, int tier, IAvailabilityCondition condition, BiFunction<SburbPlayerData, Level, ItemStack> item, EntryLists entryList) {
        DeployList.registerItem(name, tier, condition, item, (Boolean isPrimary, SburbPlayerData playerData) -> isPrimary != false ? cost1 : cost2, entryList);
    }

    public static void registerItem(String name, int tier, IAvailabilityCondition condition, BiFunction<SburbPlayerData, Level, ItemStack> item, BiFunction<Boolean, SburbPlayerData, GristSet> grist, EntryLists entryList) {
        if (entryList == EntryLists.ALL) {
            throw new IllegalArgumentException("Not allowed to add items to allList directly!");
        }
        if (DeployList.containsEntry(name)) {
            throw new IllegalStateException("Item stack already added to the deploy list: " + name);
        }
        entryList.getList().add(new DeployEntry(name, tier, condition, item, grist, entryList));
        allList.add(new DeployEntry(name, tier, condition, item, grist, entryList));
    }

    public static List<DeployEntry> getItemList(MinecraftServer server, SburbPlayerData playerData) {
        return DeployList.getItemList(server, playerData, EntryLists.ALL);
    }

    public static List<DeployEntry> getItemList(MinecraftServer server, SburbPlayerData playerData, EntryLists entryList) {
        int tier = SburbHandler.availableTier(server, playerData.playerId());
        ArrayList<DeployEntry> itemList = new ArrayList<DeployEntry>();
        for (DeployEntry entry : entryList.getList()) {
            if (!entry.isAvailable(playerData, tier)) continue;
            itemList.add(entry);
        }
        return itemList;
    }

    @Nonnull
    static ItemStack cleanStack(ItemStack stack) {
        if (stack.isEmpty()) {
            return ItemStack.EMPTY;
        }
        stack = stack.copy();
        stack.setCount(1);
        stack.applyComponents(stack.getItem().components());
        return stack;
    }

    public static boolean containsEntry(String name) {
        return DeployList.containsEntry(name, EntryLists.ALL);
    }

    public static boolean containsEntry(String name, EntryLists entryList) {
        return DeployList.getEntryForName(name, entryList) != null;
    }

    public static boolean containsItemStack(ItemStack stack, SburbPlayerData playerData, Level level) {
        return DeployList.containsItemStack(stack, playerData, level, EntryLists.ALL);
    }

    public static boolean containsItemStack(ItemStack stack, SburbPlayerData playerData, Level level, EntryLists entryList) {
        return DeployList.getEntryForItem(stack, playerData, level, entryList) != null;
    }

    public static DeployEntry getEntryForName(String name) {
        return DeployList.getEntryForName(name, EntryLists.ALL);
    }

    public static DeployEntry getEntryForName(String name, EntryLists entryList) {
        for (DeployEntry entry : entryList.getList()) {
            if (!entry.getName().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public static DeployEntry getEntryForItem(ItemStack stack, SburbPlayerData playerData, Level level) {
        return DeployList.getEntryForItem(stack, playerData, level, EntryLists.ALL);
    }

    public static DeployEntry getEntryForItem(ItemStack stack, SburbPlayerData playerData, Level level, EntryLists entryList) {
        stack = DeployList.cleanStack(stack);
        for (DeployEntry entry : entryList.getList()) {
            if (!ItemStack.matches((ItemStack)stack, (ItemStack)entry.getItemStack(playerData, level))) continue;
            return entry;
        }
        return null;
    }

    public static IAvailabilityCondition config(ModConfigSpec.BooleanValue config) {
        return playerData -> (Boolean)config.get();
    }

    public static BiFunction<SburbPlayerData, Level, ItemStack> item(ItemLike item) {
        return (playerData, world) -> new ItemStack(item);
    }

    static CompoundTag getDeployListTag(MinecraftServer server, SburbPlayerData playerData) {
        return DeployList.getDeployListTag(server, playerData, EntryLists.ALL);
    }

    static CompoundTag getDeployListTag(MinecraftServer server, SburbPlayerData playerData, EntryLists entryList) {
        CompoundTag nbt = new CompoundTag();
        ListTag tagList = new ListTag();
        nbt.put("l", (Tag)tagList);
        int tier = SburbHandler.availableTier(server, playerData.playerId());
        for (int i = 0; i < entryList.getList().size(); ++i) {
            DeployEntry entry = entryList.getList().get(i);
            entry.tryAddDeployTag(playerData, (Level)server.getLevel(Level.OVERWORLD), tier, tagList, i);
        }
        return nbt;
    }

    @SubscribeEvent
    public static void serverStarting(ServerStartingEvent event) {
        lastDay = event.getServer().overworld().getGameTime() / 24000L;
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        MinecraftServer server;
        long currentDay;
        if (!((Boolean)MinestuckConfig.SERVER.hardMode.get()).booleanValue() && (currentDay = (server = ServerLifecycleHooks.getCurrentServer()).overworld().getGameTime() / 24000L) != lastDay) {
            lastDay = currentDay;
            SkaianetData.get(server).allPlayerData().forEach(SburbPlayerData::resetGivenItems);
        }
    }

    public static void onConditionsUpdated(MinecraftServer server) {
        MSExtraData.get(server).forEach(EditData::sendGivenItemsToEditor);
    }

    public static List<ItemStack> getEditmodeTools() {
        return Collections.emptyList();
    }

    public static enum EntryLists {
        ALL{

            @Override
            public ArrayList<DeployEntry> getList() {
                return allList;
            }
        }
        ,
        DEPLOY{

            @Override
            public ArrayList<DeployEntry> getList() {
                return deployList;
            }
        }
        ,
        ATHENEUM{

            @Override
            public ArrayList<DeployEntry> getList() {
                return atheneumList;
            }
        };


        public ArrayList<DeployEntry> getList() {
            return new ArrayList<DeployEntry>();
        }
    }

    public static interface IAvailabilityCondition {
        public boolean test(SburbPlayerData var1);
    }
}

