/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.editmode;

import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.computer.editmode.DeployList;
import com.mraof.minestuck.computer.editmode.EditmodeLocations;
import com.mraof.minestuck.entity.DecoyEntity;
import com.mraof.minestuck.network.GristCachePacket;
import com.mraof.minestuck.network.editmode.EditmodeCacheLimitPacket;
import com.mraof.minestuck.network.editmode.ServerEditPackets;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.ActiveConnection;
import com.mraof.minestuck.skaianet.SburbConnections;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.util.MSAttachments;
import com.mraof.minestuck.util.Teleport;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EditData {
    private static final Logger LOGGER = LogManager.getLogger();
    private final DecoyEntity decoy;
    final ActiveConnection activeConnection;
    private final ServerPlayer player;
    private boolean isRecovering;

    EditData(DecoyEntity decoy, ServerPlayer player, ActiveConnection activeConnection) {
        this.decoy = decoy;
        this.player = player;
        this.activeConnection = activeConnection;
    }

    public PlayerIdentifier getTarget() {
        return this.activeConnection.client();
    }

    public SburbPlayerData sburbData() {
        return SburbPlayerData.get(this.getTarget(), this.player.server);
    }

    public EditmodeLocations locations() {
        return (EditmodeLocations)PlayerData.get(this.getTarget(), this.player.server).getData(MSAttachments.EDITMODE_LOCATIONS);
    }

    public GristCache getGristCache() {
        return GristCache.get(this.player.server, this.getTarget());
    }

    public ServerPlayer getEditor() {
        return this.player;
    }

    public DecoyEntity getDecoy() {
        return this.decoy;
    }

    public void sendGristCacheToEditor() {
        GristCachePacket packet = new GristCachePacket(this.getGristCache().getGristSet(), ClientPlayerData.CacheSource.EDITMODE);
        PacketDistributor.sendToPlayer((ServerPlayer)this.getEditor(), (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendCacheLimitToEditor() {
        long limit = Echeladder.get(this.getTarget(), this.player.level()).getGristCapacity();
        PacketDistributor.sendToPlayer((ServerPlayer)this.getEditor(), (CustomPacketPayload)new EditmodeCacheLimitPacket(limit), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void sendGivenItemsToEditor() {
        PacketDistributor.sendToPlayer((ServerPlayer)this.getEditor(), (CustomPacketPayload)new ServerEditPackets.UpdateDeployList(DeployList.getDeployListTag(this.player.server, this.sburbData())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public CompoundTag writeRecoveryData() {
        CompoundTag nbt = new CompoundTag();
        new PlayerRecovery(this.decoy).write(nbt);
        new ConnectionRecovery(this).write(nbt);
        return nbt;
    }

    public static PlayerRecovery readRecovery(CompoundTag nbt) {
        return new PlayerRecovery(nbt);
    }

    public static ConnectionRecovery readExtraRecovery(CompoundTag nbt) {
        if (!nbt.contains("edit_inv", 9)) {
            return null;
        }
        Optional clientResult = IdentifierHandler.load(nbt, "client").result();
        return clientResult.map(client -> new ConnectionRecovery((PlayerIdentifier)client, nbt.getList("edit_inv", 10))).orElse(null);
    }

    void recover() {
        this.isRecovering = true;
        try {
            new ConnectionRecovery(this).recover(this.player.server, this.player);
            new PlayerRecovery(this.decoy).recover(this.player, true);
        }
        finally {
            this.isRecovering = false;
        }
    }

    boolean isRecovering() {
        return this.isRecovering;
    }

    public static class PlayerRecovery {
        private final ResourceKey<Level> dimension;
        private final double posX;
        private final double posY;
        private final double posZ;
        private final float rotationYaw;
        private final float rotationPitch;
        private final GameType gameType;
        private final CompoundTag capabilities;
        private final float health;
        private final CompoundTag foodStats;
        private final ListTag inventory;

        private PlayerRecovery(DecoyEntity decoy) {
            this.dimension = decoy.level().dimension();
            this.posX = decoy.getX();
            this.posY = decoy.getY();
            this.posZ = decoy.getZ();
            this.rotationYaw = decoy.getYRot();
            this.rotationPitch = decoy.getXRot();
            this.gameType = decoy.gameType;
            this.capabilities = decoy.capabilities.copy();
            this.health = decoy.getHealth();
            this.foodStats = decoy.getFoodStatsNBT();
            this.inventory = decoy.inventory.save(new ListTag());
        }

        private PlayerRecovery(CompoundTag nbt) {
            this.dimension = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("dim")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
            this.posX = nbt.getDouble("x");
            this.posY = nbt.getDouble("y");
            this.posZ = nbt.getDouble("z");
            this.rotationYaw = nbt.getFloat("rot_yaw");
            this.rotationPitch = nbt.getFloat("rot_pitch");
            this.gameType = GameType.byId((int)nbt.getInt("game_type"));
            this.capabilities = nbt.getCompound("capabilities");
            this.health = nbt.getFloat("health");
            this.foodStats = nbt.getCompound("food");
            this.inventory = nbt.getList("inv", 10);
        }

        public CompoundTag write(CompoundTag nbt) {
            if (this.dimension != null) {
                ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.dimension.location()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> nbt.put("dim", tag));
            }
            nbt.putDouble("x", this.posX);
            nbt.putDouble("y", this.posY);
            nbt.putDouble("z", this.posZ);
            nbt.putFloat("rot_yaw", this.rotationYaw);
            nbt.putFloat("rot_pitch", this.rotationPitch);
            nbt.putInt("game_type", this.gameType.getId());
            nbt.put("capabilities", (Tag)this.capabilities);
            nbt.putFloat("health", this.health);
            nbt.put("food", (Tag)this.foodStats);
            nbt.put("inv", (Tag)this.inventory);
            return nbt;
        }

        void recover(ServerPlayer player, boolean throwException) {
            player.closeContainer();
            ResourceKey dim = this.dimension;
            if (dim == null) {
                LOGGER.warn("Couldn't load original dimension for player {}. Defaulting to overworld.", (Object)player.getGameProfile().getName());
                dim = Level.OVERWORLD;
            }
            ServerLevel world = player.server.getLevel(dim);
            if (player.level().dimension() != dim && (world == null || Teleport.teleportEntity((Entity)player, world) == null)) {
                if (throwException) {
                    throw new IllegalStateException("Unable to teleport editmode player " + player.getGameProfile().getName() + " to their original dimension with world: " + String.valueOf(world));
                }
                LOGGER.warn("Unable to teleport editmode player {} to their original dimension with world: {}", (Object)player.getGameProfile().getName(), (Object)world);
            }
            player.connection.teleport(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
            player.setGameMode(this.gameType);
            player.getAbilities().loadSaveData(this.capabilities);
            player.onUpdateAbilities();
            player.fallDistance = 0.0f;
            player.setHealth(this.health);
            player.getFoodData().readAdditionalSaveData(this.foodStats);
            player.getInventory().load(this.inventory);
        }
    }

    public static final class ConnectionRecovery {
        private final PlayerIdentifier clientPlayer;
        private final ListTag inventory;

        private ConnectionRecovery(EditData data) {
            this(data.getTarget(), data.player.getInventory().save(new ListTag()));
        }

        private ConnectionRecovery(PlayerIdentifier client, ListTag editInv) {
            this.clientPlayer = client;
            this.inventory = editInv;
        }

        private void write(CompoundTag nbt) {
            this.clientPlayer.saveToNBT(nbt, "client");
            nbt.put("edit_inv", (Tag)this.inventory);
        }

        public void recover(MinecraftServer mcServer) {
            this.recover(mcServer, null);
        }

        void recover(MinecraftServer mcServer, @Nullable ServerPlayer editPlayer) {
            SburbPlayerData.get(this.clientPlayer, mcServer).putEditmodeInventory(this.inventory);
            if (editPlayer != null) {
                SburbConnections.get(mcServer).getActiveConnection(this.clientPlayer).ifPresent(connection -> {
                    connection.lastEditmodePosition = editPlayer.position();
                });
            }
        }
    }
}

