/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.editmode;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public final class EditTools {
    private ToolMode toolMode = null;
    private BlockPos editPos1 = null;
    private BlockPos editPos2 = null;
    private Vec3 editTraceHit = new Vec3(0.0, 0.0, 0.0);
    private Direction editTraceDirection = Direction.NORTH;
    private double editReachDistance = 0.0;
    private boolean isEditDragging = false;
    private UUID editCursorID = null;

    @Nullable
    public ToolMode getToolMode() {
        return this.toolMode;
    }

    @Nullable
    public BlockPos getEditPos1() {
        return this.editPos1;
    }

    @Nullable
    public BlockPos getEditPos2() {
        return this.editPos2;
    }

    @Nonnull
    public Vec3 getEditTraceHit() {
        return this.editTraceHit;
    }

    @Nonnull
    public Direction getEditTraceDirection() {
        return this.editTraceDirection;
    }

    public double getEditReachDistance() {
        return this.editReachDistance;
    }

    @Nullable
    public UUID getEditCursorID() {
        return this.editCursorID;
    }

    public void setToolMode(ToolMode mode) {
        this.toolMode = mode;
    }

    public void setEditPos1(BlockPos pos) {
        this.editPos1 = pos;
    }

    public void setEditPos2(BlockPos pos) {
        this.editPos2 = pos;
    }

    public void setEditTrace(Vec3 hit, Direction direction) {
        this.setEditTraceHit(hit);
        this.setEditTraceDirection(direction);
    }

    private void setEditTraceHit(Vec3 hit) {
        this.editTraceHit = hit;
    }

    private void setEditTraceDirection(Direction direction) {
        this.editTraceDirection = direction;
    }

    public void setEditReachDistance(double reachDistance) {
        this.editReachDistance = reachDistance;
    }

    public void setEditCursorID(UUID uuid) {
        this.editCursorID = uuid;
    }

    public void beginDragTools(ToolMode toolMode, BlockHitResult blockHit, Player player) {
        this.setToolMode(toolMode);
        if (toolMode == ToolMode.REVISE) {
            this.setEditPos1(player.level().getBlockState(blockHit.getBlockPos()).canBeReplaced() ? blockHit.getBlockPos() : blockHit.getBlockPos().offset(blockHit.getDirection().getNormal()));
        } else {
            this.setEditPos1(blockHit.getBlockPos());
        }
        this.setEditTrace(blockHit.getLocation(), blockHit.getDirection());
        this.setEditReachDistance(blockHit.getLocation().distanceTo(player.getEyePosition()));
    }

    public void resetDragTools() {
        this.setToolMode(null);
        this.setEditPos1(null);
        this.setEditPos2(null);
        this.setEditTrace(new Vec3(0.0, 0.0, 0.0), Direction.NORTH);
        this.setEditReachDistance(0.0);
        this.setEditCursorID(null);
    }

    static enum ToolMode {
        REVISE,
        RECYCLE;

    }
}

