/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.editmode;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.computer.ProgramType;
import com.mraof.minestuck.computer.ProgramTypes;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.network.editmode.EditmodeLocationsPacket;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.util.MSAttachments;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class EditmodeLocations
implements INBTSerializable<CompoundTag> {
    public static final StreamCodec<RegistryFriendlyByteBuf, EditmodeLocations> STREAM_CODEC = StreamCodec.of((encode, locations) -> encode.writeNbt((Tag)locations.serializeNBT((HolderLookup.Provider)encode.registryAccess())), decode -> new EditmodeLocations((HolderLookup.Provider)decode.registryAccess(), decode.readNbt()));
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String REMOVED_LOCATION_MESSAGE = "minestuck.editmode.removed_location";
    private static final int ENTRY_RANGE = 30;
    private final Multimap<ResourceKey<Level>, BlockPos> computers = ArrayListMultimap.create();
    private static final List<BlockPos> ENTRY_POSITIONS = List.of(new BlockPos(0, 80, 0), new BlockPos(0, 120, 0), new BlockPos(0, 160, 0), new BlockPos(0, 200, 0), new BlockPos(0, 240, 0), new BlockPos(0, 280, 0), new BlockPos(0, 320, 0), new BlockPos(0, 360, 0), new BlockPos(0, 400, 0));

    public EditmodeLocations(HolderLookup.Provider provider, CompoundTag tag) {
        this.deserializeNBT(provider, tag);
    }

    public EditmodeLocations() {
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        ListTag listTag = new ListTag();
        for (Map.Entry entry : this.computers.entries()) {
            CompoundTag nbt = new CompoundTag();
            Level.RESOURCE_KEY_CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((ResourceKey)entry.getKey())).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> nbt.put("dim", tag));
            BlockPos pos = (BlockPos)entry.getValue();
            nbt.putInt("x", pos.getX());
            nbt.putInt("y", pos.getY());
            nbt.putInt("z", pos.getZ());
            listTag.add((Object)nbt);
        }
        compoundTag.put("computers", (Tag)listTag);
        return compoundTag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag compoundTag) {
        ListTag locationsTag = compoundTag.getList("computers", 10);
        for (int i = 0; i < locationsTag.size(); ++i) {
            CompoundTag nbt = locationsTag.getCompound(i);
            ResourceKey dimension = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)nbt.get("dim")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
            int posX = nbt.getInt("x");
            int posY = nbt.getInt("y");
            int posZ = nbt.getInt("z");
            this.computers.put((Object)dimension, (Object)new BlockPos(posX, posY, posZ));
        }
    }

    public List<BlockPos> getSortedPositions(@Nonnull ResourceKey<Level> level, @Nullable ResourceKey<Level> land) {
        Stream<Object> entryLocations = level == land ? ENTRY_POSITIONS.stream() : Stream.empty();
        return Stream.concat(this.computers.get(level).stream(), entryLocations).toList();
    }

    public static boolean checkIsValidSourcePos(EditData data, ResourceKey<Level> level, BlockPos pos) {
        PlayerIdentifier owner = data.getTarget();
        ResourceKey<Level> land = data.sburbData().getLandDimensionIfEntered();
        EditmodeLocations locations = (EditmodeLocations)PlayerData.get(owner, data.getEditor().server).getData(MSAttachments.EDITMODE_LOCATIONS);
        if (level == land && ENTRY_POSITIONS.contains(pos)) {
            return true;
        }
        if (!locations.computers.get(level).contains(pos)) {
            return false;
        }
        if (EditmodeLocations.isComputerSourceInvalidFor(data.getEditor().level(), pos, owner)) {
            EditmodeLocations.removeBlockSource(data.getEditor().server, owner, level, pos);
            return false;
        }
        return true;
    }

    public void validateClosestSource(ServerPlayer editPlayer, SburbPlayerData targetData) {
        Level editLevel = editPlayer.level();
        ResourceKey editDimension = editLevel.dimension();
        ResourceKey<Level> land = targetData.getLandDimensionIfEntered();
        this.findRelativelyClosestArea((Player)editPlayer, land).map(Area::center).ifPresent(pos -> {
            if (EditmodeLocations.isComputerSourceInvalidFor(editLevel, pos, targetData.playerId())) {
                EditmodeLocations.removeBlockSource(editPlayer.server, targetData.playerId(), (ResourceKey<Level>)editDimension, pos);
            }
        });
    }

    public static void onEntry(MinecraftServer mcServer, PlayerIdentifier owner) {
        EditmodeLocations.sendLocationsToEditor(mcServer, owner);
    }

    public static void addBlockSourceIfValid(ComputerBlockEntity computer) {
        Level level = computer.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        if (computer.getOwner() == null) {
            return;
        }
        EditmodeLocations locations = (EditmodeLocations)PlayerData.get(computer.getOwner(), (Level)level2).getData(MSAttachments.EDITMODE_LOCATIONS);
        if (locations.computers.containsEntry((Object)level2.dimension(), (Object)computer.getBlockPos())) {
            return;
        }
        if (EditmodeLocations.isComputerSourceInvalid(computer)) {
            return;
        }
        locations.computers.put((Object)level2.dimension(), (Object)computer.getBlockPos());
        EditmodeLocations.sendLocationsToEditor(level2.getServer(), computer.getOwner());
    }

    public static void removeBlockSource(MinecraftServer mcServer, PlayerIdentifier owner, ResourceKey<Level> level, BlockPos pos) {
        EditmodeLocations locations = (EditmodeLocations)PlayerData.get(owner, mcServer).getData(MSAttachments.EDITMODE_LOCATIONS);
        boolean wasRemoved = locations.computers.remove(level, (Object)pos);
        if (wasRemoved) {
            EditmodeLocations.sendLocationsToEditor(mcServer, owner);
            locations.updatePlayerNearRemovedComputerSource(mcServer, owner, level, pos);
        }
    }

    public void limitMovement(Player editPlayer, @Nullable ResourceKey<Level> land) {
        Optional<Area> closestSource = this.findRelativelyClosestArea(editPlayer, land);
        if (closestSource.isEmpty()) {
            return;
        }
        if (EditmodeLocations.isOutsideBounds(editPlayer, closestSource.get())) {
            EditmodeLocations.limitMovement(editPlayer, closestSource.get());
        }
    }

    private static void limitMovement(Player player, Area area) {
        for (Direction direction : Direction.values()) {
            Vec3 directionNormal = Vec3.atLowerCornerOf((Vec3i)direction.getNormal());
            Vec3 distance = player.position().subtract(Vec3.atLowerCornerOf((Vec3i)area.center()));
            double distanceOverBorder = distance.dot(directionNormal) - (double)area.range();
            if (!(distanceOverBorder >= 0.0)) continue;
            player.addDeltaMovement(directionNormal.scale(-distanceOverBorder));
        }
    }

    private static double relativeDistance(Player player, Area area) {
        Vec3 distance = player.position().subtract(Vec3.atLowerCornerOf((Vec3i)area.center()));
        return Math.max(Math.abs(distance.x()), Math.max(Math.abs(distance.y()), Math.abs(distance.z()))) / (double)area.range();
    }

    private Stream<Area> getAreasFor(@Nonnull ResourceKey<Level> level, @Nullable ResourceKey<Level> land) {
        int computerRange = EditmodeLocations.getComputerRange(level == land);
        Stream<Object> entryLocations = level == land ? ENTRY_POSITIONS.stream() : Stream.empty();
        return Stream.concat(this.computers.get(level).stream().map(pos -> new Area((BlockPos)pos, computerRange)), entryLocations.map(pos -> new Area((BlockPos)pos, 30)));
    }

    private static int getComputerRange(boolean isInLand) {
        return isInLand ? (Integer)MinestuckConfig.SERVER.landEditRange.get() : (Integer)MinestuckConfig.SERVER.overworldEditRange.get();
    }

    private boolean isInsideBounds(Player editPlayer, @Nullable ResourceKey<Level> land) {
        return !this.getAreasFor((ResourceKey<Level>)editPlayer.level().dimension(), land).allMatch(area -> EditmodeLocations.isOutsideBounds(editPlayer, area));
    }

    private Optional<Area> findRelativelyClosestArea(Player player, @Nullable ResourceKey<Level> land) {
        return this.getAreasFor((ResourceKey<Level>)player.level().dimension(), land).min(Comparator.comparingDouble(area -> EditmodeLocations.relativeDistance(player, area)));
    }

    private static boolean isOutsideBounds(Player player, Area area) {
        return EditmodeLocations.relativeDistance(player, area) > 1.0;
    }

    private void updatePlayerNearRemovedComputerSource(MinecraftServer mcServer, PlayerIdentifier owner, ResourceKey<Level> level, BlockPos computerPos) {
        EditData data = ServerEditHandler.getData(mcServer, owner);
        if (data == null) {
            return;
        }
        ServerPlayer editPlayer = data.getEditor();
        ResourceKey<Level> land = data.sburbData().getLandDimensionIfEntered();
        if (editPlayer.level().dimension() != level || this.isInsideBounds((Player)editPlayer, land)) {
            return;
        }
        Optional<Area> newAreaOptional = this.findRelativelyClosestArea((Player)editPlayer, land);
        if (newAreaOptional.isEmpty()) {
            return;
        }
        Area newClosestArea = newAreaOptional.get();
        Area removedArea = new Area(computerPos, EditmodeLocations.getComputerRange(editPlayer.level().dimension() == land));
        if (EditmodeLocations.relativeDistance((Player)editPlayer, removedArea) > EditmodeLocations.relativeDistance((Player)editPlayer, newClosestArea)) {
            return;
        }
        editPlayer.sendSystemMessage((Component)Component.translatable((String)REMOVED_LOCATION_MESSAGE));
        BlockPos nextClosestLocationPos = newClosestArea.center();
        editPlayer.teleportTo((double)nextClosestLocationPos.getX() + 0.5, (double)nextClosestLocationPos.getY() + 1.0, (double)nextClosestLocationPos.getZ() + 0.5);
    }

    private static void sendLocationsToEditor(MinecraftServer mcServer, PlayerIdentifier owner) {
        EditData editData = ServerEditHandler.getData(mcServer, owner);
        if (editData != null) {
            EditmodeLocationsPacket.send(editData);
        }
    }

    private static boolean isComputerSourceInvalidFor(Level level, BlockPos pos, PlayerIdentifier owner) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ComputerBlockEntity) {
            ComputerBlockEntity computerBlockEntity = (ComputerBlockEntity)blockEntity;
            return EditmodeLocations.isComputerSourceInvalid(computerBlockEntity) || !owner.equals(computerBlockEntity.getOwner());
        }
        return true;
    }

    private static boolean isComputerSourceInvalid(ComputerBlockEntity computer) {
        return computer.isBrokenOrOff() || !computer.hasExistingProgram((ProgramType)ProgramTypes.SBURB_CLIENT.get());
    }

    public record Area(BlockPos center, int range) {
    }
}

