/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.editmode;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.block.machine.EditmodeDestroyable;
import com.mraof.minestuck.computer.editmode.DeployEntry;
import com.mraof.minestuck.computer.editmode.DeployList;
import com.mraof.minestuck.computer.editmode.EditData;
import com.mraof.minestuck.computer.editmode.EditTools;
import com.mraof.minestuck.computer.editmode.EditmodeLocations;
import com.mraof.minestuck.entity.DecoyEntity;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.ServerCursorEntity;
import com.mraof.minestuck.event.OnEntryEvent;
import com.mraof.minestuck.event.SburbEvent;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.network.editmode.EditmodeLocationsPacket;
import com.mraof.minestuck.network.editmode.ServerEditPackets;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.ActiveConnection;
import com.mraof.minestuck.skaianet.SburbConnections;
import com.mraof.minestuck.skaianet.SburbHandler;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.util.MSAttachments;
import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.util.Teleport;
import com.mraof.minestuck.world.storage.MSExtraData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.EntityTravelToDimensionEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.ItemEntityPickupEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.server.ServerStoppingEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public final class ServerEditHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ArrayList<String> commands = new ArrayList<String>(Arrays.asList("effect", "gamemode", "defaultgamemode", "enchant", "xp", "tp", "spreadplayers", "kill", "clear", "spawnpoint", "setworldspawn", "give"));

    public static void onPlayerExit(Player player) {
        if (!player.level().isClientSide) {
            ServerEditHandler.reset(ServerEditHandler.getData(player));
        }
    }

    @SubscribeEvent
    public static void onDisconnect(SburbEvent.ConnectionClosed event) {
        ServerEditHandler.reset(ServerEditHandler.getData(event.getMinecraftServer(), event.getConnection()));
    }

    @SubscribeEvent
    public static void onEntry(OnEntryEvent event) {
        SburbConnections.get(event.getMcServer()).getActiveConnection(event.getPlayer()).ifPresent(connection -> {
            connection.lastEditmodePosition = null;
        });
    }

    @SubscribeEvent
    public static void onPlayerCloneEvent(PlayerEvent.Clone event) {
        Player player;
        EditData prevData = ServerEditHandler.getData(event.getOriginal());
        if (prevData != null && (player = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            LOGGER.error("Minestuck failed to prevent death or different cloning event for player {}. Applying measure to reduce problems", (Object)event.getEntity().getName().getString());
            MSExtraData data = MSExtraData.get(event.getEntity().level());
            data.removeEditData(prevData);
            data.addEditData(new EditData(prevData.getDecoy(), player2, prevData.activeConnection));
        }
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && ServerEditHandler.isInEditmode(player = (ServerPlayer)livingEntity)) {
            event.setNewDamage(0.0f);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && ServerEditHandler.isInEditmode(player = (ServerPlayer)livingEntity)) {
            event.setCanceled(true);
        }
    }

    public static void reset(EditData data) {
        ServerEditHandler.reset(null, 0.0f, data);
    }

    public static void reset(DamageSource damageSource, float damage, EditData editData) {
        ServerEditHandler.partialReset(damageSource, damage, editData);
        if (editData == null) {
            return;
        }
        MSExtraData data = MSExtraData.get(editData.getEditor().level());
        data.removeEditData(editData);
    }

    private static void partialReset(EditData data) {
        ServerEditHandler.partialReset(null, 0.0f, data);
    }

    private static void partialReset(DamageSource damageSource, float damage, EditData editData) {
        if (editData == null) {
            return;
        }
        ServerPlayer player = editData.getEditor();
        editData.recover();
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ServerEditPackets.Exit(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        editData.getDecoy().markedForDespawn = true;
        if (damageSource != null && damageSource.getDirectEntity() != player) {
            player.hurt(damageSource, damage);
        }
    }

    public static void newServerEditor(ServerPlayer player, PlayerIdentifier computerOwner, PlayerIdentifier computerTarget) {
        if (player.isPassenger()) {
            player.sendSystemMessage((Component)Component.literal((String)"You may not activate editmode while riding something"));
            return;
        }
        Optional<ActiveConnection> connectionOptional = SburbConnections.get(player.getServer()).getCheckedActiveConnection(computerTarget);
        if (connectionOptional.isEmpty()) {
            return;
        }
        ActiveConnection connection = connectionOptional.get();
        if (connection.server().equals(computerOwner) && ServerEditHandler.getData(player.server, connection) == null && !ServerEditHandler.isInEditmode(player)) {
            LOGGER.info("Activating edit mode on player \"{}\", target player: \"{}\".", (Object)player.getName().getString(), (Object)computerTarget);
            SburbPlayerData targetData = SburbPlayerData.get(computerTarget, player.server);
            DecoyEntity decoy = new DecoyEntity((ServerLevel)player.level(), player);
            EditData data = new EditData(decoy, player, connection);
            if (!ServerEditHandler.setPlayerStats(player, targetData, connection)) {
                player.sendSystemMessage((Component)Component.literal((String)"Failed to activate edit mode.").withStyle(ChatFormatting.RED));
                return;
            }
            if (targetData.getEditmodeInventory() != null) {
                player.getInventory().load(targetData.getEditmodeInventory());
            }
            decoy.level().addFreshEntity((Entity)decoy);
            MSExtraData.get(player.level()).addEditData(data);
            data.locations().validateClosestSource(player, targetData);
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ServerEditPackets.Activate(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            data.sendGivenItemsToEditor();
            EditmodeLocationsPacket.send(data);
            data.sendGristCacheToEditor();
            data.sendCacheLimitToEditor();
        }
    }

    static boolean setPlayerStats(ServerPlayer player, SburbPlayerData clientData, ActiveConnection activeConnection) {
        double posZ;
        double posX;
        GlobalPos computerPos = activeConnection.clientComputer().getPosForEditmode();
        ResourceKey landDimension = Objects.requireNonNullElse(clientData.getLandDimensionIfEntered(), computerPos.dimension());
        ServerLevel level = player.server.getLevel(landDimension);
        if (activeConnection.lastEditmodePosition != null) {
            posX = activeConnection.lastEditmodePosition.x;
            posZ = activeConnection.lastEditmodePosition.z;
        } else {
            BlockPos center = clientData.hasEntered() ? new BlockPos(0, 0, 0) : computerPos.pos();
            posX = (double)center.getX() + 0.5;
            posZ = (double)center.getZ() + 0.5;
        }
        double posY = ServerEditHandler.getMotionBlockingY(level, Mth.floor((double)posX), Mth.floor((double)posZ));
        if (Teleport.teleportEntity((Entity)player, level, posX, posY, posZ) == null) {
            return false;
        }
        player.closeContainer();
        player.getInventory().clearContent();
        player.setGameMode(GameType.CREATIVE);
        player.onUpdateAbilities();
        return true;
    }

    private static int getMotionBlockingY(ServerLevel level, int x, int z) {
        return level.getChunk(SectionPos.blockToSectionCoord((int)x), SectionPos.blockToSectionCoord((int)z)).getHeight(Heightmap.Types.MOTION_BLOCKING, x, z) + 1;
    }

    public static void resendEditmodeStatus(ServerPlayer editor) {
        EditData data = ServerEditHandler.getData((Player)editor);
        if (data != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)editor, (CustomPacketPayload)new ServerEditPackets.Activate(), (CustomPacketPayload[])new CustomPacketPayload[0]);
            data.sendGivenItemsToEditor();
            EditmodeLocationsPacket.send(data);
            data.sendGristCacheToEditor();
            data.sendCacheLimitToEditor();
        } else {
            PacketDistributor.sendToPlayer((ServerPlayer)editor, (CustomPacketPayload)new ServerEditPackets.Exit(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static boolean isInEditmode(ServerPlayer player) {
        return ServerEditHandler.getData((Player)player) != null;
    }

    @Nullable
    public static EditData getData(Player editor) {
        return MSExtraData.get(editor.level()).findEditData(editData -> editData.getEditor() == editor);
    }

    @Nullable
    public static EditData getData(MinecraftServer server, ActiveConnection connection) {
        return ServerEditHandler.getData(server, connection.client());
    }

    @Nullable
    public static EditData getData(MinecraftServer server, PlayerIdentifier client) {
        return MSExtraData.get(server).findEditData(editData -> editData.getTarget().equals(client));
    }

    @Nullable
    public static EditData getData(DecoyEntity decoy) {
        return MSExtraData.get(decoy.getCommandSenderWorld()).findEditData(editData -> editData.getDecoy() == decoy);
    }

    @SubscribeEvent
    public static void tickEnd(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        EditData data = ServerEditHandler.getData((Player)player2);
        if (data == null) {
            return;
        }
        SburbPlayerData targetData = data.sburbData();
        EditmodeLocations editmodeLocations = data.locations();
        if (player2.level().getGameTime() % 200L == 0L) {
            editmodeLocations.validateClosestSource(player2, targetData);
        }
        editmodeLocations.limitMovement((Player)player2, targetData.getLandDimensionIfEntered());
        ServerEditHandler.updateInventory(player2, targetData);
        player2.setPortalCooldown();
    }

    @SubscribeEvent
    public static void onTossEvent(ItemTossEvent event) {
        Inventory inventory = event.getPlayer().getInventory();
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EditData data = ServerEditHandler.getData((Player)player2);
            if (data == null) {
                return;
            }
            ItemStack stack = event.getEntity().getItem();
            DeployEntry entry = DeployList.getEntryForItem(stack, data.sburbData(), event.getEntity().level(), DeployList.EntryLists.DEPLOY);
            if (entry != null && !ServerEditHandler.isBlockItem(stack.getItem())) {
                cost = entry.getCurrentCost(data.sburbData());
                if (data.getGristCache().tryTake(cost, GristHelper.EnumSource.SERVER)) {
                    data.sburbData().setHasGivenItem(entry);
                    SburbHandler.onEntryItemsDeployed(player2.getServer(), data.getTarget());
                } else {
                    event.setCanceled(true);
                }
            } else if (ServerEditHandler.isAtheneumCard(stack, event.getEntity().level(), data.sburbData())) {
                cost = GristCostRecipe.findCostForItem(((Item)MSItems.CAPTCHA_CARD.get()).getDefaultInstance(), GristTypes.BUILD.get(), false, player2.level());
                if (cost == null || !data.getGristCache().tryTake(cost, GristHelper.EnumSource.SERVER)) {
                    event.setCanceled(true);
                }
            } else {
                event.setCanceled(true);
            }
            if (event.isCanceled()) {
                event.getEntity().discard();
                AbstractContainerMenu menu = player2.containerMenu;
                if (!menu.getCarried().isEmpty()) {
                    menu.setCarried(ItemStack.EMPTY);
                } else {
                    inventory.setItem(inventory.selected, ItemStack.EMPTY);
                }
            }
        }
    }

    private static boolean isAtheneumCard(ItemStack stack, Level level, SburbPlayerData playerData) {
        EncodedItemComponent encodedItemComponent = (EncodedItemComponent)stack.get(MSItemComponents.ENCODED_ITEM);
        return stack.is(MSItems.CAPTCHA_CARD) && encodedItemComponent != null && DeployList.containsItemStack(encodedItemComponent.asItemStack(), playerData, level, DeployList.EntryLists.ATHENEUM);
    }

    @SubscribeEvent
    public static void onItemPickupEvent(ItemEntityPickupEvent.Pre event) {
        ServerPlayer player;
        Player player2 = event.getPlayer();
        if (player2 instanceof ServerPlayer && ServerEditHandler.isInEditmode(player = (ServerPlayer)player2)) {
            event.setCanPickup(TriState.FALSE);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRightClickBlockControl(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EditData data = ServerEditHandler.getData(event.getEntity());
            if (data == null) {
                return;
            }
            EditTools cap = (EditTools)player2.getData(MSAttachments.EDIT_TOOLS);
            if (!event.getEntity().canInteractWithBlock(event.getPos(), 0.0) || cap.getEditPos1() != null) {
                event.setCanceled(true);
                return;
            }
            Block block = event.getLevel().getBlockState(event.getPos()).getBlock();
            ItemStack stack = event.getEntity().getMainHandItem();
            event.setUseBlock(stack.isEmpty() && (block instanceof DoorBlock || block instanceof TrapDoorBlock || block instanceof FenceGateBlock) ? TriState.TRUE : TriState.FALSE);
            if (event.getUseBlock() == TriState.TRUE) {
                return;
            }
            if (stack.isEmpty() || !ServerEditHandler.isBlockItem(stack.getItem()) || event.getHand().equals((Object)InteractionHand.OFF_HAND)) {
                event.setCanceled(true);
                return;
            }
            SburbPlayerData targetData = data.sburbData();
            ServerEditHandler.cleanStackComponentsIfNotDeployable(stack, targetData, event.getLevel());
            DeployEntry entry = DeployList.getEntryForItem(stack, targetData, event.getEntity().level());
            GristCache gristCache = data.getGristCache();
            if (entry != null) {
                GristSet cost = entry.getCurrentCost(targetData);
                if (!gristCache.canAfford(cost)) {
                    if (cost != null) {
                        event.getEntity().sendSystemMessage(GristCache.createMissingMessage(cost));
                    }
                    event.setCanceled(true);
                }
            } else if (!ServerEditHandler.isBlockItem(stack.getItem()) || !gristCache.canAfford(GristCostRecipe.findCostForItem(stack, null, false, event.getLevel()))) {
                event.setCanceled(true);
            }
            if (event.getUseItem() == TriState.DEFAULT) {
                event.setUseItem(TriState.TRUE);
            }
        }
    }

    static GristSet blockBreakCost() {
        return GristTypes.BUILD.get().amount(1L);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onLeftClickBlockControl(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            EditData data = ServerEditHandler.getData(event.getEntity());
            if (data == null) {
                return;
            }
            EditTools cap = (EditTools)player2.getData(MSAttachments.EDIT_TOOLS);
            if (!event.getEntity().canInteractWithBlock(event.getPos(), 0.0) || cap.getEditPos1() != null) {
                event.setCanceled(true);
                return;
            }
            BlockState block = event.getLevel().getBlockState(event.getPos());
            ItemStack stack = block.getCloneItemStack(null, (LevelReader)event.getLevel(), event.getPos(), event.getEntity());
            DeployEntry entry = DeployList.getEntryForItem(stack, data.sburbData(), event.getLevel());
            if (block.getDestroySpeed((BlockGetter)event.getLevel(), event.getPos()) < 0.0f || block.is(MSTags.Blocks.EDITMODE_BREAK_BLACKLIST) || !data.getGristCache().canAfford(ServerEditHandler.blockBreakCost()) && (Boolean)MinestuckConfig.SERVER.gristRefund.get() == false || entry == null || entry.getCategory() == DeployList.EntryLists.ATHENEUM) {
                event.setCanceled(true);
                return;
            }
            Block block2 = block.getBlock();
            if (block2 instanceof EditmodeDestroyable) {
                EditmodeDestroyable destroyable = (EditmodeDestroyable)block2;
                destroyable.destroyFull(block, event.getLevel(), event.getPos());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onItemUseControl(PlayerInteractEvent.RightClickItem event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && ServerEditHandler.isInEditmode(player = (ServerPlayer)player2)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().level().isClientSide) {
            EditData data = ServerEditHandler.getData(event.getPlayer());
            if (data == null) {
                return;
            }
            BlockState block = event.getLevel().getBlockState(event.getPos());
            ItemStack stack = block.getCloneItemStack(null, (LevelReader)event.getLevel(), event.getPos(), event.getPlayer());
            DeployEntry entry = DeployList.getEntryForItem(stack, data.sburbData(), event.getPlayer().level(), DeployList.EntryLists.ATHENEUM);
            if (block.getDestroySpeed((BlockGetter)event.getLevel(), event.getPos()) < 0.0f || block.is(MSTags.Blocks.EDITMODE_BREAK_BLACKLIST)) {
                event.setCanceled(true);
                return;
            }
            if (!((Boolean)MinestuckConfig.SERVER.gristRefund.get()).booleanValue()) {
                if (entry != null) {
                    data.getGristCache().addWithGutter(entry.getCurrentCost(data.sburbData()), GristHelper.EnumSource.SERVER);
                } else {
                    data.getGristCache().tryTake(ServerEditHandler.blockBreakCost(), GristHelper.EnumSource.SERVER);
                }
            } else {
                GristSet set;
                GristSet gristSet = set = entry != null ? entry.getCurrentCost(data.sburbData()) : GristCostRecipe.findCostForItem(stack, null, false, event.getPlayer().level());
                if (set != null && !set.isEmpty()) {
                    data.getGristCache().addWithGutter(set, GristHelper.EnumSource.SERVER);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void onBlockPlaced(BlockEvent.EntityPlaceEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            SburbPlayerData targetData;
            ServerPlayer player = (ServerPlayer)entity;
            EditData data = ServerEditHandler.getData((Player)player);
            if (data == null) {
                return;
            }
            if (event.isCanceled()) {
                data.sendGivenItemsToEditor();
                return;
            }
            ItemStack stack = player.getMainHandItem();
            DeployEntry entry = DeployList.getEntryForItem(stack, targetData = data.sburbData(), player.level());
            if (entry != null) {
                GristSet cost = entry.getCurrentCost(targetData);
                if (entry.getCategory() == DeployList.EntryLists.DEPLOY) {
                    targetData.setHasGivenItem(entry);
                    SburbHandler.onEntryItemsDeployed(player.server, data.getTarget());
                }
                if (!cost.isEmpty()) {
                    data.getGristCache().tryTake(cost, GristHelper.EnumSource.SERVER);
                }
                if (entry.getCategory() != DeployList.EntryLists.ATHENEUM) {
                    player.getInventory().items.set(player.getInventory().selected, (Object)ItemStack.EMPTY);
                }
            } else {
                GristSet set = GristCostRecipe.findCostForItem(stack, null, false, player.getCommandSenderWorld());
                data.getGristCache().tryTake(set, GristHelper.EnumSource.SERVER);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onAttackEvent(AttackEntityEvent event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && ServerEditHandler.isInEditmode(player = (ServerPlayer)player2)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onInteractEvent(PlayerInteractEvent.EntityInteract event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && ServerEditHandler.isInEditmode(player = (ServerPlayer)player2)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onInteractEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && ServerEditHandler.isInEditmode(player = (ServerPlayer)player2)) {
            event.setCanceled(true);
        }
    }

    public static void updateEditToolsServer(ServerPlayer player, boolean isDragging, BlockPos pos1, BlockPos pos2) {
        if (player == null) {
            throw (NullPointerException)LOGGER.throwing((Throwable)new NullPointerException("Server Player is NULL in updateEditToolsServer()!"));
        }
        if (player.level().isClientSide()) {
            throw (IllegalStateException)LOGGER.throwing((Throwable)new IllegalStateException("Server Level is clientside in updateEditToolsServer()!"));
        }
        EditTools cap = (EditTools)player.getData(MSAttachments.EDIT_TOOLS);
        boolean signX = pos1.getX() < pos2.getX();
        boolean signY = pos1.getY() > pos2.getY();
        boolean signZ = pos1.getZ() < pos2.getZ();
        double posX = pos2.getX() + (signX ? 1 : 0);
        double posY = (double)pos2.getY() + (signY ? -0.1 : 1.0);
        double posZ = pos2.getZ() + (signZ ? 1 : 0);
        boolean flipCursor = signY;
        float cursorLean = 0.0f;
        if (signX && !signZ) {
            cursorLean = 360.0f;
        }
        if (signX && signZ) {
            cursorLean = 90.0f;
        }
        if (!signX && signZ) {
            cursorLean = 180.0f;
        }
        if (!signX && !signZ) {
            cursorLean = 270.0f;
        }
        if (cap.getEditCursorID() == null) {
            cap.setEditCursorID(ServerEditHandler.createCursorEntity(player, new Vec3(posX, posY, posZ), cursorLean, flipCursor));
        } else {
            ServerEditHandler.updateCursorEntity(player, new Vec3(posX, posY, posZ), cursorLean, flipCursor, cap.getEditCursorID());
        }
    }

    public static UUID createCursorEntity(ServerPlayer player, Vec3 startPosition, float cursorLean, boolean flip) {
        ServerCursorEntity cursor = (ServerCursorEntity)MSEntityTypes.SERVER_CURSOR.get().create(player.level());
        if (cursor == null) {
            throw (NullPointerException)LOGGER.throwing((Throwable)new NullPointerException("Server Cursor is null after creation! Something is wrong!"));
        }
        cursor.noPhysics = true;
        cursor.setNoGravity(true);
        cursor.setInvulnerable(true);
        cursor.moveTo(startPosition.x, startPosition.y, startPosition.z, cursorLean - 45.0f, flip ? 135.0f : 45.0f);
        cursor.setYBodyRot(cursorLean - 45.0f);
        cursor.setYHeadRot(cursorLean - 45.0f);
        cursor.setAnimation(ServerCursorEntity.AnimationType.CLICK);
        player.serverLevel().addWithUUID((Entity)cursor);
        if (player.serverLevel().getEntity(cursor.getUUID()) == null) {
            throw new NullPointerException("Server Cursor is null after added to level! Something is wrong!");
        }
        return cursor.getUUID();
    }

    public static void updateCursorEntity(ServerPlayer player, Vec3 newPosition, float cursorLean, boolean flip, UUID uuid) {
        ServerCursorEntity cursor = (ServerCursorEntity)player.serverLevel().getEntity(uuid);
        cursor.moveTo(newPosition.x, newPosition.y, newPosition.z, cursorLean - 45.0f, flip ? 135.0f : 45.0f);
        cursor.setYBodyRot(cursorLean - 45.0f);
        cursor.setYHeadRot(cursorLean - 45.0f);
        cursor.setAnimation(ServerCursorEntity.AnimationType.IDLE);
    }

    public static void removeCursorEntity(ServerPlayer player, boolean rejected) {
        EditTools cap = (EditTools)player.getData(MSAttachments.EDIT_TOOLS);
        if (cap.getEditCursorID() != null) {
            ServerCursorEntity cursor = (ServerCursorEntity)player.serverLevel().getEntity(cap.getEditCursorID());
            cursor.queueRemoval(rejected ? ServerCursorEntity.AnimationType.REJECTED : ServerCursorEntity.AnimationType.CLICK);
        }
        cap.resetDragTools();
    }

    public static void updateInventory(ServerPlayer player, SburbPlayerData playerData) {
        List<DeployEntry> deployList = DeployList.getItemList(player.getServer(), playerData);
        deployList.removeIf(entry -> entry.getCurrentCost(playerData) == null);
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        deployList.forEach(deployEntry -> itemList.add(deployEntry.getItemStack(playerData, player.level())));
        boolean inventoryChanged = false;
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            ItemStack stack = (ItemStack)player.getInventory().items.get(i);
            if (stack.isEmpty()) continue;
            if (!ServerEditHandler.isBlockItem(stack.getItem()) || GristCostRecipe.findCostForItem(stack, null, false, player.getCommandSenderWorld()) == null) {
                if (!ServerEditHandler.isDeployItem(stack, itemList, player.level(), playerData)) {
                    player.getInventory().items.set(i, (Object)ItemStack.EMPTY);
                    inventoryChanged = true;
                }
            } else if (!stack.isComponentsPatchEmpty() && !ServerEditHandler.isDeployItem(stack, itemList, player.level(), playerData)) {
                ServerEditHandler.clearComponentPatches(stack);
                inventoryChanged = true;
            }
            if (stack.getCount() <= 1) continue;
            stack.setCount(1);
            inventoryChanged = true;
        }
        if (inventoryChanged) {
            player.getServer().getPlayerList().sendAllPlayerInfo(player);
        }
    }

    private static boolean isDeployItem(ItemStack stack, List<ItemStack> deployItemList, Level level, SburbPlayerData playerData) {
        if (ServerEditHandler.isAtheneumCard(stack, level, playerData)) {
            return true;
        }
        for (ItemStack deployStack : deployItemList) {
            if (!ItemStack.matches((ItemStack)deployStack, (ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onEntityTeleport(EntityTravelToDimensionEvent event) {
        ServerPlayer player;
        EditData data;
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (data = ServerEditHandler.getData((Player)(player = (ServerPlayer)entity))) != null && !data.isRecovering()) {
            event.setCanceled(true);
        }
    }

    public static boolean isBlockItem(Item item) {
        return item instanceof BlockItem;
    }

    public static void cleanStackComponentsIfNotDeployable(ItemStack stack, SburbPlayerData playerData, Level level) {
        if (!DeployList.containsItemStack(stack, playerData, level, DeployList.EntryLists.DEPLOY) || !ServerEditHandler.isAtheneumCard(stack, level, playerData)) {
            ServerEditHandler.clearComponentPatches(stack);
        }
    }

    private static void clearComponentPatches(ItemStack stack) {
        for (Map.Entry patchEntry : stack.getComponentsPatch().entrySet()) {
            ServerEditHandler.clearComponentPatch(stack, (DataComponentType)patchEntry.getKey());
        }
    }

    private static <T> void clearComponentPatch(ItemStack stack, DataComponentType<T> type) {
        stack.set(type, stack.getPrototype().get(type));
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getEntity();
        UUID id = player.getGameProfile().getId();
        EditData.PlayerRecovery recovery = MSExtraData.get(player.level()).removePlayerRecovery(id);
        if (recovery != null) {
            recovery.recover(player, false);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerEditHandler.onPlayerExit(event.getEntity());
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        MSExtraData.get(event.getServer()).forEachAndClear(ServerEditHandler::partialReset);
    }

    @SubscribeEvent
    public static void serverStarted(ServerStartedEvent event) {
        MSExtraData.get(event.getServer()).recoverConnections(event.getServer());
    }
}

