/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.computer.theme;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.computer.theme.ComputerTheme;
import com.mraof.minestuck.computer.theme.MSComputerThemes;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientReloadListenersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ComputerThemes {
    private static final Logger LOGGER = LogManager.getLogger((String)"minestuck/ComputerThemes");
    public static final String PATH = "minestuck/computer_themes";
    private final Map<ResourceLocation, ComputerTheme> themes;
    private final ComputerTheme.Data defaultThemeData;
    @Nullable
    private static ComputerThemes INSTANCE;

    public ComputerThemes(Map<ResourceLocation, ComputerTheme> themes) {
        this.themes = themes;
        this.defaultThemeData = Optional.ofNullable(themes.get(MSComputerThemes.DEFAULT)).map(ComputerTheme::data).orElse(ComputerTheme.Data.DEFAULT);
    }

    public static ComputerThemes instance() {
        return Objects.requireNonNull(INSTANCE, "Computer themes haven't been loaded yet!");
    }

    public ComputerTheme lookup(ResourceLocation themeId) {
        return Objects.requireNonNullElseGet(this.themes.get(themeId), () -> new ComputerTheme(themeId, this.defaultThemeData));
    }

    public Collection<ComputerTheme> allThemes() {
        return this.themes.values();
    }

    @SubscribeEvent
    public static void registerLoader(RegisterClientReloadListenersEvent event) {
        event.registerReloadListener((PreparableReloadListener)new Loader());
    }

    private static final class Loader
    extends SimpleJsonResourceReloadListener {
        private static final Gson GSON = new GsonBuilder().create();

        Loader() {
            super(GSON, ComputerThemes.PATH);
        }

        protected void apply(Map<ResourceLocation, JsonElement> jsonEntries, ResourceManager resourceManager, ProfilerFiller profiler) {
            ImmutableMap.Builder computerThemes = ImmutableMap.builder();
            for (Map.Entry<ResourceLocation, JsonElement> entry : jsonEntries.entrySet()) {
                ResourceLocation id = entry.getKey();
                ComputerTheme.Data.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(data -> computerThemes.put((Object)id, (Object)new ComputerTheme(id, (ComputerTheme.Data)data)));
            }
            INSTANCE = new ComputerThemes((Map<ResourceLocation, ComputerTheme>)computerThemes.build());
            LOGGER.info("Loaded {} computer themes", (Object)ComputerThemes.INSTANCE.themes.size());
        }
    }
}

