/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mraof.minestuck.item.MSItemTypes;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.weapon.MSToolType;
import com.mraof.minestuck.item.weapon.WeaponItem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredItem;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BetterCombatProvider
implements DataProvider {
    private static final String SICKLE = "bettercombat:sickle";
    private static final String SCYTHE = "bettercombat:scythe";
    private static final String CLAW = "bettercombat:claw";
    private static final String PICKAXE = "bettercombat:pickaxe";
    private static final String HAMMER = "bettercombat:hammer";
    private static final String AXE = "bettercombat:axe";
    private static final String HEAVY_AXE = "bettercombat:heavy_axe";
    private static final String CHAINSAW = "minestuck:chainsaw_base";
    private static final String MACE = "bettercombat:mace";
    private static final String SWORD = "bettercombat:sword";
    private static final String KATANA = "bettercombat:katana";
    private static final String CUTLASS = "bettercombat:cutlass";
    private static final String CLAYMORE = "bettercombat:claymore";
    private static final String RAPIER = "bettercombat:rapier";
    private static final String DAGGER = "bettercombat:dagger";
    private static final String LANCE = "bettercombat:lance";
    private static final String STAFF = "bettercombat:battlestaff";
    private static final String CANE = "minestuck:cane_base";
    private static final String FORK = "minestuck:fork_base";
    private static final String WAND = "bettercombat:wand";
    private static final String HALBERD = "bettercombat:halberd";
    private static final String SPEAR = "bettercombat:spear";
    private static final String TRIDENT = "bettercombat:trident";
    private final PackOutput output;
    private final Map<ResourceKey<Item>, String> weaponWithParent = new HashMap<ResourceKey<Item>, String>();

    public BetterCombatProvider(PackOutput output) {
        this.output = output;
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>();
        Path basePath = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve("minestuck").resolve("weapon_attributes");
        this.addAllWeapons();
        for (Map.Entry<ResourceKey<Item>, String> entry : this.weaponWithParent.entrySet()) {
            JsonObject object = new JsonObject();
            object.addProperty("parent", entry.getValue());
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)object, (Path)basePath.resolve(entry.getKey().location().getPath() + ".json")));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public void addAllWeapons() {
        this.addWeaponDefaults();
        this.addWeapon(MSItems.MAILBOX, HAMMER);
        this.addWeapon(MSItems.ESTROGEN_EMPOWERED_EVERYTHING_ERADICATOR, HAMMER);
        this.addWeapon(MSItems.BOOMBOX_BEATER, HAMMER);
        this.addWeapon(MSItems.CLAW_HAMMER, MACE);
        this.addWeapon(MSItems.BLACKSMITH_HAMMER, MACE);
        this.addWeapon(MSItems.SWONGE, SWORD);
        this.addWeapon(MSItems.WET_SWONGE, SWORD);
        this.addWeapon(MSItems.PUMORD, SWORD);
        this.addWeapon(MSItems.WET_PUMORD, SWORD);
        this.addWeapon(MSItems.MUSIC_SWORD, SWORD);
        this.addWeapon(MSItems.CHAINSAW_KATANA, KATANA);
        this.addWeapon(MSItems.KATANA, KATANA);
        this.addWeapon(MSItems.UNBREAKABLE_KATANA, KATANA);
        this.addWeapon(MSItems.CACTACEAE_CUTLASS, CUTLASS);
        this.addWeapon(MSItems.CUTLASS_OF_ZILLYWAIR, CUTLASS);
        this.addWeapon(MSItems.SCARLET_RIBBITAR, CUTLASS);
        this.addWeapon(MSItems.TOO_HOT_TO_HANDLE, CUTLASS);
        this.addWeapon(MSItems.COBALT_SABRE, CUTLASS);
        this.addWeapon(MSItems.CLAYMORE, CLAYMORE);
        this.addWeapon(MSItems.MACUAHUITL, CLAYMORE);
        this.addWeapon(MSItems.FROSTY_MACUAHUITL, CLAYMORE);
        this.addWeapon(MSItems.CRUEL_FATE_CRUCIBLE, CLAYMORE);
        this.addWeapon(MSItems.SUBTRACTSHUMIDIRE_ZOMORRODNEGATIVE, CLAYMORE);
        this.addWeapon(MSItems.ANGEL_APOCALYPSE, RAPIER);
        this.addWeapon(MSItems.FIRE_POKER, RAPIER);
        this.addWeapon(MSItems.NIFE, DAGGER);
        this.addWeapon(MSItems.BATTLEAXE, HEAVY_AXE);
        this.addWeapon(MSItems.CANDY_BATTLEAXE, HEAVY_AXE);
        this.addWeapon(MSItems.CHOCO_LOCO_WOODSPLITTER, HEAVY_AXE);
        this.addWeapon(MSItems.STEEL_EDGE_CANDYCUTTER, HEAVY_AXE);
        this.addWeapon(MSItems.PISTON_POWERED_POGO_AXEHAMMER, HEAVY_AXE);
        this.addWeapon(MSItems.FISSION_FOCUSED_FAULT_FELLER, HEAVY_AXE);
        this.addWeapon(MSItems.BISECTOR, HEAVY_AXE);
        this.addWeapon(MSItems.FINE_CHINA_AXE, HEAVY_AXE);
        this.addWeapon(MSItems.LUCERNE_HAMMER, HALBERD);
        this.addWeapon(MSItems.LUCERNE_HAMMER_OF_UNDYING, HALBERD);
        this.addWeapon(MSItems.OBSIDIAN_AXE_KNIFE, CLAW);
        this.addWeapon(MSItems.PROSPECTING_PICKSCYTHE, SCYTHE);
        this.addWeapon(MSItems.CUESTICK, LANCE);
        this.addWeapon(MSItems.TV_ANTENNA, SWORD);
        this.addWeapon(MSItems.CROWBAR, HEAVY_AXE);
        this.addWeapon(MSItems.UMBRELLA, FORK);
        this.addWeapon(MSItems.BARBERS_BEST_FRIEND, FORK);
        this.addWeapon(MSItems.SPEAR_CANE, SPEAR);
        this.addWeapon(MSItems.MEATFORK, TRIDENT);
        this.addWeapon(MSItems.BIDENT, TRIDENT);
        this.addWeapon(MSItems.DOUBLE_ENDED_TRIDENT, TRIDENT);
    }

    private void addWeaponDefaults() {
        MSItems.REGISTER.getEntries().forEach(weaponHolder -> {
            WeaponItem weaponItem;
            Object patt0$temp = weaponHolder.get();
            if (patt0$temp instanceof WeaponItem && (weaponItem = (WeaponItem)((Object)((Object)patt0$temp))).getToolTypes() != null) {
                for (MSToolType toolType : weaponItem.getToolTypes()) {
                    String parent = this.getWeaponParent(toolType);
                    if (parent.isEmpty()) continue;
                    this.weaponWithParent.put((ResourceKey<Item>)weaponHolder.getKey(), parent);
                }
            }
        });
    }

    public String getWeaponParent(MSToolType toolType) {
        if (toolType == MSItemTypes.SICKLE_TOOL) {
            return SICKLE;
        }
        if (toolType == MSItemTypes.SCYTHE_TOOL) {
            return SCYTHE;
        }
        if (toolType == MSItemTypes.CLAWS_TOOL) {
            return CLAW;
        }
        if (toolType == MSItemTypes.PICKAXE_TOOL) {
            return PICKAXE;
        }
        if (toolType == MSItemTypes.HAMMER_TOOL) {
            return HAMMER;
        }
        if (toolType == MSItemTypes.AXE_TOOL) {
            return AXE;
        }
        if (toolType == MSItemTypes.CHAINSAW_TOOL) {
            return CHAINSAW;
        }
        if (toolType == MSItemTypes.CLUB_TOOL || toolType == MSItemTypes.SHOVEL_TOOL) {
            return MACE;
        }
        if (toolType == MSItemTypes.SWORD_TOOL || toolType == MSItemTypes.KEY_TOOL || toolType == MSItemTypes.BATON_TOOL) {
            return SWORD;
        }
        if (toolType == MSItemTypes.KNIFE_TOOL || toolType == MSItemTypes.FAN_TOOL) {
            return DAGGER;
        }
        if (toolType == MSItemTypes.LANCE_TOOL) {
            return LANCE;
        }
        if (toolType == MSItemTypes.STAFF_TOOL) {
            return STAFF;
        }
        if (toolType == MSItemTypes.CANE_TOOL) {
            return CANE;
        }
        if (toolType == MSItemTypes.FORK_TOOL) {
            return FORK;
        }
        if (toolType == MSItemTypes.WAND_TOOL) {
            return WAND;
        }
        return "";
    }

    public void addWeapon(DeferredItem<Item> weapon, String parent) {
        this.weaponWithParent.put((ResourceKey<Item>)weapon.getKey(), parent);
    }

    public String getName() {
        return "Minestuck Better Combat Weapon Files";
    }
}

