/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.entity.consort.BoondollarPriceRecipe;
import com.mraof.minestuck.item.MSItems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BoondollarPriceProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ResourceLocation, BoondollarPriceRecipe> recipes = new HashMap<ResourceLocation, BoondollarPriceRecipe>();
    private final PackOutput output;
    private final String modid;

    public BoondollarPriceProvider(PackOutput output, String modid) {
        this.output = output;
        this.modid = modid;
    }

    protected void registerPrices() {
        this.add((ItemLike)MSItems.ONION.get(), 9, 15);
        this.add((ItemLike)MSItems.JAR_OF_BUGS.get(), 12, 18);
        this.add((ItemLike)MSItems.BUG_ON_A_STICK.get(), 4, 6);
        this.add((ItemLike)MSItems.CONE_OF_FLIES.get(), 4, 6);
        this.add((ItemLike)MSItems.GRASSHOPPER.get(), 90, 110);
        this.add((ItemLike)MSItems.SALAD.get(), 10, 14);
        this.add((ItemLike)MSItems.CHOCOLATE_BEETLE.get(), 30, 35);
        this.add((ItemLike)MSItems.DESERT_FRUIT.get(), 2, 6);
        this.add((ItemLike)MSItems.GLOWING_MUSHROOM.get(), 10, 15);
        this.add((ItemLike)MSItems.COLD_CAKE.get(), 400);
        this.add((ItemLike)MSItems.BLUE_CAKE.get(), 400);
        this.add((ItemLike)MSItems.HOT_CAKE.get(), 400);
        this.add((ItemLike)MSItems.RED_CAKE.get(), 400);
        this.add((ItemLike)MSItems.FUCHSIA_CAKE.get(), 1500);
        this.add((ItemLike)MSItems.ROCK_COOKIE.get(), 15, 20);
        this.add((ItemLike)MSItems.STRAWBERRY_CHUNK.get(), 100, 150);
        this.add((ItemLike)MSItems.TAB.get(), 200);
        this.add((ItemLike)MSItems.ORANGE_FAYGO.get(), 100);
        this.add((ItemLike)MSItems.CANDY_APPLE_FAYGO.get(), 100);
        this.add((ItemLike)MSItems.FAYGO_COLA.get(), 100);
        this.add((ItemLike)MSItems.COTTON_CANDY_FAYGO.get(), 100);
        this.add((ItemLike)MSItems.CREME_SODA_FAYGO.get(), 100);
        this.add((ItemLike)MSItems.GRAPE_FAYGO.get(), 100);
        this.add((ItemLike)MSItems.MOON_MIST_FAYGO.get(), 100);
        this.add((ItemLike)MSItems.PEACH_FAYGO.get(), 100);
        this.add((ItemLike)MSItems.REDPOP_FAYGO.get(), 100);
        this.add((ItemLike)MSItems.GOLD_SEEDS.get(), 300, 400);
        this.add((ItemLike)MSItems.APPLE_CAKE.get(), 100, 140);
        this.add((ItemLike)MSItems.IRRADIATED_STEAK.get(), 70, 80);
        this.add((ItemLike)MSItems.CANDY_CORN.get(), 100, 150);
        this.add((ItemLike)MSItems.BUILD_GUSHERS.get(), 90, 120);
        this.add((ItemLike)MSItems.AMBER_GUMMY_WORM.get(), 125, 150);
        this.add((ItemLike)MSItems.CAULK_PRETZEL.get(), 125, 150);
        this.add((ItemLike)MSItems.CHALK_CANDY_CIGARETTE.get(), 125, 150);
        this.add((ItemLike)MSItems.IODINE_LICORICE.get(), 125, 150);
        this.add((ItemLike)MSItems.SHALE_PEEP.get(), 125, 150);
        this.add((ItemLike)MSItems.TAR_LICORICE.get(), 125, 150);
        this.add((ItemLike)MSItems.COBALT_GUM.get(), 150, 180);
        this.add((ItemLike)MSItems.MARBLE_JAWBREAKER.get(), 150, 180);
        this.add((ItemLike)MSItems.MERCURY_SIXLETS.get(), 150, 180);
        this.add((ItemLike)MSItems.QUARTZ_JELLY_BEAN.get(), 150, 180);
        this.add((ItemLike)MSItems.SULFUR_CANDY_APPLE.get(), 150, 180);
        this.add((ItemLike)MSItems.AMETHYST_HARD_CANDY.get(), 175, 210);
        this.add((ItemLike)MSItems.GARNET_TWIX.get(), 175, 210);
        this.add((ItemLike)MSItems.RUBY_CROAK.get(), 175, 210);
        this.add((ItemLike)MSItems.RUST_GUMMY_EYE.get(), 175, 210);
        this.add((ItemLike)MSItems.DIAMOND_MINT.get(), 200, 240);
        this.add((ItemLike)MSItems.GOLD_CANDY_RIBBON.get(), 200, 240);
        this.add((ItemLike)MSItems.URANIUM_GUMMY_BEAR.get(), 200, 240);
        this.add((ItemLike)MSItems.ARTIFACT_WARHEAD.get(), 225, 270);
        this.add((ItemLike)MSItems.ZILLIUM_SKITTLES.get(), 250, 300);
        this.add((ItemLike)MSItems.CARVING_TOOL.get(), 60, 90);
        this.add((ItemLike)MSItems.MINI_FROG_STATUE.get(), 200, 250);
        this.add((ItemLike)MSItems.MINI_WIZARD_STATUE.get(), 200, 250);
        this.add((ItemLike)MSItems.MINI_TYPHEUS_STATUE.get(), 10000, 12000);
        this.add((ItemLike)MSItems.STONE_TABLET.get(), 20, 30);
        this.add((ItemLike)MSItems.THRESH_DVD.get(), 350, 400);
        this.add((ItemLike)MSItems.CREW_POSTER.get(), 350, 400);
        this.add((ItemLike)MSItems.SBAHJ_POSTER.get(), 350, 400);
        this.add((ItemLike)MSItems.GAMEBRO_MAGAZINE.get(), 450, 600);
        this.add((ItemLike)MSItems.GAMEGRL_MAGAZINE.get(), 450, 600);
        this.add((ItemLike)MSItems.MUSIC_DISC_EMISSARY_OF_DANCE.get(), 1000);
        this.add((ItemLike)MSItems.MUSIC_DISC_DANCE_STAB_DANCE.get(), 1000);
        this.add((ItemLike)MSItems.MUSIC_DISC_RETRO_BATTLE.get(), 1000);
        this.add((ItemLike)MSItems.CRUMPLY_HAT.get(), 80, 100);
        this.add((ItemLike)MSItems.PLUSH_IGUANA.get(), 40, 100);
        this.add((ItemLike)MSItems.PLUSH_NAKAGATOR.get(), 40, 100);
        this.add((ItemLike)MSItems.PLUSH_SALAMANDER.get(), 40, 100);
        this.add((ItemLike)MSItems.PLUSH_TURTLE.get(), 40, 100);
        this.add((ItemLike)MSItems.BATTERY.get(), 10, 100);
        this.add((ItemLike)MSItems.GRIMOIRE.get(), 666);
        this.add((ItemLike)MSItems.ACE_OF_SPADES.get(), 3000, 5000);
        this.add((ItemLike)MSItems.ACE_OF_HEARTS.get(), 3000, 5000);
        this.add((ItemLike)MSItems.ACE_OF_DIAMONDS.get(), 3000, 5000);
        this.add((ItemLike)MSItems.ACE_OF_CLUBS.get(), 3000, 5000);
        this.add((ItemLike)MSItems.CLUBS_SUITARANG.get(), 30, 50);
        this.add((ItemLike)MSItems.DIAMONDS_SUITARANG.get(), 30, 50);
        this.add((ItemLike)MSItems.HEARTS_SUITARANG.get(), 30, 50);
        this.add((ItemLike)MSItems.SPADES_SUITARANG.get(), 30, 50);
        this.add((ItemLike)MSItems.POGO_CLUB.get(), 900, 1200);
        this.add((ItemLike)MSItems.METAL_BAT.get(), 400, 500);
        this.add((ItemLike)MSItems.FIRE_POKER.get(), 1500, 2000);
        this.add((ItemLike)MSItems.COPSE_CRUSHER.get(), 1000, 1500);
        this.add((ItemLike)MSItems.KATANA.get(), 400, 500);
        this.add((ItemLike)MSItems.CACTACEAE_CUTLASS.get(), 500, 700);
        this.add((ItemLike)MSItems.STEAK_SWORD.get(), 350, 650);
        this.add((ItemLike)MSItems.BEEF_SWORD.get(), 250, 625);
        this.add((ItemLike)MSItems.GLOWYSTONE_DUST.get(), 20, 40);
        this.add((ItemLike)MSItems.IRON_CANE.get(), 300, 400);
        this.add((ItemLike)MSItems.GLOWING_LOG.get(), 20, 32);
        this.add((ItemLike)MSItems.GLOWING_PLANKS.get(), 5, 8);
        this.add((ItemLike)MSItems.COARSE_STONE.get(), 5, 8);
        this.add((ItemLike)MSItems.CHISELED_COARSE_STONE.get(), 8, 15);
        this.add((ItemLike)MSItems.SHADE_BRICKS.get(), 5, 8);
        this.add((ItemLike)MSItems.SMOOTH_SHADE_STONE.get(), 5, 8);
        this.add((ItemLike)MSItems.FROST_BRICKS.get(), 5, 8);
        this.add((ItemLike)MSItems.FROST_TILE.get(), 5, 8);
        this.add((ItemLike)MSItems.CAST_IRON.get(), 5, 8);
        this.add((ItemLike)MSItems.CHISELED_CAST_IRON.get(), 8, 15);
        this.add((ItemLike)MSItems.VINE_LOG.get(), 20, 32);
        this.add((ItemLike)MSItems.FLOWERY_VINE_LOG.get(), 25, 40);
        this.add((ItemLike)MSItems.FROST_LOG.get(), 20, 32);
        this.add((ItemLike)MSItems.WOODEN_CACTUS.get(), 50, 60);
        this.add((ItemLike)MSItems.SUGAR_CUBE.get(), 200, 240);
        this.add((ItemLike)MSItems.FUNGAL_SPORE.get(), 1, 4);
        this.add((ItemLike)MSItems.SPOREO.get(), 15, 25);
        this.add((ItemLike)MSItems.MOREL_MUSHROOM.get(), 40, 80);
        this.add((ItemLike)MSItems.PARADISES_PORTABELLO.get(), 400, 600);
        this.add((ItemLike)MSItems.BUG_NET.get(), 500, 600);
        this.add((ItemLike)Items.LILY_PAD, 24, 31);
        this.add((ItemLike)Items.POTATO, 12, 15);
        this.add((ItemLike)Items.MUSHROOM_STEW, 95, 130);
        this.add((ItemLike)Items.CARROT, 15, 18);
        this.add((ItemLike)Items.APPLE, 25, 30);
        this.add((ItemLike)Items.WHEAT, 10, 15);
        this.add((ItemLike)Items.WHEAT_SEEDS, 15, 20);
        this.add((ItemLike)Items.BEETROOT_SOUP, 70, 90);
        this.add((ItemLike)Items.BEETROOT, 10, 15);
        this.add((ItemLike)Items.BEEF, 110, 130);
        this.add((ItemLike)Items.RED_MUSHROOM, 15, 20);
        this.add((ItemLike)Items.BROWN_MUSHROOM, 10, 15);
        this.add((ItemLike)Items.COCOA_BEANS, 25, 35);
        this.add((ItemLike)Items.POTION, 5, 10);
        this.add((ItemLike)Items.SALMON, 40, 60);
        this.add((ItemLike)Items.MILK_BUCKET, 40, 50);
        this.add((ItemLike)Items.EGG, 30, 45);
        this.add((ItemLike)Items.SUGAR, 50, 80);
        this.add((ItemLike)Items.RABBIT_STEW, 130, 150);
        this.add((ItemLike)Items.POISONOUS_POTATO, 50, 60);
        this.add((ItemLike)Items.MELON, 70, 80);
        this.add((ItemLike)Items.COD, 90, 100);
        this.add((ItemLike)Items.COOKIE, 120, 150);
        this.add((ItemLike)Items.PUMPKIN_PIE, 120, 160);
        this.add((ItemLike)Items.GOLDEN_APPLE, 2500);
        this.add((ItemLike)Items.LAPIS_LAZULI, 25, 35);
        this.add((ItemLike)Items.FEATHER, 25, 35);
        this.add((ItemLike)Items.FLINT, 5, 10);
        this.add((ItemLike)Items.STONE_AXE, 250, 300);
        this.add((ItemLike)Items.EMERALD, 400, 500);
        this.add((ItemLike)Items.SLIME_BALL, 30, 40);
        this.add((ItemLike)Items.COAL, 70, 90);
        this.add((ItemLike)Items.CHARCOAL, 50, 70);
        this.add((ItemLike)Items.CLAY_BALL, 5, 10);
        this.add((ItemLike)Items.IRON_INGOT, 90, 120);
        this.add((ItemLike)Items.QUARTZ, 60, 80);
        this.add((ItemLike)Items.BLAZE_POWDER, 80, 100);
        this.add((ItemLike)Items.NETHER_BRICK, 5, 10);
        this.add((ItemLike)Items.OAK_SAPLING, 60, 90);
        this.add((ItemLike)Items.SPRUCE_SAPLING, 60, 90);
        this.add((ItemLike)Items.BIRCH_SAPLING, 60, 90);
        this.add((ItemLike)Items.JUNGLE_SAPLING, 60, 90);
        this.add((ItemLike)Items.ACACIA_SAPLING, 60, 90);
        this.add((ItemLike)Items.DARK_OAK_SAPLING, 60, 90);
        this.add((ItemLike)Items.DIAMOND, 800, 1200);
        this.add((ItemLike)Items.PRISMARINE_CRYSTALS, 100, 150);
        this.add((ItemLike)Items.PRISMARINE_SHARD, 10, 15);
        this.add((ItemLike)Items.GOLD_INGOT, 120, 180);
        this.add((ItemLike)Items.LEATHER, 65, 80);
        this.add((ItemLike)Items.GOLDEN_SWORD, 900, 1200);
        this.add((ItemLike)Items.REDSTONE, 30, 40);
        this.add((ItemLike)Items.GUNPOWDER, 50, 65);
        this.add((ItemLike)Items.BUCKET, 50, 65);
        this.add((ItemLike)Items.CLOCK, 150, 200);
        this.add((ItemLike)Items.RABBIT_FOOT, 80, 100);
        this.add((ItemLike)Items.BOOK, 50, 65);
        this.add((ItemLike)Items.ROTTEN_FLESH, 1, 5);
        this.add((ItemLike)Items.OAK_LOG, 20, 32);
        this.add((ItemLike)Items.SPRUCE_LOG, 20, 32);
        this.add((ItemLike)Items.BIRCH_LOG, 20, 32);
        this.add((ItemLike)Items.JUNGLE_LOG, 20, 32);
        this.add((ItemLike)Items.POLISHED_GRANITE, 5, 10);
        this.add((ItemLike)Items.POLISHED_ANDESITE, 5, 10);
        this.add((ItemLike)Items.NETHER_BRICKS, 5, 10);
        this.add((ItemLike)Items.RED_NETHER_BRICKS, 10, 15);
        this.add((ItemLike)Items.OAK_PLANKS, 5, 8);
        this.add((ItemLike)Items.PRISMARINE, 5, 10);
        this.add((ItemLike)Items.PRISMARINE_BRICKS, 10, 15);
        this.add((ItemLike)Items.CACTUS, 30, 40);
        this.add((ItemLike)Items.SANDSTONE, 5, 10);
        this.add((ItemLike)Items.CHISELED_SANDSTONE, 10, 15);
        this.add((ItemLike)Items.SMOOTH_SANDSTONE, 5, 10);
        this.add((ItemLike)Items.RED_SANDSTONE, 5, 10);
        this.add((ItemLike)Items.CHISELED_RED_SANDSTONE, 10, 15);
        this.add((ItemLike)Items.SMOOTH_RED_SANDSTONE, 5, 10);
        this.add((ItemLike)Items.STONE_BRICKS, 5, 10);
        this.add((ItemLike)Items.CHISELED_STONE_BRICKS, 10, 15);
        this.add((ItemLike)Items.BREAD, 90, 130);
        this.add((ItemLike)Items.CHORUS_FRUIT, 420);
        this.add((ItemLike)Items.DRAGON_BREATH, 50, 100);
        this.add((ItemLike)Items.EGG, 50, 100);
        this.add((ItemLike)Items.ELYTRA, 500, 1000);
        this.add((ItemLike)Items.OBSIDIAN, 8, 20);
        this.add((ItemLike)Items.PAPER, 5, 20);
    }

    protected void add(ItemLike item, int value) {
        this.add(Ingredient.of((ItemLike[])new ItemLike[]{item}), (IntProvider)ConstantInt.of((int)value), Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem())).getPath());
    }

    protected void add(ItemLike item, int min, int max) {
        this.add(Ingredient.of((ItemLike[])new ItemLike[]{item}), (IntProvider)UniformInt.of((int)min, (int)max), Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem())).getPath());
    }

    protected void add(Ingredient ingredient, IntProvider range, String name) {
        this.add(new BoondollarPriceRecipe(ingredient, range), ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)name));
    }

    protected void add(BoondollarPriceRecipe pricing, ResourceLocation name) {
        this.recipes.put(name, pricing);
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.registerPrices();
        Path outputPath = this.output.getOutputFolder();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(this.recipes.size());
        for (Map.Entry<ResourceLocation, BoondollarPriceRecipe> entry : this.recipes.entrySet()) {
            Path pricingPath = BoondollarPriceProvider.getPath(outputPath, entry.getKey());
            JsonElement jsonData = (JsonElement)BoondollarPriceRecipe.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow();
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonData, (Path)pricingPath));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private static Path getPath(Path outputPath, ResourceLocation id) {
        return outputPath.resolve("data/" + id.getNamespace() + "/minestuck/boondollar_prices/" + id.getPath() + ".json");
    }

    public String getName() {
        return "Boondollar pricings";
    }
}

