/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.computer.theme.ComputerTheme;
import com.mraof.minestuck.computer.theme.MSComputerThemes;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ComputerThemeProvider
implements DataProvider {
    private final Map<ResourceLocation, ComputerTheme.Data> computerThemes = new HashMap<ResourceLocation, ComputerTheme.Data>();
    private final PackOutput output;

    public ComputerThemeProvider(PackOutput output) {
        this.output = output;
    }

    protected void registerThemes() {
        this.add(MSComputerThemes.DEFAULT, ComputerTheme.Data.DEFAULT);
        this.add(MSComputerThemes.PESTERCHUM, 0x404040);
        this.add(MSComputerThemes.TROLLIAN, 0xFF0000);
        this.add(MSComputerThemes.CROCKER, 0);
        this.add(MSComputerThemes.TYPHEUS, 7188397);
        this.add(MSComputerThemes.CETUS, 9470446);
        this.add(MSComputerThemes.HEPHAESTUS, 0xFFFFFF);
        this.add(MSComputerThemes.ECHIDNA, 24063);
        this.add(MSComputerThemes.JOY, 0x282828);
        this.add(MSComputerThemes.SBURB_95, 0x282828);
        this.add(MSComputerThemes.SBURB_10, 0xFFFFFF);
        this.add(MSComputerThemes.SCOURGING_HEAT, 0xFFFFFF);
        this.add(MSComputerThemes.LIFDOFF, 0xFFFF00);
        this.add(MSComputerThemes.SKAIANET_GREEN, 0xFFFFFF);
        this.add(MSComputerThemes.SKAIANET_WHITE, 26112);
        this.add(MSComputerThemes.SKAIANET_BLACK, 0xFFFFFF);
        this.add(MSComputerThemes.ASTRAL_CHARTS, 0xFFFFFF);
        this.add(MSComputerThemes.TILLDEATH, 0xFFFFFF);
        this.add(MSComputerThemes.LOWAS, 12578794);
        this.add(MSComputerThemes.SPIROGRAPH, 26112);
        this.add(MSComputerThemes.MINESTUCK, 0xFFFFFF);
    }

    protected void add(ResourceLocation id, int textColor) {
        ResourceLocation textureLocation = id.withPath(name -> "textures/gui/theme/" + name + ".png");
        this.add(id, new ComputerTheme.Data(textureLocation, textColor));
    }

    protected void add(ResourceLocation id, ComputerTheme.Data data) {
        this.computerThemes.put(id, data);
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        this.registerThemes();
        Path outputPath = this.output.getOutputFolder(PackOutput.Target.RESOURCE_PACK);
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(this.computerThemes.size());
        for (Map.Entry<ResourceLocation, ComputerTheme.Data> entry : this.computerThemes.entrySet()) {
            Path themePath = ComputerThemeProvider.getPath(outputPath, entry.getKey());
            JsonElement encodedTheme = (JsonElement)ComputerTheme.Data.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow();
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)encodedTheme, (Path)themePath));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private static Path getPath(Path outputPath, ResourceLocation id) {
        return outputPath.resolve(id.getNamespace() + "/minestuck/computer_themes/" + id.getPath() + ".json");
    }

    public String getName() {
        return "Computer Themes";
    }
}

