/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.player.EcheladderExpSource;
import com.mraof.minestuck.player.EcheladderExpSources;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EcheladderExpSourceProvider
implements DataProvider {
    private final PackOutput output;
    private final Map<String, EcheladderExpSource> expSources = new HashMap<String, EcheladderExpSource>();

    public EcheladderExpSourceProvider(PackOutput output) {
        this.output = output;
    }

    protected void createNewSources() {
        this.add(EntityType.SILVERFISH, 1);
        this.add(EntityType.SLIME, 1);
        this.add(EntityType.MAGMA_CUBE, 1);
        this.add(EntityType.PHANTOM, 1);
        this.add(EntityType.VEX, 1);
        this.add(EntityTypeTags.ZOMBIES, 2);
        this.add(EntityTypeTags.SKELETONS, 2);
        this.add(EntityType.CREEPER, 2);
        this.add(EntityType.SPIDER, 2);
        this.add(EntityType.CAVE_SPIDER, 2);
        this.add(EntityType.PIGLIN, 2);
        this.add(EntityType.ZOMBIFIED_PIGLIN, 2);
        this.add(EntityTypeTags.ILLAGER, 3);
        this.add(EntityType.WITCH, 3);
        this.add(EntityType.ENDERMAN, 3);
        this.add(EntityType.BLAZE, 3);
        this.add(EntityType.BREEZE, 3);
        this.add(EntityType.SHULKER, 3);
        this.add(EntityType.GUARDIAN, 3);
        this.add(EntityType.GHAST, 3);
        this.add(EntityType.PIGLIN_BRUTE, 6);
        this.add(EntityType.HOGLIN, 6);
        this.add(EntityType.ZOGLIN, 6);
        this.add(EntityType.RAVAGER, 10);
        this.add(EntityType.ELDER_GUARDIAN, 20);
        this.add(EntityType.WARDEN, 200);
        this.add(EntityType.WITHER, 300);
        this.add(EntityType.ENDER_DRAGON, 400);
        this.add("minestuck", "minestuck.legendary_weapon", 400);
        this.add("minecraft", "husbandry/obtain_netherite_hoe", 300);
        this.add("minecraft", "story/enter_the_nether", 200);
        this.add("minecraft", "story/enter_the_end", 800);
    }

    private void add(EntityType<?> entityType, int amount) {
        this.expSources.put("kill_" + entityType.builtInRegistryHolder().getKey().location().getPath(), new EcheladderExpSource.KillEntity(entityType, amount));
    }

    private void add(TagKey<EntityType<?>> entityTypeTag, int amount) {
        this.expSources.put("kill_" + entityTypeTag.location().getPath(), new EcheladderExpSource.KillEntityTag(entityTypeTag, amount));
    }

    private void add(String namespace, String name, int amount) {
        name = name.replace(".", "/");
        this.expSources.put("advancement_" + name.replace("/", "_"), new EcheladderExpSource.AdvancementEarned(ResourceLocation.fromNamespaceAndPath((String)namespace, (String)name), amount));
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        this.createNewSources();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(this.expSources.size());
        for (Map.Entry<String, EcheladderExpSource> source : this.expSources.entrySet()) {
            Path path = this.getPath(source.getKey());
            JsonElement jsonData = (JsonElement)EcheladderExpSources.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)source.getValue()).getOrThrow();
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonData, (Path)path));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private Path getPath(String id) {
        return this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve("minestuck").resolve("minestuck/exp_source/" + id + ".json");
    }

    public String getName() {
        return "Minestuck Echeladder Exp Sources";
    }
}

