/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.CookingCostInterpreter;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.DefaultInterpreter;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeGeneratedCostHandler;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeInterpreter;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.RecipeSource;
import com.mraof.minestuck.alchemy.recipe.generator.recipe.SmithingInterpreter;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.item.crafting.MSRecipeTypes;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class GeneratedGristCostConfigProvider
implements DataProvider {
    private final PackOutput output;
    private final String modid;
    private final List<RecipeGeneratedCostHandler.SourceEntry> entries = new ArrayList<RecipeGeneratedCostHandler.SourceEntry>();

    public GeneratedGristCostConfigProvider(PackOutput output, String modid) {
        this.output = output;
        this.modid = modid;
    }

    protected void addEntries() {
        this.serializer(RecipeSerializer.SHAPED_RECIPE);
        this.serializer(RecipeSerializer.SHAPELESS_RECIPE);
        this.type(RecipeType.STONECUTTING);
        this.serializer(RecipeSerializer.SMITHING_TRANSFORM, SmithingInterpreter.INSTANCE);
        this.type(RecipeType.SMELTING, new CookingCostInterpreter(GristTypes.TAR.get().amount(1L)));
        this.type(MSRecipeTypes.IRRADIATING_TYPE.get(), new CookingCostInterpreter(GristTypes.URANIUM.get().amount(1L)));
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        this.addEntries();
        Path jsonPath = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("minestuck/grist_cost_generation_recipes.json");
        JsonElement json = (JsonElement)RecipeGeneratedCostHandler.SourceEntry.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow();
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)jsonPath);
    }

    protected void recipe(ResourceLocation location) {
        this.recipe(location, DefaultInterpreter.INSTANCE);
    }

    protected void serializer(RecipeSerializer<?> serializer) {
        this.serializer(serializer, DefaultInterpreter.INSTANCE);
    }

    protected void type(RecipeType<?> type) {
        this.type(type, DefaultInterpreter.INSTANCE);
    }

    protected void recipe(ResourceLocation location, RecipeInterpreter interpreter) {
        this.addEntry(new RecipeSource.SingleRecipe(location), interpreter);
    }

    protected void serializer(RecipeSerializer<?> serializer, RecipeInterpreter interpreter) {
        this.addEntry(new RecipeSource.BySerializer(serializer), interpreter);
    }

    protected void type(RecipeType<?> type, RecipeInterpreter interpreter) {
        this.addEntry(new RecipeSource.ByType(type), interpreter);
    }

    private void addEntry(RecipeSource source, RecipeInterpreter interpreter) {
        this.entries.add(new RecipeGeneratedCostHandler.SourceEntry(source, interpreter));
    }

    public String getName() {
        return "Minestuck generated grist costs config";
    }
}

