/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.advancements.ChangeModusTrigger;
import com.mraof.minestuck.advancements.ConsortItemTrigger;
import com.mraof.minestuck.advancements.ConsortTalkTrigger;
import com.mraof.minestuck.advancements.EcheladderTrigger;
import com.mraof.minestuck.advancements.EventTrigger;
import com.mraof.minestuck.advancements.IntellibeamLaserstationTrigger;
import com.mraof.minestuck.advancements.PunchDesignixTrigger;
import com.mraof.minestuck.advancements.TreeModusRootTrigger;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.consort.EnumConsort;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.inventory.captchalogue.ModusTypes;
import com.mraof.minestuck.item.BoondollarsItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.util.ColorHandler;
import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

@ParametersAreNonnullByDefault
public class MSAdvancementProvider
implements AdvancementProvider.AdvancementGenerator {
    public static final String ROOT = "minestuck.root";
    public static final String SEARCHING = "minestuck.searching";
    public static final String LONG_TIME_COMING = "minestuck.long_time_coming";
    public static final String CONNECT = "minestuck.connect";
    public static final String ENTRY = "minestuck.entry";
    public static final String ALCHEMY = "minestuck.alchemy";
    public static final String NEW_MODUS = "minestuck.new_modus";
    public static final String ALL_MODI = "minestuck.all_modi";
    public static final String GOLD_SEEDS = "minestuck.gold_seeds";
    public static final String FRENCH_FRY = "minestuck.french_fry";
    public static final String MELON_OVERLOAD = "minestuck.melon_overload";
    public static final String TREE_MODUS = "minestuck.tree_modus";
    public static final String KILL_OGRE = "minestuck.kill_ogre";
    public static final String RETURN_NODE = "minestuck.return_node";
    public static final String DUNGEON = "minestuck.dungeon";
    public static final String COMMUNE = "minestuck.commune";
    public static final String BUGS = "minestuck.bugs";
    public static final String SHADY_BUYER = "minestuck.shady_buyer";
    public static final String FIRST_STEP = "minestuck.first_step";
    public static final String DOUBLE_DIGITS = "minestuck.double_digits";
    public static final String HALFWAY_POINT = "minestuck.halfway_point";
    public static final String BIG_ONE_MIL = "minestuck.big_one_mil";
    public static final String INTELLIBEAM = "minestuck.intellibeam";
    public static final String LEGENDARY_WEAPON = "minestuck.legendary_weapon";
    public static final String BUY_OUT_SHOP = "minestuck.buy_out_shop";
    public static final String BRICK_COMPUTER = "minestuck.brick_computer";

    public static DataProvider create(PackOutput output, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        return new AdvancementProvider(output, registries, existingFileHelper, List.of(new MSAdvancementProvider()));
    }

    public void generate(HolderLookup.Provider registries, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        HolderLookup.RegistryLookup structures = registries.lookupOrThrow(Registries.STRUCTURE);
        AdvancementHolder root = Advancement.Builder.advancement().display((ItemLike)MSItems.RAW_CRUXITE.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(ROOT)), (Component)Component.translatable((String)MSAdvancementProvider.desc(ROOT)), Minestuck.id("textures/gui/advancement_bg.png"), AdvancementType.TASK, false, false, false).addCriterion("raw_cruxite", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MSItems.RAW_CRUXITE.get()})).save(saver, MSAdvancementProvider.save_loc(ROOT));
        AdvancementHolder searching = Advancement.Builder.advancement().parent(root).display((ItemLike)Items.COMPASS, (Component)Component.translatable((String)MSAdvancementProvider.title(SEARCHING)), (Component)Component.translatable((String)MSAdvancementProvider.desc(SEARCHING)), null, AdvancementType.TASK, true, true, false).addCriterion("possess_scanner", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MSItems.TEMPLE_SCANNER.get()})).save(saver, MSAdvancementProvider.save_loc(SEARCHING));
        AdvancementHolder longTimeComing = Advancement.Builder.advancement().parent(root).display((ItemLike)MSItems.SBURB_CODE.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(LONG_TIME_COMING)), (Component)Component.translatable((String)MSAdvancementProvider.desc(LONG_TIME_COMING)), null, AdvancementType.TASK, true, true, false).addCriterion("possess_code", InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{(ItemLike)MSItems.SBURB_CODE.get()})).save(saver, MSAdvancementProvider.save_loc(LONG_TIME_COMING));
        AdvancementHolder connect = Advancement.Builder.advancement().parent(root).display((ItemLike)MSItems.CLIENT_DISK.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(CONNECT)), (Component)Component.translatable((String)MSAdvancementProvider.desc(CONNECT)), null, AdvancementType.TASK, true, true, false).addCriterion("connection", EventTrigger.Instance.sburbConnection()).save(saver, MSAdvancementProvider.save_loc(CONNECT));
        AdvancementHolder entry = Advancement.Builder.advancement().parent(connect).display(ColorHandler.setDefaultColor(new ItemStack((ItemLike)MSItems.CRUXITE_APPLE.get())), (Component)Component.translatable((String)MSAdvancementProvider.title(ENTRY)), (Component)Component.translatable((String)MSAdvancementProvider.desc(ENTRY)), null, AdvancementType.TASK, true, true, false).addCriterion("use_artifact", EventTrigger.Instance.cruxiteArtifact()).save(saver, MSAdvancementProvider.save_loc(ENTRY));
        AdvancementHolder alchemy = Advancement.Builder.advancement().parent(entry).display((ItemLike)MSItems.CAPTCHA_CARD.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(ALCHEMY)), (Component)Component.translatable((String)MSAdvancementProvider.desc(ALCHEMY)), null, AdvancementType.TASK, true, true, false).addCriterion("use_punch_designix", PunchDesignixTrigger.Instance.any()).save(saver, MSAdvancementProvider.save_loc(ALCHEMY));
        AdvancementHolder newModus = Advancement.Builder.advancement().parent(alchemy).display((ItemLike)MSItems.HASHMAP_MODUS_CARD.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(NEW_MODUS)), (Component)Component.translatable((String)MSAdvancementProvider.desc(NEW_MODUS)), null, AdvancementType.TASK, true, true, false).addCriterion("change_modus_type", ChangeModusTrigger.Instance.any()).save(saver, MSAdvancementProvider.save_loc(NEW_MODUS));
        AdvancementHolder allModi = MSAdvancementProvider.changeModusCriteria(Advancement.Builder.advancement().parent(newModus).display((ItemLike)MSItems.QUEUESTACK_MODUS_CARD.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(ALL_MODI)), (Component)Component.translatable((String)MSAdvancementProvider.desc(ALL_MODI)), null, AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.Strategy.AND)).save(saver, MSAdvancementProvider.save_loc(ALL_MODI));
        AdvancementHolder goldSeeds = Advancement.Builder.advancement().parent(alchemy).display((ItemLike)MSBlocks.GOLD_SEEDS.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(GOLD_SEEDS)), (Component)Component.translatable((String)MSAdvancementProvider.desc(GOLD_SEEDS)), null, AdvancementType.TASK, true, true, false).addCriterion("plant_gold_seeds", ItemUsedOnLocationTrigger.TriggerInstance.placedBlock((Block)((Block)MSBlocks.GOLD_SEEDS.get()))).save(saver, MSAdvancementProvider.save_loc(GOLD_SEEDS));
        AdvancementHolder melonOverload = Advancement.Builder.advancement().parent(alchemy).display((ItemLike)MSItems.MELONSBANE.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(MELON_OVERLOAD)), (Component)Component.translatable((String)MSAdvancementProvider.desc(MELON_OVERLOAD)), null, AdvancementType.TASK, true, true, true).addCriterion("melon_overload", EventTrigger.Instance.melonOverload()).save(saver, MSAdvancementProvider.save_loc(MELON_OVERLOAD));
        AdvancementHolder treeModus = Advancement.Builder.advancement().parent(newModus).display((ItemLike)MSItems.TREE_MODUS_CARD.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(TREE_MODUS)), (Component)Component.translatable((String)MSAdvancementProvider.desc(TREE_MODUS)), null, AdvancementType.TASK, true, true, false).addCriterion("tree_root", TreeModusRootTrigger.Instance.count(MinMaxBounds.Ints.atLeast((int)16))).save(saver, MSAdvancementProvider.save_loc(TREE_MODUS));
        AdvancementHolder killOgre = Advancement.Builder.advancement().parent(entry).display((ItemLike)MSItems.POGO_HAMMER.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(KILL_OGRE)), (Component)Component.translatable((String)MSAdvancementProvider.desc(KILL_OGRE)), null, AdvancementType.TASK, true, true, false).addCriterion("kill_ogre", KilledTrigger.TriggerInstance.playerKilledEntity((EntityPredicate.Builder)EntityPredicate.Builder.entity().of(MSEntityTypes.OGRE.get()))).save(saver, MSAdvancementProvider.save_loc(KILL_OGRE));
        AdvancementHolder returnNode = Advancement.Builder.advancement().parent(entry).display((ItemLike)Items.RED_BED, (Component)Component.translatable((String)MSAdvancementProvider.title(RETURN_NODE)), (Component)Component.translatable((String)MSAdvancementProvider.desc(RETURN_NODE)), null, AdvancementType.TASK, true, true, false).addCriterion("touch_return_node", EventTrigger.Instance.returnNode()).save(saver, MSAdvancementProvider.save_loc(RETURN_NODE));
        AdvancementHolder dungeon = Advancement.Builder.advancement().parent(returnNode).display((ItemLike)MSBlocks.FROST_BRICKS.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(DUNGEON)), (Component)Component.translatable((String)MSAdvancementProvider.desc(DUNGEON)), null, AdvancementType.TASK, true, true, false).addCriterion("imp_dungeon", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inStructure((Holder)structures.getOrThrow(MSStructures.ImpDungeon.KEY)))).save(saver, MSAdvancementProvider.save_loc(DUNGEON));
        AdvancementHolder commune = Advancement.Builder.advancement().parent(entry).display((ItemLike)MSItems.STONE_TABLET.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(COMMUNE)), (Component)Component.translatable((String)MSAdvancementProvider.desc(COMMUNE)), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.AND).addCriterion("talk_to_consort", ConsortTalkTrigger.Instance.any()).addCriterion("visit_village", PlayerTrigger.TriggerInstance.located((LocationPredicate.Builder)LocationPredicate.Builder.inStructure((Holder)structures.getOrThrow(MSStructures.ConsortVillage.KEY)))).save(saver, MSAdvancementProvider.save_loc(COMMUNE));
        AdvancementHolder frenchFry = Advancement.Builder.advancement().parent(commune).display((ItemLike)MSItems.FRENCH_FRY.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(FRENCH_FRY)), (Component)Component.translatable((String)MSAdvancementProvider.desc(FRENCH_FRY)), null, AdvancementType.TASK, true, true, false).addCriterion("has_french_fry", ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)((ItemLike)MSItems.FRENCH_FRY.get()))).save(saver, MSAdvancementProvider.save_loc(FRENCH_FRY));
        AdvancementHolder bugs = MSAdvancementProvider.consumeBugCriteria(Advancement.Builder.advancement().parent(commune).display((ItemLike)MSItems.CHOCOLATE_BEETLE.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(BUGS)), (Component)Component.translatable((String)MSAdvancementProvider.desc(BUGS)), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.Strategy.OR)).save(saver, MSAdvancementProvider.save_loc(BUGS));
        AdvancementHolder shadyBuyer = Advancement.Builder.advancement().parent(commune).display((ItemLike)MSItems.ROCK_COOKIE.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(SHADY_BUYER)), (Component)Component.translatable((String)MSAdvancementProvider.desc(SHADY_BUYER)), null, AdvancementType.TASK, true, true, false).addCriterion("buy_item", ConsortItemTrigger.Instance.forType(EnumConsort.MerchantType.SHADY)).save(saver, MSAdvancementProvider.save_loc(SHADY_BUYER));
        AdvancementHolder firstStep = Advancement.Builder.advancement().parent(root).display(BoondollarsItem.setCount(new ItemStack((ItemLike)MSItems.BOONDOLLARS.get()), 1L), (Component)Component.translatable((String)MSAdvancementProvider.title(FIRST_STEP)), (Component)Component.translatable((String)MSAdvancementProvider.desc(FIRST_STEP)), null, AdvancementType.TASK, true, true, false).addCriterion("reach_rung", EcheladderTrigger.Instance.rung(MinMaxBounds.Ints.atLeast((int)1))).save(saver, MSAdvancementProvider.save_loc(FIRST_STEP));
        AdvancementHolder doubleDigits = Advancement.Builder.advancement().parent(firstStep).display(BoondollarsItem.setCount(new ItemStack((ItemLike)MSItems.BOONDOLLARS.get()), 100L), (Component)Component.translatable((String)MSAdvancementProvider.title(DOUBLE_DIGITS)), (Component)Component.translatable((String)MSAdvancementProvider.desc(DOUBLE_DIGITS)), null, AdvancementType.TASK, true, true, false).addCriterion("reach_rung", EcheladderTrigger.Instance.rung(MinMaxBounds.Ints.atLeast((int)10))).save(saver, MSAdvancementProvider.save_loc(DOUBLE_DIGITS));
        AdvancementHolder halfwayPoint = Advancement.Builder.advancement().parent(doubleDigits).display(BoondollarsItem.setCount(new ItemStack((ItemLike)MSItems.BOONDOLLARS.get()), 1000L), (Component)Component.translatable((String)MSAdvancementProvider.title(HALFWAY_POINT)), (Component)Component.translatable((String)MSAdvancementProvider.desc(HALFWAY_POINT)), null, AdvancementType.TASK, true, true, false).addCriterion("reach_rung", EcheladderTrigger.Instance.rung(MinMaxBounds.Ints.atLeast((int)25))).save(saver, MSAdvancementProvider.save_loc(HALFWAY_POINT));
        AdvancementHolder bigOneMil = Advancement.Builder.advancement().parent(halfwayPoint).display(BoondollarsItem.setCount(new ItemStack((ItemLike)MSItems.BOONDOLLARS.get()), 1000000L), (Component)Component.translatable((String)MSAdvancementProvider.title(BIG_ONE_MIL)), (Component)Component.translatable((String)MSAdvancementProvider.desc(BIG_ONE_MIL)), null, AdvancementType.GOAL, true, true, false).addCriterion("reach_rung", EcheladderTrigger.Instance.rung(MinMaxBounds.Ints.atLeast((int)44))).save(saver, MSAdvancementProvider.save_loc(BIG_ONE_MIL));
        AdvancementHolder intellibeam = Advancement.Builder.advancement().parent(alchemy).display((ItemLike)MSItems.INTELLIBEAM_LASERSTATION.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(INTELLIBEAM)), (Component)Component.translatable((String)MSAdvancementProvider.desc(INTELLIBEAM)), null, AdvancementType.TASK, true, true, false).addCriterion("use_intellibeam", IntellibeamLaserstationTrigger.Instance.any()).save(saver, MSAdvancementProvider.save_loc(INTELLIBEAM));
        AdvancementHolder strongWeapon = Advancement.Builder.advancement().parent(alchemy).display((ItemLike)MSItems.CALEDFWLCH.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(LEGENDARY_WEAPON)), (Component)Component.translatable((String)MSAdvancementProvider.desc(LEGENDARY_WEAPON)), null, AdvancementType.TASK, true, true, false).addCriterion("get_max_tier_weapon", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(MSTags.Items.LEGENDARY).build()})).save(saver, MSAdvancementProvider.save_loc(LEGENDARY_WEAPON));
        AdvancementHolder buyOutShop = Advancement.Builder.advancement().parent(commune).display((ItemLike)MSItems.CONE_OF_FLIES.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(BUY_OUT_SHOP)), (Component)Component.translatable((String)MSAdvancementProvider.desc(BUY_OUT_SHOP)), null, AdvancementType.TASK, true, true, false).addCriterion("buy_everything", EventTrigger.Instance.buyOutShop()).save(saver, MSAdvancementProvider.save_loc(BUY_OUT_SHOP));
        AdvancementHolder brickComputer = Advancement.Builder.advancement().parent(connect).display((ItemLike)MSItems.OLD_COMPUTER.get(), (Component)Component.translatable((String)MSAdvancementProvider.title(BRICK_COMPUTER)), (Component)Component.translatable((String)MSAdvancementProvider.desc(BRICK_COMPUTER)), null, AdvancementType.CHALLENGE, true, true, true).addCriterion("brick_computer", EventTrigger.Instance.brickComputer()).save(saver, MSAdvancementProvider.save_loc(BRICK_COMPUTER));
    }

    private static Advancement.Builder changeModusCriteria(Advancement.Builder builder) {
        for (Supplier type : Arrays.asList(ModusTypes.STACK, ModusTypes.QUEUE, ModusTypes.QUEUE_STACK, ModusTypes.TREE, ModusTypes.HASH_MAP, ModusTypes.SET)) {
            ResourceLocation id = Objects.requireNonNull(ModusTypes.REGISTRY.getKey((Object)((ModusType)type.get())));
            builder = builder.addCriterion(id.getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemLike[])new ItemLike[]{((ModusType)type.get()).getItem()}));
        }
        return builder;
    }

    private static Advancement.Builder consumeBugCriteria(Advancement.Builder builder) {
        for (ItemLike itemLike : Arrays.asList((Item)MSItems.BUG_ON_A_STICK.get(), (Item)MSItems.CHOCOLATE_BEETLE.get(), (Item)MSItems.CONE_OF_FLIES.get(), (Item)MSItems.GRASSHOPPER.get(), (Item)MSItems.JAR_OF_BUGS.get())) {
            builder = builder.addCriterion(BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem()).getPath(), ConsumeItemTrigger.TriggerInstance.usedItem((ItemLike)itemLike));
        }
        return builder;
    }

    private static String title(String name) {
        return "advancements." + name + ".title";
    }

    private static String desc(String name) {
        return "advancements." + name + ".description";
    }

    private static String save_loc(String name) {
        return "minestuck:" + name.replace('.', '/');
    }
}

