/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.mraof.minestuck.data.BetterCombatProvider;
import com.mraof.minestuck.data.BoondollarPriceProvider;
import com.mraof.minestuck.data.ComputerThemeProvider;
import com.mraof.minestuck.data.DataMapGenerator;
import com.mraof.minestuck.data.EcheladderExpSourceProvider;
import com.mraof.minestuck.data.GeneratedGristCostConfigProvider;
import com.mraof.minestuck.data.MSAdvancementProvider;
import com.mraof.minestuck.data.MSBlockStateProvider;
import com.mraof.minestuck.data.MSDamageTypeProvider;
import com.mraof.minestuck.data.MinestuckEnUsLanguageProvider;
import com.mraof.minestuck.data.MinestuckItemModelProvider;
import com.mraof.minestuck.data.RungsProvider;
import com.mraof.minestuck.data.StartingModusProvider;
import com.mraof.minestuck.data.dialogue.CarapacianSoldierDialogue;
import com.mraof.minestuck.data.dialogue.ConsortDialogue;
import com.mraof.minestuck.data.dialogue.ConsortFoodMerchantDialogue;
import com.mraof.minestuck.data.dialogue.ConsortGeneralMerchantDialogue;
import com.mraof.minestuck.data.dialogue.ShadyConsortDialogue;
import com.mraof.minestuck.data.loot_table.MSLootModifiers;
import com.mraof.minestuck.data.loot_table.MinestuckLootTableProvider;
import com.mraof.minestuck.data.recipe.MinestuckRecipeProvider;
import com.mraof.minestuck.data.tag.MSEffectTagsProvider;
import com.mraof.minestuck.data.tag.MSGristTypeTagsProvider;
import com.mraof.minestuck.data.tag.MSStructureTagsProvider;
import com.mraof.minestuck.data.tag.MinestuckBiomeTagsProvider;
import com.mraof.minestuck.data.tag.MinestuckBlockTagsProvider;
import com.mraof.minestuck.data.tag.MinestuckEntityTypeTagsProvider;
import com.mraof.minestuck.data.tag.MinestuckFluidTagsProvider;
import com.mraof.minestuck.data.tag.MinestuckItemTagsProvider;
import com.mraof.minestuck.data.tag.TerrainLandTypeTagsProvider;
import com.mraof.minestuck.data.tag.TitleLandTypeTagsProvider;
import com.mraof.minestuck.data.worldgen.BiomeModifierProvider;
import com.mraof.minestuck.data.worldgen.MSBiomeProvider;
import com.mraof.minestuck.data.worldgen.MSConfiguredFeatureProvider;
import com.mraof.minestuck.data.worldgen.MSDensityFunctionProvider;
import com.mraof.minestuck.data.worldgen.MSNoiseParametersProvider;
import com.mraof.minestuck.data.worldgen.MSPlacedFeatureProvider;
import com.mraof.minestuck.data.worldgen.MSStructureProvider;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.MOD)
public final class MinestuckData {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput output = gen.getPackOutput();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        DatapackBuiltinEntriesProvider builtinEntries = (DatapackBuiltinEntriesProvider)gen.addProvider(event.includeServer(), (DataProvider)new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), MinestuckData.registrySetBuilder(), Set.of("minestuck")));
        CompletableFuture lookupProvider = builtinEntries.getRegistryProvider();
        MinestuckBlockTagsProvider blockTags = (MinestuckBlockTagsProvider)gen.addProvider(event.includeServer(), (DataProvider)new MinestuckBlockTagsProvider(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MinestuckItemTagsProvider(output, lookupProvider, blockTags.contentsGetter(), fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MinestuckFluidTagsProvider(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MinestuckEntityTypeTagsProvider(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MSEffectTagsProvider(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MinestuckBiomeTagsProvider(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MSStructureTagsProvider(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MSGristTypeTagsProvider(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new TerrainLandTypeTagsProvider(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new TitleLandTypeTagsProvider(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new MSDamageTypeProvider.Tags(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new DataMapGenerator(output, event.getLookupProvider()));
        gen.addProvider(event.includeServer(), (DataProvider)new MinestuckRecipeProvider(output, event.getLookupProvider()));
        gen.addProvider(event.includeServer(), (DataProvider)new GeneratedGristCostConfigProvider(output, "minestuck"));
        gen.addProvider(event.includeServer(), (DataProvider)new ComputerThemeProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new BoondollarPriceProvider(output, "minestuck"));
        gen.addProvider(event.includeServer(), (DataProvider)MinestuckLootTableProvider.create(output, event.getLookupProvider()));
        gen.addProvider(event.includeServer(), (DataProvider)new MSLootModifiers(output, event.getLookupProvider()));
        gen.addProvider(event.includeServer(), MSAdvancementProvider.create(output, lookupProvider, fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new StartingModusProvider(output, "minestuck"));
        gen.addProvider(event.includeServer(), (DataProvider)new EcheladderExpSourceProvider(output));
        gen.addProvider(event.includeServer(), (DataProvider)new RungsProvider(output));
        gen.addProvider(event.includeClient(), (DataProvider)new MSBlockStateProvider(output, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new MinestuckItemModelProvider(output, fileHelper));
        MinestuckEnUsLanguageProvider enUsLanguageProvider = (MinestuckEnUsLanguageProvider)gen.addProvider(event.includeClient(), (DataProvider)new MinestuckEnUsLanguageProvider(output));
        gen.addProvider(event.includeServer(), ConsortDialogue.create(output, enUsLanguageProvider));
        gen.addProvider(event.includeServer(), ShadyConsortDialogue.create(output, enUsLanguageProvider));
        gen.addProvider(event.includeServer(), ConsortFoodMerchantDialogue.create(output, enUsLanguageProvider));
        gen.addProvider(event.includeServer(), ConsortGeneralMerchantDialogue.create(output, enUsLanguageProvider));
        gen.addProvider(event.includeServer(), CarapacianSoldierDialogue.create(output, enUsLanguageProvider));
        gen.addProvider(event.includeServer(), (DataProvider)new BetterCombatProvider(output));
    }

    private static RegistrySetBuilder registrySetBuilder() {
        return new RegistrySetBuilder().add(Registries.NOISE, MSNoiseParametersProvider::register).add(Registries.DENSITY_FUNCTION, MSDensityFunctionProvider::register).add(Registries.CONFIGURED_FEATURE, MSConfiguredFeatureProvider::register).add(Registries.PLACED_FEATURE, MSPlacedFeatureProvider::register).add(Registries.BIOME, MSBiomeProvider::register).add(Registries.STRUCTURE, MSStructureProvider::registerStructures).add(Registries.STRUCTURE_SET, MSStructureProvider::registerStructureSets).add(Registries.DAMAGE_TYPE, MSDamageTypeProvider::register).add(NeoForgeRegistries.Keys.BIOME_MODIFIERS, BiomeModifierProvider::register);
    }
}

