/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.block.ItemBlockPair;
import com.mraof.minestuck.computer.theme.ComputerTheme;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.EnumClass;
import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.LanguageProvider;

public abstract class MinestuckLanguageProvider
extends LanguageProvider {
    private final String modid;

    public MinestuckLanguageProvider(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
        this.modid = modid;
    }

    protected void add(ItemBlockPair<?, ?> pair, String name) {
        this.add((Block)pair.asBlock(), name);
    }

    protected void addBlockTooltip(Supplier<Block> key, String value) {
        this.addTooltip((ItemLike)key.get(), value);
    }

    protected void addItemTooltip(Supplier<Item> key, String value) {
        this.addTooltip((ItemLike)key.get(), value);
    }

    protected void addTooltip(ItemLike key, String value) {
        this.addExtra(key, "tooltip", value);
    }

    protected void addBlockExtra(Supplier<Block> key, String type, String value) {
        this.addExtra((ItemLike)key.get(), type, value);
    }

    protected void addItemExtra(Supplier<Item> key, String type, String value) {
        this.addExtra((ItemLike)key.get(), type, value);
    }

    protected void addExtra(ItemLike key, String type, String value) {
        this.add(key.asItem().getDescriptionId() + "." + type, value);
    }

    protected void addBlockStore(Supplier<Block> key, String value) {
        this.addStore((ItemLike)key.get(), value);
    }

    protected void addItemStore(Supplier<Item> key, String value) {
        this.addStore((ItemLike)key.get(), value);
    }

    protected void addStore(ItemLike key, String value) {
        this.add("store." + key.asItem().getDescriptionId(), value);
    }

    protected void addItemStackStore(Supplier<ItemStack> key, String value) {
        this.addStore(key.get(), value);
    }

    protected void addStore(ItemStack key, String value) {
        this.add("store." + key.getDescriptionId(), value);
    }

    protected void addBlockStoreTooltip(Supplier<Block> key, String value) {
        this.addStoreTooltip((ItemLike)key.get(), value);
    }

    protected void addItemStoreTooltip(Supplier<Item> key, String value) {
        this.addStoreTooltip((ItemLike)key.get(), value);
    }

    protected void addStoreTooltip(ItemLike key, String value) {
        this.add("store." + key.asItem().getDescriptionId() + ".tooltip", value);
    }

    protected void addItemStackStoreTooltip(Supplier<ItemStack> key, String value) {
        this.addStoreTooltip(key.get(), value);
    }

    protected void addStoreTooltip(ItemStack key, String value) {
        this.add("store." + key.getDescriptionId() + ".tooltip", value);
    }

    protected void add(CreativeModeTab key, String value) {
        this.add(((TranslatableContents)key.getDisplayName().getContents()).getKey(), value);
    }

    protected void addEntityTypeExtra(Supplier<? extends EntityType<?>> key, String type, String value) {
        this.addExtra(key.get(), type, value);
    }

    protected void addExtra(EntityType<?> key, String type, String value) {
        this.add(key.getDescriptionId() + "." + type, value);
    }

    protected void addGristType(Supplier<GristType> key, String value) {
        this.add(key.get(), value);
    }

    protected void add(GristType key, String value) {
        this.add(key.getTranslationKey(), value);
    }

    protected void add(EnumClass key, String value) {
        this.add(key.getTranslationKey(), value);
    }

    protected void add(EnumAspect key, String value) {
        this.add(key.getTranslationKey(), value);
    }

    protected void addDenizen(EnumAspect key, String value) {
        this.add("denizen." + key.getTranslationKey(), value);
    }

    protected void addRung(int rung, String value) {
        this.add(Echeladder.translationKey(rung), value);
    }

    protected void addAdvancement(String key, String title, String description) {
        this.add("advancements." + key + ".title", title);
        this.add("advancements." + key + ".description", description);
    }

    protected void addLand(String key, String value) {
        this.add("land." + key, value);
    }

    protected void addStrife(String key, String value) {
        this.add("strife." + key, value);
    }

    protected void addSubtitles(String key, String value) {
        this.add("subtitles." + this.modid + "." + key, value);
    }

    protected void addEntitySubtitles(Supplier<? extends EntityType<?>> type, String key, String value) {
        this.add("subtitles." + type.get().getDescriptionId() + "." + key, value);
    }

    protected void addColor(String key, String value) {
        this.add("minestuck.color." + key, value);
    }

    protected void addBaseDeathMessage(String key, String value) {
        this.add("death.attack." + key, value);
    }

    protected void addKillCreditDeathMessage(String key, String value) {
        this.add("death.attack." + key + ".player", value);
    }

    protected void addDeathMessageWithItem(String key, String value) {
        this.add("death.attack." + key + ".item", value);
    }

    protected void addSimpleDeathMessage(String key, String base, String killCredit) {
        this.addBaseDeathMessage(key, base);
        this.addKillCreditDeathMessage(key, killCredit);
    }

    protected void addEntitySourceDeathMessage(String key, String base, String withItem) {
        this.addBaseDeathMessage(key, base);
        this.addDeathMessageWithItem(key, withItem);
    }

    protected void addThemeName(ResourceLocation themeId, String themeName) {
        this.add(ComputerTheme.translationKeyFromId(themeId), themeName);
    }
}

