/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.entity.dialogue.condition.Conditions;
import com.mraof.minestuck.player.Rung;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RungsProvider
implements DataProvider {
    public static final ResourceLocation HEALTH_BOOST_ID = Minestuck.id("echeladder_health_boost");
    public static final ResourceLocation DAMAGE_BOOST_ID = Minestuck.id("echeladder_damage_boost");
    public static final ResourceLocation UNDERLING_PROTECTION_ID = Minestuck.id("echeladder_underling_protection");
    public static final ResourceLocation UNDERLING_DAMAGE_ID = Minestuck.id("echeladder_underling_damage");
    public static final ResourceLocation FALL_DAMAGE_REDUCTION_ID = Minestuck.id("echeladder_fall_damage_reduction");
    public static final String MUST_ENTER = "echeladder.must_enter";
    private final PackOutput output;
    private final List<Rung> rungs = new ArrayList<Rung>();
    private int rungIterate = 0;

    public RungsProvider(PackOutput output) {
        this.output = output;
    }

    protected void createRungs() {
        this.add(-11545600, 16645931, 0L, 60L);
        this.add(-65536, 0x404040, 50L, 75L);
        this.add(-6984628, 11992832, 75L, 93L);
        this.add(-8540105, 7821078, 105L, 116L);
        this.add(-2578944, 0xFFFFFF, 140L, 145L);
        this.add(-8454144, 16738816, 170L, 181L);
        this.add(-16744690, 38143, 200L, 226L);
        this.add(-8355712, 0x3F3F3F, 250L, 282L, Optional.of(new Rung.RungCondition(Conditions.hasEntered(), MUST_ENTER)));
        this.add(-16711903, 32639, 320L, 352L);
        this.add(-12058369, 11665663, 425L, 440L);
        this.add(-12566464, 8101045, 575L, 550L);
        this.add(-1769728, 7182848, 790L, 687L);
        this.add(-2114708, 2201121, 1140L, 858L);
        this.add(-3223858, 8352831, 1630L, 1072L);
        this.add(-65536, 0xFF7F7F, 2230L, 1340L);
        this.add(-3764659, 11471500, 2980L, 1675L);
        this.add(-10427052, 2791001, 3850L, 2093L);
        this.add(-7811448, 16767218, 4800L, 2616L);
        this.add(-16748868, 0xFFFFFF, 6000L, 3270L);
        this.add(-971994, 14352255, 7500L, 4087L);
        this.add(-4124672, 3430844, 9500L, 5108L);
        this.add(-4551884, 14674024, 11900L, 6385L);
        this.add(-11455320, 2794451, 15200L, 7981L);
        this.add(-7156736, 0x4C4C4C, 19300L, 9976L);
        this.add(-7118533, 54040, 24400L, 12470L);
        this.add(-15658719, 7283365, 45000L, 15587L);
        this.add(-2745560, 12888617, 68000L, 19483L);
        this.add(-1080959, 2325504, 95500L, 24353L);
        this.add(-1221606, 0x2D2D2D, 124000L, 30441L);
        this.add(-2368549, 16738081, 180000L, 38051L);
        this.add(-1064192, 8685536, 260000L, 47563L);
        this.add(-13293147, 0, 425000L, 59453L);
        this.add(-10272735, 0xADADAD, 632000L, 74316L);
        this.add(-4408132, 14828544, 880000L, 92895L);
        this.add(-4582144, 14841353, 1000000L, 116118L);
        this.add(-12409931, 657568, 1000000L, 145147L);
        this.add(-12819628, 13018659, 1000000L, 181433L);
        this.add(-3885439, 3719505, 1000000L, 226791L);
        this.add(-6908266, 16361024, 1000000L, 283488L);
        this.add(-9737365, 3575370, 1000000L, 354360L);
        this.add(-5432413, 0xFFFFFF, 1000000L, 442950L);
        this.add(-16768513, 41409, 1000000L, 553687L);
        this.add(-16777216, 7039390, 1000000L, 692108L);
        this.add(-14069861, 0x2D2D2D, 1000000L, 865135L);
        this.add(-5396357, 1577338, 1000000L, 1081418L);
        this.add(-12345803, 16748584, 1000000L, 1351772L);
        this.add(-7448514, 2063502, 1000000L, 1689715L);
        this.add(-10461088, 14831634, 1000000L, 2112143L);
        this.add(-2242478, 9904608, 1000000L, 2640178L);
        this.add(-1, 0, 1000000L, 3300222L);
    }

    private void add(int backgroundColor, int textColor, long boondollars, long gristCapacity) {
        this.add(backgroundColor, textColor, boondollars, gristCapacity, Optional.empty());
    }

    private void add(int backgroundColor, int textColor, long boondollars, long gristCapacity, Optional<Rung.RungCondition> rungCondition) {
        this.rungs.add(new Rung(this.rungIterate, backgroundColor, textColor, RungsProvider.rungRequirement(this.rungIterate), boondollars, gristCapacity, rungCondition));
        ++this.rungIterate;
    }

    private static long rungRequirement(int rung) {
        return 15L * (long)rung + 10L;
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        this.createRungs();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(this.rungs.size());
        Path path = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve("minestuck").resolve("minestuck/config/rungs.json");
        JsonElement jsonElement = (JsonElement)Rung.LIST_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, this.rungs).getOrThrow();
        futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonElement, (Path)path));
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return "Minestuck Rungs";
    }
}

