/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.inventory.captchalogue.ModusTypes;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class StartingModusProvider
implements DataProvider {
    private final PackOutput output;
    private final String modid;

    public StartingModusProvider(PackOutput output, String modid) {
        this.output = output;
        this.modid = modid;
    }

    protected List<ModusType<?>> createDefaultModusTypes() {
        return List.of(ModusTypes.STACK.get(), ModusTypes.QUEUE.get());
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        Path path = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(this.modid).resolve("minestuck/config/starting_modus.json");
        List<ModusType<?>> modusTypes = this.createDefaultModusTypes();
        JsonArray jsonList = new JsonArray(modusTypes.size());
        modusTypes.forEach(modusType -> jsonList.add(String.valueOf(ModusTypes.REGISTRY.getKey(modusType))));
        return DataProvider.saveStable((CachedOutput)cache, (JsonElement)jsonList, (Path)path);
    }

    public String getName() {
        return "Minestuck Starting Modus";
    }
}

