/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.dialogue;

import com.mraof.minestuck.data.dialogue.ChainBuilder;
import com.mraof.minestuck.data.dialogue.DialogueLangHelper;
import com.mraof.minestuck.data.dialogue.DialogueProvider;
import com.mraof.minestuck.data.dialogue.FolderedDialogue;
import com.mraof.minestuck.data.dialogue.SelectableDialogueProvider;
import com.mraof.minestuck.entity.consort.EnumConsort;
import com.mraof.minestuck.entity.dialogue.DialogueMessage;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import com.mraof.minestuck.entity.dialogue.Trigger;
import com.mraof.minestuck.entity.dialogue.condition.Condition;
import com.mraof.minestuck.entity.dialogue.condition.Conditions;
import com.mraof.minestuck.item.MSItems;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.common.data.LanguageProvider;

public final class CarapacianSoldierDialogue {
    public static DataProvider create(PackOutput output, LanguageProvider enUsLanguageProvider) {
        SelectableDialogueProvider provider = new SelectableDialogueProvider("minestuck", RandomlySelectableDialogue.DialogueCategory.CARAPACIAN_SOLDIER, output);
        DialogueLangHelper l = new DialogueLangHelper("minestuck", enUsLanguageProvider);
        CarapacianSoldierDialogue.carapacianDialogues(provider, l);
        return provider;
    }

    private static void carapacianDialogues(SelectableDialogueProvider provider, DialogueLangHelper l) {
        provider.addRandomlySelectable("dread_waiting", SelectableDialogueProvider.defaultWeight(Conditions.isInLand()), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They explain that sometimes it's more exhausting to be posted on a Land since there isn't any fighting. If you aren't in combat you have time to think. That's when the dread sets in.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("forlorn", SelectableDialogueProvider.defaultWeight(Conditions.isInSkaia()), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("Sometimes they wish they could just all set their weapons down and be done with this war.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("constant_nakking", SelectableDialogueProvider.defaultWeight(Conditions.isInConsortLand(EnumConsort.NAKAGATOR)), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They describe how they have a huge headache from the constant nakking.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("too_quiet", SelectableDialogueProvider.defaultWeight(Conditions.isInConsortLand(EnumConsort.TURTLE)), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They look around paranoid, saying that while the turtles are a nice change of pace from the other consorts they've come across, they are so quiet its unnerving.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("constant_thipping", SelectableDialogueProvider.defaultWeight(Conditions.isInConsortLand(EnumConsort.IGUANA)), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("One of the nearby iguanas asked for some food and when they gave it to them the iguana complained for an hour about the \"lack of a comprehensive flavor profile\".", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("glub_glub", SelectableDialogueProvider.defaultWeight(Conditions.isInConsortLand(EnumConsort.SALAMANDER)), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They hear the local salamanders glub so often that it's started to become part of their own vocabulary. Glub glub.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("rain_sleet_or_snow", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They sigh and share that they would love to deliver mail one day. That has to be one of the most honorable professions out there.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("dreamer", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), new FolderedDialogue(builder -> {
            ResourceLocation explainDreamers = builder.add("explain_dreamers", new ChainBuilder().node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They explain that Dreamers are heroes who reside in towers on the moons of Prospit and Derse.", new DialogueMessage.Argument[0]))).node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("There is one for each Land that exists, although they don't know what the connection is there.", new DialogueMessage.Argument[0]))));
            builder.addStart(new DialogueProvider.NodeSelectorBuilder().node(Conditions.hasEntered(), CarapacianSoldierDialogue.descriptionNode(l.subMsg("familiar", "They look at you with surprise, saying you remind them of the Dreamers.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("who", "Who are the Dreamers?", new DialogueMessage.Argument[0])).nextDialogue(explainDreamers))).defaultNode(CarapacianSoldierDialogue.descriptionNode(l.subMsg("unfamiliar", "They are curious as to who you are and what you are doing here.", new DialogueMessage.Argument[0]))));
        }));
        provider.addRandomlySelectable("not_so_bad", SelectableDialogueProvider.defaultWeight(Conditions.isInSkaia()), new ChainBuilder().node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They recount one time where they went out to an isolated part of the Battlefield. Unexpectedly, a member of enemy scouting party came across them while sat on a hill side.", new DialogueMessage.Argument[0]))).node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They went to draw their weapon only to realize they forgot it back at camp. The two soldiers stared at each other for what felt like ages.", new DialogueMessage.Argument[0]))).node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("To make things worse, the rest of the scouting party called out to see what was going on. But just when they thought their life was coming to an end, the other soldier pretended like they weren't there and announced that the area was clear.", new DialogueMessage.Argument[0]))).node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They never ran so fast, trying to get back somewhere safe. And they certainly never leave anywhere without a weapon now.", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("enemy", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInSkaia(), Conditions.isProspitian())), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They are panicking about whether any Dersites are nearby.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("propaganda", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInSkaia(), Conditions.isDersite())), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They already knew that the propaganda surrounding Prospitians was fake but it was still surprising to see that they didn't have horns or cool fangs or blood red eyes. Kind of a bummer honestly.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("teeth", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They find it curious that certain carapacians have sharp jagged teeth when the vast majority have rounded ones.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("foreign_land", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They describe how rare it is for a Prospitian to visit Derse or a Dersite to visit Prospit. The presence of someone from the other kingdom can be unnerving.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("poor_frogs", SelectableDialogueProvider.defaultWeight(Conditions.isProspitian()), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They lament how Dersites treat frogs and frog paraphernalia. Croaks and ribbits are in the top 5 best sounds to exist, why would you want to squish an animal that makes those sorts of sounds?", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("meditative_travel", SelectableDialogueProvider.defaultWeight(Conditions.isDersite()), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They say that not everyone enjoys how far the travel is from Derse to Skaia, but that they do. It can be nice to just close your eyes while in the shuttle or stare out into the inky blackness.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("skaia_dense", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They comment on how you can't really see the Battlefield from beyond Skaia. And when you are on the Battlefield you can't see much of the Medium.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("remember_cloning", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), new FolderedDialogue(builder -> {
            DialogueProvider.MessageProducer goodToKnow = l.subMsg("good_to_know", "Oh, good to know.", new DialogueMessage.Argument[0]);
            ResourceLocation made = builder.add("made", CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("Made.", new DialogueMessage.Argument[0])).animation("angry").addDescription(l.subMsg("made.desc", "They clearly don't want to talk about this more.", new DialogueMessage.Argument[0])));
            ResourceLocation veil = builder.add("veil", new ChainBuilder().node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They ask if you have seen the ring of asteroids orbiting Skaia. That is the Veil.", new DialogueMessage.Argument[0]))).node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("It is not uncommon for the asteroids in the Veil to have buildings on them, built onto the surface. Some even contain sprawling complexes under the surface.", new DialogueMessage.Argument[0]))).node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("Included amongst those facilities are laboratories where carapacians from both kingdoms get made.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("huh", "\"Made\"?", new DialogueMessage.Argument[0])).nextDialogue(made)).addClosingResponse(goodToKnow)));
            builder.addStart(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They shudder, remembering events from early in their life. They never want to go back.", new DialogueMessage.Argument[0])).animation("anxious").addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("go_where", "Go back to where?", new DialogueMessage.Argument[0])).nextDialogue(veil)).addClosingResponse(l.subMsg("bye", "Goodbye.", new DialogueMessage.Argument[0])));
        }));
        provider.addRandomlySelectable("sword_barter", SelectableDialogueProvider.weighted(40, Conditions.isHolding((Item)MSItems.REGISWORD.get())), new FolderedDialogue(builder -> {
            DialogueProvider.MessageProducer goodbye = l.subMsg("goodbye", "That's really strange. Good luck with that!", new DialogueMessage.Argument[0]);
            ResourceLocation thanks = builder.add("thanks", CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They thank you for helping them.", new DialogueMessage.Argument[0])));
            ResourceLocation barter = builder.add("barter", CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They ask if you have a new sword for them.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("give_item", "[Give them the %s]", DialogueMessage.Argument.MATCHED_ITEM)).addPlayerMessage(l.subMsg("give_item.reply", "Here you go!", new DialogueMessage.Argument[0])).visibleCondition(l.subText("give_item.condition", "Must have a sword, excluding a regisword"), new Condition.ItemTagMatchExclude((TagKey<Item>)ItemTags.SWORDS, (Item)MSItems.REGISWORD.get())).addTrigger(new Trigger.SetNPCMatchedItem(EquipmentSlot.MAINHAND)).addTrigger(new Trigger.GiveItem((Item)MSItems.REGISWORD.get(), 1)).addTrigger(new Trigger.SetDialogue(thanks)).nextDialogue(thanks)).addClosingResponse(l.subMsg("not_yet", "Not yet.", new DialogueMessage.Argument[0])));
            ResourceLocation badMood = builder.add("bad_mood", CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They explain that the arch agent does not always get along with the Black Queen and when he gets in a bad mood he allegedly will order his minions to go and distribute a bunch of these swords around. Apparently the queen is even aware of it and finds it amusing.", new DialogueMessage.Argument[0])));
            ResourceLocation frequently = builder.add("frequently", CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They mention that the last few times they were outside the palace, there was a bin labelled \"Regicide weapon disposal\". It was always full.", new DialogueMessage.Argument[0])));
            builder.addStart(new ChainBuilder().node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("They mention that the weirdest thing happened earlier.", new DialogueMessage.Argument[0]))).node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("A Dersite agent wandered up to them and shoved this sword into their hands. He loudly exclaimed that it would be such a shame if a member of royalty was \"forcibly retired\" because anyone who would do such a thing \"might just become the wealthiest carapacian to ever live\".", new DialogueMessage.Argument[0]))).node(CarapacianSoldierDialogue.descriptionNode(l.defaultKeyMsg("Not having another sword they just kind of brought it into battle, but now they wish it would be gone.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("suggestion", "Maybe I could find you something else to use?", new DialogueMessage.Argument[0])).nextDialogue(barter).setNextAsEntrypoint()).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("derse_loyalty", "Why would an agent of Derse want the Dersite royalty dead?", new DialogueMessage.Argument[0])).condition(Conditions.isDersite()).nextDialogue(badMood)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("prospitian_loyalty", "Have the agents tried anything like this before?", new DialogueMessage.Argument[0])).condition(Conditions.isProspitian()).nextDialogue(frequently)).addClosingResponse(goodbye)));
        }));
    }

    private static DialogueProvider.NodeBuilder descriptionNode(DialogueProvider.MessageProducer message) {
        return new DialogueProvider.NodeBuilder(DialogueLangHelper.msg(DialogueProvider.DOTS)).addDescription(message);
    }
}

