/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.dialogue;

import com.mraof.minestuck.data.dialogue.DialogueProvider;
import com.mraof.minestuck.entity.dialogue.Dialogue;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class ChainBuilder
implements DialogueProvider.DialogueProducer,
DialogueProvider.NodeProducer {
    private boolean withFolders = false;
    private final List<DialogueProvider.NodeBuilder> nodes = new ArrayList<DialogueProvider.NodeBuilder>();
    private boolean loop = false;

    public ChainBuilder withFolders() {
        this.withFolders = true;
        return this;
    }

    public ChainBuilder node(DialogueProvider.NodeBuilder nodeBuilder) {
        this.nodes.add(nodeBuilder);
        return this;
    }

    public ChainBuilder loop() {
        this.loop = true;
        return this;
    }

    private <T> T build(ResourceLocation id, BiConsumer<ResourceLocation, Dialogue.NodeSelector> register, BiFunction<DialogueProvider.NodeBuilder, ResourceLocation, T> startNodeBuilder) {
        int index2;
        if (this.nodes.isEmpty()) {
            throw new IllegalStateException("Nodes must be added to this chain builder");
        }
        List<ResourceLocation> ids = IntStream.range(0, this.nodes.size()).mapToObj(index -> id.withSuffix((this.withFolders ? "/" : ".") + (index + 1))).toList();
        for (index2 = 1; index2 < this.nodes.size(); ++index2) {
            this.nodes.get(index2 - 1).next(ids.get(index2));
        }
        if (this.loop) {
            this.nodes.get(this.nodes.size() - 1).next(ids.get(0));
        }
        for (index2 = 1; index2 < this.nodes.size(); ++index2) {
            this.nodes.get(index2).buildAndRegister(ids.get(index2), register);
        }
        return startNodeBuilder.apply(this.nodes.get(0), ids.get(0));
    }

    @Override
    public Dialogue.Node buildNode(ResourceLocation id, BiConsumer<ResourceLocation, Dialogue.NodeSelector> register) {
        return this.build(id, register, (startNode, startId) -> startNode.buildNode((ResourceLocation)startId, register));
    }

    @Override
    public ResourceLocation buildAndRegister(ResourceLocation id, BiConsumer<ResourceLocation, Dialogue.NodeSelector> register) {
        return this.build(id, register, (startNode, startId) -> startNode.buildAndRegister((ResourceLocation)startId, register));
    }
}

