/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.dialogue;

import com.mraof.minestuck.data.dialogue.ChainBuilder;
import com.mraof.minestuck.data.dialogue.DialogueLangHelper;
import com.mraof.minestuck.data.dialogue.DialogueProvider;
import com.mraof.minestuck.data.dialogue.FolderedDialogue;
import com.mraof.minestuck.data.dialogue.SelectableDialogueProvider;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.dialogue.DialogueMessage;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import com.mraof.minestuck.entity.dialogue.Trigger;
import com.mraof.minestuck.entity.dialogue.condition.Condition;
import com.mraof.minestuck.entity.dialogue.condition.Conditions;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.world.lands.LandTypes;
import java.util.List;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.LanguageProvider;
import net.neoforged.neoforge.registries.DeferredItem;

public final class ConsortDialogue {
    public static DataProvider create(PackOutput output, LanguageProvider enUsLanguageProvider) {
        SelectableDialogueProvider provider = new SelectableDialogueProvider("minestuck", RandomlySelectableDialogue.DialogueCategory.CONSORT, output);
        DialogueLangHelper l = new DialogueLangHelper("minestuck", enUsLanguageProvider);
        ConsortDialogue.consortDialogues(provider, l);
        return provider;
    }

    private static void consortDialogues(SelectableDialogueProvider provider, DialogueLangHelper l) {
        String helpingPlayer = "helpingPlayer";
        ResourceLocation genericThanks = provider.dialogue().add("generic_thanks", (DialogueProvider.DialogueProducer)new DialogueProvider.NodeSelectorBuilder().node(new Condition.Flag(helpingPlayer), new DialogueProvider.NodeBuilder(l.subMsg("player_helped", "Thank you for helping me!", new DialogueMessage.Argument[0])).animation("happy")).defaultNode(new DialogueProvider.NodeBuilder(l.subMsg("other_helped", "Someone else really helped me earlier", new DialogueMessage.Argument[0])).animation("happy")));
        ResourceLocation thanks = provider.dialogue().add("thanks", (DialogueProvider.DialogueProducer)new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Thanks!", new DialogueMessage.Argument[0])));
        DialogueProvider.MessageProducer sadFaceMsg = l.msg("sad_face", ":(", new DialogueMessage.Argument[0]);
        DialogueProvider.MessageProducer yesMsg = l.msg("yes", "Yes", new DialogueMessage.Argument[0]);
        DialogueProvider.MessageProducer noMsg = l.msg("no", "No", new DialogueMessage.Argument[0]);
        DialogueProvider.MessageProducer thanksGoodbyeMsg = l.msg("goodbye", "Oh good to know, bye.", new DialogueMessage.Argument[0]);
        provider.addRandomlySelectable("blown_away", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.WIND)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Someone in the village was blown away in one of the recent wind storms.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("pipe_network", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.WIND)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The pipes are supposed to connect together in a complex network, but I wonder if that's actually the case.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("underling_pipes", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.WIND)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("These underlings creep me out! I saw one of the tiny ones squeeze its way out of a pipe covered in who knows what.", new DialogueMessage.Argument[0])).animation("angry")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("At least I have the sensibility to be ashamed when I'm caught doing that.", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("wind_blast", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.WIND)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I used to play a game where I would sit on a pipe and wait for a blast of air from it to send me flying upwards.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).nextDialogue("hurt", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I always enjoy the sensation of a flurry of wind as I plummeted back down to the hard hard ground.", new DialogueMessage.Argument[0])).animation("happy").addClosingResponse())));
        provider.addRandomlySelectable("pyre", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.WIND), Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.TURTLE))), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("If only I was faster than the wind! That would be fun!", new DialogueMessage.Argument[0])).animation("happy")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Actually, nevermind. I would be burned on a pyre for being a witch due to our primal society.", new DialogueMessage.Argument[0])).animation("anxious")));
        provider.addRandomlySelectable("koolaid", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.PULSE), Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.TURTLE))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Some people say the oceans of blood are actually kool-aid. I'm too scared to taste it for myself.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("murder_rain", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.PULSE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You don't want to know what it's like to be outside when it rains. You can't tell who's a murderer or who forgot an umbrella!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("swimming", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.PULSE), Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.TURTLE))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("If you're looking for a good land to swim in, it's definitely not this one.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("blood_surprise", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.PULSE), Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.NAKAGATOR))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("OH GOD IS THAT BLOOD oh wait nevermind.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("skeleton_horse", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.THUNDER)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Some people say at night, skeletons riding skeleton horses come through the town.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("blue_moon", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.THUNDER), Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.IGUANA))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Every once in a blue moon, lightning strikes and burns down the village. We have to rebuild it!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("lightning_strike", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.THUNDER), Conditions.isAnyEntityType(MSEntityTypes.TURTLE))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You don't want to be struck by lightning. No one does.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("reckoning", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.THUNDER)), new ChainBuilder().withFolders().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Those darn doomsayers, preaching about the Apocalypse and The Reckoning and such!", new DialogueMessage.Argument[0])).animation("angry")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("What's The Reckoning? It's when meteors from The Veil are sent towards Skaia.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Like any reasonable %s believes in that!", DialogueMessage.Argument.ENTITY_TYPE))));
        provider.addRandomlySelectable("thunder_death", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.THUNDER), Conditions.isInTerrainLand(LandTypes.WOOD))), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("We're lucky to have rain with this weather.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Otherwise the thunder would surely have been our death.", new DialogueMessage.Argument[0])).addClosingResponse()));
        provider.addRandomlySelectable("hardcore", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.THUNDER), Conditions.isInTerrainLand(LandTypes.HEAT))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This land is HARDCORE! There's lava and lightning wherever you go!", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("thunder_throw", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.THUNDER), Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.SALAMANDER))), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Nemesis has been throwing thunder for generations, not stopping for even a moment.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("They are even doing it in their sleep. Can you believe that?", new DialogueMessage.Argument[0])).addClosingResponse()));
        provider.addRandomlySelectable("bunny_birthday", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.RABBITS), Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR, MSEntityTypes.SALAMANDER))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Our daughter wants a bunny for her birthday, even though she caught six in the past three hours.", new DialogueMessage.Argument[0])).addClosingResponse().addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("question", "You have a daughter?", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("question.reply", "You have a daughter?", new DialogueMessage.Argument[0])).nextDialogue("whatever", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("An uncle. My cousin. Whatever, I'm not keeping track of potential familial relationships.", new DialogueMessage.Argument[0])).addClosingResponse())));
        provider.addRandomlySelectable("rabbit_eating", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.RABBITS), Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.SALAMANDER))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("One time our village ran out of food and we tried eating rabbits. It was a dark period in our village history.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("edgy_life_hatred", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.RABBITS), Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.NAKAGATOR))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This place is just so full of life! I despise it.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("rabbit.food_shortage", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.RABBITS), Conditions.isInTerrainLand(MSTags.TerrainLandTypes.IS_DESOLATE))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This land is already pretty desolate. There being lots of rabbits eating everything they find doesn't help!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).condition(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR)).nextDialogue("other_way", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("But with that many rabbits around, there sure are other ways of getting food...", new DialogueMessage.Argument[0])).addClosingResponse())));
        provider.addRandomlySelectable("rabbit_food", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.RABBITS), Conditions.any(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.IS_DESOLATE), Conditions.isInTerrainLand(LandTypes.FUNGI), Conditions.isInTerrainLand(LandTypes.SHADE)))), new FolderedDialogue(builder -> {
            ResourceLocation cacti = builder.add("cacti", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Except maybe cacti, but would rabbits eat something that prickly?", new DialogueMessage.Argument[0])));
            ResourceLocation next = builder.add("next", new DialogueProvider.NodeSelectorBuilder().node(Conditions.any(Conditions.isInTerrainLand(LandTypes.FUNGI), Conditions.isInTerrainLand(LandTypes.SHADE)), new DialogueProvider.NodeBuilder(l.subMsg("mushrooms", "I mean, there's not really much else than mushrooms around here.", new DialogueMessage.Argument[0]))).defaultNode(new DialogueProvider.NodeBuilder(l.subMsg("desolate", "There's not really much food to be found in this desolate place.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).condition(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SAND)).nextDialogue(cacti))));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I sure wonder where the rabbits are getting their food from.", new DialogueMessage.Argument[0])).next(next));
        }));
        provider.addRandomlySelectable("pet_zombie", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(MSTags.TitleLandTypes.MONSTERS), Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR, MSEntityTypes.SALAMANDER))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I've heard moaning coming from next door. I found out they are keeping a pet zombie there! Tamed it and everything!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("spider_raid", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.MONSTERS)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("A few giant spiders raided our village last night, taking all of our bugs! Those monsters...", new DialogueMessage.Argument[0])).animation("angry"));
        provider.addRandomlySelectable("monstersona", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(MSTags.TitleLandTypes.MONSTERS), Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.NAKAGATOR))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("What's your monster-sona? Mine is a zombie.", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("why_monsters", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(MSTags.TitleLandTypes.MONSTERS))), new FolderedDialogue(builder -> {
            DialogueProvider.ResponseBuilder noReason = new DialogueProvider.ResponseBuilder(l.subMsg("no_reason", "Maybe there is no reason?", new DialogueMessage.Argument[0]));
            DialogueProvider.MessageProducer noAnswerMsg = l.subMsg("no_answer", "I don't have an answer, bye.", new DialogueMessage.Argument[0]);
            ResourceLocation whyNoReason = builder.add("why_no_reason", new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The %s has a destiny, and I believe in fate. Why wouldn't there be a reason?", DialogueMessage.Argument.LAND_TITLE)).addClosingResponse(noAnswerMsg)));
            ResourceLocation whyPunish = builder.add("why_punish", new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Punishment for what? For who?", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Monsters didn't first pop out of the ground yesterday. If it was punishment for someone specific they are probably long dead.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Whatever reason it's happening for, I certainly don't feel like I am learning any lesson from it...", new DialogueMessage.Argument[0])).animation("angry").addResponse(noReason.nextDialogue(whyNoReason)).addClosingResponse(noAnswerMsg)));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Sometimes I really wonder why there are any monsters here to begin with!", new DialogueMessage.Argument[0])).animation("angry").addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("punishment", "Maybe it is punishment?", new DialogueMessage.Argument[0])).nextDialogue(whyPunish)).addResponse(noReason.nextDialogue(whyNoReason)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("confused", "Isn't it normal for there to be monsters?", new DialogueMessage.Argument[0])).nextDialogue(builder.add("not_normal", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Yeah right. There is no way this is normal.", new DialogueMessage.Argument[0]))))));
        }));
        provider.addRandomlySelectable("bug_treasure", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.TOWERS), Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.IGUANA))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Legends say underneath the tower to the north is a Captain Lizardtail's buried treasure! Literal tons of bugs, they say!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("tower_gone", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.TOWERS), Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.SALAMANDER))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("That tower over there was built by my ancestor Fjorgenheimer! You can tell by how its about to fall apa- oh it fell apart.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("no_tower_treasure", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.TOWERS), Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.NAKAGATOR))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I feel ripped off. I was born in a land full of magical towers but none of them have treasure!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("tower_motivation", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.TOWERS))), new FolderedDialogue(builder -> {
            ResourceLocation newTower = builder.add("new_tower", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I'm going to make the tallest tower this land has ever seen!", new DialogueMessage.Argument[0])).animation("happy"));
            builder.addStart(new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("We would keep making towers, but we have no motivation.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Each time a %s starts to build, they have a bajillion ideas on what to do with it.", DialogueMessage.Argument.ENTITY_TYPE))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("They see all the other towers and think they can do better. But after the ground work gets laid, reality sets in.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Suddenly decisions that seemed simple enough to just ignore become unavoidable.", new DialogueMessage.Argument[0])).animation("anxious")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("And they start to question decisions they already made like \"Why did I start building on top of my flimsy house?\" and \"Why did I put myself into life-long debt for artisanal bricks?\"", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Next thing you know, there's another half baked pile of rock taking up space. It's just kind of pointless!", new DialogueMessage.Argument[0])).animation("anxious").addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("dont_give_up", "That's no reason to give up!", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("dont_give_up.reply", "Just because you haven't made a better tower yet doesn't mean you never will!", new DialogueMessage.Argument[0])).nextDialogue("motivation", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You know what? Yeah! I'm ready to take out another loan and try again. Thanks!", new DialogueMessage.Argument[0]))).addTrigger(new Trigger.SetDialogue(newTower))).addClosingResponse(thanksGoodbyeMsg)));
        }));
        provider.addRandomlySelectable("glass_books", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.THOUGHT), Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.IGUANA))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Our smartest villager read all the books in the library and now knows how to make glass jars! He's a gift from the big frog above!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("book_food", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.THOUGHT), Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.NAKAGATOR))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("We ate all the books in the nearby college ruins. It turns out thousand-year-old leather doesn't make the best dinner.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("to_eat", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.THOUGHT), Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.NAKAGATOR))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("To eat or not to eat, that is the question.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("book_purpose", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.THOUGHT), Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR))), new FolderedDialogue(builder -> {
            ResourceLocation buyMyProducts = builder.add("buy_my_products", new DialogueProvider.NodeBuilder().addMessage(l.subMsg("a", "I'm feeling generous, so how about this.", new DialogueMessage.Argument[0])).addMessage(l.subMsg("b", "If you want to get started on being an intellectual giant, I can offer you a discounted price on my self help memoir. It's only 5 payments of 8000 boondollars.", new DialogueMessage.Argument[0])).addDescription(l.subMsg("description", "They show you a book labelled \"Grindset Tales: From Pawn to King (How to follow the Philosopher's Journey)\"", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("purchase", "[Purchase book]", new DialogueMessage.Argument[0])).visibleCondition(l.subText("not_purchase", "No matter how you feel, you are compelled to decline"), Conditions.none(Conditions.alwaysTrue()))).addClosingResponse(l.subMsg("decline", "Yeah no way.", new DialogueMessage.Argument[0])).addClosingResponse(l.subMsg("decline_hard", "Absolutely no chance.", new DialogueMessage.Argument[0])));
            ResourceLocation unenlightened = builder.add("unenlightened", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("That's a pretty low IQ sentiment. To be honest I think you could use some help moving away from such a toxic mindset.", new DialogueMessage.Argument[0])).next(buyMyProducts));
            ResourceLocation fact2 = builder.add("fact_2", new DialogueProvider.NodeBuilder().addMessage(l.subMsg("a", "Fact 2: The louder you are and the more often you interrupt others in a conversation, the higher your IQ is.", new DialogueMessage.Argument[0])).addMessage(l.subMsg("b", "You already failed this by listening to me patiently but it's okay, you are lucky you have the Master around.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("request_more", "Got any more wisdom?", new DialogueMessage.Argument[0])).nextDialogue(buyMyProducts).setNextAsEntrypoint()).addClosingResponse(thanksGoodbyeMsg));
            builder.addStart(new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Lets talk real facts right now. The true purpose of books is not to actually read them, it's about presentation.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Actual intellect is all about LOOKING like you know things.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("disagree", "[Disagree]", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("disagree.reply", "No I'm pretty sure books are meant to be read.", new DialogueMessage.Argument[0])).nextDialogue(unenlightened)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("continue", "[Let them continue enlightening you]", new DialogueMessage.Argument[0])).nextDialogue(fact2))));
        }));
        provider.addRandomlySelectable("mystery_recipe", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.CAKE), Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.NAKAGATOR))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("All of the villagers here are trying to crack the mystery of how to make the frosted bread we see all day on our walks.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("cake_regen", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.CAKE), Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.SALAMANDER))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I heard all the cakes magically regenerate if you don't completely eat them! That's completely stupid!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("cake_recipe", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.CAKE), Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.SALAMANDER))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Let's see, the recipe calls for 5 tbsp. of sugar, 2 tbsp. vanilla, 1 large grasshopper... what are you looking at?", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("fire_cakes", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.CAKE), Conditions.isInTerrainLand(LandTypes.HEAT))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("If you're not careful, anything can set you on fire here, even the cakes!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("frosting", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.CAKE), Conditions.isInTerrainLand(LandTypes.FROST))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("When we start talking about cakes, the others start mentioning frosting. I'm not sure I get what they're talking about!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("gear_technology", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.CLOCKWORK), Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.IGUANA))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Legends say the giant gears were used for technology no consort has ever seen before. That's absurd! It's obviously food!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("evil_gears", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.CLOCKWORK), Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR, MSEntityTypes.IGUANA))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("My neighbor says the gears are evil! He also said that swords are used for combat, so he's probably insane.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("ticking", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.CLOCKWORK), Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.SALAMANDER))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The ticking keeps me up all night. It keeps us all up all night. Save us.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("frog_creation", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.FROGS)), new FolderedDialogue(builder -> {
            ResourceLocation explain = builder.add("explain", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The Genesis Frog is the cornerstone of %s beliefs! In the Vast Croak, Our Glorious Speaker brought everything into existence.", DialogueMessage.Argument.ENTITY_TYPE)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("doubt", "How do you know They are real?", new DialogueMessage.Argument[0])).nextDialogue("inside", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Because we are inside Our Glorious Speaker right now!", new DialogueMessage.Argument[0])))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("make", "What did you mean when you said that someone had to make another Genesis Frog?", new DialogueMessage.Argument[0])).nextDialogue("no_idea", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("No clue. Just seemed like it would involve a long quest or something if a new Genesis Frog ever had to be made.", new DialogueMessage.Argument[0])))).addClosingResponse(thanksGoodbyeMsg));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("We are thankful for all the frogs that They gave to us when the universe was created. They, of course, is the Genesis Frog. I feel bad for the fool who has to make another!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("who", "What is the Genesis Frog?", new DialogueMessage.Argument[0])).nextDialogue(explain).setNextAsEntrypoint()).addClosingResponse());
        }));
        provider.addRandomlySelectable("frog_location", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.FROGS)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You won't find many frogs where you find villages. Most of them live where the terrain is rougher.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("frog_imitation", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.FROGS)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Ribbit, ribbit! I'm a frog! I don't care what you say!", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("frog_variants", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.FROGS)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Most people believe there aren't that many types of frogs. 4740, maybe? Anything beyond that would be preposterous.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Here in %s, however, we know that there are 9.444731276889531e+22 types of frogs.", DialogueMessage.Argument.LAND_NAME)).addClosingResponse()));
        provider.addRandomlySelectable("frog_hatred", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.FROGS)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("For whatever reason, residents of Derse HATE frogs! Why would someone hate frogs?", new DialogueMessage.Argument[0])).animation("angry"));
        provider.addRandomlySelectable("grasshopper_fishing", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.FROGS), Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.IGUANA))), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("My brother found a magic grasshopper while fishing recently!", new DialogueMessage.Argument[0])).animation("happy")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Usually all we find are rings!", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("gay_frogs", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.FROGS), Conditions.isInTerrainLand(LandTypes.RAINBOW))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The frogs around here are all so gay! Look at them happily hopping about!", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("non_teleporting_frogs", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.FROGS), Conditions.isInTerrainLand(LandTypes.END))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("While the rest of us are getting dizzy, teleporting at random in the tall grass, the frogs seem immune! Makes it harder to catch them, that's for sure.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("lewd_buckets", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.BUCKETS)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Some may call our land lewd, but the buckets are just so fun to swim in!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("water_buckets", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.BUCKETS), Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SAND))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The buckets are a great source of water, as long as you pick the ones with water...", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("warm_buckets", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.BUCKETS), Conditions.isInTerrainLand(LandTypes.FROST))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Did you know that some buckets provide warmth? I tend to curl up next to one from time to time.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("oil_buckets", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.BUCKETS), Conditions.isInTerrainLand(LandTypes.SHADE))), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Did you know that the buckets sometimes hold something other than oil?", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In some cases, they even contain something drinkable!", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("blindness", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.LIGHT)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("God, it's bright. Half of our village is blind. It's beginning to become a serious problem.", new DialogueMessage.Argument[0])).animation("anxious"));
        provider.addRandomlySelectable("doctors_inside", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.LIGHT), Conditions.isAnyEntityType(MSEntityTypes.TURTLE))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Our best village doctors found that staying outside in the blinding light for too long is not good for us. Most of us stay inside all our lives. It's sad.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("staring", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.LIGHT)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Are you staring at me? No, really! I can't see because I'm blind.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("sunglasses", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.LIGHT), Conditions.isInTerrainLand(LandTypes.HEAT))), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You'd better wear sunglasses, else you might not see where you're going.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This is not the best place to wander blindly in.", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("bright_snow", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.LIGHT), Conditions.isInTerrainLand(LandTypes.FROST))), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You would think that the light would melt more snow.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("But nope, the snow stays as frozen as ever!", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("glimmering_snow", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.LIGHT), Conditions.isInTerrainLand(LandTypes.FROST))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Isn't it wonderful how much the snow is glimmering in the light?", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("glimmering_sand", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.LIGHT), Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SAND))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Isn't it wonderful how much the sand is glimmering in the light?", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("light_pillars", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.LIGHT), Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.TURTLE))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Those light pillars... they somehow make me think of the legend of the wyrm.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("murder_silence", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.SILENCE), Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR, MSEntityTypes.SALAMANDER))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This is a great place for murder. No one will hear you scream.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("silent_underlings", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.SILENCE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This place is so quiet and peaceful. Too bad we can't hear underlings about to kill us.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("listening", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.SILENCE), Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.SALAMANDER))), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Shhh, they can hear you...", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Just kidding, no one can hear you! The land itself muffles your words!", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("calmness", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTitleLand(LandTypes.SILENCE), Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.IGUANA))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The sense of calmness in the air, it's kind of unnerving!", new DialogueMessage.Argument[0])).animation("anxious"));
        provider.addRandomlySelectable("climb_high", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.any(Conditions.isInTitleLand(LandTypes.TOWERS), Conditions.isInTitleLand(LandTypes.WIND)), Conditions.isAnyEntityType(MSEntityTypes.IGUANA))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Climb up high and you'll be up for a great view!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("height_fear", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.any(Conditions.isInTitleLand(LandTypes.TOWERS), Conditions.isInTitleLand(LandTypes.WIND)), Conditions.isAnyEntityType(MSEntityTypes.TURTLE))), new DialogueProvider.NodeSelectorBuilder().node(new Condition.AtOrAboveY(78.0), new DialogueProvider.NodeBuilder(l.subMsg("panic", "AAH, I am scared of heights!", new DialogueMessage.Argument[0])).animation("anxious")).node(Conditions.isInTitleLand(LandTypes.TOWERS), "towers", new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I'd climb up one of those towers and look at the view, but I am scared of heights.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I mean, what if I slipped and fell off the stairs?", new DialogueMessage.Argument[0])))).defaultNode("rock", new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I'd climb up one of those rocks and look at the view, but I am scared of heights.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I mean what if I fell down and landed on my back?", new DialogueMessage.Argument[0])))));
        provider.addRandomlySelectable("mush_farm", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.SHADE)), new ChainBuilder().withFolders().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Someone's gotta be farmin' all these goddamn fuckin' mushrooms, pain in the ass through truly it be.", new DialogueMessage.Argument[0])).animation("angry")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("So that's what I'm doing.", new DialogueMessage.Argument[0])).animation("angry")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Standing around here.", new DialogueMessage.Argument[0])).animation("angry")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("farmin' all these", new DialogueMessage.Argument[0])).animation("angry")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("goddamn", new DialogueMessage.Argument[0])).animation("angry")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("fuckin", new DialogueMessage.Argument[0])).animation("angry")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("mushrooms", new DialogueMessage.Argument[0])).animation("angry")));
        provider.addRandomlySelectable("mushroom_pizza", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.SHADE)), new FolderedDialogue(builder -> builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Do you put glow mushrooms on your pizza or leave them off?", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("on", "Put them on", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("on.reply", "I put them on!", new DialogueMessage.Argument[0])).nextDialogue(builder.add("on", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Good! I was afraid I'd have to kill you!", new DialogueMessage.Argument[0]))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("off", "Leave them off", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("off.reply", "I leave them off!", new DialogueMessage.Argument[0])).nextDialogue(builder.add("off", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You are a despicable person.", new DialogueMessage.Argument[0]))))))));
        provider.addRandomlySelectable("fire_hazard", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTerrainLand(LandTypes.SHADE), Conditions.none(Conditions.isInTitleLand(LandTypes.THUNDER)))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Our land is a fire waiting to happen! Hopefully there isn't any lightning!", new DialogueMessage.Argument[0])).animation("anxious"));
        provider.addRandomlySelectable("that_boy_needs_therapy", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.SHADE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Sometimes I wonder whether a purely mushroom diet is the cause of my dwindling mental capacity. In those moments, I think 'Ooh! mushroom!'... speaking of mushrooms, Sometimes I wonder...", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("lazy_king", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.SHADE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I feel like our king just sits around doing nothing but eating weird glowing mushrooms! So lazy!", new DialogueMessage.Argument[0])));
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.ORANGE_FAYGO, "Orange", MSItems.SCALEMATE_LEMONSNOUT, "Lemonsnout", Conditions.isInTerrainLand(LandTypes.SHADE));
        provider.addRandomlySelectable("getting_hot", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.HEAT)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Is it getting hot in here or is it just me?", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("step_into_fire", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.HEAT)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You'd better watch where you're going. Wouldn't want you to step right into some fire.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("lava_crickets", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.HEAT)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Have you ever had a lava-roasted cricket? The lava really brings out the cricket juices.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("tummy_tunnel", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.HEAT)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Man this shop is packed tighter then my tummy tunnel when I gotta make brown on the john after eating one too many of them incandescent pies what be popping around.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("the_water_is_molten", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.HEAT)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You know the water is fucking molten goo? Who thought it would be a good idea to make water out of lava or some shit? How do we even stay hydrated in this place dude?", new DialogueMessage.Argument[0])).animation("angry"));
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.CANDY_APPLE_FAYGO, "Candy Apple", MSItems.SCALEMATE_APPLESCAB, "Applescab", Conditions.isInTerrainLand(LandTypes.HEAT));
        provider.addRandomlySelectable("wood_flammability", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.WOOD)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Sometimes we get freaked out about how flammable our land is, but surprisingly fire does shit all.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Makes me wonder if the wood itself decides it doesn't want to stay lit.", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("one_big_tree", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.WOOD)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Why is everything made out of wood? Was the whole place one big tree at some point?", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("consort_wood_carving", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.WOOD)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In the beginning, the surface was really smooth and there was nothing around. At some point we decided to start carving out our houses and a bunch of furniture.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("early_work", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.WOOD)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Ohhh my %s I hate hanging out around here. This is where I carved some of my first furniture. My early work is SO embarrassing.", DialogueMessage.Argument.ENTITY_SOUND)));
        provider.addRandomlySelectable("splinters", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.WOOD)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Be careful not to walk barefoot here, you could get a splinter!", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Some of our kind have died due to the amount of splinters they received while on a walk.", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("sand_surfing", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SAND)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Sand-surfing is my new favorite sport! Too bad you can't really move, though.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("camel", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SAND)), new FolderedDialogue(builder -> builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Want to buy a used camel? Only 2000 boondollars.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("yes", "Why not? Seems like a good price for a camel!", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("yes.reply", "Sure!", new DialogueMessage.Argument[0])).nextDialogue(builder.add("no_camel", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Hahaha! Sucker! I have no camel! Cya later! 8)", new DialogueMessage.Argument[0])).addDescription(l.subMsg("desc", "The %s starts running away, pauses when they realize they never took your boondollars, then continues running to avoid an awkward situation.", DialogueMessage.Argument.ENTITY_TYPE)))).setNextAsEntrypoint()).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("no", "Of course not! You know better!", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("no.reply", "Not at all!", new DialogueMessage.Argument[0])).nextDialogue(builder.add("dancing_camel", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Are you sure? Too bad! The camel knew how to dance, too!", new DialogueMessage.Argument[0]))))))));
        provider.addRandomlySelectable("like_sand", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SAND)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I actually like sand. It's coarse and rough and irritating and it gets everywhere. Reminds me of myself!", new DialogueMessage.Argument[0])));
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.COTTON_CANDY_FAYGO, "Cotton Candy", MSItems.SCALEMATE_BERRYBREATH, "Berrybreath", Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SAND));
        provider.addRandomlySelectable("knockoff", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SANDSTONE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I kind of feel like we're a stale, knockoff sand land.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("sandless", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SANDSTONE)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("According to legend, %s ate all the sand here leaving nothing but sandstone!", DialogueMessage.Argument.LAND_DENIZEN))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I'm kidding, I made that up on the spot. I had no other dialogue.", new DialogueMessage.Argument[0]))));
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.CREME_SODA_FAYGO, "Creme Soda", MSItems.SCALEMATE_HONEYTONGUE, "Honeytongue", Conditions.isInTerrainLand(MSTags.TerrainLandTypes.SANDSTONE));
        provider.addRandomlySelectable("frozen", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FROST)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("My neighbors were complaining the other night about the snow.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Personally, the cold never really bothered me anyways.", new DialogueMessage.Argument[0])).addDescription(l.subMsg("desc", "You hear a faint \"ba-dum tss\" in the distance.", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("fur_coat", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FROST)), new FolderedDialogue(builder -> builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Darn! I only need 100 more boondollars for a nice, fur coat! I'm going to freeze!", new DialogueMessage.Argument[0])).animation("anxious").addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("pay", "[Pay 100 boondollars]", new DialogueMessage.Argument[0])).condition(new Condition.PlayerHasBoondollars(100)).addTrigger(new Trigger.AddBoondollars(-100)).addTrigger(new Trigger.GiveFromLootTable(MSLootTables.CONSORT_JUNK_REWARD)).addTrigger(new Trigger.AddConsortReputation(50)).addTrigger(new Trigger.SetDialogue(genericThanks)).addTrigger(new Trigger.SetFlag(helpingPlayer, true)).addPlayerMessage(l.subMsg("pay.reply", "Here you go!", new DialogueMessage.Argument[0])).nextDialogue(builder.add("gratitude", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Oh, thank you! Now I won't freeze to death out here! Take this as a token of gratitude!", new DialogueMessage.Argument[0])).animation("happy")))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("ignore", "[Don't give them any of your hard-earned boondollars!]", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("ignore.reply", "Sorry, but I can't help you.", new DialogueMessage.Argument[0])).nextDialogue(builder.add("death", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I guess I'll just die then...", new DialogueMessage.Argument[0]))))))));
        provider.addRandomlySelectable("tent_protection", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTerrainLand(LandTypes.FROST), Condition.HasMoveRestriction.INSTANCE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("These tents doesn't protect against the cold very well, but they are good enough.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("all_ores", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.ROCK)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Jokes on the losers in other lands, we have ALL the resources! All of them!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("rockfu", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.ROCK)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Here in %s, we practice rock-fu! Learn the way of the rock to CRUSH your enemies into a fine rock powder!", DialogueMessage.Argument.LAND_NAME)));
        provider.addRandomlySelectable("rock_cycle", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.ROCK)), new ChainBuilder().withFolders().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("It's crazy how much rocks can change form.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("With the power of wind and water, a massive mountain can turn to nothing more than a hill given enough time!", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("But all that sediment doesn't just disappear, big piles of it can get squished together to form new kinds of rock!", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Then if you add more pressure and then some heat, you have something entirely new.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("But we're not done! If that sinks farther down and gets hotter then it can turn into magma, which can then cool off and crystallize into yet another rock.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("It doesn't even always happen in that order, rocks of any kind can break into sediment or change form under heat and pressure.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("There's nearly endless permutations, it's really beautiful.", new DialogueMessage.Argument[0])).animation("happy").addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("insult", "Ok nerd.", new DialogueMessage.Argument[0])).nextDialogue("sad", new DialogueProvider.NodeBuilder(sadFaceMsg))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("intrigued", "That's cool!", new DialogueMessage.Argument[0])).nextDialogue("hypocrite", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Ok nerd!", new DialogueMessage.Argument[0])))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("love_rocks", "I love rocks, wish I could be one.", new DialogueMessage.Argument[0])).nextDialogue("agree", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Me too! I want to be limestone.", new DialogueMessage.Argument[0])).animation("happy")))));
        provider.addRandomlySelectable("favorite_sediment", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.ROCK)), new FolderedDialogue(builder -> {
            ResourceLocation favorite = builder.add("consort_favorite", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Good choice! Mine is silty clay. It's primarily a texture thing.", new DialogueMessage.Argument[0])).animation("happy"));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("What's your favorite kind of sediment to taste?", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("sand", "Sand is clearly the best!", new DialogueMessage.Argument[0])).nextDialogue(favorite)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("silt", "Silt is superior!", new DialogueMessage.Argument[0])).nextDialogue(favorite)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("clay", "Clay is my top pick!", new DialogueMessage.Argument[0])).nextDialogue(favorite)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("dirt", "I can go for some nice dirt no matter the particle size!", new DialogueMessage.Argument[0])).nextDialogue(favorite)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("question", "Why would you eat sediment?", new DialogueMessage.Argument[0])).nextDialogue("worried", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Oh this is not a safe space suddenly", new DialogueMessage.Argument[0])))));
        }));
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.MOON_MIST_FAYGO, "Moon Mist", MSItems.SCALEMATE_PUMPKINSNUFFLE, "Pumpkinsnuffle", Conditions.isInTerrainLand(MSTags.TerrainLandTypes.ROCK));
        provider.addRandomlySelectable("all_trees", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.FOREST)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Jokes on the losers in other lands, we have ALL the trees! All of them!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("really_likes_trees", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.FOREST)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Do you like trees? I really like trees. I am one with the tree. Trees. TREES. TREEEES!", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("creepy_trees", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.FOREST)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("These trees freak me the fuck out sometimes. We rarely go out alone anymore because sometimes we don't find our way back home.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Worst part is, we never find a body.", new DialogueMessage.Argument[0])).animation("anxious")));
        provider.addRandomlySelectable("deep_roots", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(MSTags.TerrainLandTypes.FOREST)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The trees are always trying to grow and expand. Bet that's why their roots travel so deep!", new DialogueMessage.Argument[0])));
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.PEACH_FAYGO, "Peach", MSItems.SCALEMATE_CINNAMONWHIFF, "Cinnamonwhiff", Conditions.isInTerrainLand(MSTags.TerrainLandTypes.FOREST));
        provider.addRandomlySelectable("mycelium", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FUNGI)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Frog, don't you love the feeling of mycelium on your toes?", new DialogueMessage.Argument[0])).animation("happy")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("No? Is that just me?", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("adaptation", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FUNGI)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("At first, no one liked the mushrooms when our planet was cursed with the Dank.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Those who refused to adapt to the new food source Perished, obviously.", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("mushroom_curse", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FUNGI)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Curse %s! And curse all their mushrooms, too! I miss eating crickets instead of all these mushrooms!", DialogueMessage.Argument.LAND_DENIZEN)).animation("angry"));
        provider.addRandomlySelectable("jacket", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FUNGI)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("It's so damp and cold. I wish I had a jacket!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("mildew", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FUNGI)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Ah, the mildew on the grass in the morning makes the landscape so pretty!", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("fungus_destroyer", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FUNGI)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("According to legends of old, the %s will come one day and get the evil %s to clear up all this fungus!", DialogueMessage.Argument.LAND_TITLE, DialogueMessage.Argument.LAND_DENIZEN)));
        provider.addRandomlySelectable("generic_green", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAINBOW)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Have you ever noticed rainbow wood looks green from a distance? I wonder if green is somehow more generic than other colors.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("overwhelming_colors", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTerrainLand(LandTypes.RAINBOW), Conditions.isAnyEntityType(MSEntityTypes.TURTLE))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Even for us turtles, this place is too bright. All the light and colors around here can be really overwhelming!", new DialogueMessage.Argument[0])).animation("anxious"));
        provider.addRandomlySelectable("saw_rainbow", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAINBOW)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I saw a rainbow yesterday! Normally I see way more than that.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("sunglasses", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAINBOW)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Some sunglasses would be really great in a Land like this. Too bad I don't have ears!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("what_is_wool", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAINBOW)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I have no clue what the ground here is made of. I've never seen anything like it anywhere else!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("love_colors", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAINBOW)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("People ask me, \"What's your favorite color?\" I can't pick! I love them all! They're all special in their own way! Well, except green.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("types_of_colors", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAINBOW)), new ChainBuilder().withFolders().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In the additive color system, there are three primary colors: red, green, and blue.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In the subtractive color system, there are also three primary colors, but those are magenta, yellow, and cyan.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In the additive system, mixing red and green makes yellow, mixing green and blue makes cyan, and mixing blue and red makes magenta.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In the subtractive system, mixing magenta and yellow makes red, mixing yellow and cyan makes green, and mixing cyan and magenta makes blue!", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("These six colors make up the color wheel: red, yellow, green, cyan, blue, magenta, and then back to red.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("When you look at a rainbow, you don't see magenta, because the blue on one end doesn't mix with the red on the other end.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You do, however, see purple, which is between magenta and blue. Short answer for why that is, your eyes are lying to you.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Beyond the six main colors, however, there are also six other colors: pink, brown, orange, lime, light blue, and purple.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In addition, there are also the tones of white, light gray, gray, and black.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In the additive system, mixing all the colors together makes white.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In the subtractive system, mixing all the colors together makes black.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("When dealing with dye, however, you can find some unusual combinations, or lack of combinations.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Dyes work largely on the subtractive color system, but they don't always mix the way they should.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This is because dyes, while vibrant, are imperfect representations of their respective colors.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Lime, for example, should be a mix of yellow and green. To get lime dye, though, you need to mix cactus green with white dye instead.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("When mixing red and blue to get magenta, the blue overpowers the red and you get purple. You have to mix the purple with not just red, but pink to get magenta.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Dye is weird like that.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("...what, you're still listening to me? Wow. No one's ever listened to the whole thing before. Would you like to hear it again?", new DialogueMessage.Argument[0]))).loop());
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.GRAPE_FAYGO, "Grape", MSItems.SCALEMATE_WITNESS, "The Witness", Conditions.isInTerrainLand(LandTypes.RAINBOW));
        provider.addRandomlySelectable("at_the_end", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.END)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This may be the start of our conversation, but now we're at the end.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("chorus_fruit", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.END)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Never eat fruit. Last time I tried it, I blacked out and came to somewhere else! Stick to bugs like a normal person!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("end_grass", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.END)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The grass in this place just keeps growing everywhere! You can bet that any patches of grass you find weren't there before. I don't even know how it takes root in the stone like that.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("grass_curse", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.END)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Rumors say that %s got mad one day and cursed the world with all this grass everywhere. It gets into our homes!", DialogueMessage.Argument.LAND_DENIZEN)));
        provider.addRandomlySelectable("tall_grass", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.END)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The taller grass is so disorienting to walk through! Unless you are careful it will just move you around.", new DialogueMessage.Argument[0])).animation("anxious"));
        provider.addRandomlySelectable("useless_elytra", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.END)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("One time, I saw a guy with some weird wing-looking things on his back. He could glide with them, but without being able to stay in the air, what's the point?", new DialogueMessage.Argument[0])));
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.REDPOP_FAYGO, "Redpop", MSItems.SCALEMATE_PYRALSPITE, "Pyralspite", Conditions.isInTerrainLand(LandTypes.END));
        provider.addRandomlySelectable("empty_ocean", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAIN)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Our oceans used to be filled with life! Now they're all barren, thanks to %s.", DialogueMessage.Argument.LAND_DENIZEN)));
        provider.addRandomlySelectable("forbidden_snack", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAIN)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Contrary to popular belief, chalk is not safe for consumption... but how can I resist its allure?", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("cotton_candy", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAIN)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Have you ever considered eating a rain cloud? Yum! Maybe it tastes like cotton candy...", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("monsters_below", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAIN)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Do you know what lies deep beneath the ocean waters? Scary to think about!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("keep_swimming", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAIN)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Just keep swimming, just keep swimming! Yay, swimming!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("battle_site", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FLORA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This land was the site of a battle ages and ages and ages ago.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("blood_oceans", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FLORA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The giant creatures who warred here long ago shed so much blood that, even now, the oceans are red with it.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("giant_swords", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FLORA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("My grandpa told me that the giant swords everywhere were dropped by giants locked in combat ages ago.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("bloodberries", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FLORA)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The strawberries here grow big and red thanks to all the blood in the water supply! The flowers thrive, too!", new DialogueMessage.Argument[0])).animation("happy")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Strawberry juice is the only thing safe to drink here. If I have any more, I'll scream. Please save us.", new DialogueMessage.Argument[0])).animation("anxious")));
        provider.addRandomlySelectable("sharp_slide", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FLORA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Don't use the sharp sides of giant swords as slides. May her beautiful soul rest in pieces.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("immortality_herb", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInTerrainLand(LandTypes.FLORA), Condition.FirstTimeGenerating.INSTANCE)).keepOnReset(), new ChainBuilder().withFolders().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I have a herb that grants immortality! I'm going to eat it right now!", new DialogueMessage.Argument[0])).animation("happy")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("However, they are easily confused with an explosion-causing herb...", new DialogueMessage.Argument[0])).animation("anxious")).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I'm taking the risk.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.DOTS)).addTrigger(new Trigger.Explode()))));
        provider.addRandomlySelectable("spices", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.FLORA)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("A good chef cooks with the spices found throughout the land.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Other chefs are envious that they don't live in %s.", DialogueMessage.Argument.LAND_NAME))));
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.GRAPE_FAYGO, "Grape", MSItems.SCALEMATE_PUCEFOOT, "Pucefoot", Conditions.isInTerrainLand(LandTypes.FLORA));
        provider.addRandomlySelectable("red_better", SelectableDialogueProvider.defaultWeight(Conditions.any(Conditions.isInTerrainLand(LandTypes.RED_SAND), Conditions.isInTerrainLand(LandTypes.RED_SANDSTONE))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Red is much better than yellow, don't you think?", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("yellow_better", SelectableDialogueProvider.defaultWeight(Conditions.any(Conditions.isInTerrainLand(LandTypes.SAND), Conditions.isInTerrainLand(LandTypes.SANDSTONE))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("In our village, we have tales of monsters that are attracted to red. That's why everything is yellow!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("bad_water", SelectableDialogueProvider.defaultWeight(Conditions.any(Conditions.isInTerrainLand(LandTypes.SHADE), Conditions.isInTerrainLand(LandTypes.HEAT), Conditions.isInTerrainLand(LandTypes.WOOD), Conditions.isInTerrainLand(LandTypes.RAINBOW), Conditions.isInTerrainLand(LandTypes.END))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Can you imagine living in a world where the liquid in the oceans is actually drinkable?", new DialogueMessage.Argument[0])));
        ConsortDialogue.terrainFaygoDialogue(provider, l, MSItems.FAYGO_COLA, "Cola", MSItems.SCALEMATE_PYRALSPITE, "Pyralspite", Conditions.any(Conditions.isInTerrainLand(LandTypes.WOOD), Conditions.isInTerrainLand(LandTypes.FROST), Conditions.isInTerrainLand(LandTypes.FUNGI), Conditions.isInTerrainLand(LandTypes.RAIN)));
        provider.addRandomlySelectable("denizen_mention", SelectableDialogueProvider.defaultWeight(Conditions.isInLand()), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("It's a wonderful day. Hopefully some monster underneath the planet's surface doesn't eat us all!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("ring_fishing", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.IGUANA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("My brother found a magic ring while fishing recently! Just kidding. That kind of stuff only happens in fantasy worlds.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("frog_walk", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.TURTLE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Frog, it's such a wonderful day to just walk around a village.", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("delicious_hair", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.IGUANA)), new FolderedDialogue(builder -> builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Holy leapin' god, you have such wonderful hair! Can I eat some?", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("no", "I don't have any hair.", new DialogueMessage.Argument[0])).nextDialogue(builder.add("disappointed", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Aw, is that not hair? I have such a hard time telling with your freakish kind.", new DialogueMessage.Argument[0]))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("yes", "[Hand over some hair]", new DialogueMessage.Argument[0])).visibleCondition(new Condition.PlayerHasItem((Item)MSItems.PONYTAIL.get(), 1)).addPlayerMessage(l.subMsg("yes.reply", "Sure here you go", new DialogueMessage.Argument[0])).nextDialogue(builder.add("happy", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Oh %s, thank you for the snack!", DialogueMessage.Argument.ENTITY_SOUND)).animation("happy"))).addTrigger(new Trigger.TakeItem((Item)MSItems.PONYTAIL.get())).addTrigger(new Trigger.SetDialogue(genericThanks)).addTrigger(new Trigger.SetFlag(helpingPlayer, true))))));
        provider.addRandomlySelectable("music_invention", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR, MSEntityTypes.SALAMANDER)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I invented music, y'kno! My favorite song goes like ba ba dum, dum ba dum.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("wyrm", SelectableDialogueProvider.weighted(4, Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.IGUANA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Legends speak of the Wyrm, a giant ivory pillar that radiated joy and happiness and uselessness.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("useless_pogo", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I once found this piece of junk that launched me upward when I hit the ground with it. It really hurt when I came back down, and I didn't get anywhere!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("await_hero", SelectableDialogueProvider.defaultWeight(Conditions.isInHomeLand()), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Here, in the %s, we %s worship the %s. We wait and hope for the day that they awaken.", DialogueMessage.Argument.LAND_NAME, DialogueMessage.Argument.ENTITY_TYPES, DialogueMessage.Argument.LAND_TITLE)));
        provider.addRandomlySelectable("zazzerpan", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.TURTLE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Old wizard Zazzerpan would be turning in his grave if he saw the horrors that walk these lands. Those giclopses sure are terrifying!", new DialogueMessage.Argument[0])).animation("anxious"));
        provider.addRandomlySelectable("texas_history", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isAnyEntityType(MSEntityTypes.TURTLE), Conditions.isFromLand())), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The place was %s, the year, was 20XX.", DialogueMessage.Argument.LAND_NAME)));
        provider.addRandomlySelectable("disks", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.IGUANA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I used to be an adventurer like you, then I never got the disks.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("whoops", SelectableDialogueProvider.weighted(4, Conditions.isAnyEntityType(MSEntityTypes.IGUANA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Beware the man who speaks in hands, wait...wrong game.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("fourth_wall", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.IGUANA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Maybe you should do something more productive than talking to NPCs.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("consort_scoliosis", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.TURTLE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I'm not actually a child, I simply have an incredibly advanced case of consort scoliosis that has gone untreated for years.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("oh_to_be_ugly", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Inspite of the fact that I'm training to become an evil wizard, I'm simply not ugly enough to fit the bill. Any good wizardling knows that one must be as ugly as their desires to truly obtain power.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("no_to_podcasting", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.IGUANA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("My buddy wanted to do some podcasting... I'm no longer friends with him I'm not gonna lie", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("bats", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.TURTLE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I don't like the idea of a bat. Never seen one, and I don't plan on it. It's just like, why the fuck are they built like that!?", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("so_what", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Uhuh, so what you think you and your little hairy non-reptilian disposition impresses me? It doesn't impress me you just look like a fool. A damned hairy fool.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("trolly_problem", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The trolly problem isn't really all that complicated for me all things considered. I mean, I'll probably die of old age before the trolly ever hits me considering my incredibly short and quickly dwindling lifespan", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("a_little_lampshading", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.IGUANA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Look I know you aren't a reptile, I just got one question. You ever hear some of these people talk? I swear, they must be putting mercury in the water with how nonsensical conversation can be with these guys.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("hats", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I like crumpled hats, they're comfy and easy to wear!", new DialogueMessage.Argument[0])).animation("happy"));
        provider.addRandomlySelectable("best_scales", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR, MSEntityTypes.IGUANA)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Everyone loves me for my luxurious shiny scales and cool demeanour.", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("laser_defense_system", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.TURTLE)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Anytime someone approaches me when I want to be left alone I picture an orbital defense satellite beaming a laser down at them with precise precision.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I'm exploding you with my mind right now,,", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("too_humble", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You ever notice how the other consorts are constantly insulting others or self-aggrandizing?", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Not me though. I'm way more humble than the rest of these dummies.", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("wwizard", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.TURTLE)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Secret wizards? Th-there are no secret wizards! Wh-what're you speaking of, o-outlandish traveller?", new DialogueMessage.Argument[0])).animation("anxious"));
        provider.addRandomlySelectable("stock_market", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR)), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I bought a bunch of stocks on the market... Now I'm broke...", new DialogueMessage.Argument[0])).animation("anxious"));
        provider.addRandomlySelectable("identity", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER), Conditions.isFromLand())), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I heard that the true name of the %s is %s. Isn't that cool?", DialogueMessage.Argument.LAND_TITLE, DialogueMessage.Argument.LAND_PLAYER_NAME)));
        provider.addRandomlySelectable("college", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), new DialogueProvider.NodeSelectorBuilder().node(new Condition.PlayerHasBoondollars(1000), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Wow, you have so many boondollars! I'll never make that much in my short, amphibious lifetime.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Please, I need to pay for my children to attend college...", new DialogueMessage.Argument[0])))).defaultNode(new DialogueProvider.NodeBuilder(l.subMsg("poor", "Wow you have a distinct lack of boondollars for someone in your position. Slumming it like the rest of us, eh?", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("unknown", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.TURTLE)), new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("They are coming...", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Huh? 'Who the fuck is They'? What kind of question is that?! I don't know! Who the fuck are you?", new DialogueMessage.Argument[0])).animation("angry")));
        provider.addRandomlySelectable("cult", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.TURTLE, MSEntityTypes.SALAMANDER)), new FolderedDialogue(builder -> {
            String hasSulfur = "has_sulfur";
            ResourceLocation oneDay = builder.add("later", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("%s. You will join us one day...", DialogueMessage.Argument.ENTITY_SOUND)));
            ResourceLocation exchange = builder.add("exchange", new DialogueProvider.NodeSelectorBuilder().node(new Condition.Flag(hasSulfur), new DialogueProvider.NodeBuilder(l.subMsg("exchange.proceed", "There is hope for you yet... bring me 10 sulfur and the horn of a goat and I shall have something to exchange with you.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("give_items", "[Hand over items]", new DialogueMessage.Argument[0])).visibleCondition(Conditions.all(new Condition.PlayerHasItem((Item)MSItems.NATIVE_SULFUR.get(), 10), new Condition.PlayerHasItem(Items.GOAT_HORN, 1))).addTrigger(new Trigger.TakeItem((Item)MSItems.NATIVE_SULFUR.get(), 10)).addTrigger(new Trigger.TakeItem(Items.GOAT_HORN, 1)).addTrigger(new Trigger.GiveItem((Item)MSItems.LONG_FORGOTTEN_WARHORN.get())).addTrigger(new Trigger.SetDialogue(oneDay)).nextDialogue(builder.add("pleased", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("May our influence grow ever stronger.", new DialogueMessage.Argument[0])))))).defaultNode(new DialogueProvider.NodeBuilder(l.subMsg("exchange.decline", "No, there is no helping you without any materials.", new DialogueMessage.Argument[0]))));
            ResourceLocation disappointment = builder.add("disappointment", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Hmm... perhaps you are not as ready for the arcane as we suspected. Pretend I said nothing.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("argue", "Wait! Will this %s prove I am ready?", DialogueMessage.Argument.MATCHED_ITEM)).condition(new Condition.ItemTagMatch(MSTags.Items.MAGIC_WEAPON)).nextDialogue(exchange)).addClosingResponse(l.subMsg("resign", "Alright fine. Bye.", new DialogueMessage.Argument[0])));
            ResourceLocation afterInvitation = builder.add("after_invitation", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Meet me by dawn with mercury, salt, and sulfur to begin the initiation.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("no", "No thanks, I'm good.", new DialogueMessage.Argument[0])).nextDialogue(oneDay)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("start", "I only have some sulfur, is this enough?", new DialogueMessage.Argument[0])).condition(new Condition.PlayerHasItem((Item)MSItems.NATIVE_SULFUR.get(), 1)).addTrigger(new Trigger.SetFlag(hasSulfur, true)).nextDialogue(disappointment)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("candy_question", "Will grist candy work?", new DialogueMessage.Argument[0])).nextDialogue(disappointment)));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("We would love to invite you, %s, to our secret wizards cult.", DialogueMessage.Argument.PLAYER_TITLE)).next(afterInvitation));
        }));
        provider.addRandomlySelectable("underling_commission", SelectableDialogueProvider.weighted(12, Conditions.isInHomeLand()), new FolderedDialogue(builder -> {
            ResourceLocation explainCarapacian = builder.add("explain_carapacian", new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("It's the people who live on Prospit and Derse. Those garish golden and purple cities in the sky that are almost the size of a planet.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The prospitians and dersites have been fighting on the Battlefield inside Skaia for longer than I care to know.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("It was agents of Derse that made the commission. Now we have to live alongside a bunch of screaming weirdos who explode into grist.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Why couldn't they commission something normal like art of their consort-sona?", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("why_fight", "Why are the carapacians fighting?", new DialogueMessage.Argument[0])).nextDialogue(builder.add("no_idea", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I have no idea, all I can imagine is that it would take a lot to solve the issue.", new DialogueMessage.Argument[0])).addClosingResponse(thanksGoodbyeMsg)))).addClosingResponse(thanksGoodbyeMsg)));
            ResourceLocation answer = builder.add("answer", new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Oh do you not know? Some incredibly rude carapacians came by to visit %s.", DialogueMessage.Argument.LAND_DENIZEN))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("They asked %s to create all the Underlings, no idea why!", DialogueMessage.Argument.LAND_DENIZEN)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("ask_carapacian", "Who are the carapacians?", new DialogueMessage.Argument[0])).nextDialogue(explainCarapacian)).addClosingResponse(thanksGoodbyeMsg)));
            builder.addStart(new DialogueProvider.NodeBuilder(l.subMsg("start", "Ugh. I don't like those Underlings. Can't believe anyone would ever ask to make them!", new DialogueMessage.Argument[0])).animation("angry").addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("ask", "What do you mean?", new DialogueMessage.Argument[0])).nextDialogue(answer)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("agree", "I know right?", new DialogueMessage.Argument[0])).nextDialogue(builder.add("confront", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("If I wasn't so scared of confrontation I would give them a stern talking to.", new DialogueMessage.Argument[0]))))));
        }));
        provider.addRandomlySelectable("title_presence", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isAnyEntityType(MSEntityTypes.IGUANA, MSEntityTypes.SALAMANDER), Conditions.isFromLand())), new FolderedDialogue(builder -> builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I sense the presence of the %s. Tell me if you see them, ok?", DialogueMessage.Argument.PLAYER_TITLE)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("i_am", "[Present yourself as the %s]", DialogueMessage.Argument.PLAYER_TITLE)).addPlayerMessage(l.subMsg("i_am.reply", "I am the %s.", DialogueMessage.Argument.PLAYER_TITLE)).nextDialogue(builder.add("i_am", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("OH MY %s", DialogueMessage.Argument.ENTITY_SOUND_2))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("agree", "[\"Agree\" to do that]", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("agree.reply", "Hehe, ok I will.", new DialogueMessage.Argument[0])).nextDialogue(thanks)))));
        provider.addRandomlySelectable("denizen", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.IGUANA, MSEntityTypes.TURTLE), Conditions.isInHomeLand())), new FolderedDialogue(builder -> builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("%s has been sleeping for a thousand years. I shudder at the thought of their return.", DialogueMessage.Argument.LAND_DENIZEN)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("what", "What?", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("what.reply", "The... what?", new DialogueMessage.Argument[0])).nextDialogue(builder.add("explain", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The Denizen is the One that Slumbers in our very soil. It is eternally waiting for the %s to awaken it. Then they will be given The Choice, and their victory will be determined by what they choose.", DialogueMessage.Argument.LAND_CLASS)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("where", "Where can I find this Denizen?", new DialogueMessage.Argument[0])).nextDialogue(builder.add("location", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Supposedly there is a giant palace somewhere. The Denizen rests at its core. However I don't know anyone who has seen it!", new DialogueMessage.Argument[0])))))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("alignment", "[Ask if the denizens are bad or not]", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("alignment.reply", "Were these 'denizens' bad?", new DialogueMessage.Argument[0])).nextDialogue(builder.add("alignment", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("How am I supposed to know if they were good or bad? There's more to a living being than just black and white!", new DialogueMessage.Argument[0])).animation("angry")))))));
        provider.addRandomlySelectable("floating_island", SelectableDialogueProvider.defaultWeight(Conditions.all(Conditions.isInHomeLand(), new Condition.NearSpawn(256))), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I heard a floating island just appeared somewhere near here recently and falling chunks destroyed a village underneath it!", new DialogueMessage.Argument[0])));
        provider.addRandomlySelectable("heroic_stench", SelectableDialogueProvider.defaultWeight(Conditions.isInLand()), new DialogueProvider.NodeSelectorBuilder().node(Condition.PlayerHasEntered.INSTANCE, new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You smell kind of... heroic... like a hero, perhaps? It makes me kinda nervous to be around you!", new DialogueMessage.Argument[0])).animation("anxious")).defaultNode(new DialogueProvider.NodeBuilder(l.subMsg("leech", "You smell like you're leeching from the success from another hero... is this true?", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("watch_skaia", SelectableDialogueProvider.defaultWeight(Conditions.isFromLand()), new DialogueProvider.NodeSelectorBuilder().node(Conditions.all(Condition.IsInSkaia.INSTANCE, Conditions.isAnyEntityType(MSEntityTypes.TURTLE)), new DialogueProvider.NodeBuilder(l.subMsg("at_skaia.turtle", "Oh my...! I'm actually on Skaia!", new DialogueMessage.Argument[0]))).node(Condition.IsInSkaia.INSTANCE, new DialogueProvider.NodeBuilder(l.subMsg("at_skaia", "OH MY %s! I'M ACTUALLY ON SKAIA!", DialogueMessage.Argument.ENTITY_SOUND_2)).animation("happy")).node(Condition.ConsortVisitedSkaia.INSTANCE, new DialogueProvider.NodeBuilder(l.subMsg("has_visited", "You know, I have actually visited Skaia at one point!", new DialogueMessage.Argument[0]))).defaultNode(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Sometimes, I look up in the sky to see Skaia and wish I could visit there some day...", new DialogueMessage.Argument[0]))));
        provider.addRandomlySelectable("echeladder_progress", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), new FolderedDialogue(builder -> {
            DialogueProvider.MessageProducer whatIs = l.msg("what_is", "What is an Echeladder?", new DialogueMessage.Argument[0]);
            DialogueProvider.MessageProducer meta = l.msg("meta", "If it's abstract, then how do you know about it?", new DialogueMessage.Argument[0]);
            ResourceLocation explainLeveling = builder.add("explain_leveling", new ChainBuilder().node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("There are multiple ways to climb the Rungs. But the main one is to beat up Underlings.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Very early on, defeating other kinds of monsters could probably also help you too.", new DialogueMessage.Argument[0]))).node(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Other than combat, I bet the first time you alchemize things with large grist costs you could get a bump.", new DialogueMessage.Argument[0])).addClosingResponse(thanksGoodbyeMsg)));
            ResourceLocation smartass = builder.add("smartass", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("What, are you calling me an NPC? I should be asking you the same. You don't exactly scream \"Rich inner life\".", new DialogueMessage.Argument[0])).addDescription(l.subMsg("desc", "You are convinced you can hear this consort ascend a rung after that burn on you.", new DialogueMessage.Argument[0])));
            ResourceLocation explainEcheladder = builder.add("explain_echeladder", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The Echeladder is an abstract system composed of Rungs. Every time you climb a rung you gain some boondollars, get a little stronger, and increase your grist cache.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("leveling", "How do you climb it?", new DialogueMessage.Argument[0])).nextDialogue(explainLeveling)).addResponse(new DialogueProvider.ResponseBuilder(meta).addPlayerMessage(meta).nextDialogue(smartass)).addClosingResponse(thanksGoodbyeMsg));
            builder.addStart(new DialogueProvider.NodeSelectorBuilder().node(Conditions.hasAdvancement("minestuck.big_one_mil"), new DialogueProvider.NodeBuilder(l.subMsg("one_mil", "Amazing! You look like you have almost reached the end of your Echeladder!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(whatIs).nextDialogue(explainEcheladder))).node(Conditions.hasAdvancement("minestuck.halfway_point"), new DialogueProvider.NodeBuilder(l.subMsg("halfway", "Woah, you look like you've climbed at least halfway up your Echeladder!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(whatIs).nextDialogue(explainEcheladder))).node(Conditions.hasAdvancement("minestuck.double_digits"), new DialogueProvider.NodeBuilder(l.subMsg("double_digits", "You look like you've climbed at least a 5th of the way up your Echeladder. Not bad.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(whatIs).nextDialogue(explainEcheladder))).defaultNode(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You give off the look of someone who has barely climbed their Echeladder.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(whatIs).nextDialogue(explainEcheladder))));
        }));
        provider.addRandomlySelectable("hungry", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.IGUANA, MSEntityTypes.NAKAGATOR)), new FolderedDialogue(builder -> {
            String barterFlag = "barter";
            String noBarterFlag = "no_barter";
            ResourceLocation satisfied = builder.add("satisfied", new DialogueProvider.NodeSelectorBuilder().node(new Condition.Flag(helpingPlayer), new DialogueProvider.NodeBuilder(l.subMsg("player_specific", "Thanks for giving me food earlier!", new DialogueMessage.Argument[0])).animation("happy")).defaultNode(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I was hungry before, but another player gave me a great snack!", new DialogueMessage.Argument[0])).animation("happy")));
            DialogueProvider.NodeBuilder barterNode = new DialogueProvider.NodeBuilder(l.defaultKeyMsg("But I am starving here! What if I paid you 10 boondollars for it?", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("yes", "[Give them the %s]", DialogueMessage.Argument.MATCHED_ITEM)).condition(Condition.HasMatchedItem.INSTANCE).addTrigger(Trigger.TakeMatchedItem.INSTANCE).addTrigger(new Trigger.AddBoondollars(10)).addTrigger(new Trigger.SetDialogue(satisfied)).addTrigger(new Trigger.SetFlag(helpingPlayer, true)).addPlayerMessage(l.subMsg("yes.reply", "Sure, I can agree to that.", new DialogueMessage.Argument[0])).addDescription(l.subMsg("yes.desc", "You are given 10 boondollars for the %s.", DialogueMessage.Argument.MATCHED_ITEM)).nextDialogue(builder.add("finally", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Finally!", new DialogueMessage.Argument[0]))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("no", "Too Cheap", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("no.reply", "I won't let it go that cheap.", new DialogueMessage.Argument[0])).nextDialogue(builder.add("end", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Fine. I will just go and find a real food store.", new DialogueMessage.Argument[0])))).setNextAsEntrypoint());
            ResourceLocation firstNo = builder.add("first_no", new DialogueProvider.NodeSelectorBuilder().node(new Condition.Flag(barterFlag), barterNode).defaultNode(new DialogueProvider.NodeBuilder(sadFaceMsg).animation("anxious")));
            DialogueProvider.MessageProducer noReplyMsg = l.msg(builder.startId(), "first_no_reply", "I don't really want to give this away.", new DialogueMessage.Argument[0]);
            builder.addStart(new DialogueProvider.NodeSelectorBuilder().node(new Condition.ItemTagMatch(MSTags.Items.CONSORT_SNACKS), new DialogueProvider.NodeBuilder(l.subMsg("ask", "A %s! Could I have some?", DialogueMessage.Argument.MATCHED_ITEM)).addResponse(new DialogueProvider.ResponseBuilder(yesMsg).condition(Condition.HasMatchedItem.INSTANCE).addTrigger(Trigger.TakeMatchedItem.INSTANCE).addTrigger(new Trigger.AddConsortReputation(15)).addTrigger(new Trigger.SetDialogue(satisfied)).addTrigger(new Trigger.SetFlag(helpingPlayer, true)).addPlayerMessage(l.subMsg("yes_reply", "Sure, here.", new DialogueMessage.Argument[0])).nextDialogue(builder.add("thanks", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Thank you! I will remember your kindness for the rest of my short life.", new DialogueMessage.Argument[0])).animation("happy")))).addResponse(new DialogueProvider.ResponseBuilder(noMsg).condition(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR)).addTrigger(new Trigger.SetFlag(barterFlag, false)).addPlayerMessage(noReplyMsg).nextDialogue(firstNo).setNextAsEntrypoint()).addResponse(new DialogueProvider.ResponseBuilder(noMsg).condition(Conditions.isAnyEntityType(MSEntityTypes.IGUANA)).addTrigger(new Trigger.SetFlag(noBarterFlag, false)).addPlayerMessage(noReplyMsg).nextDialogue(firstNo).setNextAsEntrypoint()).addResponse(new DialogueProvider.ResponseBuilder(noMsg).condition(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER)).addTrigger(new Trigger.SetRandomFlag(List.of(barterFlag, noBarterFlag), false)).addPlayerMessage(noReplyMsg).nextDialogue(firstNo).setNextAsEntrypoint())).defaultNode(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I'm hungry. Have any bugs? Maybe a chocolate chip cookie? Mmm.", new DialogueMessage.Argument[0]))));
        }));
        provider.addRandomlySelectable("computer_expert", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()), new FolderedDialogue(builder -> {
            ResourceLocation done = builder.add("done", new DialogueProvider.NodeSelectorBuilder().node(Conditions.all(new Condition.Flag(helpingPlayer), Conditions.hasAdvancement("minestuck.brick_computer")), new DialogueProvider.NodeBuilder(l.subMsg("player_specific_advancement", "Hey by the look on your face you've installed one of my custom programs! Glad to be of service.", new DialogueMessage.Argument[0]))).node(new Condition.Flag(helpingPlayer), new DialogueProvider.NodeBuilder(l.subMsg("player_specific", "That should fit nicely in your computer. You won't regret it!", new DialogueMessage.Argument[0]))).defaultNode(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I love helping people. You should have seen the face of this other person I helped earlier. Priceless.", new DialogueMessage.Argument[0]))));
            ResourceLocation sure = builder.add("sure", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Alright, all I need is a music disc. One that's in good condition. Got one?", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("yes", "[Hand over the %s]", DialogueMessage.Argument.MATCHED_ITEM)).visibleCondition(l.subText("give_item.condition", "Must have a music disc, excluding a broken disc"), new Condition.ItemTagMatchExclude((TagKey<Item>)Tags.Items.MUSIC_DISCS, Items.MUSIC_DISC_11)).addTrigger(Trigger.TakeMatchedItem.INSTANCE).addTrigger(new Trigger.GiveItem(Items.MUSIC_DISC_11)).addTrigger(new Trigger.SetFlag(helpingPlayer, true)).addTrigger(new Trigger.SetDialogue(done)).addDescription(l.subMsg("desc", "They take the disc and gently place it on the ground. Then they take out a hammer and break it to pieces before giving it back to you.", new DialogueMessage.Argument[0])).nextDialogue(done)).addClosingResponse(noMsg));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Me? I'm a computer expert. In fact I can slip you the latest software if you are interested.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("accept", "Sure, what is it.", new DialogueMessage.Argument[0])).nextDialogue(sure).setNextAsEntrypoint()).addClosingResponse(noMsg));
        }));
        provider.addRandomlySelectable("rap_battle", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR, MSEntityTypes.IGUANA)), new FolderedDialogue(builder -> {
            String rapA = "rap_a";
            String rapB = "rap_b";
            String rapC = "rap_c";
            String rapD = "rap_d";
            String rapE = "rap_e";
            String rapF = "rap_f";
            ResourceLocation afterRap = builder.add("after_rap", new DialogueProvider.NodeBuilder().addDescription(l.defaultKeyMsg("... that rap was really awful.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("school", "[Ruin their whole day]", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("school.reply", "All right, now it's my turn.", new DialogueMessage.Argument[0])).addDescription(l.subMsg("school.desc", "The %s proceeded to drop sick fire unlike any the %s had ever seen before.", DialogueMessage.Argument.PLAYER_TITLE, DialogueMessage.Argument.LAND_NAME)).setNextAsEntrypoint().nextDialogue(builder.add("final", new DialogueProvider.NodeBuilder().addMessage(l.defaultKeyMsg("%s. You are the greatest rapper ever.", DialogueMessage.Argument.ENTITY_SOUND))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("concede", "[Let the poor guy think they won]", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("concede.reply", "... wow. I'm just... not going to try to go against something like that.", new DialogueMessage.Argument[0])).setNextAsEntrypoint().nextDialogue(builder.add("concede", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("%s, yes! I am the greatest rapper ever!", DialogueMessage.Argument.ENTITY_SOUND))))));
            ResourceLocation raps = builder.add("raps", new DialogueProvider.NodeSelectorBuilder().node(new Condition.Flag(rapA), new DialogueProvider.NodeBuilder().addMessage(l.subMsg("a1", "I see you carryin' a pick", new DialogueMessage.Argument[0])).addMessage(l.subMsg("a2", "You think you minin'? Sick", new DialogueMessage.Argument[0])).addMessage(l.subMsg("a3", "But uh...", new DialogueMessage.Argument[0])).addMessage(l.subMsg("a4", "you ain't. Word.", new DialogueMessage.Argument[0])).next(afterRap)).node(new Condition.Flag(rapB), new DialogueProvider.NodeBuilder().addMessage(l.subMsg("b1", "You're green and square, kinda beveled on the sides", new DialogueMessage.Argument[0])).addMessage(l.subMsg("b2", "And the corners I guess. Or are they called vertexes?", new DialogueMessage.Argument[0])).addMessage(l.subMsg("b3", "But I'm sayin' you're generic. Like, so generic", new DialogueMessage.Argument[0])).addMessage(l.subMsg("b4", "it doesn't make sense. ... uh, sorry for being a jerk.", new DialogueMessage.Argument[0])).next(afterRap)).node(new Condition.Flag(rapC), new DialogueProvider.NodeBuilder().addMessage(l.subMsg("c1", "Yeah. Yeah. Yeah. Yeah.", new DialogueMessage.Argument[0])).addMessage(l.subMsg("c2", "Ooh. Ooh. Ooh. Ooh.", new DialogueMessage.Argument[0])).addMessage(l.subMsg("c3", "%1$s. %1$s. %1$s. %1$s.", DialogueMessage.Argument.ENTITY_SOUND)).addMessage(l.subMsg("c4", "Yeah. Yeah. Yeah. Yeah.", new DialogueMessage.Argument[0])).next(afterRap)).node(new Condition.Flag(rapD), new DialogueProvider.NodeBuilder().addMessage(l.subMsg("d1", "I'm the Knight of Time, the god of sick beats", new DialogueMessage.Argument[0])).addMessage(l.subMsg("d2", "Settle down and lemme... why are you giving me that look?", new DialogueMessage.Argument[0])).addMessage(l.subMsg("d3", "This is my own original rap!", new DialogueMessage.Argument[0])).addMessage(l.subMsg("d4", "Really!", new DialogueMessage.Argument[0])).next(afterRap)).node(new Condition.Flag(rapE), new DialogueProvider.NodeBuilder().addMessage(l.subMsg("e1", "Incaseyoucouldn'ttell,", new DialogueMessage.Argument[0])).addMessage(l.subMsg("e2", "you'reuglyandyousmell!", new DialogueMessage.Argument[0])).addMessage(l.subMsg("e3", "OOOHHHHHHHHH!", new DialogueMessage.Argument[0])).addMessage(l.subMsg("e4", "...That's how rap works, right?", new DialogueMessage.Argument[0])).next(afterRap)).defaultNode(new DialogueProvider.NodeBuilder().addMessage(l.subMsg("f1", "Have a nice trip and I'll see you next fall!", new DialogueMessage.Argument[0])).addMessage(l.subMsg("f2", "I hope you don't mind that my house isn't tall,", new DialogueMessage.Argument[0])).addMessage(l.subMsg("f3", "'Cuz them things is dang'rous and although no one cares,", new DialogueMessage.Argument[0])).addMessage(l.subMsg("f4", "I'm tellin' ya, dawg, I WARNED YOU 'BOUT STAIRS!", new DialogueMessage.Argument[0])).next(afterRap)));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I challenge you to a rap battle! Accept challenge? Y/N", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("accept", "[Accept this consort's challenge!]", new DialogueMessage.Argument[0])).addTrigger(new Trigger.SetRandomFlag(List.of(rapA, rapB, rapC, rapD, rapE, rapF), false)).addPlayerMessage(l.subMsg("accept.reply", "Y! I'll take you on! You can even go first.", new DialogueMessage.Argument[0])).nextDialogue(raps).setNextAsEntrypoint()).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("deny", "[Don't bother with this guy]", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("deny.reply", "N. Maybe later.", new DialogueMessage.Argument[0])).nextDialogue(builder.add("deny", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Maybe one day I will find a challenger worthy of my greatness....", new DialogueMessage.Argument[0]))))));
        }));
    }

    private static void terrainFaygoDialogue(SelectableDialogueProvider provider, DialogueLangHelper l, DeferredItem<Item> drink, String capitalizedDrinkName, DeferredItem<Item> scalemateItem, String scalemateCapitalizedName, Condition terrain) {
        String drinkRegistryName = drink.getId().getPath();
        String dialogueId = drinkRegistryName + "_" + scalemateItem.getId().getPath();
        Item drinkItem = drink.asItem();
        Condition.PlayerHasItem faygoCondition = new Condition.PlayerHasItem(drinkItem, 1);
        provider.addRandomlySelectable(dialogueId, SelectableDialogueProvider.defaultWeight(terrain), new FolderedDialogue(builder -> {
            ResourceLocation satisfied = builder.add("satisfied", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I drank my faygo too fast to cherish it, but at least I have the dye stains to remember it by.", new DialogueMessage.Argument[0])));
            ResourceLocation scalemate = builder.add("explain_scalemate", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Because I'm willing to be the bigger consort about this, I will refrain from commenting on your ignorance. Scalemates are highly collectable designer dragon stuffed animals.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("return", "Lets talk about the drink again.", new DialogueMessage.Argument[0])).nextDialogue(provider.dialogue().dialogueId(dialogueId + "/ask_drink"))));
            ResourceLocation afterInvitation = builder.add("ask_drink", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I would give you my first born child for that, if I had one. Since I don't, could I exchange it for my scalemate " + scalemateCapitalizedName + "?", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("scalemate_confused", "What is a scalemate?", new DialogueMessage.Argument[0])).nextDialogue(scalemate)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("exchange", "[Hand over the faygo for scalemate]", new DialogueMessage.Argument[0])).visibleCondition(faygoCondition).addPlayerMessage(l.subMsg("yes.reply", "Sure here you go", new DialogueMessage.Argument[0])).nextDialogue(builder.add("happy", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Ohhhh yeah that's the stuff. Straight up ambrosia.", new DialogueMessage.Argument[0])))).addTrigger(new Trigger.TakeItem(drinkItem)).addTrigger(new Trigger.GiveItem(scalemateItem.asItem())).addTrigger(new Trigger.SetDialogue(satisfied))).addClosingResponse(l.subMsg("no", "No", new DialogueMessage.Argument[0])));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Everyone knows that the best flavor of faygo is " + capitalizedDrinkName + ". There is literally nothing else that can top it.", new DialogueMessage.Argument[0])).addClosingResponse(l.subMsg("bye", "Oh, good to know. Bye.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("different_better", "I prefer another flavor", new DialogueMessage.Argument[0])).nextDialogue(builder.add("scoundrel", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You are a liar and a scoundrel.", new DialogueMessage.Argument[0]))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("dont_drink", "I don't drink faygo", new DialogueMessage.Argument[0])).nextDialogue(builder.add("foul", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Begone foul beast.", new DialogueMessage.Argument[0]))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("possess", "I have some with me", new DialogueMessage.Argument[0])).visibleCondition(faygoCondition).nextDialogue(afterInvitation)));
        }));
    }
}

