/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.dialogue;

import com.mraof.minestuck.data.dialogue.DialogueLangHelper;
import com.mraof.minestuck.data.dialogue.DialogueProvider;
import com.mraof.minestuck.data.dialogue.SelectableDialogueProvider;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.dialogue.DialogueMessage;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import com.mraof.minestuck.entity.dialogue.Trigger;
import com.mraof.minestuck.entity.dialogue.condition.Conditions;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.world.lands.LandTypes;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public final class ConsortFoodMerchantDialogue {
    private static final Trigger.OpenConsortMerchantGui SHOP_TRIGGER = new Trigger.OpenConsortMerchantGui(MSLootTables.CONSORT_FOOD_STOCK);

    public static DataProvider create(PackOutput output, LanguageProvider enUsLanguageProvider) {
        SelectableDialogueProvider provider = new SelectableDialogueProvider("minestuck", RandomlySelectableDialogue.DialogueCategory.CONSORT_FOOD_MERCHANT, output);
        ConsortFoodMerchantDialogue.dialogue(provider, new DialogueLangHelper("minestuck", enUsLanguageProvider));
        return provider;
    }

    private static void dialogue(SelectableDialogueProvider provider, DialogueLangHelper l) {
        provider.addRandomlySelectable("food_shop", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You hungry? I bet you are! Why else would you be talking to me?", new DialogueMessage.Argument[0])).addClosingResponse(l.subMsg("bye", "Never mind", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("next", "What do you have?", new DialogueMessage.Argument[0])).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("fast_food", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Welcome to MacCricket's, what would you like?", new DialogueMessage.Argument[0])).addClosingResponse(l.subMsg("bye", "I'm good", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("next", "Show me your menu", new DialogueMessage.Argument[0])).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("grocery_store", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.IGUANA)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Thank you for choosing Stop and Hop, this village's #1 one grocer!", new DialogueMessage.Argument[0])).addClosingResponse(l.subMsg("bye", "No thanks", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("next", "What do you have to sell?", new DialogueMessage.Argument[0])).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("tasty_welcome", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.TURTLE)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Welcome. I hope you find something tasty among our wares.", new DialogueMessage.Argument[0])).addClosingResponse(l.subMsg("bye", "Goodbye", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("next", "Let me see your wares", new DialogueMessage.Argument[0])).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("breeze", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.WIND)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("It's hard to catch our food with the Breeze carrying them away and whatnot!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("blood", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.PULSE)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Hope you like red meat!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("rabbit", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.RABBITS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Rabbit stew! Mmmm!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("lightning", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.THUNDER)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Lightning-smoked meat really adds to the flavor!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("frog_leg", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.FROGS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Frog legs are good but eating them is heresy! Buy some of our food instead!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("frog", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.FROGS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("We would never eat frogs here in the %s! Grasshoppers, though...", DialogueMessage.Argument.LAND_NAME)).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("time", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.CLOCKWORK)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Tick Tock, time's a-wasting! Eat something or leave!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("thyme", SelectableDialogueProvider.defaultWeight(Conditions.any(Conditions.isInTitleLand(LandTypes.CLOCKWORK), Conditions.isInTitleLand(LandTypes.THOUGHT))).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Take your mind off of the limited time we have left alive with food!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("library", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.THOUGHT)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I'm selling recipes I made from a nearby library's cookbook. Buy some!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("cake", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.CAKE)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Who needs cake when you have crickets!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("light", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.LIGHT)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Crickets are nocturnal so our species' main food source is hard to find here. Oh well!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("silence", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.SILENCE)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This place used to be filled with the sounds of crickets until we captured them all for food!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("rage", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(MSTags.TitleLandTypes.MONSTERS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You're not you when you're hungry. Buy a snickers!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("hope", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.TOWERS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I HOPE you're hungry!", new DialogueMessage.Argument[0])).addDescription(l.subMsg("desc", "You hear a faint ba-dum tss in the distance.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("buckets", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.BUCKETS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Ever soaked your grist candies in the liquids the buckets contain? It really enhances the taste!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
    }
}

