/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.dialogue;

import com.mraof.minestuck.data.dialogue.DialogueLangHelper;
import com.mraof.minestuck.data.dialogue.DialogueProvider;
import com.mraof.minestuck.data.dialogue.SelectableDialogueProvider;
import com.mraof.minestuck.entity.dialogue.DialogueMessage;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import com.mraof.minestuck.entity.dialogue.Trigger;
import com.mraof.minestuck.entity.dialogue.condition.Conditions;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.world.lands.LandTypes;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.neoforge.common.data.LanguageProvider;

public final class ConsortGeneralMerchantDialogue {
    private static final Trigger.OpenConsortMerchantGui SHOP_TRIGGER = new Trigger.OpenConsortMerchantGui(MSLootTables.CONSORT_GENERAL_STOCK);

    public static DataProvider create(PackOutput output, LanguageProvider enUsLanguageProvider) {
        SelectableDialogueProvider provider = new SelectableDialogueProvider("minestuck", RandomlySelectableDialogue.DialogueCategory.CONSORT_GENERAL_MERCHANT, output);
        ConsortGeneralMerchantDialogue.dialogue(provider, new DialogueLangHelper("minestuck", enUsLanguageProvider));
        return provider;
    }

    private static void dialogue(SelectableDialogueProvider provider, DialogueLangHelper l) {
        provider.addRandomlySelectable("generic", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("We have generic goods for generic people!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("got_the_goods", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You want the goods? We got the goods.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("top_tier", SelectableDialogueProvider.defaultWeight(Conditions.alwaysTrue()).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("We have top tier goods for a top tier god!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("breeze", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.WIND)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("The breeze has brought me many fine wares.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("blood", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.PULSE)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I accept payment in blood. And boondollars. I also take checks.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("life", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.RABBITS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Twenty years selling losers hats and shit really takes the life out of you.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("doom", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.THUNDER)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("With my prices, my competitors are doomed!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("frog", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.FROGS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Get your frog merchandise here! Limited time only! ....Just kidding, I'm always here.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("time", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.CLOCKWORK)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Future me has told me that some sucker would buy tons of \"goods\" from me... will that sucker be you?", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("book", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.THOUGHT)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Books have taught us how to sell as much useless crap as possible, want some?", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("cake", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.CAKE)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Don't buy goods here. Cake is our specialty, not general goods. Very low quality.", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("light", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.LIGHT)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You may be blind but I'm sure you can see our prices are fantastic!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("silence", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.SILENCE)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("This land may be silent but our prices will make you SCREAM!... with joy, of course!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("rage", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(MSTags.TitleLandTypes.MONSTERS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Other store's prices are INFURIATING! Our prices, however, will soothe that frustration!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("tower", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.TOWERS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("I got the goods; they're all recently raided from a nearby tower!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("buckets", SelectableDialogueProvider.defaultWeight(Conditions.isInTitleLand(LandTypes.BUCKETS)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Here's a witty one-liner tying in buckets and general stores!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
        provider.addRandomlySelectable("eye_catching", SelectableDialogueProvider.defaultWeight(Conditions.isInTerrainLand(LandTypes.RAINBOW)).keepOnReset(), new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Looking for something that won't catch your eye? You've come to the right place!", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(DialogueLangHelper.msg(DialogueProvider.ARROW)).addTrigger(SHOP_TRIGGER)));
    }
}

