/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.dialogue;

import com.mraof.minestuck.data.dialogue.DialogueProvider;
import com.mraof.minestuck.entity.dialogue.DialogueMessage;
import java.util.List;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.LanguageProvider;

public final class DialogueLangHelper {
    private final String modid;
    private final LanguageProvider languageProvider;

    public DialogueLangHelper(String modid, LanguageProvider languageProvider) {
        this.modid = modid;
        this.languageProvider = languageProvider;
    }

    public DialogueProvider.MessageProducer defaultKeyMsg(String text, DialogueMessage.Argument ... arguments) {
        return id -> this.registerAndBuild(DialogueLangHelper.languageKeyBase(id), text, arguments);
    }

    public DialogueProvider.MessageProducer subMsg(String key, String text, DialogueMessage.Argument ... arguments) {
        return id -> this.registerAndBuild(DialogueLangHelper.languageKeyBase(id) + "." + key, text, arguments);
    }

    public DialogueProvider.MessageProducer msg(ResourceLocation id, String key, String text, DialogueMessage.Argument ... arguments) {
        return DialogueLangHelper.msg(this.registerAndBuild(DialogueLangHelper.languageKeyBase(id) + "." + key, text, arguments));
    }

    public DialogueProvider.MessageProducer msg(String key, String text, DialogueMessage.Argument ... arguments) {
        return DialogueLangHelper.msg(this.registerAndBuild(DialogueLangHelper.languageKeyBase(ResourceLocation.fromNamespaceAndPath((String)this.modid, (String)key)), text, arguments));
    }

    public static DialogueProvider.MessageProducer msg(DialogueMessage message) {
        return baseId -> message;
    }

    public Function<ResourceLocation, String> subText(String subKey, String text) {
        return id -> {
            String key = DialogueLangHelper.languageKeyBase(id) + "." + subKey;
            this.languageProvider.add(key, text);
            return key;
        };
    }

    private DialogueMessage registerAndBuild(String key, String text, DialogueMessage.Argument ... arguments) {
        this.languageProvider.add(key, text);
        return new DialogueMessage(key, List.of(arguments));
    }

    private static String languageKeyBase(ResourceLocation id) {
        return id.getNamespace() + ".dialogue." + id.getPath().replace("/", ".");
    }
}

