/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.dialogue;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.data.dialogue.DialogueLangHelper;
import com.mraof.minestuck.entity.dialogue.Dialogue;
import com.mraof.minestuck.entity.dialogue.DialogueAnimationData;
import com.mraof.minestuck.entity.dialogue.DialogueMessage;
import com.mraof.minestuck.entity.dialogue.Trigger;
import com.mraof.minestuck.entity.dialogue.condition.Condition;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class DialogueProvider
implements DataProvider {
    private final Map<ResourceLocation, Dialogue.NodeSelector> dialogues = new HashMap<ResourceLocation, Dialogue.NodeSelector>();
    private final String modId;
    private final String subFolder;
    private final PackOutput output;
    public static final DialogueMessage ARROW = new DialogueMessage("minestuck.arrow");
    public static final DialogueMessage DOTS = new DialogueMessage("minestuck.dots");

    public DialogueProvider(String modId, String subFolder, PackOutput output) {
        this.modId = modId;
        this.subFolder = subFolder;
        this.output = output;
    }

    public ResourceLocation dialogueId(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)(this.subFolder + "/" + path));
    }

    public ResourceLocation add(String path, DialogueProducer builder) {
        return builder.buildAndRegister(this.dialogueId(path), this::checkAndAdd);
    }

    public void add(ResourceLocation id, SimpleDialogueProducer builder) {
        builder.buildAndRegister(id, this::checkAndAdd);
    }

    private void checkAndAdd(ResourceLocation id, Dialogue.NodeSelector dialogue) {
        if (this.dialogues.containsKey(id)) {
            throw new IllegalArgumentException(String.valueOf(id) + " was added twice");
        }
        this.dialogues.put(id, dialogue);
    }

    boolean hasAddedDialogue(ResourceLocation dialogueId) {
        return this.dialogues.containsKey(dialogueId);
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        HashSet missingDialogue = new HashSet();
        this.dialogues.values().forEach(dialogue -> dialogue.visitConnectedDialogue(dialogueId -> {
            if (!this.hasAddedDialogue((ResourceLocation)dialogueId)) {
                missingDialogue.add(dialogueId);
            }
        }));
        if (!missingDialogue.isEmpty()) {
            throw new IllegalStateException("Some referenced dialogue is missing: " + String.valueOf(missingDialogue));
        }
        Path outputPath = this.output.getOutputFolder();
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(this.dialogues.size());
        for (Map.Entry<ResourceLocation, Dialogue.NodeSelector> entry : this.dialogues.entrySet()) {
            Path dialoguePath = DialogueProvider.getPath(outputPath, entry.getKey());
            JsonElement dialogueJson = (JsonElement)Dialogue.NodeSelector.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow();
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)dialogueJson, (Path)dialoguePath));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private static Path getPath(Path outputPath, ResourceLocation id) {
        return outputPath.resolve("data/" + id.getNamespace() + "/minestuck/dialogue/" + id.getPath() + ".json");
    }

    public String getName() {
        return "Dialogues";
    }

    public static interface DialogueProducer {
        public ResourceLocation buildAndRegister(ResourceLocation var1, BiConsumer<ResourceLocation, Dialogue.NodeSelector> var2);
    }

    public static interface SimpleDialogueProducer
    extends DialogueProducer {
        public Dialogue.NodeSelector buildSelector(ResourceLocation var1, BiConsumer<ResourceLocation, Dialogue.NodeSelector> var2);

        @Override
        default public ResourceLocation buildAndRegister(ResourceLocation id, BiConsumer<ResourceLocation, Dialogue.NodeSelector> register) {
            register.accept(id, this.buildSelector(id, register));
            return id;
        }
    }

    public static class ResponseBuilder {
        private final MessageProducer message;
        private final List<Trigger> triggers = new ArrayList<Trigger>();
        @Nullable
        private DialogueProducer nextDialogue = null;
        private boolean setEntrypoint = false;
        private final List<Pair<Dialogue.MessageType, MessageProducer>> replyMessages = new ArrayList<Pair<Dialogue.MessageType, MessageProducer>>();
        private Condition condition = Condition.AlwaysTrue.INSTANCE;
        private boolean hideIfFailed = true;
        private Function<ResourceLocation, String> failTooltip = id -> null;

        ResponseBuilder(MessageProducer message) {
            this.message = message;
        }

        public ResponseBuilder nextDialogue(String key, DialogueProducer dialogueProducer) {
            this.nextDialogue = (id, register) -> dialogueProducer.buildAndRegister(id.withSuffix("." + key), register);
            return this;
        }

        public ResponseBuilder nextDialogue(ResourceLocation nextDialogueId) {
            this.nextDialogue = (id, register) -> nextDialogueId;
            return this;
        }

        public ResponseBuilder addPlayerMessage(MessageProducer producer) {
            return this.addReplyMessage(Dialogue.MessageType.PLAYER, producer);
        }

        public ResponseBuilder addDescription(MessageProducer producer) {
            return this.addReplyMessage(Dialogue.MessageType.DESCRIPTION, producer);
        }

        public ResponseBuilder addReplyMessage(Dialogue.MessageType type, MessageProducer producer) {
            this.replyMessages.add((Pair<Dialogue.MessageType, MessageProducer>)Pair.of((Object)((Object)type), (Object)producer));
            return this;
        }

        public ResponseBuilder loop() {
            this.nextDialogue = (id, register) -> id;
            return this;
        }

        public ResponseBuilder setNextAsEntrypoint() {
            this.setEntrypoint = true;
            return this;
        }

        public ResponseBuilder condition(Condition condition) {
            this.hideIfFailed = true;
            this.condition = condition;
            return this;
        }

        public ResponseBuilder visibleCondition(Condition condition) {
            this.hideIfFailed = false;
            this.condition = condition;
            return this;
        }

        public ResponseBuilder visibleCondition(Function<ResourceLocation, String> failTooltip, Condition condition) {
            this.hideIfFailed = false;
            this.condition = condition;
            this.failTooltip = failTooltip;
            return this;
        }

        public ResponseBuilder addTrigger(Trigger trigger) {
            this.triggers.add(trigger);
            return this;
        }

        public Dialogue.Response build(ResourceLocation id, BiConsumer<ResourceLocation, Dialogue.NodeSelector> register) {
            Optional<Dialogue.NextDialogue> nextDialogue = Optional.ofNullable(this.nextDialogue).map(producer -> producer.buildAndRegister(id, register)).map(nextId -> new Dialogue.NextDialogue((ResourceLocation)nextId, this.setEntrypoint, this.replyMessages.stream().map(pair -> pair.mapSecond(producer -> producer.build(id))).toList()));
            DialogueMessage message = this.message.build(id);
            return new Dialogue.Response(message, this.triggers, nextDialogue, this.condition, this.hideIfFailed, Optional.ofNullable(this.failTooltip.apply(id)));
        }
    }

    public static class NodeBuilder
    implements SimpleDialogueProducer,
    NodeProducer {
        private final List<Pair<Dialogue.MessageType, MessageProducer>> messages = new ArrayList<Pair<Dialogue.MessageType, MessageProducer>>();
        private DialogueAnimationData animation = DialogueAnimationData.DEFAULT_ANIMATION;
        private ResourceLocation guiPath = Dialogue.DEFAULT_GUI;
        private final List<ResponseBuilder> responses = new ArrayList<ResponseBuilder>();

        public NodeBuilder(MessageProducer message) {
            this.addMessage(message);
        }

        public NodeBuilder() {
        }

        public NodeBuilder addMessage(MessageProducer message) {
            this.messages.add((Pair<Dialogue.MessageType, MessageProducer>)Pair.of((Object)((Object)Dialogue.MessageType.ENTITY), (Object)message));
            return this;
        }

        public NodeBuilder addDescription(MessageProducer message) {
            this.messages.add((Pair<Dialogue.MessageType, MessageProducer>)Pair.of((Object)((Object)Dialogue.MessageType.DESCRIPTION), (Object)message));
            return this;
        }

        public NodeBuilder animation(String emotion) {
            return this.animation(new DialogueAnimationData(emotion, 224, 224, 0, 0, 1.0f));
        }

        public NodeBuilder animation(DialogueAnimationData animation) {
            this.animation = animation;
            return this;
        }

        public NodeBuilder gui(ResourceLocation guiPath) {
            this.guiPath = guiPath;
            return this;
        }

        public NodeBuilder addClosingResponse() {
            return this.addClosingResponse(DialogueLangHelper.msg(DOTS));
        }

        public NodeBuilder addClosingResponse(MessageProducer message) {
            return this.addResponse(new ResponseBuilder(message));
        }

        public NodeBuilder next(String key, DialogueProducer dialogueProducer) {
            return this.addResponse(new ResponseBuilder(DialogueLangHelper.msg(ARROW)).nextDialogue(key, dialogueProducer));
        }

        public NodeBuilder next(ResourceLocation dialogueId) {
            return this.addResponse(new ResponseBuilder(DialogueLangHelper.msg(ARROW)).nextDialogue(dialogueId));
        }

        public NodeBuilder addResponse(ResponseBuilder responseBuilder) {
            this.responses.add(responseBuilder);
            return this;
        }

        @Override
        public Dialogue.Node buildNode(ResourceLocation id, BiConsumer<ResourceLocation, Dialogue.NodeSelector> register) {
            List<Pair<Dialogue.MessageType, DialogueMessage>> messages = this.messages.stream().map(pair -> pair.mapSecond(producer -> producer.build(id))).toList();
            List<Dialogue.Response> responses = this.responses.stream().map(builder -> builder.build(id, register)).toList();
            return new Dialogue.Node(messages, this.animation, this.guiPath, responses);
        }

        @Override
        public Dialogue.NodeSelector buildSelector(ResourceLocation id, BiConsumer<ResourceLocation, Dialogue.NodeSelector> register) {
            return new NodeSelectorBuilder().defaultNode(this).buildSelector(id, register);
        }
    }

    public static class NodeSelectorBuilder
    implements SimpleDialogueProducer {
        private final List<Pair<Condition, NodeProducer>> conditionedNodes = new ArrayList<Pair<Condition, NodeProducer>>();
        @Nullable
        private NodeProducer defaultNode;

        public NodeSelectorBuilder node(Condition condition, String key, NodeProducer node) {
            return this.node(condition, (id, register) -> node.buildNode(id.withSuffix("." + key), register));
        }

        public NodeSelectorBuilder node(Condition condition, NodeProducer node) {
            this.conditionedNodes.add((Pair<Condition, NodeProducer>)Pair.of((Object)condition, (Object)node));
            return this;
        }

        public NodeSelectorBuilder defaultNode(String key, NodeProducer node) {
            return this.defaultNode((id, register) -> node.buildNode(id.withSuffix("." + key), register));
        }

        public NodeSelectorBuilder defaultNode(NodeProducer node) {
            this.defaultNode = node;
            return this;
        }

        @Override
        public Dialogue.NodeSelector buildSelector(ResourceLocation id, BiConsumer<ResourceLocation, Dialogue.NodeSelector> register) {
            Objects.requireNonNull(this.defaultNode, "Default node must be set");
            return new Dialogue.NodeSelector(this.conditionedNodes.stream().map(pair -> pair.mapSecond(builder -> builder.buildNode(id, register))).toList(), this.defaultNode.buildNode(id, register));
        }
    }

    public static interface MessageProducer {
        public DialogueMessage build(ResourceLocation var1);
    }

    public static interface NodeProducer {
        public Dialogue.Node buildNode(ResourceLocation var1, BiConsumer<ResourceLocation, Dialogue.NodeSelector> var2);
    }
}

