/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.dialogue;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.data.dialogue.DialogueProvider;
import com.mraof.minestuck.entity.dialogue.Dialogue;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import com.mraof.minestuck.entity.dialogue.condition.Condition;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class SelectableDialogueProvider
implements DataProvider {
    private final DialogueProvider dialogueProvider;
    private final Map<ResourceLocation, Dialogue.SelectableDialogue> selectableDialogueMap = new HashMap<ResourceLocation, Dialogue.SelectableDialogue>();
    private final String modId;
    private final RandomlySelectableDialogue.DialogueCategory category;
    private final PackOutput output;

    public SelectableDialogueProvider(String modId, RandomlySelectableDialogue.DialogueCategory category, PackOutput output) {
        this.dialogueProvider = new DialogueProvider(modId, category.folderName(), output);
        this.modId = modId;
        this.category = category;
        this.output = output;
    }

    public static SelectableBuilder weighted(int weight, Condition condition) {
        return new SelectableBuilder(condition, weight);
    }

    public static SelectableBuilder defaultWeight(Condition condition) {
        return new SelectableBuilder(condition, 10);
    }

    public void addRandomlySelectable(String path, SelectableBuilder selectable, DialogueProvider.DialogueProducer builder) {
        this.addRandomlySelectable(path, selectable, this.dialogueProvider.add(path, builder));
    }

    public void addRandomlySelectable(String path, SelectableBuilder selectable, ResourceLocation dialogueId) {
        this.selectableDialogueMap.put(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)path), selectable.build(dialogueId));
    }

    public DialogueProvider dialogue() {
        return this.dialogueProvider;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(this.selectableDialogueMap.size() + 1);
        futures.add(this.dialogueProvider.run(cache));
        Set missingDialogue = this.selectableDialogueMap.values().stream().map(Dialogue.SelectableDialogue::dialogueId).filter(id -> !this.dialogueProvider.hasAddedDialogue((ResourceLocation)id)).collect(Collectors.toSet());
        if (!missingDialogue.isEmpty()) {
            throw new IllegalStateException("Some referenced dialogue is missing: " + String.valueOf(missingDialogue));
        }
        Path outputPath = this.output.getOutputFolder();
        for (Map.Entry<ResourceLocation, Dialogue.SelectableDialogue> entry : this.selectableDialogueMap.entrySet()) {
            Path selectablePath = outputPath.resolve("data/" + entry.getKey().getNamespace() + "/" + this.category.folderNameForSelectable() + "/" + entry.getKey().getPath() + ".json");
            JsonElement selectableJson = (JsonElement)Dialogue.SelectableDialogue.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).getOrThrow();
            futures.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)selectableJson, (Path)selectablePath));
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public String getName() {
        return "Selectable dialogue provider: " + this.category.folderName();
    }

    public static final class SelectableBuilder {
        private final Condition condition;
        private final int weight;
        private boolean keepOnReset = false;

        public SelectableBuilder(Condition condition, int weight) {
            this.condition = condition;
            this.weight = weight;
        }

        public SelectableBuilder keepOnReset() {
            this.keepOnReset = true;
            return this;
        }

        public Dialogue.SelectableDialogue build(ResourceLocation dialogueId) {
            return new Dialogue.SelectableDialogue(dialogueId, this.condition, this.weight, this.keepOnReset);
        }
    }
}

