/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.dialogue;

import com.mraof.minestuck.data.dialogue.DialogueLangHelper;
import com.mraof.minestuck.data.dialogue.DialogueProvider;
import com.mraof.minestuck.data.dialogue.FolderedDialogue;
import com.mraof.minestuck.data.dialogue.SelectableDialogueProvider;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.dialogue.DialogueMessage;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import com.mraof.minestuck.entity.dialogue.Trigger;
import com.mraof.minestuck.entity.dialogue.condition.Condition;
import com.mraof.minestuck.entity.dialogue.condition.Conditions;
import com.mraof.minestuck.item.loot.MSLootTables;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.data.LanguageProvider;

public final class ShadyConsortDialogue {
    public static DataProvider create(PackOutput output, LanguageProvider enUsLanguageProvider) {
        SelectableDialogueProvider provider = new SelectableDialogueProvider("minestuck", RandomlySelectableDialogue.DialogueCategory.SHADY_CONSORT, output);
        ShadyConsortDialogue.dialogue(provider, new DialogueLangHelper("minestuck", enUsLanguageProvider));
        return provider;
    }

    private static void dialogue(SelectableDialogueProvider provider, DialogueLangHelper l) {
        provider.addRandomlySelectable("shady_offer", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.SALAMANDER, MSEntityTypes.TURTLE)), new FolderedDialogue(builder -> {
            ResourceLocation purchase = builder.add("purchase", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Thanks for your cash.", new DialogueMessage.Argument[0])));
            ResourceLocation shadyOffer2 = builder.add("next", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("You're missin' out kiddo. %s it. I'll sell you this thing for 500 boondollars.", DialogueMessage.Argument.ENTITY_SOUND)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("buy", "buy it already! [Pay 500 boondollars]", new DialogueMessage.Argument[0])).visibleCondition(new Condition.PlayerHasBoondollars(500)).addTrigger(new Trigger.AddBoondollars(-500)).addTrigger(new Trigger.AddConsortReputation(-35)).addTrigger(new Trigger.GiveFromLootTable(MSLootTables.CONSORT_JUNK_REWARD)).addPlayerMessage(l.subMsg("buy.reply", " Sure! Fine! Ok! Jeez...", new DialogueMessage.Argument[0])).nextDialogue(purchase).setNextAsEntrypoint()).addClosingResponse(l.subMsg("deny", "It may be a deception, do not buy the \"thing\"!", new DialogueMessage.Argument[0])));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Hey kid... I'll give you something special for 1000 boondollars...", new DialogueMessage.Argument[0])).addDescription(l.subMsg("desc", "This %s seems pretty shady. You're not sure whether or not to trust them...", DialogueMessage.Argument.ENTITY_TYPE)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("buy", "Buy \"Something special\" [Pay 1000 boondollars]", new DialogueMessage.Argument[0])).visibleCondition(new Condition.PlayerHasBoondollars(1000)).addTrigger(new Trigger.AddBoondollars(-1000)).addTrigger(new Trigger.AddConsortReputation(-15)).addTrigger(new Trigger.GiveFromLootTable(MSLootTables.CONSORT_JUNK_REWARD)).addTrigger(new Trigger.SetPlayerDialogue(purchase)).addPlayerMessage(l.subMsg("buy.reply", "Ok... Sure??", new DialogueMessage.Argument[0])).nextDialogue(builder.add("item", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Here, kid.", new DialogueMessage.Argument[0]))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("deny", "Do not buy from the shadowy dealer.", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("deny.reply", "Uh, no thanks...", new DialogueMessage.Argument[0])).nextDialogue(shadyOffer2)));
        }));
        provider.addRandomlySelectable("peppy_offer", SelectableDialogueProvider.defaultWeight(Conditions.isAnyEntityType(MSEntityTypes.NAKAGATOR, MSEntityTypes.IGUANA)), new FolderedDialogue(builder -> {
            ResourceLocation purchase = builder.add("purchase", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Thank you for your money!", new DialogueMessage.Argument[0])));
            ResourceLocation peppyOffer2 = builder.add("next", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Oh! No worries! How about I sell it to you for just 500 boondollars instead??", new DialogueMessage.Argument[0])).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("buy", "Buy that cheap item! [pay 500 boondollars]", new DialogueMessage.Argument[0])).visibleCondition(new Condition.PlayerHasBoondollars(500)).addTrigger(new Trigger.AddBoondollars(-500)).addTrigger(new Trigger.AddConsortReputation(-35)).addTrigger(new Trigger.GiveFromLootTable(MSLootTables.CONSORT_JUNK_REWARD)).addPlayerMessage(l.subMsg("buy.reply", "Sure! I'd be glad to!", new DialogueMessage.Argument[0])).nextDialogue(purchase).setNextAsEntrypoint()).addClosingResponse(l.subMsg("deny", "Still do not buy from cheery salesman.", new DialogueMessage.Argument[0])));
            builder.addStart(new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Hey there! I've got a wonderful item here for just 1000 boondollars? How about it kid?", new DialogueMessage.Argument[0])).addDescription(l.subMsg("desc", "This %s is way too nice to ever scam you! Surely you can trust them?", DialogueMessage.Argument.ENTITY_TYPE)).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("buy", "Buy \"Wonderful item\" [Pay 1000 boondollars]", new DialogueMessage.Argument[0])).visibleCondition(new Condition.PlayerHasBoondollars(1000)).addTrigger(new Trigger.AddBoondollars(-1000)).addTrigger(new Trigger.AddConsortReputation(-15)).addTrigger(new Trigger.GiveFromLootTable(MSLootTables.CONSORT_JUNK_REWARD)).addTrigger(new Trigger.SetPlayerDialogue(purchase)).addPlayerMessage(l.subMsg("buy.reply", "Sure! Why not?", new DialogueMessage.Argument[0])).nextDialogue(builder.add("item", new DialogueProvider.NodeBuilder(l.defaultKeyMsg("Here you are!", new DialogueMessage.Argument[0]))))).addResponse(new DialogueProvider.ResponseBuilder(l.subMsg("deny", "Do not buy from cheery salesman.", new DialogueMessage.Argument[0])).addPlayerMessage(l.subMsg("deny.reply", "No thanks! I'm short on cash.", new DialogueMessage.Argument[0])).nextDialogue(peppyOffer2)));
        }));
    }
}

