/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.loot_table;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.loot.LandTableLootEntry;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.item.loot.functions.SetBoondollarCount;
import com.mraof.minestuck.item.loot.functions.SetSburbCodeFragments;
import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.entries.TagEntry;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemDamageFunction;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.neoforged.neoforge.common.Tags;

public final class MSChestLootTables
implements LootTableSubProvider {
    public static final String ITEM_POOL = "item";
    public static final ResourceKey<LootTable> WEAPON_ITEM_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Minestuck.id("chests/weapon_item"));
    public static final ResourceKey<LootTable> SUPPLY_ITEM_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Minestuck.id("chests/supply_item"));
    public static final ResourceKey<LootTable> MISC_ITEM_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Minestuck.id("chests/misc_item"));
    public static final ResourceKey<LootTable> RARE_ITEM_TABLE = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)Minestuck.id("chests/rare_item"));

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> lootProcessor) {
        lootProcessor.accept(MSLootTables.BLANK_DISK_DUNGEON_LOOT_INJECT, LootTable.lootTable().withPool(LootPool.lootPool().name("minestuck").setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.BLANK_DISK.get())).setWeight(1).setQuality(1).apply(this.countRange(0.0f, 2.0f)))));
        lootProcessor.accept(MSLootTables.SBURB_CODE_LIBRARY_LOOT_INJECT, LootTable.lootTable().withPool(LootPool.lootPool().name("minestuck").setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.SBURB_CODE.get())).setWeight(1).setQuality(1).apply(this.countRange(0.0f, 1.0f)).apply(SetSburbCodeFragments.builder()))));
        lootProcessor.accept(MSLootTables.FROG_TEMPLE_CHEST, LootTable.lootTable().withPool(LootPool.lootPool().name("weapons").setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)2.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).setWeight(5).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_SWORD).setWeight(5).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_SWORD).setWeight(3).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.CLAW_HAMMER.get())).setWeight(5).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.SICKLE.get())).setWeight(5).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.KATANA.get())).setWeight(3).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.SLEDGE_HAMMER.get())).setWeight(3).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.WOODEN_SPOON.get())).setWeight(5).setQuality(-2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.SCYTHE.get())).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.KNITTING_NEEDLE.get())).setWeight(4).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.SHURIKEN.get())).setWeight(8).setQuality(-2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.METAL_BAT.get())).setWeight(4).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.MACE.get())).setWeight(1).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.JOUSTING_LANCE.get())).setWeight(2).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.FAN.get())).setWeight(4).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.LUCERNE_HAMMER.get())).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.FORK.get())).setWeight(4).setQuality(-1).apply(this.minorDamageRange()))).withPool(LootPool.lootPool().name("supplies").setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)6.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(2).setQuality(2).apply(this.countRange(2.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).setWeight(1).setQuality(3).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PUMPKIN).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WRITABLE_BOOK).setWeight(2).setQuality(1).apply(this.countRange(0.0f, 1.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.BLANK_DISK.get())).setWeight(2).setQuality(3).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.RAW_CRUXITE.get())).setWeight(4).setQuality(0).apply(this.countRange(1.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.RAW_URANIUM.get())).setWeight(2).setQuality(1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.BUG_ON_A_STICK.get())).setWeight(4).setQuality(-1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.CHOCOLATE_BEETLE.get())).setWeight(4).setQuality(-1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.FOOD_CAN.get())).setWeight(4).setQuality(-1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.GRASSHOPPER.get())).setWeight(4).setQuality(-1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.CONE_OF_FLIES.get())).setWeight(4).setQuality(-1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.GOLDEN_GRASSHOPPER.get())).setWeight(1).setQuality(1).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSBlocks.MINI_FROG_STATUE.get())).setWeight(1).setQuality(1).apply(this.countRange(0.0f, 1.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.CARVING_TOOL.get())).setWeight(5).setQuality(0).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.STONE_TABLET.get())).setWeight(2).setQuality(0).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.HASHMAP_MODUS_CARD.get())).setWeight(1).setQuality(1).apply(this.countRange(0.0f, 1.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.QUEUE_MODUS_CARD.get())).setWeight(1).setQuality(1).apply(this.countRange(0.0f, 1.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.QUEUESTACK_MODUS_CARD.get())).setWeight(1).setQuality(1).apply(this.countRange(0.0f, 1.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.SET_MODUS_CARD.get())).setWeight(1).setQuality(1).apply(this.countRange(0.0f, 1.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.STACK_MODUS_CARD.get())).setWeight(1).setQuality(1).apply(this.countRange(0.0f, 1.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)MSItems.TREE_MODUS_CARD.get())).setWeight(1).setQuality(1).apply(this.countRange(0.0f, 1.0f)))));
        lootProcessor.accept(WEAPON_ITEM_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LandTableLootEntry.builder(WEAPON_ITEM_TABLE).setPool(ITEM_POOL)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BOW).setWeight(5).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_SWORD).setWeight(5).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_SWORD).setWeight(3).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CLAW_HAMMER).setWeight(5).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SICKLE).setWeight(5).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.KATANA).setWeight(3).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.LIPSTICK).setWeight(1).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SLEDGE_HAMMER).setWeight(3).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.WOODEN_SPOON).setWeight(5).setQuality(-2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SCYTHE).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.KNITTING_NEEDLE).setWeight(4).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SHURIKEN).setWeight(8).setQuality(-2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.METAL_BAT).setWeight(4).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.MACE).setWeight(1).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.JOUSTING_LANCE).setWeight(2).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.FAN).setWeight(4).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.LUCERNE_HAMMER).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.FORK).setWeight(4).setQuality(-1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FOREST, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CANE).setWeight(10).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.DEUCE_CLUB).setWeight(10).setQuality(-1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.TAIGA, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CANE).setWeight(10).setQuality(-1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.DEUCE_CLUB).setWeight(10).setQuality(-1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FROST, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FUNGI, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.PARADISES_PORTABELLO).setWeight(3).setQuality(1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.HEAT, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BLACKSMITH_HAMMER).setWeight(2).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BISICKLE).setWeight(2).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.TOO_HOT_TO_HANDLE).setWeight(2).setQuality(1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.ROCK, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.PETRIFICATION, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.SAND, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CACTACEAE_CUTLASS).setWeight(4).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_SWORD).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_AXE).setWeight(1).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.LUSH_DESERTS, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CACTACEAE_CUTLASS).setWeight(4).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_SWORD).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_AXE).setWeight(1).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RED_SAND, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CACTACEAE_CUTLASS).setWeight(4).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_SWORD).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_AXE).setWeight(1).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.SANDSTONE, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RED_SANDSTONE, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.SHADE, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.WOOD, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.POGO_HAMMER).setWeight(3).setQuality(0).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RAINBOW, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHEARS).setWeight(10).setQuality(-1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FLORA, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SICKLE).setWeight(8).setQuality(-1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.END, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_HOE).setWeight(5).setQuality(0).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RAIN, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.FROGS, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.WIND, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.POGO_HAMMER).setWeight(1).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.LIGHT, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.CLOCKWORK, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BISICKLE).setWeight(5).setQuality(0))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.SILENCE, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.NIGHT_CLUB).setWeight(1).setQuality(1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.THUNDER, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.PULSE, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.THOUGHT, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SPEAR_CANE).setWeight(1).setQuality(1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.BUCKETS, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.CAKE, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SILVER_SPOON).setWeight(5).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.FUDGESICKLE).setWeight(2).setQuality(1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.RABBITS, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.MONSTERS, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SPIKED_CLUB).setWeight(2).setQuality(0).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.UNDEAD, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SPIKED_CLUB).setWeight(2).setQuality(0).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.TOWERS, WEAPON_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.IRON_CANE).setWeight(5).setQuality(1).apply(this.minorDamageRange()))));
        lootProcessor.accept(SUPPLY_ITEM_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LandTableLootEntry.builder(SUPPLY_ITEM_TABLE).setPool(ITEM_POOL)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CAPTCHA_CARD).setWeight(20).setQuality(0).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ARROW).setWeight(15).setQuality(0).apply(this.countRange(1.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BREAD).setWeight(20).setQuality(0).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHEAT).setWeight(15).setQuality(0).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.APPLE).setWeight(15).setQuality(0).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.EXPERIENCE_BOTTLE).setWeight(1).setQuality(2).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_APPLE).setWeight(1).setQuality(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ROTTEN_FLESH).setWeight(15).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(12).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.PHLEGM_GUSHERS).setWeight(7).setQuality(1).apply(this.countRange(3.0f, 7.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FOREST, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_AXE).setWeight(10).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_AXE).setWeight(5).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_AXE).setWeight(1).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.TAIGA, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_AXE).setWeight(10).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_AXE).setWeight(5).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_AXE).setWeight(1).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FROST, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FLINT_AND_STEEL).setWeight(10).setQuality(0).apply(this.damageRange(0.0f, 0.25f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).setWeight(8).setQuality(0).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).setWeight(1).setQuality(2).apply(this.countRange(1.0f, 2.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FUNGI, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SPOREO).setWeight(6).setQuality(0).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.MOREL_MUSHROOM).setWeight(1).setQuality(1))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.HEAT, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COAL).setWeight(8).setQuality(0).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLAZE_POWDER).setWeight(5).setQuality(1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLAZE_ROD).setWeight(3).setQuality(1).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LAVA_BUCKET).setWeight(6).setQuality(0))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.ROCK, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_PICKAXE).setWeight(15).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_PICKAXE).setWeight(7).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_PICKAXE).setWeight(1).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.PETRIFICATION, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_PICKAXE).setWeight(15).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_PICKAXE).setWeight(7).setQuality(1).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND_PICKAXE).setWeight(1).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.SAND, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(6).setQuality(1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_PICKAXE).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_SHOVEL).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_HOE).setWeight(2).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.LUSH_DESERTS, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(6).setQuality(1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_PICKAXE).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_SHOVEL).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_HOE).setWeight(2).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RED_SAND, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(6).setQuality(1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_PICKAXE).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_SHOVEL).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLDEN_HOE).setWeight(2).setQuality(2).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.SANDSTONE, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(2).setQuality(2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(5).setQuality(0).apply(this.countRange(1.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_PICKAXE).setWeight(8).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_PICKAXE).setWeight(3).setQuality(1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RED_SANDSTONE, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(2).setQuality(2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(5).setQuality(0).apply(this.countRange(1.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE_PICKAXE).setWeight(8).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_PICKAXE).setWeight(3).setQuality(1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.SHADE, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_MUSHROOM).setWeight(10).setQuality(0).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BROWN_MUSHROOM).setWeight(10).setQuality(0).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MUSHROOM_STEW).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.OIL_BUCKET).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TORCH).setWeight(8).setQuality(0).apply(this.countRange(1.0f, 5.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.WOOD, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_INGOT).setWeight(4).setQuality(2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(5).setQuality(0).apply(this.countRange(1.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_AXE).setWeight(3).setQuality(1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RAINBOW, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_CHESTPLATE).setWeight(2).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_HELMET).setWeight(2).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_LEGGINGS).setWeight(2).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LEATHER_BOOTS).setWeight(2).setQuality(0).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)TagEntry.expandTag(MSTags.Items.FAYGO).setWeight(1).setQuality(0))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FLORA, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHEARS).setWeight(10).setQuality(-1).apply(this.minorDamageRange()))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.END, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ELYTRA).setWeight(1).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL).setWeight(10).setQuality(1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHORUS_FRUIT).setWeight(10).setQuality(-5).apply(this.countRange(1.0f, 4.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RAIN, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.FROGS, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BUG_NET).setWeight(6).setQuality(2).apply(this.minorDamageRange())).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.GRASSHOPPER).setWeight(11).setQuality(-3).apply(this.countRange(2.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.GOLDEN_GRASSHOPPER).setWeight(1).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.WIND, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.LIGHT, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TORCH).setWeight(10).setQuality(-1))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.CLOCKWORK, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CLOCK).setWeight(10).setQuality(0).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COMPASS).setWeight(5).setQuality(0))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.SILENCE, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.THUNDER, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.PULSE, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BEEF).setWeight(8).setQuality(0).apply(this.countRange(1.0f, 3.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.THOUGHT, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BRAIN_JUICE_BUCKET).setWeight(8).setQuality(-1))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.BUCKETS, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL)));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.CAKE, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CAKE).setWeight(8).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.REVERSE_CAKE).setWeight(1).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.APPLE_CAKE).setWeight(7).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.COLD_CAKE).setWeight(5).setQuality(-2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.HOT_CAKE).setWeight(5).setQuality(-2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.BLUE_CAKE).setWeight(3).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.RED_CAKE).setWeight(3).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.NEGATIVE_CAKE).setWeight(2).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.CARROT_CAKE).setWeight(3).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.CHOCOLATEY_CAKE).setWeight(4).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.MOON_CAKE).setWeight(4).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COOKIE).setWeight(5).setQuality(0).apply(this.countRange(2.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CANDY_CORN).setWeight(3).setQuality(0))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.RABBITS, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RABBIT).setWeight(10).setQuality(-1).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COOKED_RABBIT).setWeight(7).setQuality(0).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RABBIT_STEW).setWeight(4).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CARROT).setWeight(12).setQuality(0).apply(this.countRange(1.0f, 5.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.MONSTERS, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL).setWeight(5).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.UNDEAD, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL).setWeight(5).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.TOWERS, SUPPLY_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LADDER).setWeight(10).setQuality(-1).apply(this.countRange(3.0f, 10.0f)))));
        lootProcessor.accept(MISC_ITEM_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LandTableLootEntry.builder(MISC_ITEM_TABLE).setPool(ITEM_POOL)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_INGOT).setWeight(15).setQuality(1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(10).setQuality(1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REDSTONE).setWeight(8).setQuality(1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ENDER_PEARL).setWeight(2).setQuality(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.FLARP_MANUAL).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SASSACRE_TEXT).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.WISEGUY).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.TABLESTUCK_MANUAL).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.TILLDEATH_HANDBOOK).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BINARY_CODE).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.NONBINARY_CODE).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.INK_SQUID_PRO_QUO).setWeight(8).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BARBASOL).setWeight(10).setQuality(0).apply(this.countRange(1.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.GENERIC_OBJECT).setWeight(10).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.RAW_CRUXITE).setWeight(15).setQuality(1).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.RAW_URANIUM).setWeight(12).setQuality(1).apply(this.countRange(1.0f, 4.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FOREST, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_SAPLING).setWeight(5).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_SAPLING).setWeight(5).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_SAPLING).setWeight(5).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.JUNGLE_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ACACIA_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DARK_OAK_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_PLANKS).setWeight(3).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_PLANKS).setWeight(3).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_PLANKS).setWeight(3).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_LEAVES).setWeight(10).setQuality(-2).apply(this.countRange(2.0f, 15.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.TAIGA, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_SAPLING).setWeight(5).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_SAPLING).setWeight(5).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_SAPLING).setWeight(5).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.JUNGLE_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ACACIA_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DARK_OAK_LOG).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_PLANKS).setWeight(3).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_PLANKS).setWeight(3).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BIRCH_PLANKS).setWeight(3).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_LEAVES).setWeight(10).setQuality(-2).apply(this.countRange(2.0f, 15.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FROST, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SNOWBALL).setWeight(20).setQuality(-1).apply(this.countRange(1.0f, 10.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SNOW).setWeight(10).setQuality(-2).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SNOW_BLOCK).setWeight(10).setQuality(-2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SPRUCE_SAPLING).setWeight(15).setQuality(-1))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FUNGI, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BROWN_MUSHROOM).setWeight(8).setQuality(0).apply(this.countRange(2.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_MUSHROOM).setWeight(8).setQuality(0).apply(this.countRange(2.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SLIME_BALL).setWeight(5).setQuality(0).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.FUNGAL_SPORE).setWeight(10).setQuality(0).apply(this.countRange(6.0f, 11.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SUSHROOM).setWeight(1).setQuality(0))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.HEAT, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MAGMA_CREAM).setWeight(5).setQuality(0).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BRICK).setWeight(10).setQuality(-1).apply(this.countRange(1.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHERRACK).setWeight(15).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OBSIDIAN).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.CAST_IRON).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.NATIVE_SULFUR).setWeight(4).setQuality(-1).apply(this.countRange(1.0f, 6.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.CHISELED_CAST_IRON).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 3.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.ROCK, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE).setWeight(10).setQuality(-2).apply(this.countRange(1.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COBBLESTONE).setWeight(15).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GRAVEL).setWeight(10).setQuality(-2).apply(this.countRange(1.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BRICK).setWeight(8).setQuality(-1).apply(this.countRange(1.0f, 6.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BRICKS).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 4.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.PETRIFICATION, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STONE).setWeight(10).setQuality(-2).apply(this.countRange(1.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COBBLESTONE).setWeight(15).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GRAVEL).setWeight(10).setQuality(-2).apply(this.countRange(1.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BRICK).setWeight(8).setQuality(-1).apply(this.countRange(1.0f, 6.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BRICKS).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 4.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.SAND, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SAND).setWeight(15).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_SAND).setWeight(5).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SANDSTONE).setWeight(10).setQuality(-2).apply(this.countRange(2.0f, 12.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SMOOTH_SANDSTONE).setWeight(6).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_SANDSTONE).setWeight(3).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CACTUS).setWeight(12).setQuality(-1).apply(this.countRange(1.0f, 5.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.LUSH_DESERTS, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SAND).setWeight(15).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_SAND).setWeight(5).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SANDSTONE).setWeight(10).setQuality(-2).apply(this.countRange(2.0f, 12.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SMOOTH_SANDSTONE).setWeight(6).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_SANDSTONE).setWeight(3).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CACTUS).setWeight(12).setQuality(-1).apply(this.countRange(1.0f, 5.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RED_SAND, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_SAND).setWeight(15).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SAND).setWeight(5).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_SANDSTONE).setWeight(10).setQuality(-2).apply(this.countRange(2.0f, 12.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SMOOTH_RED_SANDSTONE).setWeight(6).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SANDSTONE).setWeight(3).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CACTUS).setWeight(12).setQuality(-1).apply(this.countRange(1.0f, 5.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.SANDSTONE, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SANDSTONE).setWeight(15).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SMOOTH_SANDSTONE).setWeight(10).setQuality(-2).apply(this.countRange(1.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHISELED_SANDSTONE).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_SANDSTONE).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SAND).setWeight(8).setQuality(-2).apply(this.countRange(1.0f, 5.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RED_SANDSTONE, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_SANDSTONE).setWeight(15).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SMOOTH_RED_SANDSTONE).setWeight(10).setQuality(-2).apply(this.countRange(1.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.CHISELED_RED_SANDSTONE).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SANDSTONE).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_SAND).setWeight(8).setQuality(-2).apply(this.countRange(1.0f, 5.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.SHADE, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.BLUE_DIRT).setWeight(15).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.GLOWING_LOG).setWeight(6).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.GLOWING_MUSHROOM).setWeight(12).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.GLOWING_MUSHROOM_VINES).setWeight(4).setQuality(-1).apply(this.countRange(1.0f, 3.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.WOOD, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DARK_OAK_PLANKS).setWeight(5).setQuality(-2).apply(this.countRange(1.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.JUNGLE_PLANKS).setWeight(8).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_PLANKS).setWeight(8).setQuality(-2).apply(this.countRange(2.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DARK_OAK_LOG).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.JUNGLE_LOG).setWeight(5).setQuality(-2).apply(this.countRange(1.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_LOG).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DARK_OAK_SAPLING).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.JUNGLE_SAPLING).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OAK_SAPLING).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.GLOWING_LOG).setWeight(4).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COCOA_BEANS).setWeight(3).setQuality(0))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RAINBOW, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)TagEntry.expandTag((TagKey)Tags.Items.DYES).setWeight(1).setQuality(-3).apply(this.countRange(1.0f, 8.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHITE_WOOL).setWeight(3).setQuality(-1).apply(this.countRange(8.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLASS).setWeight(3).setQuality(-1).apply(this.countRange(8.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.TERRACOTTA).setWeight(2).setQuality(1).apply(this.countRange(8.0f, 16.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.FLORA, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DANDELION).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.POPPY).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BLUE_ORCHID).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ALLIUM).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.AZURE_BLUET).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RED_TULIP).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ORANGE_TULIP).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WHITE_TULIP).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PINK_TULIP).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.OXEYE_DAISY).setWeight(3).setQuality(-1).apply(this.countRange(1.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SUNFLOWER).setWeight(6).setQuality(-2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LILAC).setWeight(6).setQuality(-2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ROSE_BUSH).setWeight(6).setQuality(-2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PEONY).setWeight(6).setQuality(-2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.FERN).setWeight(11).setQuality(-2).apply(this.countRange(1.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.FLOWERY_MOSSY_COBBLESTONE).setWeight(9).setQuality(0).apply(this.countRange(8.0f, 24.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MOSSY_COBBLESTONE).setWeight(9).setQuality(0).apply(this.countRange(8.0f, 24.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.END, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DRAGON_BREATH).setWeight(1).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SHULKER_SHELL).setWeight(1).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.END_STONE).setWeight(8).setQuality(-1).apply(this.countRange(1.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.END_ROD).setWeight(5).setQuality(0).apply(this.countRange(1.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.END_GRASS).setWeight(5).setQuality(-1).apply(this.countRange(1.0f, 16.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.COARSE_END_STONE).setWeight(8).setQuality(-1).apply(this.countRange(1.0f, 6.0f)))));
        lootProcessor.accept(MSChestLootTables.locationForTerrain(LandTypes.RAIN, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BEACON).setWeight(1).setQuality(-2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.FROGS, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LILY_PAD).setWeight(9).setQuality(-2).apply(this.countRange(1.0f, 9.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.MINI_FROG_STATUE).setWeight(5).setQuality(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.THRESH_DVD).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.WIND, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CREW_POSTER).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.LIGHT, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLOWSTONE).setWeight(8).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.DICE).setWeight(8).setQuality(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GLOWSTONE_DUST).setWeight(12).setQuality(-1).apply(this.countRange(2.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SBAHJ_POSTER).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.CLOCKWORK, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REPEATER).setWeight(4).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SBAHJ_POSTER).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.SILENCE, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.PUMPKIN).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CREW_POSTER).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.THUNDER, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CREW_POSTER).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.PULSE, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.REPEATER).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.RAZOR_BLADE).setWeight(4).setQuality(-1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.THRESH_DVD).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.THOUGHT, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.THOUGHT_DIRT).setWeight(15).setQuality(-1).apply(this.countRange(2.0f, 10.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SBAHJ_POSTER).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.BUCKETS, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BUCKET).setWeight(10).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.WATER_BUCKET).setWeight(8).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.LAVA_BUCKET).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.OIL_BUCKET).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BLOOD_BUCKET).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BRAIN_JUICE_BUCKET).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.WATER_COLORS_BUCKET).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.ENDER_BUCKET).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.OBSIDIAN_BUCKET).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.THRESH_DVD).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.CAKE, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.SUGAR).setWeight(8).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.MILK_BUCKET).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.COCOA_BEANS).setWeight(3).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.THRESH_DVD).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.RABBITS, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RABBIT_HIDE).setWeight(8).setQuality(0).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.RABBIT_FOOT).setWeight(2).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.GOLD_SEEDS).setWeight(3).setQuality(0).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SBAHJ_POSTER).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.MONSTERS, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ROTTEN_FLESH).setWeight(15).setQuality(-2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(12).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GUNPOWDER).setWeight(8).setQuality(0).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STRING).setWeight(10).setQuality(0).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CREW_POSTER).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.UNDEAD, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.ROTTEN_FLESH).setWeight(15).setQuality(-2).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BONE).setWeight(12).setQuality(-1).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GUNPOWDER).setWeight(8).setQuality(0).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.STRING).setWeight(10).setQuality(0).apply(this.countRange(1.0f, 3.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CREW_POSTER).setWeight(4).setQuality(2))));
        lootProcessor.accept(MSChestLootTables.locationForTitle(LandTypes.TOWERS, MISC_ITEM_TABLE), LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.THRESH_DVD).setWeight(4).setQuality(2))));
        lootProcessor.accept(RARE_ITEM_TABLE, LootTable.lootTable().withPool(LootPool.lootPool().name(ITEM_POOL).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.IRON_INGOT).setWeight(20).setQuality(1).apply(this.countRange(0.0f, 5.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.GOLD_INGOT).setWeight(15).setQuality(1).apply(this.countRange(0.0f, 4.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.DIAMOND).setWeight(15).setQuality(2).apply(this.countRange(0.0f, 2.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.GRIMOIRE).setWeight(3).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.MINI_WIZARD_STATUE).setWeight(5).setQuality(1)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.CASSETTE_PLAYER).setWeight(1).setQuality(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.SENDIFICATOR).setWeight(1).setQuality(3)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.TRANSPORTALIZER).setWeight(2).setQuality(2)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.DICE).setWeight(5).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CUEBALL).setWeight(1).setQuality(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CRYPTID_PHOTO).setWeight(1).setQuality(4)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.COMPUTER).setWeight(1).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.LAPTOP).setWeight(1).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSBlocks.CHESSBOARD).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.CIGARETTE_LANCE).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.ACE_OF_CLUBS).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.ACE_OF_DIAMONDS).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.ACE_OF_HEARTS).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.ACE_OF_SPADES).setWeight(2).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.ENERGY_CORE).setWeight(10).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.GUTTER_BALL).setWeight(1).setQuality(0)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.PLUSH_MUTATED_CAT).setWeight(2).setQuality(1))));
        lootProcessor.accept(MSLootTables.BASIC_MEDIUM_CHEST, LootTable.lootTable().withPool(LootPool.lootPool().name("weapons").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(WEAPON_ITEM_TABLE))).withPool(LootPool.lootPool().name("supplies").setRolls((NumberProvider)ConstantValue.exactly((float)3.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(SUPPLY_ITEM_TABLE))).withPool(LootPool.lootPool().name("misc").setRolls((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(MISC_ITEM_TABLE))).withPool(LootPool.lootPool().name("rare").setRolls((NumberProvider)UniformGenerator.between((float)0.0f, (float)1.0f)).add((LootPoolEntryContainer.Builder)NestedLootTable.lootTableReference(RARE_ITEM_TABLE))).withPool(LootPool.lootPool().name("boondollars").setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.SORROW_GUSHERS).setWeight(7).setQuality(-1).apply(this.countRange(3.0f, 7.0f))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BOONDOLLARS).setWeight(10).setQuality(-1).apply(SetBoondollarCount.builder((NumberProvider)UniformGenerator.between((float)5.0f, (float)50.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BOONDOLLARS).setWeight(5).setQuality(0).apply(SetBoondollarCount.builder((NumberProvider)UniformGenerator.between((float)50.0f, (float)250.0f)))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem(MSItems.BOONDOLLARS).setWeight(2).setQuality(0).apply(SetBoondollarCount.builder((NumberProvider)UniformGenerator.between((float)250.0f, (float)1000.0f))))));
    }

    public static ResourceKey<LootTable> locationForTerrain(Supplier<TerrainLandType> landType, ResourceKey<LootTable> baseLoot) {
        ResourceLocation landName = Objects.requireNonNull(LandTypes.TERRAIN_REGISTRY.getKey((Object)landType.get()));
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)baseLoot.location().withSuffix("/terrain/" + landName.getNamespace() + "/" + landName.getPath()));
    }

    public static ResourceKey<LootTable> locationForTitle(Supplier<TitleLandType> landType, ResourceKey<LootTable> baseLoot) {
        ResourceLocation landName = Objects.requireNonNull(LandTypes.TITLE_REGISTRY.getKey((Object)landType.get()));
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)baseLoot.location().withSuffix("/title/" + landName.getNamespace() + "/" + landName.getPath()));
    }

    public LootItemFunction.Builder minorDamageRange() {
        return this.damageRange(0.75f, 1.0f);
    }

    public LootItemFunction.Builder damageRange(float min, float max) {
        return SetItemDamageFunction.setDamage((NumberProvider)UniformGenerator.between((float)min, (float)max));
    }

    public LootItemFunction.Builder countRange(float min, float max) {
        return SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)min, (float)max));
    }
}

