/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.recipe;

import com.mraof.minestuck.data.recipe.MinestuckRecipeProvider;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public final class CommonRecipes {
    public static RecipeBuilder stairsRecipe(ItemLike stairsBlock, ItemLike sourceBlock) {
        return CommonRecipes.stairsRecipe(stairsBlock, sourceBlock, "has_" + CommonRecipes.id(sourceBlock).getPath());
    }

    public static RecipeBuilder stairsRecipe(ItemLike stairsBlock, ItemLike sourceBlock, String criterionName) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)stairsBlock, (int)4).define(Character.valueOf('#'), sourceBlock).pattern("#  ").pattern("## ").pattern("###").unlockedBy(criterionName, MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder slabRecipe(ItemLike slabBlock, ItemLike sourceBlock) {
        return CommonRecipes.slabRecipe(slabBlock, sourceBlock, "has_" + CommonRecipes.id(sourceBlock).getPath());
    }

    public static RecipeBuilder slabRecipe(ItemLike slabBlock, ItemLike sourceBlock, String criterionName) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)slabBlock, (int)6).define(Character.valueOf('#'), sourceBlock).pattern("###").unlockedBy(criterionName, MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder wallRecipe(ItemLike wallBlock, ItemLike sourceBlock) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)wallBlock, (int)6).define(Character.valueOf('#'), sourceBlock).pattern("###").pattern("###").unlockedBy("has_" + CommonRecipes.id(sourceBlock).getPath(), MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder pressurePlateRecipe(ItemLike pressurePlateBlock, ItemLike sourceBlock) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)pressurePlateBlock).define(Character.valueOf('#'), sourceBlock).pattern("##").unlockedBy("has_" + CommonRecipes.id(sourceBlock).getPath(), MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder buttonRecipe(ItemLike buttonBlock, ItemLike sourceBlock) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)buttonBlock).requires(sourceBlock).unlockedBy("has_" + CommonRecipes.id(sourceBlock).getPath(), MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder planksRecipe(ItemLike planksBlock, ItemLike sourceBlock) {
        return ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)planksBlock, (int)4).requires(sourceBlock).unlockedBy("has_" + CommonRecipes.id(sourceBlock).getPath(), MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder woodRecipe(ItemLike woodBlock, ItemLike sourceBlock) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)woodBlock, (int)3).define(Character.valueOf('#'), sourceBlock).pattern("##").pattern("##").group("bark").unlockedBy("has_" + CommonRecipes.id(sourceBlock).getPath(), MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder bookshelfRecipe(ItemLike bookshelfBlock, ItemLike sourceBlock, ItemLike sourceBlockSlab) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)bookshelfBlock).define(Character.valueOf('b'), (ItemLike)Items.BOOK).define(Character.valueOf('p'), sourceBlock).define(Character.valueOf('s'), sourceBlockSlab).pattern("psp").pattern("bbb").pattern("psp").unlockedBy("has_" + CommonRecipes.id(sourceBlock).getPath(), MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder ladderRecipe(ItemLike ladderBlock, ItemLike sourceBlock) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)ladderBlock, (int)4).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('p'), sourceBlock).pattern("s s").pattern("sps").pattern("s s").unlockedBy("has_" + CommonRecipes.id(sourceBlock).getPath(), MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder signRecipe(ItemLike signBlock, ItemLike sourceBlock) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)signBlock, (int)3).define(Character.valueOf('s'), (ItemLike)Items.STICK).define(Character.valueOf('p'), sourceBlock).pattern("ppp").pattern("ppp").pattern(" s ").unlockedBy("has_" + CommonRecipes.id(sourceBlock).getPath(), MinestuckRecipeProvider.has(sourceBlock));
    }

    public static RecipeBuilder hangingSignRecipe(ItemLike hangingSignBlock, ItemLike sourceBlock) {
        return ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)hangingSignBlock, (int)6).define(Character.valueOf('c'), (ItemLike)Items.CHAIN).define(Character.valueOf('w'), sourceBlock).pattern("c c").pattern("www").pattern("www").unlockedBy("has_" + CommonRecipes.id(sourceBlock).getPath(), MinestuckRecipeProvider.has(sourceBlock));
    }

    private static ResourceLocation id(ItemLike item) {
        return Objects.requireNonNull(BuiltInRegistries.ITEM.getKey((Object)item.asItem()));
    }
}

