/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.recipe;

import com.mraof.minestuck.api.alchemy.recipe.combination.CombinationRecipeBuilder;
import com.mraof.minestuck.block.BlockCollections;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.block.SkaiaBlocks;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.util.MSTags;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.Tags;

public final class MinestuckCombinationsProvider {
    public static void buildRecipes(RecipeOutput consumer) {
        Object combination;
        int n;
        int n2;
        ItemLike[][] woodItems = new ItemLike[][]{{Blocks.OAK_LOG, Blocks.SPRUCE_LOG, Blocks.BIRCH_LOG, Blocks.JUNGLE_LOG, Blocks.ACACIA_LOG, Blocks.DARK_OAK_LOG, Blocks.MANGROVE_LOG, Blocks.CHERRY_LOG}, {Blocks.OAK_PLANKS, Blocks.SPRUCE_PLANKS, Blocks.BIRCH_PLANKS, Blocks.JUNGLE_PLANKS, Blocks.ACACIA_PLANKS, Blocks.DARK_OAK_PLANKS, Blocks.MANGROVE_PLANKS, Blocks.CHERRY_PLANKS}, {Blocks.OAK_SLAB, Blocks.SPRUCE_SLAB, Blocks.BIRCH_SLAB, Blocks.JUNGLE_SLAB, Blocks.ACACIA_SLAB, Blocks.DARK_OAK_SLAB, Blocks.MANGROVE_SLAB, Blocks.CHERRY_SLAB}, {Blocks.OAK_STAIRS, Blocks.SPRUCE_STAIRS, Blocks.BIRCH_STAIRS, Blocks.JUNGLE_STAIRS, Blocks.ACACIA_STAIRS, Blocks.DARK_OAK_STAIRS, Blocks.MANGROVE_STAIRS, Blocks.CHERRY_STAIRS}, {Blocks.OAK_SAPLING, Blocks.SPRUCE_SAPLING, Blocks.BIRCH_SAPLING, Blocks.JUNGLE_SAPLING, Blocks.ACACIA_SAPLING, Blocks.DARK_OAK_SAPLING, Blocks.MANGROVE_PROPAGULE, Blocks.CHERRY_SAPLING}, {Blocks.OAK_LEAVES, Blocks.SPRUCE_LEAVES, Blocks.BIRCH_LEAVES, Blocks.JUNGLE_LEAVES, Blocks.ACACIA_LEAVES, Blocks.DARK_OAK_LEAVES, Blocks.MANGROVE_LEAVES, Blocks.CHERRY_LEAVES}, {Blocks.OAK_DOOR, Blocks.SPRUCE_DOOR, Blocks.BIRCH_DOOR, Blocks.JUNGLE_DOOR, Blocks.ACACIA_DOOR, Blocks.DARK_OAK_DOOR, Blocks.MANGROVE_DOOR, Blocks.CHERRY_DOOR}, {Blocks.OAK_FENCE, Blocks.SPRUCE_FENCE, Blocks.BIRCH_FENCE, Blocks.JUNGLE_FENCE, Blocks.ACACIA_FENCE, Blocks.DARK_OAK_FENCE, Blocks.MANGROVE_FENCE, Blocks.CHERRY_FENCE}, {Blocks.OAK_FENCE_GATE, Blocks.SPRUCE_FENCE_GATE, Blocks.BIRCH_FENCE_GATE, Blocks.JUNGLE_FENCE_GATE, Blocks.ACACIA_FENCE_GATE, Blocks.DARK_OAK_FENCE_GATE, Blocks.MANGROVE_FENCE_GATE, Blocks.CHERRY_FENCE_GATE}, {Blocks.OAK_TRAPDOOR, Blocks.SPRUCE_TRAPDOOR, Blocks.BIRCH_TRAPDOOR, Blocks.JUNGLE_TRAPDOOR, Blocks.ACACIA_TRAPDOOR, Blocks.DARK_OAK_TRAPDOOR, Blocks.MANGROVE_TRAPDOOR, Blocks.CHERRY_TRAPDOOR}};
        int[][] woodCombinations = new int[][]{{0, 1, 5}, {2, 3, 4}};
        int[][] itemCombinations = new int[][]{{1, 2, 3}, {0, 5, 4}, {6, 7, 8}, {6, 2, 9}};
        for (ItemLike[] itemType : woodItems) {
            int[][] nArrayArray = woodCombinations;
            n2 = nArrayArray.length;
            for (n = 0; n < n2; ++n) {
                int[] combination2 = nArrayArray[n];
                CombinationRecipeBuilder.of(itemType[combination2[2]]).input(itemType[combination2[0]]).or().input(itemType[combination2[1]]).namedSource("wood_combination").buildFor(consumer, "minestuck");
            }
        }
        for (int woodType = 0; woodType < woodItems[0].length; ++woodType) {
            int[][] nArrayArray = itemCombinations;
            int n3 = nArrayArray.length;
            for (int itemType = 0; itemType < n3; ++itemType) {
                combination = nArrayArray[itemType];
                CombinationRecipeBuilder.of(woodItems[combination[2]][woodType]).input(woodItems[combination[0]][woodType]).or().input(woodItems[combination[1]][woodType]).namedSource("item_combination").buildFor(consumer, "minestuck");
            }
            CombinationRecipeBuilder.of(woodItems[4][woodType]).namedInput((ItemLike)Items.WHEAT_SEEDS).and().input(woodItems[5][woodType]).buildFor(consumer, "minestuck");
            CombinationRecipeBuilder.of(woodItems[4][woodType]).namedInput((ItemLike)Items.STICK).and().input(woodItems[5][woodType]).buildFor(consumer, "minestuck");
        }
        for (int[] wood : woodCombinations) {
            combination = itemCombinations;
            n2 = ((int[])combination).length;
            for (n = 0; n < n2; ++n) {
                int item = combination[n];
                CombinationRecipeBuilder.of(woodItems[item[2]][wood[2]]).namedInput(woodItems[item[0]][wood[0]]).or().namedInput(woodItems[item[1]][wood[1]]).buildFor(consumer, "minestuck");
                CombinationRecipeBuilder.of(woodItems[item[2]][wood[2]]).namedInput(woodItems[item[0]][wood[1]]).or().namedInput(woodItems[item[1]][wood[0]]).buildFor(consumer, "minestuck");
            }
        }
        List<Function> coloredBlocks = Arrays.asList(BlockCollections::coloredWool, BlockCollections::coloredTerracotta, BlockCollections::coloredGlass, BlockCollections::coloredGlassPane);
        for (Function blockProvider : coloredBlocks) {
            for (DyeColor color : DyeColor.values()) {
                if (color == DyeColor.WHITE) continue;
                CombinationRecipeBuilder.of((ItemLike)blockProvider.apply(color)).input((TagKey<Item>)color.getTag()).or().namedInput((ItemLike)blockProvider.apply(DyeColor.WHITE)).buildFor(consumer, "minestuck");
            }
        }
        for (DyeColor color : DyeColor.values()) {
            CombinationRecipeBuilder.of((ItemLike)BlockCollections.coloredGlass(color)).namedInput((ItemLike)Items.GLASS).and().input((TagKey<Item>)color.getTag()).buildFor(consumer, "minestuck");
            CombinationRecipeBuilder.of((ItemLike)BlockCollections.coloredGlassPane(color)).namedInput((ItemLike)Items.GLASS_PANE).and().input((TagKey<Item>)color.getTag()).buildFor(consumer, "minestuck");
            CombinationRecipeBuilder.of((ItemLike)BlockCollections.coloredTerracotta(color)).namedInput((ItemLike)Items.TERRACOTTA).and().input((TagKey<Item>)color.getTag()).buildFor(consumer, "minestuck");
            CombinationRecipeBuilder.of((ItemLike)BlockCollections.coloredConcrete(color)).namedInput((ItemLike)BlockCollections.coloredConcretePowder(color)).or().input((ItemLike)Items.WATER_BUCKET).buildFor(consumer, "minestuck");
            if (color == DyeColor.LIGHT_GRAY) continue;
            CombinationRecipeBuilder.of((ItemLike)BlockCollections.coloredConcretePowder(color)).input((TagKey<Item>)color.getTag()).or().namedInput((ItemLike)BlockCollections.coloredConcretePowder(DyeColor.LIGHT_GRAY)).buildFor(consumer, "minestuck");
        }
        CombinationRecipeBuilder.of((ItemLike)Items.COAL_BLOCK).input((ItemLike)Items.COAL).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DIAMOND_BLOCK).input((ItemLike)Items.DIAMOND).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.LAPIS_BLOCK).input((ItemLike)Items.LAPIS_LAZULI).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.EMERALD_BLOCK).input((ItemLike)Items.EMERALD).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COPPER_BLOCK).input((ItemLike)Items.COPPER_INGOT).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GOLD_BLOCK).input((ItemLike)Items.GOLD_INGOT).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.IRON_BLOCK).input((ItemLike)Items.IRON_INGOT).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.QUARTZ_BLOCK).input((ItemLike)Items.QUARTZ).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE_BLOCK).input((ItemLike)Items.REDSTONE).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHERITE_BLOCK).input((ItemLike)Items.NETHERITE_INGOT).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CUT_COPPER_STAIRS).input((ItemLike)Items.COPPER_INGOT).or().input((ItemLike)Items.STONE_BRICK_STAIRS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CUT_COPPER_SLAB).input((ItemLike)Items.COPPER_INGOT).or().input((ItemLike)Items.STONE_BRICK_SLAB).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CUT_COPPER).input((ItemLike)Items.COPPER_INGOT).or().input((ItemLike)Items.STONE_BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RAW_GOLD_BLOCK).input((ItemLike)Items.RAW_GOLD).and().namedInput((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RAW_IRON_BLOCK).input((ItemLike)Items.RAW_IRON).and().namedInput((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RAW_COPPER_BLOCK).input((ItemLike)Items.RAW_COPPER).and().namedInput((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COAL_ORE).input((ItemLike)Items.COAL).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DIAMOND_ORE).input((ItemLike)Items.DIAMOND).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.LAPIS_ORE).input((ItemLike)Items.LAPIS_LAZULI).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.EMERALD_ORE).input((ItemLike)Items.EMERALD).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COPPER_ORE).input((ItemLike)Items.COPPER_INGOT).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GOLD_ORE).input((ItemLike)Items.GOLD_INGOT).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.IRON_ORE).input((ItemLike)Items.IRON_INGOT).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_QUARTZ_ORE).input((ItemLike)Items.QUARTZ).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE_ORE).input((ItemLike)Items.REDSTONE).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RAW_COPPER).input((ItemLike)Items.RAW_IRON).and().namedInput((ItemLike)Items.ORANGE_DYE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RAW_GOLD).input((ItemLike)Items.PORKCHOP).and().namedInput((ItemLike)Items.LIGHTNING_ROD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RAW_IRON).input((ItemLike)Items.STONE).or().namedInput((ItemLike)Items.GRAY_DYE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DIAMOND).input((ItemLike)Items.EMERALD).and().namedInput((ItemLike)Items.COAL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DIAMOND).input((ItemLike)Items.EMERALD).and().namedInput((ItemLike)Items.LAPIS_LAZULI).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CHARCOAL).input((TagKey<Item>)ItemTags.LOGS).and().input((ItemLike)Items.COAL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.STONE_BRICKS).input((ItemLike)Items.STONE).and().input((ItemLike)Items.CRACKED_STONE_BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CRACKED_STONE_BRICKS).input((ItemLike)Items.COBBLESTONE).and().input((ItemLike)Items.STONE_BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COBBLESTONE).input((ItemLike)Items.STONE).or().namedInput((ItemLike)Items.CRACKED_STONE_BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COBBLESTONE).input((ItemLike)Items.STONE).or().namedInput((ItemLike)Items.GRAVEL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GRAVEL).input((TagKey<Item>)ItemTags.SAND).and().input((ItemLike)Items.COBBLESTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.STONE).input((ItemLike)Items.COBBLESTONE).and().namedInput((ItemLike)Items.CUT_SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SANDSTONE).namedInput((ItemLike)Items.COBBLESTONE).or().namedInput((ItemLike)Items.CUT_SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SANDSTONE).namedInput((ItemLike)Items.STONE).or().namedInput((ItemLike)Items.SAND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SANDSTONE).namedInput((ItemLike)Items.COBBLESTONE).or().namedInput((ItemLike)Items.SAND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SANDSTONE).namedInput((ItemLike)Items.GRAVEL).or().namedInput((ItemLike)Items.CUT_SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SANDSTONE).namedInput((ItemLike)Items.CUT_SANDSTONE).or().namedInput((ItemLike)Items.SAND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.STONE).input((ItemLike)Items.COBBLESTONE).and().namedInput((ItemLike)Items.CUT_RED_SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RED_SANDSTONE).namedInput((ItemLike)Items.COBBLESTONE).or().namedInput((ItemLike)Items.CUT_RED_SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RED_SANDSTONE).namedInput((ItemLike)Items.COBBLESTONE).or().namedInput((ItemLike)Items.RED_SAND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RED_SANDSTONE).namedInput((ItemLike)Items.GRAVEL).or().namedInput((ItemLike)Items.CUT_RED_SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RED_SANDSTONE).namedInput((ItemLike)Items.CUT_RED_SANDSTONE).or().namedInput((ItemLike)Items.RED_SAND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SANDSTONE_STAIRS).input((ItemLike)Items.SAND).or().input((ItemLike)Items.STONE_BRICK_STAIRS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RED_SANDSTONE_STAIRS).input((ItemLike)Items.RED_SAND).or().input((ItemLike)Items.STONE_BRICK_STAIRS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RED_SAND).input((ItemLike)Items.SAND).and().input((ItemLike)Items.RED_DYE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RED_SANDSTONE).input((ItemLike)Items.SANDSTONE).and().input((ItemLike)Items.RED_DYE).namedSource("dye").buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CUT_RED_SANDSTONE).input((ItemLike)Items.CUT_SANDSTONE).and().input((ItemLike)Items.RED_DYE).namedSource("dye").buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CHISELED_RED_SANDSTONE).input((ItemLike)Items.CHISELED_SANDSTONE).and().input((ItemLike)Items.RED_DYE).namedSource("dye").buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SMOOTH_RED_SANDSTONE).input((ItemLike)Items.SMOOTH_SANDSTONE).and().input((ItemLike)Items.RED_DYE).namedSource("dye").buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RED_SANDSTONE_STAIRS).input((ItemLike)Items.SANDSTONE_STAIRS).and().input((ItemLike)Items.RED_DYE).namedSource("dye").buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.LIGHT_GRAY_CONCRETE_POWDER).input((ItemLike)Items.GRAVEL).or().input((ItemLike)Items.SAND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MOSSY_COBBLESTONE).input((ItemLike)Items.COBBLESTONE).or().input((ItemLike)Items.WHEAT_SEEDS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MOSSY_COBBLESTONE_WALL).input((ItemLike)Items.COBBLESTONE_WALL).or().namedInput((ItemLike)Items.WHEAT_SEEDS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MOSSY_COBBLESTONE_WALL).input((ItemLike)Items.COBBLESTONE_WALL).or().namedInput((ItemLike)Items.MOSSY_COBBLESTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MOSSY_STONE_BRICKS).input((ItemLike)Items.STONE_BRICKS).or().input((ItemLike)Items.WHEAT_SEEDS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CLAY).input((ItemLike)Items.SAND).and().input((ItemLike)Items.WATER_BUCKET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.AMETHYST_CLUSTER).input((ItemLike)Items.POINTED_DRIPSTONE).or().input((ItemLike)Items.AMETHYST_SHARD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CALCITE).input((ItemLike)Items.AMETHYST_SHARD).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CANDLE).input((ItemLike)Items.BOOK).and().input((ItemLike)Items.TORCH).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COBBLED_DEEPSLATE).input((ItemLike)Items.COBBLESTONE).and().input((ItemLike)Items.CHARCOAL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEEPSLATE).input((ItemLike)Items.STONE).or().input((ItemLike)Items.INK_SAC).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POINTED_DRIPSTONE).input((ItemLike)Items.DRIPSTONE_BLOCK).or().input((ItemLike)Items.ARROW).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.LIGHTNING_ROD).input((ItemLike)Items.REDSTONE).and().input((ItemLike)Items.COPPER_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DRIPSTONE_BLOCK).input((ItemLike)Items.STONE).and().input((ItemLike)Items.BIG_DRIPLEAF).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POWDER_SNOW_BUCKET).input((ItemLike)Items.ANVIL).or().input((ItemLike)Items.ICE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SMOOTH_BASALT).input((ItemLike)Items.HONEYCOMB).or().input((ItemLike)Items.BASALT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.TINTED_GLASS).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.FERMENTED_SPIDER_EYE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.TUFF).input((ItemLike)Items.FLINT_AND_STEEL).or().input((ItemLike)Items.BIRCH_WOOD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COBBLED_DEEPSLATE_SLAB).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.COBBLESTONE_SLAB).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COBBLED_DEEPSLATE_STAIRS).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.COBBLESTONE_STAIRS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COBBLED_DEEPSLATE_WALL).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.COBBLESTONE_WALL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CHISELED_DEEPSLATE).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.CHISELED_SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POLISHED_DEEPSLATE).input((ItemLike)Items.HONEYCOMB).or().input((ItemLike)Items.DEEPSLATE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POLISHED_DEEPSLATE_WALL).input((ItemLike)Items.HONEYCOMB).or().input((ItemLike)Items.DEEPSLATE_TILE_WALL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POLISHED_DEEPSLATE_SLAB).input((ItemLike)Items.HONEYCOMB).or().input((ItemLike)Items.DEEPSLATE_TILE_SLAB).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POLISHED_DEEPSLATE_STAIRS).input((ItemLike)Items.HONEYCOMB).or().input((ItemLike)Items.DEEPSLATE_TILE_STAIRS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEEPSLATE_BRICKS).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEEPSLATE_BRICK_SLAB).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.BRICK_SLAB).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEEPSLATE_BRICK_STAIRS).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.BRICK_STAIRS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEEPSLATE_BRICK_WALL).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.BRICK_WALL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CRACKED_DEEPSLATE_BRICKS).input((ItemLike)Items.TNT).or().input((ItemLike)Items.DEEPSLATE_BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEEPSLATE_TILE_SLAB).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.NETHER_BRICK_SLAB).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEEPSLATE_TILE_STAIRS).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.NETHER_BRICK_STAIRS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEEPSLATE_TILE_WALL).input((ItemLike)Items.INK_SAC).or().input((ItemLike)Items.NETHER_BRICK_WALL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CRACKED_DEEPSLATE_TILES).input((ItemLike)Items.TNT).or().input((ItemLike)Items.DEEPSLATE_TILES).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GLOW_ITEM_FRAME).input((ItemLike)Items.GOLDEN_CARROT).or().input((ItemLike)Items.ITEM_FRAME).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.AMETHYST_BLOCK).input((ItemLike)Items.GLASS).or().input((ItemLike)Items.PURPLE_DYE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.FURNACE).input((ItemLike)Items.COBBLESTONE).and().input((ItemLike)Items.COAL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.JUKEBOX).input((ItemLike)Items.NOTE_BLOCK).and().namedInput((ItemLike)Items.DIAMOND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.JUKEBOX).input((ItemLike)Items.NOTE_BLOCK).and().namedInput((TagKey<Item>)Tags.Items.MUSIC_DISCS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.TNT).input((TagKey<Item>)ItemTags.SAND).and().input((ItemLike)Items.GUNPOWDER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.IRON_TRAPDOOR).input((TagKey<Item>)ItemTags.WOODEN_TRAPDOORS).or().namedInput((ItemLike)Items.IRON_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.IRON_TRAPDOOR).input((TagKey<Item>)ItemTags.WOODEN_TRAPDOORS).or().namedInput((ItemLike)Items.IRON_BLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DROPPER).input((ItemLike)Items.DISPENSER).and().input((ItemLike)Items.HOPPER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ENDER_CHEST).input((ItemLike)Items.ENDER_PEARL).and().input((ItemLike)Items.CHEST).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BOOKSHELF).input((ItemLike)Items.BOOK).or().namedInput((TagKey<Item>)ItemTags.PLANKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BOOKSHELF).input((ItemLike)Items.BOOK).and().namedInput((ItemLike)Items.CHEST).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ENCHANTING_TABLE).input((ItemLike)Items.BOOK).and().input((ItemLike)Items.EXPERIENCE_BOTTLE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ANVIL).input((ItemLike)Items.CRAFTING_TABLE).or().input((ItemLike)Items.IRON_BLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.IRON_DOOR).input((TagKey<Item>)ItemTags.WOODEN_DOORS).and().input((ItemLike)Items.IRON_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COMPASS).namedInput((ItemLike)Items.CLOCK).or().input((ItemLike)Items.IRON_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COMPASS).namedInput((ItemLike)Items.REDSTONE).or().input((ItemLike)Items.IRON_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CLOCK).namedInput((ItemLike)Items.COMPASS).and().input((ItemLike)Items.GOLD_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CLOCK).namedInput((ItemLike)Items.REDSTONE).and().input((ItemLike)Items.GOLD_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BELL).namedInput((ItemLike)MSItems.HORN).and().input((ItemLike)Items.CLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GLOWSTONE_DUST).input((ItemLike)Items.TORCH).or().input((ItemLike)Items.REDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.WRITABLE_BOOK).input((ItemLike)Items.BOOK).or().input((TagKey<Item>)ItemTags.SIGNS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NAME_TAG).input((TagKey<Item>)ItemTags.SIGNS).and().input((ItemLike)Items.LEAD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BOOK).input((ItemLike)Items.INK_SAC).and().input((ItemLike)Items.PAPER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CARTOGRAPHY_TABLE).input((ItemLike)Items.CRAFTING_TABLE).or().input((ItemLike)Items.MAP).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.COBWEB).input((ItemLike)Items.SLIME_BLOCK).or().input((ItemLike)Items.STRING).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.TORCH).input((ItemLike)Items.REDSTONE_TORCH).or().input((TagKey<Item>)ItemTags.COALS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.AMETHYST_SHARD).input((ItemLike)Items.COAL).or().input((ItemLike)Items.PISTON).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GLOW_INK_SAC).input((ItemLike)Items.LEATHER).or().input((ItemLike)Items.GLOWSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PEARLESCENT_FROGLIGHT).input((ItemLike)Items.MAGMA_CREAM).or().input((ItemLike)Items.SAND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.VERDANT_FROGLIGHT).input((ItemLike)Items.MAGMA_CREAM).or().input((ItemLike)Items.SNOW_BLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.OCHRE_FROGLIGHT).input((ItemLike)Items.MAGMA_CREAM).or().input((ItemLike)Items.GRASS_BLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ECHO_SHARD).input((ItemLike)Items.SCULK).or().input((ItemLike)Items.DIAMOND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GRASS_BLOCK).input((ItemLike)Items.DIRT).and().namedInput((ItemLike)Items.SHORT_GRASS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GRASS_BLOCK).input((ItemLike)Items.DIRT).and().namedInput((ItemLike)Items.WHEAT_SEEDS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MUD).input((ItemLike)Items.DIRT).and().namedInput((ItemLike)Items.WATER_BUCKET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MYCELIUM).input((ItemLike)Items.GRASS_BLOCK).and().input((TagKey<Item>)Tags.Items.MUSHROOMS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CACTUS).input((ItemLike)Items.SAND).and().input((ItemLike)Items.SHORT_GRASS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEAD_BUSH).input((ItemLike)Items.SAND).or().namedInput((ItemLike)Items.SHORT_GRASS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DEAD_BUSH).input((ItemLike)Items.SAND).or().namedInput((TagKey<Item>)ItemTags.SAPLINGS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.LILY_PAD).input((TagKey<Item>)ItemTags.LEAVES).or().input((ItemLike)Items.WATER_BUCKET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.VINE).input((TagKey<Item>)ItemTags.LEAVES).and().input((ItemLike)Items.LADDER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ROSE_BUSH).input((ItemLike)Items.LARGE_FERN).or().input((ItemLike)Items.POPPY).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SUGAR_CANE).input((ItemLike)Items.BAMBOO).and().input((ItemLike)Items.SUGAR).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.AZALEA).input((ItemLike)Items.ROOTED_DIRT).or().input((ItemLike)Items.OAK_SAPLING).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.FLOWERING_AZALEA).input((TagKey<Item>)ItemTags.FLOWERS).and().input((ItemLike)Items.AZALEA).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.AZALEA_LEAVES).input((ItemLike)Items.AZALEA).and().input((ItemLike)Items.OAK_LEAVES).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.FLOWERING_AZALEA_LEAVES).input((TagKey<Item>)ItemTags.FLOWERS).and().input((ItemLike)Items.AZALEA_LEAVES).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BIG_DRIPLEAF).input((ItemLike)Items.BONE_MEAL).or().input((ItemLike)Items.SMALL_DRIPLEAF).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SMALL_DRIPLEAF).input((ItemLike)Items.SPYGLASS).or().input((ItemLike)Items.LILY_PAD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MOSS_BLOCK).input((ItemLike)Items.GRASS_BLOCK).or().input((ItemLike)Items.SHORT_GRASS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ROOTED_DIRT).input((ItemLike)Items.VINE).and().input((ItemLike)Items.DIRT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MOSS_CARPET).input((ItemLike)Items.GRASS_BLOCK).and().input((ItemLike)Items.SHORT_GRASS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SPORE_BLOSSOM).input((ItemLike)Items.LILY_PAD).or().input((ItemLike)Items.BONE_MEAL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GLOW_BERRIES).input((ItemLike)Items.GLOWSTONE_DUST).and().input((ItemLike)Items.SWEET_BERRIES).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GLOW_LICHEN).input((ItemLike)Items.GLOWSTONE_DUST).or().input((ItemLike)Items.VINE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.HANGING_ROOTS).input((ItemLike)Items.VINE).or().input((ItemLike)Items.DEAD_BUSH).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MANGROVE_ROOTS).input((ItemLike)Items.HANGING_ROOTS).and().input((ItemLike)Items.STICK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SCULK).input((ItemLike)Items.MOSS_BLOCK).or().input((ItemLike)Items.SOUL_SOIL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SCULK_VEIN).input((ItemLike)Items.SCULK).and().input((ItemLike)Items.GLOW_LICHEN).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SCULK_CATALYST).input((ItemLike)Items.SCULK).or().input((ItemLike)Items.SPAWNER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SCULK_SENSOR).input((ItemLike)Items.SCULK).and().input((ItemLike)Items.STRING).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SCULK_SHRIEKER).input((ItemLike)Items.SCULK_SENSOR).or().input((ItemLike)Items.BELL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MINECART).input((TagKey<Item>)ItemTags.BOATS).or().input((ItemLike)Items.RAIL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CHEST_MINECART).input((ItemLike)Items.MINECART).and().input((ItemLike)Items.CHEST).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.FURNACE_MINECART).input((ItemLike)Items.MINECART).and().input((ItemLike)Items.FURNACE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.TNT_MINECART).input((ItemLike)Items.MINECART).and().input((ItemLike)Items.TNT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.HOPPER_MINECART).input((ItemLike)Items.MINECART).and().input((ItemLike)Items.HOPPER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RAIL).namedInput((ItemLike)Items.IRON_BARS).and().input((ItemLike)Items.STICK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.RAIL).namedInput((ItemLike)Items.LADDER).and().input((ItemLike)Items.IRON_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ACTIVATOR_RAIL).input((ItemLike)Items.RAIL).and().input((ItemLike)Items.REDSTONE_TORCH).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DETECTOR_RAIL).input((ItemLike)Items.RAIL).and().namedInput((TagKey<Item>)ItemTags.WOODEN_PRESSURE_PLATES).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DETECTOR_RAIL).input((ItemLike)Items.RAIL).and().namedInput((ItemLike)Items.STONE_PRESSURE_PLATE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DETECTOR_RAIL).input((ItemLike)Items.RAIL).and().namedInput((ItemLike)Items.LIGHT_WEIGHTED_PRESSURE_PLATE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DETECTOR_RAIL).input((ItemLike)Items.RAIL).and().namedInput((ItemLike)Items.HEAVY_WEIGHTED_PRESSURE_PLATE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POWERED_RAIL).input((ItemLike)Items.RAIL).and().namedInput((ItemLike)Items.GOLD_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POWERED_RAIL).input((ItemLike)Items.RAIL).and().namedInput((ItemLike)Items.FURNACE_MINECART).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.LADDER).input((TagKey<Item>)ItemTags.PLANKS).or().namedInput((ItemLike)Items.RAIL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.LADDER).input((ItemLike)Items.STICK).or().input((ItemLike)Items.VINE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE_TORCH).input((ItemLike)Items.TORCH).and().input((ItemLike)Items.REDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE_LAMP).input((ItemLike)Items.GLOWSTONE).and().input((ItemLike)Items.REDSTONE_TORCH).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE).input((ItemLike)Items.GUNPOWDER).or().namedInput((ItemLike)Items.STONE_BUTTON).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE).input((ItemLike)Items.GUNPOWDER).or().namedInput((ItemLike)Items.STONE_PRESSURE_PLATE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE).input((ItemLike)Items.GUNPOWDER).or().namedInput((ItemLike)Items.LEVER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE).namedInput((ItemLike)Items.GRAVEL).and().input((ItemLike)Items.RED_DYE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE_TORCH).input((ItemLike)Items.GUNPOWDER).or().namedInput((TagKey<Item>)ItemTags.WOODEN_BUTTONS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.REDSTONE_TORCH).input((ItemLike)Items.GUNPOWDER).or().namedInput((TagKey<Item>)ItemTags.WOODEN_PRESSURE_PLATES).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHERRACK).input((ItemLike)Items.COBBLESTONE).and().input((ItemLike)Items.LAVA_BUCKET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SOUL_SAND).input((TagKey<Item>)ItemTags.SAND).or().input((ItemLike)Items.NETHER_WART).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SOUL_SOIL).input((ItemLike)Items.DIRT).or().input((ItemLike)Items.NETHER_WART).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BLACKSTONE).input((ItemLike)Items.STONE).or().namedInput((ItemLike)Items.BLACK_DYE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BASALT).input((ItemLike)Items.LAVA_BUCKET).or().namedInput((ItemLike)Items.QUARTZ_PILLAR).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BASALT).input((ItemLike)Items.LAVA_BUCKET).or().namedInput((ItemLike)Items.PURPUR_PILLAR).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CRYING_OBSIDIAN).input((ItemLike)Items.OBSIDIAN).or().namedInput((ItemLike)Items.GHAST_TEAR).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_WART).input((ItemLike)Items.RED_MUSHROOM).and().input((ItemLike)Items.SOUL_SAND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_BRICKS).input((ItemLike)Items.NETHERRACK).and().namedInput((ItemLike)Items.BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_BRICKS).input((ItemLike)Items.NETHERRACK).and().namedInput((ItemLike)Items.BRICK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_BRICK).namedInput((ItemLike)Items.NETHERRACK).or().input((ItemLike)Items.BRICK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_BRICK).namedInput((ItemLike)Items.NETHER_BRICKS).or().input((ItemLike)Items.BRICK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_BRICK_FENCE).input((TagKey<Item>)ItemTags.WOODEN_FENCES).and().namedInput((ItemLike)Blocks.NETHER_BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_BRICK_FENCE).input((TagKey<Item>)ItemTags.WOODEN_FENCES).and().namedInput((ItemLike)Items.NETHER_BRICK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_BRICK_STAIRS).input((TagKey<Item>)ItemTags.WOODEN_STAIRS).and().namedInput((ItemLike)Blocks.NETHER_BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.NETHER_BRICK_STAIRS).input((TagKey<Item>)ItemTags.WOODEN_STAIRS).and().namedInput((ItemLike)Items.NETHER_BRICK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GLOWSTONE).input((ItemLike)Items.NETHERRACK).and().input((ItemLike)Items.GLOWSTONE_DUST).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CRIMSON_STEM).input((TagKey<Item>)ItemTags.LOGS).or().input((ItemLike)Items.CRIMSON_FUNGUS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.WARPED_STEM).input((TagKey<Item>)ItemTags.LOGS).or().input((ItemLike)Items.WARPED_FUNGUS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CRIMSON_ROOTS).input((ItemLike)Items.SHORT_GRASS).or().input((ItemLike)Items.CRIMSON_FUNGUS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.WARPED_ROOTS).input((ItemLike)Items.SHORT_GRASS).or().input((ItemLike)Items.WARPED_FUNGUS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.WEEPING_VINES).input((ItemLike)Items.VINE).and().input((ItemLike)Items.CRIMSON_ROOTS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.TWISTING_VINES).input((ItemLike)Items.VINE).and().input((ItemLike)Items.WARPED_ROOTS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CRIMSON_NYLIUM).input((ItemLike)Items.MYCELIUM).or().input((ItemLike)Items.CRIMSON_FUNGUS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.WARPED_NYLIUM).input((ItemLike)Items.MYCELIUM).or().input((ItemLike)Items.WARPED_FUNGUS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.WARPED_WART_BLOCK).input((TagKey<Item>)ItemTags.LEAVES).and().input((ItemLike)Items.WARPED_FUNGUS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SHROOMLIGHT).input((ItemLike)Items.GLOWSTONE).or().namedInput((ItemLike)Items.CRIMSON_FUNGUS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SHROOMLIGHT).input((ItemLike)Items.GLOWSTONE).or().namedInput((ItemLike)Items.WARPED_FUNGUS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MAGMA_CREAM).input((ItemLike)Items.SLIME_BALL).and().input((ItemLike)Items.BLAZE_POWDER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MAGMA_BLOCK).input((ItemLike)Items.LAVA_BUCKET).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BLAZE_ROD).input((ItemLike)Items.STICK).and().namedInput((ItemLike)Items.LAVA_BUCKET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BLAZE_ROD).input((ItemLike)Items.STICK).and().namedInput((ItemLike)Items.BLAZE_POWDER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BLAZE_POWDER).input((ItemLike)Items.REDSTONE).or().namedInput((ItemLike)Items.LAVA_BUCKET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BLAZE_POWDER).input((ItemLike)Items.REDSTONE).or().namedInput((ItemLike)Items.NETHERRACK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ANCIENT_DEBRIS).input((ItemLike)MSItems.STEEL_BEAM).and().input((ItemLike)MSItems.RAW_URANIUM).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.APPLE).namedInput((ItemLike)Items.OAK_SAPLING).and().input((ItemLike)Items.WHEAT_SEEDS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.APPLE).namedInput((ItemLike)Items.OAK_LEAVES).and().input((ItemLike)Items.WHEAT_SEEDS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GOLDEN_APPLE).input((ItemLike)Items.APPLE).and().namedInput((ItemLike)Items.GOLD_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GOLDEN_APPLE).input((ItemLike)Items.APPLE).and().namedInput((ItemLike)Items.GOLD_NUGGET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ENCHANTED_GOLDEN_APPLE).input((ItemLike)Items.APPLE).and().input((ItemLike)Items.GOLD_BLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POTATO).input((ItemLike)Items.CARROT).and().input((ItemLike)Items.WHEAT_SEEDS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CARROT).input((ItemLike)Items.POTATO).or().input((ItemLike)Items.WHEAT_SEEDS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.MELON).input((ItemLike)Items.PUMPKIN).or().input((ItemLike)MSBlocks.STRAWBERRY).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PUMPKIN).input((ItemLike)Items.MELON).and().input((ItemLike)Items.CARROT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SUGAR).input((ItemLike)Items.COOKIE).and().input((ItemLike)Items.REDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PORKCHOP).input((ItemLike)Items.ROTTEN_FLESH).or().input((ItemLike)Items.CARROT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.LEATHER).input((ItemLike)Items.ROTTEN_FLESH).or().input((ItemLike)Items.WATER_BUCKET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BEEF).input((ItemLike)Items.ROTTEN_FLESH).or().input((ItemLike)Items.WHEAT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CHICKEN).input((ItemLike)Items.ROTTEN_FLESH).or().input((ItemLike)Items.WHEAT_SEEDS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.POISONOUS_POTATO).input((ItemLike)Items.POTATO).or().input((ItemLike)Items.PUFFERFISH).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.FERMENTED_SPIDER_EYE).input((ItemLike)Items.SPIDER_EYE).or().input((ItemLike)Items.ROTTEN_FLESH).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.END_STONE).input((ItemLike)Items.STONE).and().input((ItemLike)Items.ENDER_PEARL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DRAGON_EGG).input((ItemLike)Items.ENDER_EYE).and().input((ItemLike)Items.EGG).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ENDER_EYE).input((ItemLike)Items.ENDER_PEARL).and().input((ItemLike)Items.BLAZE_POWDER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CHORUS_FLOWER).input((TagKey<Item>)ItemTags.SMALL_FLOWERS).and().input((ItemLike)Items.CHORUS_FRUIT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ELYTRA).namedInput((ItemLike)Items.FEATHER).or().input((ItemLike)Items.CHORUS_FRUIT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ELYTRA).namedInput((ItemLike)Items.LEATHER_CHESTPLATE).and().input((ItemLike)Items.PHANTOM_MEMBRANE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CHORUS_FRUIT).input((ItemLike)Items.ENDER_PEARL).and().input((ItemLike)Items.POTATO).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DRAGON_BREATH).input((ItemLike)Items.GLASS_BOTTLE).or().input((ItemLike)Items.DRAGON_HEAD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DIAMOND_HORSE_ARMOR).input((ItemLike)Items.DIAMOND).and().input((ItemLike)Items.SADDLE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GOLDEN_HORSE_ARMOR).input((ItemLike)Items.GOLD_INGOT).and().input((ItemLike)Items.SADDLE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.IRON_HORSE_ARMOR).input((ItemLike)Items.IRON_INGOT).and().input((ItemLike)Items.SADDLE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SADDLE).input((ItemLike)Items.STRING).and().input((ItemLike)Items.LEATHER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SHEARS).input((ItemLike)Items.IRON_INGOT).and().input((ItemLike)Items.SHORT_GRASS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.FIRE_CHARGE).input((ItemLike)Items.BLAZE_POWDER).or().input((ItemLike)Items.GUNPOWDER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BOW).input((ItemLike)Items.WOODEN_SWORD).or().input((ItemLike)Items.ARROW).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.FLOWER_POT).input((TagKey<Item>)ItemTags.SMALL_FLOWERS).and().input((ItemLike)Items.BRICK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.EXPERIENCE_BOTTLE).namedInput((ItemLike)Items.POTION).or().input((ItemLike)Items.ENCHANTED_BOOK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.EXPERIENCE_BOTTLE).namedInput((ItemLike)Items.GLASS_BOTTLE).or().input((ItemLike)Items.ENCHANTED_BOOK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.TRIDENT).namedInput((ItemLike)Items.PRISMARINE_SHARD).and().input((ItemLike)MSItems.FORK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.TURTLE_HELMET).namedInput((ItemLike)Items.IRON_HELMET).or().input((ItemLike)Items.SEAGRASS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SPYGLASS).namedInput((ItemLike)Items.SPIDER_EYE).or().input((ItemLike)Items.OBSERVER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BUCKET).input((ItemLike)Items.BOWL).or().namedInput((ItemLike)Items.IRON_INGOT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.WET_SPONGE).input((ItemLike)Items.WATER_BUCKET).and().namedInput((ItemLike)Items.SPONGE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.WET_SPONGE).input((ItemLike)Items.WATER_BUCKET).and().namedInput((ItemLike)Items.YELLOW_WOOL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ICE).input((ItemLike)Items.GLASS).and().input((ItemLike)Items.SNOW_BLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PRISMARINE_CRYSTALS).input((ItemLike)Items.PRISMARINE_SHARD).or().namedInput((ItemLike)Items.DIAMOND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PRISMARINE_CRYSTALS).input((ItemLike)Items.PRISMARINE_SHARD).or().namedInput((ItemLike)Items.EMERALD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PRISMARINE).input((ItemLike)Items.PRISMARINE_SHARD).and().input((ItemLike)Items.COBBLESTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PRISMARINE_BRICKS).input((ItemLike)Items.PRISMARINE_SHARD).and().input((ItemLike)Items.STONE_BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.DARK_PRISMARINE).input((ItemLike)Items.PRISMARINE).and().input((ItemLike)Items.BLACK_DYE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SEA_LANTERN).input((ItemLike)Items.PRISMARINE_SHARD).or().namedInput((ItemLike)Items.GLOWSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SEA_LANTERN).input((ItemLike)Items.PRISMARINE).and().namedInput((ItemLike)Items.PRISMARINE_CRYSTALS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PRISMARINE_SHARD).namedInput((ItemLike)Items.PRISMARINE).or().input((ItemLike)Items.FLINT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PRISMARINE_SHARD).namedInput((ItemLike)Items.PRISMARINE_BRICKS).or().input((ItemLike)Items.FLINT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PRISMARINE_SHARD).namedInput((ItemLike)Items.DARK_PRISMARINE).or().input((ItemLike)Items.FLINT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PRISMARINE_CRYSTALS).namedInput((ItemLike)Items.QUARTZ).or().input((ItemLike)Items.WATER_BUCKET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PRISMARINE_SHARD).namedInput((ItemLike)Items.QUARTZ).and().input((ItemLike)Items.WATER_BUCKET).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.HEART_OF_THE_SEA).namedInput((ItemLike)Items.NAUTILUS_SHELL).and().input((ItemLike)Items.DIAMOND).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.INK_SAC).input((TagKey<Item>)ItemTags.FISHES).and().input((ItemLike)Items.BLACK_DYE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.PACKED_ICE).input((ItemLike)Items.ICE).or().input((ItemLike)Items.CHEST).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BLUE_ICE).input((ItemLike)Items.BLUE_DYE).and().input((ItemLike)Items.ICE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SKELETON_SKULL).input((ItemLike)Items.WITHER_SKELETON_SKULL).and().namedInput((ItemLike)Items.BONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.SKELETON_SKULL).input((ItemLike)Items.WITHER_SKELETON_SKULL).and().namedInput((ItemLike)Items.BONE_MEAL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.ZOMBIE_HEAD).input((ItemLike)Items.SKELETON_SKULL).or().input((ItemLike)Items.ROTTEN_FLESH).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.CREEPER_HEAD).input((ItemLike)Items.VINE).or().input((ItemLike)Items.GUNPOWDER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.BONE).input((ItemLike)Items.STICK).or().input((ItemLike)Items.SKELETON_SKULL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of((ItemLike)Items.GHAST_TEAR).input((ItemLike)Items.PHANTOM_MEMBRANE).and().input((ItemLike)Items.GUNPOWDER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSItems.PAPER_SWORD).input((ItemLike)Items.PAPER).or().namedInput((ItemLike)MSItems.KATANA).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PAPER_SWORD).input((ItemLike)Items.PAPER).or().namedInput((ItemLike)Items.WOODEN_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PAPER_SWORD).input((ItemLike)Items.PAPER).or().namedInput((ItemLike)Items.STONE_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SWONGE).input((ItemLike)Items.WOODEN_SWORD).and().namedInput((ItemLike)Items.SPONGE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PUMORD).input((ItemLike)MSItems.SWONGE).or().input((ItemLike)MSBlocks.PUMICE_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CACTACEAE_CUTLASS).input((ItemLike)Items.WOODEN_SWORD).and().namedInput((ItemLike)Items.CACTUS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CACTACEAE_CUTLASS).input((ItemLike)Items.WOODEN_SWORD).and().namedInput((ItemLike)MSBlocks.BLOOMING_CACTUS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STEAK_SWORD).namedInput((ItemLike)Items.WOODEN_SWORD).or().input((ItemLike)Items.COOKED_BEEF).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STEAK_SWORD).namedInput((ItemLike)Items.STONE_SWORD).or().input((ItemLike)Items.COOKED_BEEF).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BEEF_SWORD).input((ItemLike)Items.WOODEN_SWORD).or().input((ItemLike)Items.BEEF).build(consumer);
        CombinationRecipeBuilder.of(MSItems.IRRADIATED_STEAK_SWORD).input((ItemLike)Items.WOODEN_SWORD).or().input((ItemLike)MSItems.IRRADIATED_STEAK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SORD).namedInput((ItemLike)MSItems.KATANA).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SORD).namedInput((ItemLike)Items.WOODEN_SWORD).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FROSTY_MACUAHUITL).namedInput((ItemLike)MSItems.MACUAHUITL).or().input((ItemLike)MSItems.ICE_SHARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.KATANA).namedInput((ItemLike)Items.STONE_SWORD).and().input((ItemLike)Items.ROTTEN_FLESH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.KATANA).namedInput((ItemLike)Items.IRON_SWORD).and().input((ItemLike)Items.ROTTEN_FLESH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FIRE_POKER).input((ItemLike)Items.IRON_SWORD).and().input((ItemLike)Items.BLAZE_ROD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TOO_HOT_TO_HANDLE).input((ItemLike)Items.IRON_SWORD).or().input((ItemLike)Items.BLAZE_ROD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REGISWORD).namedInput((ItemLike)Items.IRON_SWORD).and().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REGISWORD).namedInput((ItemLike)MSItems.KATANA).and().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CRUEL_FATE_CRUCIBLE).namedInput((ItemLike)Items.IRON_SWORD).or().input((ItemLike)MSItems.GRIMOIRE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLAYMORE).input((ItemLike)Items.IRON_SWORD).and().input((ItemLike)Items.IRON_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UNBREAKABLE_KATANA).input((ItemLike)MSItems.KATANA).and().input((ItemLike)Items.BEDROCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ANGEL_APOCALYPSE).input((ItemLike)Items.IRON_SWORD).and().input((ItemLike)Items.FEATHER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.COBALT_SABRE).input((ItemLike)MSItems.TOO_HOT_TO_HANDLE).or().input((ItemLike)Items.LAPIS_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCARLET_RIBBITAR).input((ItemLike)MSItems.CALEDSCRATCH).and().input((ItemLike)MSItems.FROG).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SHATTER_BEACON).input((ItemLike)Items.BEACON).and().input((ItemLike)Items.DIAMOND_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SHATTER_BACON).input((ItemLike)Items.PORKCHOP).and().input((ItemLike)MSItems.SHATTER_BEACON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CALEDFWLCH).input((ItemLike)MSItems.ROYAL_DERINGER).or().input((ItemLike)MSItems.CUEBALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MUSIC_SWORD).input((ItemLike)MSBlocks.CASSETTE_PLAYER).or().input((ItemLike)MSItems.CLAYMORE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PILLOW_TALK).input((ItemLike)MSItems.UNBREAKABLE_KATANA).and().input((ItemLike)Items.BAMBOO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.KRAKENS_EYE).input((ItemLike)Items.HEART_OF_THE_SEA).or().input((ItemLike)MSItems.CLAYMORE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CINNAMON_SWORD).input((ItemLike)Items.WOODEN_SWORD).and().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UNION_BUSTER).input((ItemLike)MSItems.ROCKEFELLERS_WALKING_BLADECANE).and().input((ItemLike)MSItems.NIGHTSTICK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.THORN_IN_YOUR_SIDE).input((ItemLike)Items.IRON_SWORD).and().input((ItemLike)Items.ROSE_BUSH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ROSE_PROTOCOL).input((ItemLike)MSItems.THORN_IN_YOUR_SIDE).and().input((ItemLike)MSItems.COMPUTER_PARTS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DIAMOND_DAGGER).input((ItemLike)MSItems.DAGGER).and().input((ItemLike)Items.DIAMOND).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PIGLINS_PRIDE).input((ItemLike)MSItems.DIAMOND_DAGGER).and().input((ItemLike)Items.NETHERITE_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BASILISK_BREATH_DRAGONSLAYER).input((ItemLike)MSItems.PIGLINS_PRIDE).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HALLOWED_SKEWER).input((ItemLike)MSItems.DIAMOND_DAGGER).or().input((ItemLike)Items.TOTEM_OF_UNDYING).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GENESIS_GODSTABBER).input((ItemLike)MSItems.HALLOWED_SKEWER).and().input((ItemLike)MSItems.FROG).build(consumer);
        CombinationRecipeBuilder.of(MSItems.NIFE).input((ItemLike)MSItems.DAGGER).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LIGHT_OF_MY_KNIFE).input((ItemLike)MSItems.DAGGER).and().input((ItemLike)Items.LANTERN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.THOUSAND_DEGREE_KNIFE).input((ItemLike)MSItems.LIGHT_OF_MY_KNIFE).and().input((ItemLike)Items.LAVA_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STARSHARD_TRI_BLADE).input((ItemLike)MSItems.LIGHT_OF_MY_KNIFE).or().input((ItemLike)Items.NETHER_STAR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TOOTHRIPPER).input((ItemLike)MSItems.DAGGER).or().namedInput((ItemLike)Items.ROTTEN_FLESH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TOOTHRIPPER).input((ItemLike)MSItems.DAGGER).or().namedInput((ItemLike)Items.BONE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SHADOWRAZOR).input((ItemLike)MSItems.TOOTHRIPPER).and().namedInput((ItemLike)MSItems.SORROW_GUSHERS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PRINCESS_PERIL).input((ItemLike)MSItems.SHADOWRAZOR).or().input((ItemLike)MSItems.GAMEGRL_MAGAZINE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.KEYBLADE).input((ItemLike)MSItems.HOUSE_KEY).and().input((ItemLike)Items.IRON_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_KEY).input((ItemLike)MSItems.KEYBLADE).or().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LOCKSOFTENER).input((ItemLike)MSItems.KEYBLADE).and().input((ItemLike)MSItems.CLOTHES_IRON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BISEKEYAL).input((ItemLike)MSItems.KEYBLADE).and().input((ItemLike)MSItems.BI_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.KEY_TO_THE_MACHINE).input((ItemLike)MSItems.KEYBLADE).or().input((ItemLike)Items.REPEATER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.KEY_TO_THE_CITY).input((ItemLike)MSItems.DEMOCRATIC_DEMOLITIONER).or().input((ItemLike)MSItems.KEY_TO_THE_MACHINE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.INNER_HEART).input((ItemLike)MSItems.GAMEGRL_MAGAZINE).and().input((ItemLike)MSItems.KEYBLADE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DRAGON_KEY).input((ItemLike)MSItems.KEYBLADE).and().input((ItemLike)MSItems.SCALEMATE_APPLESCAB).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TRUE_BLUE).input((ItemLike)MSItems.KEYBLADE).and().input((ItemLike)MSItems.EIGHTBALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BLUE_BEAMS).input((ItemLike)MSItems.TRUE_BLUE).or().input((ItemLike)MSItems.SHATTER_BEACON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.INKSPLOCKER_UNLOCKER).input((ItemLike)MSItems.KEYBLADE).and().input((ItemLike)MSItems.INK_SQUID_PRO_QUO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.INKSQUIDDER_DEPTHKEY).input((ItemLike)MSItems.INKSPLOCKER_UNLOCKER).or().input((ItemLike)Items.HEART_OF_THE_SEA).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REGIKEY).input((ItemLike)MSItems.KEYBLADE).or().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLOCKKEEPER).input((ItemLike)MSItems.REGIKEY).and().input((ItemLike)Items.CLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HOME_BY_MIDNIGHT).input((ItemLike)MSItems.CLOCKKEEPER).or().input((ItemLike)MSItems.ESTROGEN_EMPOWERED_EVERYTHING_ERADICATOR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LATCHMELTER).input((ItemLike)MSItems.BLAZING_GLORY).and().input((ItemLike)MSItems.HOUSE_KEY).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CRIMSON_LEAP).input((ItemLike)MSItems.FROG).and().input((ItemLike)MSItems.KEYBLADE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.NO_TIME_FOR_FLIES).input((ItemLike)MSItems.CLOCKKEEPER).and().input((ItemLike)MSItems.CRIMSON_LEAP).build(consumer);
        CombinationRecipeBuilder.of(MSItems.NATURES_HEART).input((ItemLike)MSItems.CROP_CHOP).or().input((ItemLike)MSItems.KEYBLADE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LOCH_PICK).input((ItemLike)MSItems.CRYPTID_PHOTO).or().input((ItemLike)MSItems.DRAGON_KEY).build(consumer);
        CombinationRecipeBuilder.of(MSItems.YALDABAOTHS_KEYTON).input((ItemLike)MSItems.LATCHMELTER).or().input((ItemLike)MSItems.CELESTIAL_FULCRUM).build(consumer);
        CombinationRecipeBuilder.of(MSItems.KEYTAR).input((ItemLike)MSItems.HOUSE_KEY).and().input((ItemLike)Items.NOTE_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ALLWEDDOL).input((ItemLike)MSItems.YALDABAOTHS_KEYTON).and().input((ItemLike)MSItems.CUEBALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CONDUCTORS_BATON).input((ItemLike)Items.STICK).and().input((ItemLike)Items.NOTE_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SHARP_NOTE).input((ItemLike)MSItems.KNITTING_NEEDLE).and().input((ItemLike)MSItems.CONDUCTORS_BATON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.URANIUM_BATON).input((ItemLike)MSItems.RAW_URANIUM).or().input((ItemLike)MSItems.CONDUCTORS_BATON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WIND_WAKER).input((ItemLike)Items.OAK_BOAT).or().input((ItemLike)MSItems.CONDUCTORS_BATON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CELESTIAL_FULCRUM).input((ItemLike)Items.AMETHYST_SHARD).or().input((ItemLike)MSItems.CONDUCTORS_BATON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HYMN_FOR_HORRORTERRORS).input((ItemLike)MSItems.THORN_OF_OGLOGOTH).and().input((ItemLike)MSItems.CELESTIAL_FULCRUM).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TV_ANTENNA).input((ItemLike)MSItems.CONDUCTORS_BATON).and().input((ItemLike)MSBlocks.OLD_COMPUTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BO_STAFF).input((ItemLike)Items.STICK).and().input((ItemLike)Items.IRON_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BAMBOO_BEATSTICK).input((ItemLike)MSItems.BO_STAFF).and().input((ItemLike)Items.BAMBOO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BARBERS_MAGIC_TOUCH).input((ItemLike)MSItems.BARBASOL).and().input((ItemLike)MSItems.WIZARD_STAFF).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TELESCOPIC_BEATDOWN_BRUISER).input((ItemLike)MSItems.BO_STAFF).or().input((ItemLike)Items.SPYGLASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ION_DESTABILIZER).input((ItemLike)MSItems.IRON_LASS_CHESTPLATE).or().input((ItemLike)MSItems.BO_STAFF).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BATLEACKS).namedInput((ItemLike)MSItems.BATTLEAXE).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BATLEACKS).namedInput((ItemLike)Items.WOODEN_AXE).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.COPSE_CRUSHER).input((ItemLike)Items.IRON_AXE).and().input((ItemLike)Items.PISTON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.QUENCH_CRUSHER).input((ItemLike)MSItems.COPSE_CRUSHER).or().input((ItemLike)MSItems.DESERT_FRUIT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MELONSBANE).input((ItemLike)MSItems.QUENCH_CRUSHER).or().namedInput((ItemLike)Items.MELON_SLICE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MELONSBANE).input((ItemLike)MSItems.QUENCH_CRUSHER).or().namedInput((ItemLike)Items.MELON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CROP_CHOP).input((ItemLike)Items.GOLDEN_AXE).or().namedInput((ItemLike)Items.POTATO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CROP_CHOP).input((ItemLike)Items.GOLDEN_AXE).or().namedInput((ItemLike)Items.CARROT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.THE_LAST_STRAW).input((ItemLike)MSItems.CROP_CHOP).and().input((ItemLike)Items.HAY_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BATTLEAXE).input((ItemLike)Items.IRON_AXE).and().input((ItemLike)Items.IRON_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_BATTLEAXE).input((ItemLike)MSItems.BATTLEAXE).or().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CHOCO_LOCO_WOODSPLITTER).input((ItemLike)MSItems.CANDY_BATTLEAXE).or().input((ItemLike)Items.COCOA_BEANS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STEEL_EDGE_CANDYCUTTER).input((ItemLike)MSItems.CHOCO_LOCO_WOODSPLITTER).and().input((ItemLike)Items.IRON_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BLACKSMITH_BANE).input((ItemLike)Items.WOODEN_AXE).and().input((ItemLike)Items.ANVIL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REGIAXE).input((ItemLike)MSItems.BLACKSMITH_BANE).and().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GOTHY_AXE).input((ItemLike)MSItems.REGIAXE).or().input((ItemLike)Items.SPIDER_EYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SURPRISE_AXE).input((ItemLike)MSItems.BLACKSMITH_BANE).and().input((ItemLike)MSItems.SURPRISE_EMBRYO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SHOCK_AXE).input((ItemLike)MSItems.SURPRISE_AXE).and().input((ItemLike)MSItems.BATTERY).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCRAXE).input((ItemLike)Items.IRON_AXE).and().input((TagKey<Item>)Tags.Items.MUSIC_DISCS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LORENTZ_DISTRANSFORMATIONER).input((ItemLike)Items.IRON_AXE).and().namedInput((ItemLike)MSBlocks.TRANSPORTALIZER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LORENTZ_DISTRANSFORMATIONER).input((ItemLike)Items.IRON_AXE).and().namedInput((ItemLike)Items.CHORUS_FRUIT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PISTON_POWERED_POGO_AXEHAMMER).input((ItemLike)MSItems.COPSE_CRUSHER).and().input((ItemLike)MSItems.POGO_HAMMER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FISSION_FOCUSED_FAULT_FELLER).input((ItemLike)MSItems.PISTON_POWERED_POGO_AXEHAMMER).and().input((ItemLike)MSItems.ENERGY_CORE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HEPHAESTUS_LUMBERJACK).input((ItemLike)Items.GOLDEN_AXE).and().input((ItemLike)Items.LAVA_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.RUBY_CROAK).input((ItemLike)MSItems.EMERALD_AXE).and().input((ItemLike)MSItems.FROG).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BISECTOR).input((ItemLike)MSItems.BI_DYE).and().input((ItemLike)Items.IRON_AXE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FINE_CHINA_AXE).input((ItemLike)Items.DECORATED_POT).or().input((ItemLike)Items.DIAMOND_AXE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SICKLE).input((ItemLike)Items.IRON_HOE).and().input((ItemLike)Items.WHEAT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.OW_THE_EDGE).input((ItemLike)MSItems.HEMEOREAPER).or().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.THORNY_SUBJECT).input((ItemLike)MSItems.SICKLE).and().input((ItemLike)Items.ROSE_BUSH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SNOW_WHITE_DREAM).input((ItemLike)MSItems.THORNY_SUBJECT).and().input((ItemLike)Items.APPLE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HOMES_SMELL_YA_LATER).input((ItemLike)MSItems.SICKLE).or().input((ItemLike)MSItems.THRESH_DVD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HEMEOREAPER).input((ItemLike)MSItems.HOMES_SMELL_YA_LATER).or().input((ItemLike)MSItems.BLOOD_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FUDGESICKLE).input((ItemLike)MSItems.SICKLE).or().input((ItemLike)Items.COCOA_BEANS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REGISICKLE).input((ItemLike)MSItems.SICKLE).and().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HERETICUS_AURURM).input((ItemLike)MSItems.REGISICKLE).and().input((ItemLike)Items.GOLD_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_SICKLE).input((ItemLike)MSItems.SICKLE).or().namedInput((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_SICKLE).namedInput((ItemLike)MSItems.FUDGESICKLE).and().input((ItemLike)Items.SUGAR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLAW_SICKLE).namedInput((ItemLike)MSItems.CAT_CLAWS_DRAWN).and().input((ItemLike)MSItems.HEMEOREAPER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLAW_SICKLE).namedInput((ItemLike)MSItems.CAT_CLAWS_SHEATHED).and().input((ItemLike)MSItems.HEMEOREAPER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLAW_OF_NRUBYIGLITH).namedInput((ItemLike)MSItems.CLAW_SICKLE).and().input((ItemLike)MSItems.GRIMOIRE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCYTHE).input((ItemLike)MSItems.SICKLE).and().input((ItemLike)Items.WOODEN_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MARASCHINO_CHERRY_SCYTHE).input((ItemLike)MSItems.SCYTHE).and().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PROSPECTING_PICKSCYTHE).input((ItemLike)MSItems.SCYTHE).and().input((ItemLike)Items.GOLDEN_PICKAXE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EIGHTBALL_SCYTHE).input((ItemLike)MSItems.SCYTHE).and().input((ItemLike)MSItems.EIGHTBALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TIME_FLAYER).input((ItemLike)MSItems.EIGHTBALL_SCYTHE).and().input((ItemLike)Items.CLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DESTINY_DECIMATOR).input((ItemLike)Items.NETHERITE_HOE).or().input((ItemLike)Items.WITHER_SKELETON_SKULL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SUNRAY_HARVESTER).input((ItemLike)MSItems.SCYTHE).and().input((ItemLike)Items.LAVA_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GREEN_SUN_RAYREAPER).input((ItemLike)MSItems.SUNRAY_HARVESTER).and().input((ItemLike)MSItems.RAW_URANIUM).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SKAITHE).input((ItemLike)MSItems.SCYTHE).and().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HELLBRINGERS_HOE_INACTIVE).input((ItemLike)Items.NETHERITE_HOE).or().input((ItemLike)MSItems.CRYPTID_PHOTO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STALE_BAGUETTE).input((ItemLike)Items.BREAD).or().namedInput((ItemLike)Items.STICK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STALE_BAGUETTE).input((ItemLike)Items.BREAD).or().namedInput((ItemLike)MSItems.DEUCE_CLUB).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GLUB_CLUB).input((ItemLike)MSItems.DEUCE_CLUB).or().namedInput((ItemLike)Items.COD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GLUB_CLUB).input((ItemLike)MSItems.DEUCE_CLUB).or().namedInput((ItemLike)Items.SALMON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GLUB_CLUB).input((ItemLike)MSItems.DEUCE_CLUB).or().namedInput((ItemLike)Items.TROPICAL_FISH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PRISMARINE_BASHER).input((ItemLike)MSItems.GLUB_CLUB).or().namedInput((ItemLike)Items.PRISMARINE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PRISMARINE_BASHER).input((ItemLike)MSItems.GLUB_CLUB).or().namedInput((ItemLike)Items.PRISMARINE_SHARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PRISMARINE_BASHER).input((ItemLike)MSItems.GLUB_CLUB).or().namedInput((ItemLike)Items.DARK_PRISMARINE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PRISMARINE_BASHER).input((ItemLike)MSItems.GLUB_CLUB).or().namedInput((ItemLike)Items.PRISMARINE_BRICKS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLUB_ZERO).input((ItemLike)MSItems.PRISMARINE_BASHER).and().namedInput((ItemLike)Items.ICE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLUB_ZERO).input((ItemLike)MSItems.PRISMARINE_BASHER).and().namedInput((ItemLike)Items.PACKED_ICE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLUB_ZERO).input((ItemLike)MSItems.PRISMARINE_BASHER).and().namedInput((ItemLike)Items.BLUE_ICE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLUB_ZERO).input((ItemLike)MSItems.PRISMARINE_BASHER).and().namedInput((ItemLike)MSItems.ICE_SHARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.POGO_CLUB).input((ItemLike)MSItems.DEUCE_CLUB).and().input((ItemLike)Items.SLIME_BALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BARBER_BASHER).input((ItemLike)MSItems.DEUCE_CLUB).and().input((ItemLike)MSItems.BARBASOL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.NIGHT_CLUB).input((ItemLike)MSItems.DEUCE_CLUB).and().input((ItemLike)MSItems.CREW_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.NIGHTSTICK).input((ItemLike)MSItems.NIGHT_CLUB).and().input((ItemLike)MSItems.SCALEMATE_APPLESCAB).build(consumer);
        CombinationRecipeBuilder.of(MSItems.RED_EYES).input((ItemLike)MSItems.NIGHT_CLUB).and().namedInput((ItemLike)Items.SPIDER_EYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.METAL_BAT).input((ItemLike)MSItems.DEUCE_CLUB).and().input((ItemLike)Items.IRON_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CRICKET_BAT).input((ItemLike)MSItems.METAL_BAT).or().input((ItemLike)MSItems.GRASSHOPPER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLOWN_CLUB).input((ItemLike)MSItems.METAL_BAT).or().input((ItemLike)MSItems.HORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DOCTOR_DETERRENT).input((ItemLike)MSItems.SNOW_WHITE_DREAM).and().input((ItemLike)MSItems.DEUCE_CLUB).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPIKED_CLUB).input((ItemLike)MSItems.METAL_BAT).or().input((TagKey<Item>)ItemTags.LOGS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.M_ACE).input((ItemLike)MSItems.MACE).and().input((ItemLike)MSItems.NONBINARY_CODE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DESOLATOR_MACE).input((ItemLike)MSItems.MACE).or().input((ItemLike)Items.FLINT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BLAZING_GLORY).input((ItemLike)MSItems.MACE).and().namedInput((ItemLike)Items.BLAZE_POWDER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.RUBIKS_MACE).input((ItemLike)MSItems.MACE).and().input((ItemLike)MSItems.WATER_COLORS_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.M_ACE_OF_CLUBS).input((ItemLike)MSItems.M_ACE).and().input((ItemLike)MSItems.ACE_OF_CLUBS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HOME_GROWN_MACE).input((ItemLike)MSItems.MACE).and().input((ItemLike)Items.BAMBOO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CARNIE_CLUB).input((ItemLike)MSItems.CLOWN_CLUB).and().input((ItemLike)MSItems.CRYPTID_PHOTO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TOFFEE_CLUB).input((ItemLike)MSItems.METAL_BAT).and().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SLEDGE_HAMMER).input((ItemLike)MSItems.CLAW_HAMMER).and().namedInput((ItemLike)Items.BRICKS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SLEDGE_HAMMER).input((ItemLike)MSItems.CLAW_HAMMER).and().namedInput((ItemLike)Items.COBBLESTONE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MAILBOX).input((ItemLike)MSItems.SLEDGE_HAMMER).and().namedInput((ItemLike)Items.CHEST).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BLACKSMITH_HAMMER).input((ItemLike)MSItems.SLEDGE_HAMMER).and().namedInput((ItemLike)Items.ANVIL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BLACKSMITH_HAMMER).input((ItemLike)MSItems.SLEDGE_HAMMER).and().namedInput((ItemLike)Items.IRON_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.POGO_HAMMER).input((ItemLike)MSItems.SLEDGE_HAMMER).and().input((ItemLike)Items.SLIME_BALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WRINKLEFUCKER).input((ItemLike)MSItems.POGO_HAMMER).or().input((ItemLike)MSItems.CLOTHES_IRON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DEMOCRATIC_DEMOLITIONER).input((ItemLike)MSItems.MAILBOX).or().input((ItemLike)MSItems.FOOD_CAN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BOOMBOX_BEATER).input((ItemLike)MSItems.CASSETTE_PLAYER).or().input((ItemLike)MSItems.SLEDGE_HAMMER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REGI_HAMMER).input((ItemLike)MSItems.CLAW_HAMMER).and().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FEAR_NO_ANVIL).input((ItemLike)MSItems.BLACKSMITH_HAMMER).or().input((ItemLike)Items.CLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TELESCOPIC_SASSACRUSHER).input((ItemLike)MSItems.SLEDGE_HAMMER).and().input((ItemLike)MSItems.SASSACRE_TEXT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MELT_MASHER).input((ItemLike)MSItems.FEAR_NO_ANVIL).or().input((ItemLike)Items.LAVA_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ESTROGEN_EMPOWERED_EVERYTHING_ERADICATOR).input((ItemLike)MSItems.FISSION_FOCUSED_FAULT_FELLER).or().input((ItemLike)MSItems.GAMEGRL_MAGAZINE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EEEEEEEEEEEE).input((ItemLike)MSItems.ESTROGEN_EMPOWERED_EVERYTHING_ERADICATOR).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.POPAMATIC_VRILLYHOO).input((ItemLike)MSItems.ZILLYHOO_HAMMER).and().input((ItemLike)MSItems.FLUORITE_OCTET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCARLET_ZILLYHOO).input((ItemLike)MSItems.ZILLYHOO_HAMMER).and().input((ItemLike)MSItems.FROG).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MWRTHWL).input((ItemLike)MSItems.REGI_HAMMER).or().input((ItemLike)MSItems.CUEBALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WIZARD_STAFF).input((ItemLike)MSItems.MINI_WIZARD_STATUE).and().input((ItemLike)MSItems.CANE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WATER_STAFF).input((ItemLike)MSItems.WIZARD_STAFF).and().input((ItemLike)Items.HEART_OF_THE_SEA).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FIRE_STAFF).input((ItemLike)MSItems.WIZARD_STAFF).and().input((ItemLike)Items.MAGMA_CREAM).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PRIME_STAFF).input((ItemLike)MSItems.BLACK_KINGS_SCEPTER).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.VAUDEVILLE_HOOK).namedInput((ItemLike)MSItems.CANE).and().input((ItemLike)Items.FISHING_ROD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.VAUDEVILLE_HOOK).namedInput((ItemLike)Items.STICK).or().input((ItemLike)MSItems.WISEGUY).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BEAR_POKING_STICK).namedInput((ItemLike)MSItems.CANE).or().input((ItemLike)Items.LEATHER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BEAR_POKING_STICK).namedInput((ItemLike)Items.STICK).or().input((ItemLike)Items.LEATHER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UMBRELLA).input((ItemLike)Items.STICK).and().namedInput((ItemLike)Items.BLACK_WOOL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UMBRELLA).input((ItemLike)Items.STICK).and().namedInput((ItemLike)Items.SHIELD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UMBRELLA).namedInput((ItemLike)MSItems.CANE).and().namedInput((ItemLike)Items.BLACK_WOOL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UMBRELLA).namedInput((ItemLike)MSItems.CANE).and().namedInput((ItemLike)Items.SHIELD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BARBERS_BEST_FRIEND).input((ItemLike)MSItems.UMBRELLA).and().input((ItemLike)MSItems.RAZOR_BLADE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UPPER_CRUST_CRUST_CANE).input((ItemLike)MSItems.PRIM_AND_PROPER_WALKING_POLE).or().namedInput((ItemLike)MSItems.STALE_BAGUETTE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UPPER_CRUST_CRUST_CANE).input((ItemLike)MSItems.PRIM_AND_PROPER_WALKING_POLE).or().namedInput((ItemLike)Items.BREAD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.KISSY_CUTIE_HEART_HITTER).input((ItemLike)MSItems.IRON_CANE).or().input((ItemLike)MSItems.GAMEGRL_MAGAZINE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.KISSY_CUTIE_HEART_SPLITTER).input((ItemLike)MSItems.SCYTHE).or().input((ItemLike)MSItems.GAMEGRL_MAGAZINE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MUTANT_CUTIE_CELL_PUTTER).input((ItemLike)MSItems.KISSY_CUTIE_HEART_HITTER).and().input((ItemLike)MSItems.PLUSH_MUTATED_CAT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MUTANT_CUTIE_CELL_CUTTER).input((ItemLike)MSItems.KISSY_CUTIE_HEART_SPLITTER).and().input((ItemLike)MSItems.PLUSH_MUTATED_CAT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ZEPHYR_CANE).namedInput((ItemLike)MSItems.IRON_CANE).or().namedInput((ItemLike)Items.FEATHER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ZEPHYR_CANE).namedInput((ItemLike)MSItems.IRON_CANE).or().namedInput((ItemLike)Items.PHANTOM_MEMBRANE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPEAR_CANE).input((ItemLike)MSItems.CANE).or().namedInput((ItemLike)Items.IRON_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPEAR_CANE).input((ItemLike)MSItems.CANE).or().namedInput((ItemLike)MSItems.KATANA).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPEAR_CANE).input((ItemLike)MSItems.IRON_CANE).or().namedInput((ItemLike)Items.STONE_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPEAR_CANE).namedInput((ItemLike)MSItems.IRON_CANE).or().namedInput((ItemLike)Items.IRON_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPEAR_CANE).namedInput((ItemLike)MSItems.IRON_CANE).or().namedInput((ItemLike)MSItems.KATANA).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PARADISES_PORTABELLO).input((ItemLike)Items.STICK).or().namedInput((ItemLike)Items.RED_MUSHROOM).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PARADISES_PORTABELLO).input((ItemLike)Items.STICK).or().namedInput((ItemLike)Items.BROWN_MUSHROOM).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REGI_CANE).namedInput((ItemLike)MSItems.CANE).and().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REGI_CANE).namedInput((ItemLike)MSItems.IRON_CANE).and().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.URANIUM_POWERED_STICK).input((ItemLike)Items.STICK).or().input((ItemLike)MSItems.RAW_URANIUM).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_CANE).input((ItemLike)MSItems.VAUDEVILLE_HOOK).and().namedInput((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_CANE).input((ItemLike)MSItems.VAUDEVILLE_HOOK).and().namedInput((ItemLike)MSItems.DIAMOND_MINT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_CANE).input((ItemLike)MSItems.VAUDEVILLE_HOOK).or().namedInput((ItemLike)MSItems.CANDY_SICKLE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PRIM_AND_PROPER_WALKING_POLE).namedInput((ItemLike)MSItems.CANE).and().input((ItemLike)Items.GOLD_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PRIM_AND_PROPER_WALKING_POLE).namedInput((ItemLike)MSItems.VAUDEVILLE_HOOK).and().input((ItemLike)Items.GOLD_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LESS_PROPER_WALKING_STICK).input((ItemLike)MSItems.PRIM_AND_PROPER_WALKING_POLE).and().namedInput((ItemLike)MSItems.KATANA).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LESS_PROPER_WALKING_STICK).input((ItemLike)MSItems.PRIM_AND_PROPER_WALKING_POLE).and().namedInput((ItemLike)MSItems.UNBREAKABLE_KATANA).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LESS_PROPER_WALKING_STICK).input((ItemLike)MSItems.PRIM_AND_PROPER_WALKING_POLE).and().namedInput((ItemLike)MSItems.IRON_CANE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ROCKEFELLERS_WALKING_BLADECANE).input((ItemLike)MSItems.LESS_PROPER_WALKING_STICK).and().input((ItemLike)Items.OBSIDIAN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DRAGON_CANE).input((ItemLike)MSItems.ROCKEFELLERS_WALKING_BLADECANE).or().namedInput((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DRAGON_CANE).input((ItemLike)MSItems.ROCKEFELLERS_WALKING_BLADECANE).or().namedInput((ItemLike)Items.DRAGON_HEAD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CHANCEWYRMS_EXTRA_FORTUNATE_STABBING_IMPLEMENT).input((ItemLike)MSItems.DRAGON_CANE).and().namedInput((ItemLike)MSItems.FLUORITE_OCTET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WOODEN_SPOON).input((ItemLike)Items.WOODEN_SHOVEL).and().namedInput((ItemLike)Items.BOWL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WOODEN_SPOON).input((ItemLike)Items.WOODEN_SHOVEL).and().namedInput((ItemLike)Items.MUSHROOM_STEW).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WOODEN_SPOON).input((ItemLike)Items.WOODEN_SHOVEL).and().namedInput((ItemLike)Items.RABBIT_STEW).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WOODEN_SPOON).input((ItemLike)Items.WOODEN_SHOVEL).and().namedInput((ItemLike)Items.BEETROOT_SOUP).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SILVER_SPOON).input((ItemLike)Items.IRON_SHOVEL).and().namedInput((ItemLike)Items.BOWL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SILVER_SPOON).input((ItemLike)Items.IRON_SHOVEL).and().namedInput((ItemLike)Items.MUSHROOM_STEW).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SILVER_SPOON).input((ItemLike)Items.IRON_SHOVEL).and().namedInput((ItemLike)Items.RABBIT_STEW).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SILVER_SPOON).input((ItemLike)Items.IRON_SHOVEL).and().namedInput((ItemLike)Items.BEETROOT_SOUP).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SILVER_SPOON).namedInput((ItemLike)MSItems.WOODEN_SPOON).and().input((ItemLike)Items.IRON_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MELONBALLER).input((ItemLike)MSItems.SILVER_SPOON).or().namedInput((ItemLike)Items.MELON_SLICE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SIGHTSEEKER).input((ItemLike)MSItems.SILVER_SPOON).or().namedInput((ItemLike)Items.SPIDER_EYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TERRAIN_FLATENATOR).input((ItemLike)Items.IRON_SHOVEL).or().namedInput((ItemLike)Items.PISTON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.NOSFERATU_SPOON).input((ItemLike)MSItems.SILVER_SPOON).or().input((ItemLike)MSItems.GRIMOIRE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.THRONGLER).input((ItemLike)MSItems.NOSFERATU_SPOON).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WET_MEAT_SHIT_THRONGLER).input((ItemLike)MSItems.THRONGLER).and().input((ItemLike)MSItems.MEATFORK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CROCKER_SPOON).input((ItemLike)MSItems.SILVER_SPOON).and().input((ItemLike)Items.CAKE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_FORK).input((ItemLike)MSItems.FORK).or().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TUNING_FORK).input((ItemLike)MSItems.FORK).and().input((ItemLike)Items.NOTE_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ELECTRIC_FORK).input((ItemLike)MSItems.FORK).or().input((ItemLike)MSItems.BATTERY).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EATING_FORK_GEM).input((ItemLike)MSItems.NOSFERATU_SPOON).and().input((ItemLike)Items.PRISMARINE_CRYSTALS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DEVIL_FORK).input((ItemLike)MSItems.NOSFERATU_SPOON).and().input((ItemLike)Items.BLAZE_POWDER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SKAIA_FORK).input((ItemLike)MSItems.FORK).and().input((ItemLike)MSBlocks.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SKAIAN_CROCKER_ROCKER).input((ItemLike)MSItems.SKAIA_FORK).or().input((ItemLike)MSItems.CROCKER_FORK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPORK).input((ItemLike)MSItems.FORK).or().input((ItemLike)MSItems.WOODEN_SPOON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GOLDEN_SPORK).input((ItemLike)MSItems.SPORK).or().input((ItemLike)Items.GOLD_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MEATFORK).input((ItemLike)Items.TRIDENT).and().input((ItemLike)Items.BEEF).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BIDENT).input((ItemLike)MSItems.BI_DYE).and().input((ItemLike)Items.TRIDENT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DOUBLE_ENDED_TRIDENT).input((ItemLike)Items.TRIDENT).or().input((ItemLike)MSItems.MIRROR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EDISONS_FURY).input((ItemLike)MSItems.ELECTRIC_FORK).or().input((ItemLike)Items.REDSTONE_LAMP).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CAT_CLAWS_DRAWN).input((ItemLike)MSItems.MAKESHIFT_CLAWS_DRAWN).and().input((TagKey<Item>)Tags.Items.INGOTS_IRON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.COFFEE_CLAWS_DRAWN).input((ItemLike)MSItems.CAT_CLAWS_DRAWN).and().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.POGO_CLAWS).input((ItemLike)MSItems.MAKESHIFT_CLAWS_DRAWN).and().input((ItemLike)Items.SLIME_BALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ATOMIKITTY_KATAR_DRAWN).input((ItemLike)MSItems.CAT_CLAWS_DRAWN).and().input((ItemLike)MSItems.RAW_URANIUM).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SKELETONIZER_DRAWN).input((ItemLike)MSItems.CAT_CLAWS_DRAWN).or().input((ItemLike)Items.BONE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SKELETON_DISPLACER_DRAWN).input((ItemLike)MSItems.SKELETONIZER_DRAWN).and().input((ItemLike)Items.ENDER_EYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TEARS_OF_THE_ENDERLICH_DRAWN).input((ItemLike)MSItems.SKELETON_DISPLACER_DRAWN).and().input((ItemLike)Items.GHAST_TEAR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LION_LACERATORS_DRAWN).input((ItemLike)MSItems.TEARS_OF_THE_ENDERLICH_DRAWN).or().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ACTION_CLAWS_DRAWN).input((ItemLike)MSItems.CAT_CLAWS_DRAWN).and().input((ItemLike)MSItems.FLUORITE_OCTET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LIPSTICK).input((ItemLike)MSItems.LIP_BALM).and().input((ItemLike)Items.GREEN_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CAKESAW).input((ItemLike)MSItems.LIPSTICK_CHAINSAW).or().input((ItemLike)Items.CAKE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MAGENTA_MAULER).input((ItemLike)MSItems.LIPSTICK_CHAINSAW).and().input((ItemLike)Items.LILAC).build(consumer);
        CombinationRecipeBuilder.of(MSItems.THISTLEBLOWER).input((ItemLike)MSItems.LIPSTICK_CHAINSAW).or().input((ItemLike)Items.ROSE_BUSH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HAND_CRANKED_VAMPIRE_ERASER).input((ItemLike)MSItems.POINTY_STICK).or().input((ItemLike)MSItems.LIPSTICK_CHAINSAW).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EMERALD_IMMOLATOR).input((ItemLike)MSItems.LIPSTICK_CHAINSAW).and().input((ItemLike)MSItems.EMERALD_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FROSTTOOTH).input((ItemLike)MSItems.EMERALD_IMMOLATOR).or().input((ItemLike)MSItems.CLUB_ZERO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.OBSIDIATOR).input((ItemLike)MSItems.FROSTTOOTH).and().input((ItemLike)Items.OBSIDIAN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DEVILS_DELIGHT).input((ItemLike)MSItems.OBSIDIATOR).and().input((ItemLike)MSItems.CRYPTID_PHOTO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DEMONBANE_RAGRIPPER).input((ItemLike)MSItems.DEVILS_DELIGHT).and().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CHAINSAW_KATANA).input((ItemLike)MSItems.LIPSTICK_CHAINSAW).and().input((ItemLike)MSItems.KATANA).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LANEC).input((ItemLike)MSItems.WOODEN_LANCE).and().input((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.JOUSTING_LANCE).input((ItemLike)MSItems.WOODEN_LANCE).and().input((TagKey<Item>)Tags.Items.INGOTS_IRON).build(consumer);
        CombinationRecipeBuilder.of(MSItems.POGO_LANCE).input((ItemLike)MSItems.JOUSTING_LANCE).and().input((ItemLike)Items.SLIME_BALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LANCELOTS_LOLLY).input((ItemLike)MSItems.JOUSTING_LANCE).and().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DRAGON_LANCE).input((ItemLike)MSItems.JOUSTING_LANCE).and().input((ItemLike)MSItems.SCALEMATE_APPLESCAB).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SKY_PIERCER).input((ItemLike)MSItems.DRAGON_LANCE).or().input((ItemLike)MSItems.STAR_RAY).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FIDUSPAWN_LANCE).input((ItemLike)MSItems.DRAGON_LANCE).or().input((ItemLike)MSItems.URANIUM_GUMMY_BEAR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REGILANCE).input((ItemLike)MSItems.JOUSTING_LANCE).or().input((ItemLike)MSItems.CHESSBOARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CIGARETTE_LANCE).input((ItemLike)MSItems.REGILANCE).and().input((ItemLike)MSItems.EIGHTBALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LUCERNE_HAMMER).input((ItemLike)MSItems.SPEAR_CANE).and().namedInput((ItemLike)MSItems.CLAW_HAMMER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LUCERNE_HAMMER_OF_UNDYING).input((ItemLike)MSItems.LUCERNE_HAMMER).or().namedInput((ItemLike)Items.TOTEM_OF_UNDYING).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_FAN).input((ItemLike)MSItems.FAN).and().input((ItemLike)MSItems.CANDY_CORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPINES_OF_FLUTHLU).input((ItemLike)MSItems.FAN).and().input((ItemLike)MSItems.GRIMOIRE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.RAZOR_FAN).input((ItemLike)MSItems.FAN).and().input((ItemLike)MSItems.RAZOR_BLADE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MOTOR_FAN).input((ItemLike)MSItems.RAZOR_FAN).and().input((ItemLike)MSItems.BATTERY).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ATOMIC_VAPORIZER).input((ItemLike)MSItems.MOTOR_FAN).or().input((ItemLike)MSItems.QUANTUM_SABRE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SHAVING_FAN).input((ItemLike)MSItems.RAZOR_FAN).and().input((ItemLike)MSItems.BARBASOL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FIRESTARTER).input((ItemLike)MSItems.RAZOR_FAN).or().input((ItemLike)MSItems.BLAZING_GLORY).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STAR_RAY).input((ItemLike)MSItems.FIRESTARTER).or().input((ItemLike)MSItems.SUNRAY_HARVESTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TYPHONIC_TRIVIALIZER).input((ItemLike)MSItems.FAN).or().namedInput((ItemLike)MSBlocks.SMOOTH_SHADE_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WAND).input((ItemLike)MSItems.MINI_WIZARD_STATUE).or().input((ItemLike)Items.STICK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.NEEDLE_WAND).input((ItemLike)MSItems.KNITTING_NEEDLE).and().namedInput((ItemLike)MSBlocks.MINI_WIZARD_STATUE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ARTIFUCKER).input((ItemLike)MSItems.POINTER_WAND).and().namedInput((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.POINTER_WAND).input((ItemLike)MSItems.NEEDLE_WAND).and().namedInput((ItemLike)MSBlocks.COMPUTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.POOL_CUE_WAND).input((ItemLike)MSItems.NEEDLE_WAND).and().namedInput((ItemLike)MSItems.CUESTICK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.THORN_OF_OGLOGOTH).input((ItemLike)MSItems.NEEDLE_WAND).and().namedInput((ItemLike)MSItems.GRIMOIRE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SBAHJARANG).input((ItemLike)MSItems.SHURIKEN).and().namedInput((ItemLike)MSItems.SBAHJ_POSTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CLUBS_SUITARANG).input((ItemLike)MSItems.SHURIKEN).and().namedInput((ItemLike)MSItems.ACE_OF_CLUBS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DIAMONDS_SUITARANG).input((ItemLike)MSItems.SHURIKEN).and().namedInput((ItemLike)MSItems.ACE_OF_DIAMONDS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HEARTS_SUITARANG).input((ItemLike)MSItems.SHURIKEN).and().namedInput((ItemLike)MSItems.ACE_OF_HEARTS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPADES_SUITARANG).input((ItemLike)MSItems.SHURIKEN).and().namedInput((ItemLike)MSItems.ACE_OF_SPADES).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CHAKRAM).input((ItemLike)MSItems.SHURIKEN).or().namedInput((ItemLike)Items.ENDER_EYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UMBRAL_INFILTRATOR).input((ItemLike)MSItems.CHAKRAM).or().namedInput((ItemLike)Items.OBSIDIAN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SORCERERS_PINBALL).input((ItemLike)Items.IRON_BLOCK).or().namedInput((ItemLike)MSBlocks.MINI_WIZARD_STATUE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LAPTOP).input((ItemLike)MSBlocks.COMPUTER).and().namedInput((ItemLike)MSItems.BATTERY).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LAPTOP).input((ItemLike)MSBlocks.COMPUTER).and().namedInput((ItemLike)Items.BOOK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CROCKERTOP).input((ItemLike)MSBlocks.LAPTOP).and().namedInput((ItemLike)MSItems.CROCKER_SPOON).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CROCKERTOP).input((ItemLike)MSBlocks.LAPTOP).and().namedInput((ItemLike)MSItems.CROCKER_FORK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.HUBTOP).input((ItemLike)MSBlocks.LAPTOP).and().input((ItemLike)MSBlocks.POWER_HUB).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LUNCHTOP).input((ItemLike)MSBlocks.LAPTOP).and().input((ItemLike)Items.APPLE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.OLD_COMPUTER).input((ItemLike)MSBlocks.COMPUTER).and().input((ItemLike)Items.CLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GRIST_WIDGET).namedInput((ItemLike)MSItems.CROCKER_SPOON).or().input((ItemLike)MSItems.CAPTCHA_CARD).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GRIST_WIDGET).namedInput((ItemLike)MSItems.CROCKER_FORK).or().input((ItemLike)MSItems.CAPTCHA_CARD).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GRIST_COLLECTOR).input((ItemLike)MSItems.ITEM_MAGNET).or().input((ItemLike)Items.CHEST).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.ANTHVIL).input((ItemLike)MSBlocks.POWER_HUB).and().input((ItemLike)Items.ANVIL).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.POWER_HUB).input((ItemLike)MSItems.ENERGY_CORE).and().input((ItemLike)MSItems.BATTERY).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.TRANSPORTALIZER).input((ItemLike)Items.ENDER_PEARL).and().input((ItemLike)Items.IRON_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CAPTCHAROID_CAMERA).input((ItemLike)MSItems.CAPTCHA_CARD).and().namedInput((ItemLike)MSBlocks.COMPUTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CAPTCHAROID_CAMERA).input((ItemLike)MSItems.CAPTCHA_CARD).or().namedInput((ItemLike)Items.ENDER_EYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.QUEUESTACK_MODUS_CARD).input((ItemLike)MSItems.STACK_MODUS_CARD).and().input((ItemLike)MSItems.QUEUE_MODUS_CARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TREE_MODUS_CARD).input(MSTags.Items.MODUS_CARD).or().namedInput((ItemLike)Items.STICK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TREE_MODUS_CARD).input(MSTags.Items.MODUS_CARD).or().namedInput((TagKey<Item>)ItemTags.SAPLINGS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TREE_MODUS_CARD).input(MSTags.Items.MODUS_CARD).or().namedInput((TagKey<Item>)ItemTags.LEAVES).build(consumer);
        CombinationRecipeBuilder.of(MSItems.HASHMAP_MODUS_CARD).input(MSTags.Items.MODUS_CARD).and().input((ItemLike)MSBlocks.COMPUTER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SET_MODUS_CARD).input(MSTags.Items.MODUS_CARD).and().input((ItemLike)Items.ITEM_FRAME).build(consumer);
        CombinationRecipeBuilder.of(MSItems.IRON_BOAT).input((TagKey<Item>)ItemTags.BOATS).and().namedInput((ItemLike)Items.MINECART).build(consumer);
        CombinationRecipeBuilder.of(MSItems.IRON_BOAT).input((TagKey<Item>)ItemTags.BOATS).and().namedInput((ItemLike)Items.IRON_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.IRON_BOAT).input((TagKey<Item>)ItemTags.BOATS).and().namedInput((ItemLike)Items.IRON_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GOLD_BOAT).input((TagKey<Item>)ItemTags.BOATS).and().namedInput((ItemLike)Items.GOLD_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GOLD_BOAT).input((TagKey<Item>)ItemTags.BOATS).and().namedInput((ItemLike)Items.GOLD_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CARDBOARD_TUBE).input((ItemLike)Items.STICK).or().input((ItemLike)Items.PAPER).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GOLD_SEEDS).input((ItemLike)Items.WHEAT_SEEDS).and().namedInput((ItemLike)Items.GOLD_NUGGET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GOLD_SEEDS).input((ItemLike)Items.WHEAT_SEEDS).and().namedInput((ItemLike)Items.GOLD_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.OBSIDIAN_BUCKET).input((ItemLike)Items.WATER_BUCKET).or().input((ItemLike)Items.LAVA_BUCKET).namedSource("buckets").build(consumer);
        CombinationRecipeBuilder.of(MSItems.OBSIDIAN_BUCKET).input((ItemLike)Items.BUCKET).and().namedInput((ItemLike)Items.OBSIDIAN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STONE_TABLET).input((ItemLike)Items.STONE).or().namedInput((ItemLike)MSItems.CARVING_TOOL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STONE_TABLET).input((ItemLike)Items.STONE).or().namedInput((ItemLike)Items.WRITABLE_BOOK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.STONE_TABLET).input((ItemLike)Items.STONE).or().namedInput((ItemLike)MSItems.CAPTCHA_CARD).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GLOWYSTONE_DUST).input((ItemLike)Items.REDSTONE).or().input((ItemLike)Items.GLOWSTONE_DUST).build(consumer);
        CombinationRecipeBuilder.of(MSItems.COCOA_WART).input((ItemLike)Items.COCOA_BEANS).and().input((ItemLike)Items.NETHER_WART).build(consumer);
        CombinationRecipeBuilder.of((ItemLike)MSBlocks.HORSE_CLOCK.getMainBlock()).input((ItemLike)Items.SADDLE).or().input((ItemLike)MSBlocks.REDSTONE_CLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_13).input((ItemLike)Items.MUSIC_DISC_13).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_CAT).input((ItemLike)Items.MUSIC_DISC_CAT).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_BLOCKS).input((ItemLike)Items.MUSIC_DISC_BLOCKS).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_CHIRP).input((ItemLike)Items.MUSIC_DISC_CHIRP).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_FAR).input((ItemLike)Items.MUSIC_DISC_FAR).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_MALL).input((ItemLike)Items.MUSIC_DISC_MALL).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_MELLOHI).input((ItemLike)Items.MUSIC_DISC_MELLOHI).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_EMISSARY).input((ItemLike)MSItems.MUSIC_DISC_EMISSARY_OF_DANCE).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_DANCE_STAB).input((ItemLike)MSItems.MUSIC_DISC_DANCE_STAB_DANCE).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_RETRO_BATTLE).input((ItemLike)MSItems.MUSIC_DISC_RETRO_BATTLE).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_11).input((ItemLike)Items.MUSIC_DISC_11).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_PIGSTEP).input((ItemLike)Items.MUSIC_DISC_PIGSTEP).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_STAL).input((ItemLike)Items.MUSIC_DISC_STAL).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_STRAD).input((ItemLike)Items.MUSIC_DISC_STRAD).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_WAIT).input((ItemLike)Items.MUSIC_DISC_WAIT).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_WARD).input((ItemLike)Items.MUSIC_DISC_WARD).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_OTHERSIDE).input((ItemLike)Items.MUSIC_DISC_OTHERSIDE).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CASSETTE_5).input((ItemLike)Items.MUSIC_DISC_5).or().namedInput((ItemLike)MSBlocks.CASSETTE_PLAYER).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLUE_DIRT).input((ItemLike)Items.DIRT).or().input((ItemLike)Items.BLUE_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.THOUGHT_DIRT).input((ItemLike)Items.DIRT).or().input((ItemLike)Items.LIME_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.COARSE_END_STONE).input((ItemLike)Items.COARSE_DIRT).or().input((ItemLike)Items.END_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.END_GRASS).namedInput((ItemLike)Items.GRASS_BLOCK).or().input((ItemLike)Items.END_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.END_GRASS).namedInput((ItemLike)Items.MYCELIUM).or().input((ItemLike)Items.END_STONE).build(consumer);
        CombinationRecipeBuilder.of((ItemLike)Items.GRASS_BLOCK).namedInput((ItemLike)MSBlocks.END_GRASS).and().input((ItemLike)Items.DIRT).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.VINE_LOG).input((ItemLike)Items.OAK_LOG).and().input((ItemLike)Items.VINE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FLOWERY_VINE_LOG).input((ItemLike)MSBlocks.VINE_LOG).or().input((TagKey<Item>)ItemTags.SMALL_FLOWERS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GLOWING_MUSHROOM).input((ItemLike)Items.BROWN_MUSHROOM).or().input((ItemLike)Items.GLOWSTONE_DUST).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GLOWING_MUSHROOM_VINES).input((ItemLike)MSItems.GLOWING_MUSHROOM_VINES).and().input((ItemLike)Items.VINE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GLOWING_LOG).input((TagKey<Item>)ItemTags.LOGS).or().input((ItemLike)MSBlocks.GLOWING_MUSHROOM).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GLOWING_PLANKS).input((TagKey<Item>)ItemTags.PLANKS).or().input((ItemLike)MSBlocks.GLOWING_MUSHROOM).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GLOWY_GOOP).input((ItemLike)Items.SLIME_BLOCK).or().input((ItemLike)MSBlocks.GLOWING_MUSHROOM).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.COAGULATED_BLOOD).input((ItemLike)Items.SLIME_BLOCK).and().input((ItemLike)MSItems.BLOOD_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PETRIFIED_POPPY).namedInput((ItemLike)Items.STONE).or().input((ItemLike)Items.POPPY).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PETRIFIED_POPPY).namedInput((ItemLike)Items.GRAVEL).or().input((ItemLike)Items.POPPY).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PETRIFIED_POPPY).namedInput((ItemLike)Items.COBBLESTONE).or().input((ItemLike)Items.POPPY).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PETRIFIED_LOG).namedInput((ItemLike)Items.STONE).or().input((TagKey<Item>)ItemTags.LOGS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PETRIFIED_LOG).namedInput((ItemLike)Items.GRAVEL).or().input((TagKey<Item>)ItemTags.LOGS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PETRIFIED_LOG).namedInput((ItemLike)Items.COBBLESTONE).or().input((TagKey<Item>)ItemTags.LOGS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CINDERED_LOG).input((TagKey<Item>)ItemTags.LOGS).or().namedInput((ItemLike)Items.MAGMA_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CINDERED_LOG).input((TagKey<Item>)ItemTags.LOGS).or().namedInput((ItemLike)Items.MAGMA_CREAM).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CINDERED_LOG).input((TagKey<Item>)ItemTags.LOGS).or().namedInput((ItemLike)Items.LAVA_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CINDERED_PLANKS).input((TagKey<Item>)ItemTags.PLANKS).or().namedInput((ItemLike)Items.MAGMA_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CINDERED_PLANKS).input((TagKey<Item>)ItemTags.PLANKS).or().namedInput((ItemLike)Items.MAGMA_CREAM).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CINDERED_PLANKS).input((TagKey<Item>)ItemTags.PLANKS).or().namedInput((ItemLike)Items.LAVA_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLOOMING_CACTUS).input((ItemLike)Items.CACTUS).and().input((TagKey<Item>)ItemTags.SMALL_FLOWERS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GLOWFLOWER).input((ItemLike)Items.GLOWSTONE_DUST).and().input((TagKey<Item>)ItemTags.SMALL_FLOWERS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SUGAR_CUBE).input((ItemLike)Items.COOKIE).and().input((ItemLike)Items.REDSTONE_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOODEN_CACTUS).input((ItemLike)Items.CACTUS).or().namedInput((ItemLike)Items.WOODEN_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOODEN_CACTUS).input((ItemLike)Items.CACTUS).or().namedInput((TagKey<Item>)ItemTags.PLANKS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOODEN_CACTUS).input((ItemLike)Items.CACTUS).or().namedInput((TagKey<Item>)ItemTags.LOGS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.RAINBOW_SAPLING).input((ItemLike)MSBlocks.RAINBOW_LEAVES).or().input((ItemLike)MSBlocks.RAINBOW_LOG).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.END_SAPLING).input((ItemLike)MSBlocks.END_LEAVES).or().input((ItemLike)MSBlocks.END_LOG).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SHADEWOOD_SAPLING).input((ItemLike)MSBlocks.SHADEWOOD_LEAVES).or().input((ItemLike)MSBlocks.SHADEWOOD_LOG).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SPIKES).input((ItemLike)Items.CACTUS).and().input((ItemLike)Items.IRON_SWORD).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.COARSE_STONE).input((ItemLike)Items.STONE).and().input((ItemLike)Items.BASALT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CHISELED_COARSE_STONE).input((ItemLike)Items.CHISELED_STONE_BRICKS).and().namedInput((ItemLike)Items.GRAVEL).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CHISELED_COARSE_STONE).input((ItemLike)Items.CHISELED_STONE_BRICKS).and().namedInput((ItemLike)MSBlocks.COARSE_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SHADE_STONE).input((ItemLike)Items.STONE).or().namedInput((ItemLike)MSBlocks.BLUE_DIRT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SHADE_STONE).input((ItemLike)Items.STONE).or().namedInput((ItemLike)Items.BLUE_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SHADE_BRICKS).input((ItemLike)Items.STONE_BRICKS).or().namedInput((ItemLike)MSBlocks.BLUE_DIRT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SHADE_BRICKS).input((ItemLike)Items.STONE_BRICKS).or().namedInput((ItemLike)Items.LAPIS_LAZULI).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SMOOTH_SHADE_STONE).input((ItemLike)Items.SMOOTH_STONE).or().namedInput((ItemLike)MSBlocks.BLUE_DIRT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SMOOTH_SHADE_STONE).input((ItemLike)Items.SMOOTH_STONE).or().namedInput((ItemLike)Items.LAPIS_LAZULI).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SHADE_BRICK_STAIRS).input((ItemLike)Items.STONE_BRICK_STAIRS).or().namedInput((ItemLike)MSBlocks.BLUE_DIRT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SHADE_BRICK_STAIRS).input((ItemLike)Items.STONE_BRICK_STAIRS).or().namedInput((ItemLike)Items.LAPIS_LAZULI).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.TAR_SHADE_BRICKS).input((ItemLike)MSBlocks.SHADE_BRICKS).and().namedInput((ItemLike)MSItems.OIL_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_TILE).input((TagKey<Item>)Tags.Items.STONES).and().namedInput((ItemLike)Items.ICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_TILE).input((TagKey<Item>)Tags.Items.STONES).and().namedInput((ItemLike)Items.PACKED_ICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_BRICKS).input((ItemLike)Items.STONE_BRICKS).and().namedInput((ItemLike)Items.ICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_BRICKS).input((ItemLike)Items.STONE_BRICKS).and().namedInput((ItemLike)Items.PACKED_ICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CHISELED_FROST_BRICKS).input((ItemLike)Items.CHISELED_STONE_BRICKS).and().namedInput((ItemLike)Items.ICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CHISELED_FROST_BRICKS).input((ItemLike)Items.CHISELED_STONE_BRICKS).and().namedInput((ItemLike)Items.PACKED_ICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SUSPICIOUS_CHISELED_MYCELIUM_BRICKS).input((ItemLike)MSBlocks.CHISELED_MYCELIUM_BRICKS).or().namedInput((ItemLike)MSItems.SUSHROOM).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CAST_IRON).input((ItemLike)Items.IRON_BLOCK).and().input((ItemLike)Items.LAVA_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CHISELED_CAST_IRON).input((ItemLike)Items.CHISELED_STONE_BRICKS).or().input((ItemLike)MSBlocks.CAST_IRON).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CAST_IRON_TILE).input((ItemLike)MSBlocks.CAST_IRON).and().input((ItemLike)Blocks.COPPER_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CAST_IRON_SHEET).input((ItemLike)MSBlocks.CAST_IRON).and().input((TagKey<Item>)ItemTags.PLANKS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CAST_IRON_FRAME).input((ItemLike)MSBlocks.CAST_IRON).or().input((ItemLike)Blocks.SCAFFOLDING).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.STEEL_BEAM).input((ItemLike)Items.QUARTZ_PILLAR).and().input((ItemLike)Blocks.IRON_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.MYCELIUM_STONE).input((TagKey<Item>)Tags.Items.STONES).and().input((ItemLike)Items.MYCELIUM).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLACK_STONE).input((TagKey<Item>)Tags.Items.STONES).and().namedInput((ItemLike)Items.BLACK_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLACK_STONE).input((ItemLike)Items.STONE).or().namedInput((ItemLike)Items.MAGMA_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLACK_STONE_BRICKS).namedInput((ItemLike)Items.STONE_BRICKS).and().namedInput((ItemLike)Items.BLACK_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLACK_STONE_BRICKS).namedInput((ItemLike)Items.BRICKS).and().namedInput((ItemLike)MSBlocks.BLACK_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLACK_SAND).input((ItemLike)Items.SAND).and().namedInput((ItemLike)Items.BLACK_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLACK_SAND).input((ItemLike)Items.SAND).or().namedInput((ItemLike)Items.MAGMA_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.IGNEOUS_STONE).input((ItemLike)Items.BLACKSTONE).or().input((ItemLike)MSBlocks.BLACK_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.POLISHED_IGNEOUS_BRICKS).input((ItemLike)Items.BRICKS).and().input((ItemLike)MSBlocks.IGNEOUS_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.MAGMATIC_IGNEOUS_STONE).input((ItemLike)MSBlocks.IGNEOUS_STONE).or().input((ItemLike)Items.MAGMA_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.IGNEOUS_SPIKE).input((ItemLike)MSBlocks.IGNEOUS_STONE).or().input((ItemLike)Items.POINTED_DRIPSTONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PUMICE_STONE).input((ItemLike)Items.SPONGE).or().namedInput((ItemLike)Items.MAGMA_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PUMICE_BRICKS).input((ItemLike)Items.BRICKS).or().input((ItemLike)MSBlocks.PUMICE_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PUMICE_TILES).input((ItemLike)Items.POLISHED_ANDESITE).or().input((ItemLike)MSBlocks.PUMICE_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.HEAT_LAMP).input((ItemLike)MSItems.MOLTEN_AMBER_BUCKET).or().input((ItemLike)Items.SHROOMLIGHT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FLOWERY_MOSSY_COBBLESTONE).input((ItemLike)Items.MOSSY_COBBLESTONE).or().input((TagKey<Item>)ItemTags.SMALL_FLOWERS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FLOWERY_MOSSY_STONE_BRICKS).input((ItemLike)Items.MOSSY_STONE_BRICKS).or().input((TagKey<Item>)ItemTags.SMALL_FLOWERS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CHALK).input((TagKey<Item>)Tags.Items.STONES).or().namedInput((ItemLike)Items.NAUTILUS_SHELL).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CHALK).input((TagKey<Item>)Tags.Items.STONES).and().namedInput((ItemLike)Items.WHITE_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PINK_STONE).input((TagKey<Item>)Tags.Items.STONES).and().namedInput((ItemLike)Items.PINK_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BROWN_STONE).input((TagKey<Item>)Tags.Items.STONES).and().namedInput((ItemLike)Items.BROWN_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.GREEN_STONE).input((TagKey<Item>)Tags.Items.STONES).and().namedInput((ItemLike)Items.GREEN_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CARVED_LOG).input((TagKey<Item>)ItemTags.LOGS).or().input((ItemLike)Items.HONEY_BOTTLE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CARVED_WOODEN_LEAF).input((TagKey<Item>)ItemTags.LEAVES).or().input((ItemLike)Items.BOWL).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.UNCARVED_WOOD).input((TagKey<Item>)ItemTags.LOGS).and().input((ItemLike)Items.SMOOTH_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CARVED_HEAVY_PLANKS).input((TagKey<Item>)ItemTags.LOGS).and().input((ItemLike)Items.STONE_BRICKS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CARVED_KNOTTED_WOOD).input((TagKey<Item>)ItemTags.LOGS).and().input((ItemLike)Items.CHISELED_STONE_BRICKS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.POLISHED_UNCARVED_WOOD).input((TagKey<Item>)ItemTags.LOGS).and().input((ItemLike)Items.POLISHED_ANDESITE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CARVED_PLANKS).input((TagKey<Item>)ItemTags.PLANKS).and().input((ItemLike)Items.STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CHIPBOARD).input((TagKey<Item>)ItemTags.LOGS).and().input((ItemLike)Items.COBBLESTONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOOD_SHAVINGS).input((TagKey<Item>)ItemTags.LOGS).or().namedInput((ItemLike)Items.STONECUTTER).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOOD_SHAVINGS).input((TagKey<Item>)ItemTags.LOGS).or().namedInput((ItemLike)MSItems.CARVING_TOOL).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOODEN_GRASS).input((TagKey<Item>)ItemTags.PLANKS).or().input((ItemLike)Items.SHORT_GRASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CARVED_BUSH).input((ItemLike)MSItems.UNCARVED_WOOD).or().namedInput((TagKey<Item>)ItemTags.SAPLINGS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSItems.CARVED_BUSH).input((ItemLike)MSItems.UNCARVED_WOOD).or().namedInput((TagKey<Item>)ItemTags.LEAVES).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.TREATED_UNCARVED_WOOD).input((ItemLike)MSItems.UNCARVED_WOOD).or().input((ItemLike)MSItems.MOLTEN_AMBER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.TREATED_CHIPBOARD).input((ItemLike)MSItems.CHIPBOARD).or().input((ItemLike)MSItems.MOLTEN_AMBER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.TREATED_WOOD_SHAVINGS).input((ItemLike)MSItems.WOOD_SHAVINGS).or().input((ItemLike)MSItems.MOLTEN_AMBER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.TREATED_HEAVY_PLANKS).input((ItemLike)MSItems.CARVED_HEAVY_PLANKS).or().input((ItemLike)MSItems.MOLTEN_AMBER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.TREATED_PLANKS).input((ItemLike)MSItems.CARVED_PLANKS).or().input((ItemLike)MSItems.MOLTEN_AMBER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.POLISHED_TREATED_UNCARVED_WOOD).input((ItemLike)MSItems.POLISHED_UNCARVED_WOOD).or().input((ItemLike)MSItems.MOLTEN_AMBER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.TREATED_CARVED_KNOTTED_WOOD).input((ItemLike)MSItems.CARVED_KNOTTED_WOOD).or().input((ItemLike)MSItems.MOLTEN_AMBER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.TREATED_WOODEN_GRASS).input((ItemLike)MSItems.WOODEN_GRASS).or().input((ItemLike)MSItems.MOLTEN_AMBER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LACQUERED_UNCARVED_WOOD).input((ItemLike)MSItems.TREATED_UNCARVED_WOOD).or().input((ItemLike)Items.HONEYCOMB_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LACQUERED_CHIPBOARD).input((ItemLike)MSItems.TREATED_CHIPBOARD).or().input((ItemLike)Items.HONEYCOMB_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LACQUERED_WOOD_SHAVINGS).input((ItemLike)MSItems.TREATED_WOOD_SHAVINGS).or().input((ItemLike)Items.HONEYCOMB_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LACQUERED_HEAVY_PLANKS).input((ItemLike)MSItems.TREATED_HEAVY_PLANKS).or().input((ItemLike)Items.HONEYCOMB_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LACQUERED_PLANKS).input((ItemLike)MSItems.TREATED_PLANKS).or().input((ItemLike)Items.HONEYCOMB_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.POLISHED_LACQUERED_UNCARVED_WOOD).input((ItemLike)MSItems.POLISHED_TREATED_UNCARVED_WOOD).or().input((ItemLike)Items.HONEYCOMB_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LACQUERED_CARVED_KNOTTED_WOOD).input((ItemLike)MSItems.TREATED_CARVED_KNOTTED_WOOD).or().input((ItemLike)Items.HONEYCOMB_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LACQUERED_WOODEN_MUSHROOM).input((ItemLike)MSItems.LACQUERED_UNCARVED_WOOD).or().input((ItemLike)Items.BROWN_MUSHROOM).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOODEN_LAMP).input((ItemLike)MSItems.LACQUERED_UNCARVED_WOOD).or().namedInput((ItemLike)Items.OCHRE_FROGLIGHT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOODEN_LAMP).input((ItemLike)MSItems.LACQUERED_UNCARVED_WOOD).or().namedInput((ItemLike)Items.PEARLESCENT_FROGLIGHT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOODEN_LAMP).input((ItemLike)MSItems.LACQUERED_UNCARVED_WOOD).or().namedInput((ItemLike)Items.VERDANT_FROGLIGHT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_PLANKS).input((TagKey<Item>)ItemTags.PLANKS).or().namedInput((ItemLike)Items.SNOW_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_PLANKS).input((TagKey<Item>)ItemTags.PLANKS).or().namedInput((ItemLike)Items.SNOW).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_PLANKS).input((TagKey<Item>)ItemTags.PLANKS).or().namedInput((ItemLike)Items.SNOWBALL).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_LOG).input((TagKey<Item>)ItemTags.LOGS).or().namedInput((ItemLike)Items.SNOW_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_LOG).input((TagKey<Item>)ItemTags.LOGS).or().namedInput((ItemLike)Items.SNOW).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.FROST_LOG).input((TagKey<Item>)ItemTags.LOGS).or().namedInput((ItemLike)Items.SNOWBALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_CORN).input((ItemLike)Items.SUGAR).and().input((ItemLike)Items.WHEAT_SEEDS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TUIX_BAR).input((ItemLike)Items.COCOA_BEANS).or().input((ItemLike)Items.BRICK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GOLDEN_GRASSHOPPER).input((ItemLike)MSItems.GRASSHOPPER).or().input((ItemLike)Items.GOLD_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BUG_NET).input((ItemLike)Items.STICK).or().namedInput((ItemLike)Items.COBWEB).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BUG_NET).input((ItemLike)Items.STRING).and().namedInput((ItemLike)Items.BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.MIRROR).input((ItemLike)Items.PAINTING).or().input((ItemLike)Items.WATER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PARTICLE_ACCELERATOR).input((ItemLike)Items.REPEATER).or().input((ItemLike)MSItems.ENERGY_CORE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.OIL_BUCKET).input((ItemLike)Items.LAVA_BUCKET).and().input((ItemLike)Items.BONE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BLOOD_BUCKET).input((ItemLike)Items.WATER_BUCKET).and().input((ItemLike)Items.ROTTEN_FLESH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BRAIN_JUICE_BUCKET).input((ItemLike)Items.WATER_BUCKET).and().input((ItemLike)Items.SLIME_BALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WATER_COLORS_BUCKET).input((ItemLike)Items.WATER_BUCKET).and().input((TagKey<Item>)Tags.Items.DYES).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ENDER_BUCKET).input((ItemLike)Items.LAVA_BUCKET).and().input((ItemLike)Items.ENDER_PEARL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LIGHT_WATER_BUCKET).input((ItemLike)Items.WATER_BUCKET).and().input((ItemLike)Items.GLOWSTONE_DUST).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CAULK_BUCKET).input((ItemLike)Items.WATER_BUCKET).and().input((ItemLike)Items.AMETHYST_SHARD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MOLTEN_AMBER_BUCKET).input((ItemLike)Items.LAVA_BUCKET).and().input((ItemLike)Items.HONEY_BOTTLE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.UNKNOWABLE_EGG).input((ItemLike)MSItems.SURPRISE_EMBRYO).or().input((ItemLike)MSItems.GRIMOIRE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.LONG_FORGOTTEN_WARHORN).input((ItemLike)Items.NOTE_BLOCK).and().input((ItemLike)MSItems.GRIMOIRE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CRUXITE_BLOCK).input((ItemLike)MSItems.RAW_CRUXITE).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.URANIUM_BLOCK).input((ItemLike)MSItems.RAW_URANIUM).or().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.PIPE).input((ItemLike)Items.HOPPER).or().namedInput((ItemLike)Items.BAMBOO).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.PIPE_INTERSECTION).input((ItemLike)MSBlocks.CHALK).and().input((ItemLike)Items.CHISELED_STONE_BRICKS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.PARCEL_PYXIS).input((ItemLike)MSBlocks.PIPE).or().input((ItemLike)MSItems.MAILBOX).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.TRAJECTORY_BLOCK).input((ItemLike)Items.POWERED_RAIL).or().input((ItemLike)Items.SLIME_BLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.STAT_STORER).input((ItemLike)MSItems.COMPUTER_PARTS).and().input((ItemLike)MSBlocks.REMOTE_OBSERVER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.REMOTE_OBSERVER).input((ItemLike)Items.OBSERVER).or().input((ItemLike)MSItems.PLUTONIUM_CORE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.WIRELESS_REDSTONE_TRANSMITTER).input((ItemLike)Items.REPEATER).or().input((ItemLike)MSItems.PLUTONIUM_CORE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.WIRELESS_REDSTONE_RECEIVER).input((ItemLike)Items.COMPARATOR).or().input((ItemLike)MSItems.PLUTONIUM_CORE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.SOLID_SWITCH).input((ItemLike)Items.LEVER).and().input((ItemLike)Items.REDSTONE_LAMP).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.VARIABLE_SOLID_SWITCH).input((ItemLike)MSBlocks.SOLID_SWITCH).or().input((ItemLike)Items.COMPARATOR).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.ONE_SECOND_INTERVAL_TIMED_SOLID_SWITCH).input((ItemLike)MSBlocks.SOLID_SWITCH).or().input((ItemLike)Items.STONE_BUTTON).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.TWO_SECOND_INTERVAL_TIMED_SOLID_SWITCH).input((ItemLike)MSBlocks.SOLID_SWITCH).or().input((TagKey<Item>)ItemTags.WOODEN_BUTTONS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.PLATFORM_GENERATOR).input((ItemLike)Items.PISTON).or().input((ItemLike)Items.SHIELD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.PLATFORM_RECEPTACLE).input((ItemLike)Items.DAYLIGHT_DETECTOR).or().input((ItemLike)Items.IRON_BLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.ITEM_MAGNET).input((ItemLike)MSItems.PLUTONIUM_CORE).or().input((ItemLike)Items.FISHING_ROD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.REDSTONE_CLOCK).input((ItemLike)Items.CLOCK).and().input((ItemLike)Items.COMPARATOR).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.ROTATOR).input((ItemLike)Items.PISTON).or().input((ItemLike)Items.COMPASS).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.TOGGLER).input((ItemLike)Items.PISTON).or().input((ItemLike)Items.LEVER).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.REMOTE_COMPARATOR).input((ItemLike)MSBlocks.BLOCK_PRESSURE_PLATE).or().input((ItemLike)MSItems.PLUTONIUM_CORE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.FALL_PAD).input((TagKey<Item>)ItemTags.WOOL).or().input((ItemLike)Items.HAY_BLOCK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.FRAGILE_STONE).input((TagKey<Item>)Tags.Items.STONES).and().input((ItemLike)Items.GRAVEL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.RETRACTABLE_SPIKES).input((ItemLike)MSBlocks.SPIKES).and().input((ItemLike)Items.STICKY_PISTON).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.BLOCK_PRESSURE_PLATE).input((ItemLike)Items.OBSERVER).or().input((ItemLike)Items.STONE_PRESSURE_PLATE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.PUSHABLE_BLOCK).input((TagKey<Item>)Tags.Items.STONES).or().input((ItemLike)Items.GRAVEL).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.BLOCK_TELEPORTER).input((ItemLike)MSBlocks.SENDIFICATOR).or().input((ItemLike)MSBlocks.BLOCK_PRESSURE_PLATE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.STONE_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.NETHERRACK_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)Items.NETHERRACK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.COBBLESTONE_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)Items.COBBLESTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.SANDSTONE_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)Items.SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.RED_SANDSTONE_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)Items.RED_SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.END_STONE_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)Items.END_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.SHADE_STONE_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)MSBlocks.SHADE_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.PINK_STONE_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)MSBlocks.PINK_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.MYCELIUM_STONE_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)MSBlocks.MYCELIUM_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.UNCARVED_WOOD_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)MSBlocks.UNCARVED_WOOD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.BLACK_STONE_CRUXITE_ORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)MSBlocks.BLACK_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.STONE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)Items.STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.DEEPSLATE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)Items.DEEPSLATE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.NETHERRACK_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)Items.NETHERRACK).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.COBBLESTONE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)Items.COBBLESTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.SANDSTONE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)Items.SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.RED_SANDSTONE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)Items.RED_SANDSTONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.END_STONE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)Items.END_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.SHADE_STONE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)MSBlocks.SHADE_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.PINK_STONE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)MSBlocks.PINK_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.MYCELIUM_STONE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)MSBlocks.MYCELIUM_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.UNCARVED_WOOD_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)MSBlocks.UNCARVED_WOOD).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.BLACK_STONE_URANIUM_ORE).input((ItemLike)MSItems.RAW_URANIUM).and().input((ItemLike)MSBlocks.BLACK_STONE).buildFor(consumer, "minestuck");
        CombinationRecipeBuilder.of(MSBlocks.NETHERRACK_COAL_ORE).input((ItemLike)Items.COAL).and().input((ItemLike)Items.NETHERRACK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SHADE_STONE_COAL_ORE).input((ItemLike)Items.COAL).and().input((ItemLike)MSBlocks.SHADE_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PINK_STONE_COAL_ORE).input((ItemLike)Items.COAL).and().input((ItemLike)MSBlocks.PINK_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.END_STONE_IRON_ORE).input((ItemLike)Items.IRON_INGOT).and().input((ItemLike)Items.END_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SANDSTONE_IRON_ORE).input((ItemLike)Items.IRON_INGOT).and().input((ItemLike)Items.SANDSTONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.RED_SANDSTONE_IRON_ORE).input((ItemLike)Items.IRON_INGOT).and().input((ItemLike)Items.RED_SANDSTONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.UNCARVED_WOOD_IRON_ORE).input((ItemLike)Items.IRON_INGOT).and().input((ItemLike)MSBlocks.UNCARVED_WOOD).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SANDSTONE_GOLD_ORE).input((ItemLike)Items.GOLD_INGOT).and().input((ItemLike)Items.SANDSTONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.RED_SANDSTONE_GOLD_ORE).input((ItemLike)Items.GOLD_INGOT).and().input((ItemLike)Items.RED_SANDSTONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.SHADE_STONE_GOLD_ORE).input((ItemLike)Items.GOLD_INGOT).and().input((ItemLike)MSBlocks.SHADE_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PINK_STONE_GOLD_ORE).input((ItemLike)Items.GOLD_INGOT).and().input((ItemLike)MSBlocks.PINK_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLACK_STONE_GOLD_ORE).input((ItemLike)Items.GOLD_INGOT).and().input((ItemLike)MSBlocks.BLACK_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.END_STONE_REDSTONE_ORE).input((ItemLike)Items.REDSTONE).and().input((ItemLike)Items.END_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.UNCARVED_WOOD_REDSTONE_ORE).input((ItemLike)Items.REDSTONE).and().input((ItemLike)MSBlocks.UNCARVED_WOOD).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLACK_STONE_REDSTONE_ORE).input((ItemLike)Items.REDSTONE).and().input((ItemLike)MSBlocks.BLACK_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.STONE_QUARTZ_ORE).input((ItemLike)Items.QUARTZ).and().input((ItemLike)Items.STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLACK_STONE_QUARTZ_ORE).input((ItemLike)Items.QUARTZ).and().input((ItemLike)MSBlocks.BLACK_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PINK_STONE_LAPIS_ORE).input((ItemLike)Items.LAPIS_LAZULI).and().input((ItemLike)MSBlocks.PINK_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PINK_STONE_DIAMOND_ORE).input((ItemLike)Items.DIAMOND).and().input((ItemLike)MSBlocks.PINK_STONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.UNCARVED_WOOD_EMERALD_ORE).input((ItemLike)Items.EMERALD).and().input((ItemLike)MSBlocks.UNCARVED_WOOD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EMERALD_SWORD).input((ItemLike)Items.DIAMOND_SWORD).or().input((ItemLike)Items.EMERALD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EMERALD_AXE).input((ItemLike)Items.DIAMOND_AXE).or().input((ItemLike)Items.EMERALD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EMERALD_PICKAXE).input((ItemLike)Items.DIAMOND_PICKAXE).or().input((ItemLike)Items.EMERALD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EMERALD_SHOVEL).input((ItemLike)Items.DIAMOND_SHOVEL).or().input((ItemLike)Items.EMERALD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EMERALD_HOE).input((ItemLike)Items.DIAMOND_HOE).or().input((ItemLike)Items.EMERALD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MINE_AND_GRIST).input((ItemLike)Items.DIAMOND_PICKAXE).and().input((ItemLike)MSBlocks.GRIST_WIDGET).build(consumer);
        Item[] metalHelmets = new Item[]{Items.IRON_HELMET, Items.GOLDEN_HELMET, Items.NETHERITE_HELMET};
        Item[] metalChestplates = new Item[]{Items.IRON_CHESTPLATE, Items.GOLDEN_CHESTPLATE, Items.NETHERITE_CHESTPLATE};
        Item[] metalLeggings = new Item[]{Items.IRON_LEGGINGS, Items.GOLDEN_LEGGINGS, Items.NETHERITE_LEGGINGS};
        Item[] metalBoots = new Item[]{Items.IRON_BOOTS, Items.GOLDEN_BOOTS, Items.NETHERITE_BOOTS};
        for (int i = 0; i < metalHelmets.length; ++i) {
            for (ItemLike prismarine : new ItemLike[]{Items.PRISMARINE_SHARD, Blocks.PRISMARINE}) {
                CombinationRecipeBuilder.of(MSItems.PRISMARINE_HELMET).namedInput((ItemLike)metalHelmets[i]).or().namedInput(prismarine).build(consumer);
                CombinationRecipeBuilder.of(MSItems.PRISMARINE_CHESTPLATE).namedInput((ItemLike)metalChestplates[i]).or().namedInput(prismarine).build(consumer);
                CombinationRecipeBuilder.of(MSItems.PRISMARINE_LEGGINGS).namedInput((ItemLike)metalLeggings[i]).or().namedInput(prismarine).build(consumer);
                CombinationRecipeBuilder.of(MSItems.PRISMARINE_BOOTS).namedInput((ItemLike)metalBoots[i]).or().namedInput(prismarine).build(consumer);
            }
        }
        CombinationRecipeBuilder.of(MSItems.IRON_LASS_GLASSES).namedInput((ItemLike)Items.IRON_HELMET).and().input((ItemLike)MSItems.PARTICLE_ACCELERATOR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.IRON_LASS_CHESTPLATE).namedInput((ItemLike)Items.IRON_CHESTPLATE).and().input((ItemLike)MSItems.PARTICLE_ACCELERATOR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.IRON_LASS_SKIRT).namedInput((ItemLike)Items.IRON_LEGGINGS).and().input((ItemLike)MSItems.PARTICLE_ACCELERATOR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.IRON_LASS_SHOES).namedInput((ItemLike)Items.IRON_BOOTS).and().input((ItemLike)MSItems.PARTICLE_ACCELERATOR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PROSPIT_CIRCLET).namedInput((ItemLike)Items.GOLDEN_HELMET).and().input(SkaiaBlocks.WHITE_CROWN_STAINED_GLASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PROSPIT_SHIRT).namedInput((ItemLike)Items.LEATHER_CHESTPLATE).and().input(SkaiaBlocks.WHITE_CROWN_STAINED_GLASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PROSPIT_PANTS).namedInput((ItemLike)Items.LEATHER_LEGGINGS).and().input(SkaiaBlocks.WHITE_CROWN_STAINED_GLASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PROSPIT_SHOES).namedInput((ItemLike)Items.LEATHER_BOOTS).and().input(SkaiaBlocks.WHITE_CROWN_STAINED_GLASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DERSE_CIRCLET).namedInput((ItemLike)Items.GOLDEN_HELMET).or().input(SkaiaBlocks.BLACK_CROWN_STAINED_GLASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DERSE_SHIRT).namedInput((ItemLike)Items.LEATHER_CHESTPLATE).or().input(SkaiaBlocks.BLACK_CROWN_STAINED_GLASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DERSE_PANTS).namedInput((ItemLike)Items.LEATHER_LEGGINGS).or().input(SkaiaBlocks.BLACK_CROWN_STAINED_GLASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.DERSE_SHOES).namedInput((ItemLike)Items.LEATHER_BOOTS).or().input(SkaiaBlocks.BLACK_CROWN_STAINED_GLASS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.AMPHIBEANIE).namedInput((ItemLike)MSItems.CRUMPLY_HAT).and().input((ItemLike)MSItems.FROG).build(consumer);
        CombinationRecipeBuilder.of(MSItems.NOSTRILDAMUS).namedInput((ItemLike)MSItems.TEMPLE_SCANNER).or().input((ItemLike)Items.EMERALD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PONYTAIL).namedInput((ItemLike)Items.HANGING_ROOTS).or().input((ItemLike)Items.SADDLE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PRIMED_TNT).input((ItemLike)Items.TNT).or().input((TagKey<Item>)ItemTags.BUTTONS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.UNSTABLE_TNT).input((ItemLike)Items.TNT).or().input((ItemLike)Items.REDSTONE_TORCH).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.INSTANT_TNT).input((ItemLike)Items.TNT).or().input((ItemLike)Items.REDSTONE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.STONE_EXPLOSIVE_BUTTON).namedInput((ItemLike)Items.TNT).and().input((ItemLike)Items.STONE_BUTTON).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.STONE_EXPLOSIVE_BUTTON).namedInput((ItemLike)MSBlocks.INSTANT_TNT).and().input((ItemLike)Items.STONE_BUTTON).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOODEN_EXPLOSIVE_BUTTON).namedInput((ItemLike)Items.TNT).and().input((TagKey<Item>)ItemTags.WOODEN_BUTTONS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.WOODEN_EXPLOSIVE_BUTTON).namedInput((ItemLike)MSBlocks.INSTANT_TNT).and().input((TagKey<Item>)ItemTags.WOODEN_BUTTONS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.APPLE_CAKE).input((ItemLike)Items.CAKE).or().input((ItemLike)Items.APPLE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.BLUE_CAKE).input((ItemLike)Items.CAKE).or().input((ItemLike)MSBlocks.GLOWING_MUSHROOM).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.COLD_CAKE).input((ItemLike)Items.CAKE).or().namedInput((ItemLike)Items.ICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.COLD_CAKE).input((ItemLike)Items.CAKE).or().namedInput((ItemLike)Items.PACKED_ICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.RED_CAKE).input((ItemLike)Items.CAKE).or().namedInput((ItemLike)Items.MELON_SLICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.RED_CAKE).input((ItemLike)Items.CAKE).or().namedInput((ItemLike)Items.GLISTERING_MELON_SLICE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.HOT_CAKE).input((ItemLike)Items.CAKE).or().namedInput((ItemLike)Items.LAVA_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.HOT_CAKE).input((ItemLike)Items.CAKE).or().namedInput((ItemLike)Items.BLAZE_POWDER).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.HOT_CAKE).input((ItemLike)Items.CAKE).or().namedInput((ItemLike)Items.MAGMA_BLOCK).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.REVERSE_CAKE).input((ItemLike)Items.CAKE).or().namedInput((ItemLike)Items.GLASS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.REVERSE_CAKE).input((ItemLike)Items.CAKE).or().namedInput((ItemLike)Items.GLASS_PANE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.NEGATIVE_CAKE).input((ItemLike)MSBlocks.REVERSE_CAKE).and().input((ItemLike)MSBlocks.FUCHSIA_CAKE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CARROT_CAKE).input((ItemLike)Items.CAKE).or().input((ItemLike)Items.CARROT).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.LARGE_CAKE).input((ItemLike)Items.CAKE).or().input((ItemLike)Items.BONE_MEAL).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.PINK_FROSTED_TOP_LARGE_CAKE).input((ItemLike)MSItems.LARGE_CAKE).and().input((ItemLike)Items.PINK_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.CHOCOLATEY_CAKE).input((ItemLike)Items.CAKE).or().input((ItemLike)Items.COCOA_BEANS).build(consumer);
        CombinationRecipeBuilder.of(MSBlocks.MOON_CAKE).input((ItemLike)Items.CAKE).or().input((TagKey<Item>)ItemTags.BEDS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ROCK_COOKIE).input((ItemLike)Items.COOKIE).and().namedInput((ItemLike)Items.STONE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ROCK_COOKIE).input((ItemLike)Items.COOKIE).and().namedInput((ItemLike)Items.COBBLESTONE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ROCK_COOKIE).input((ItemLike)Items.COOKIE).and().namedInput((ItemLike)Items.GRAVEL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WOODEN_CARROT).input((ItemLike)Items.CARROT).and().namedInput((TagKey<Item>)ItemTags.PLANKS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.WOODEN_CARROT).input((ItemLike)Items.CARROT).and().namedInput((TagKey<Item>)ItemTags.LOGS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FUNGAL_SPORE).input((ItemLike)Items.WHEAT_SEEDS).or().input((TagKey<Item>)Tags.Items.MUSHROOMS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SPOREO).input((ItemLike)Items.COOKIE).and().input((ItemLike)MSItems.FUNGAL_SPORE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FRENCH_FRY).input((ItemLike)Items.POTATO).and().namedInput((ItemLike)Items.STICK).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FRENCH_FRY).input((ItemLike)Items.POTATO).and().namedInput((ItemLike)Items.BLAZE_ROD).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SURPRISE_EMBRYO).input((ItemLike)Items.EGG).and().input((ItemLike)Items.PUMPKIN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FOOD_CAN).input((ItemLike)Items.COOKED_BEEF).and().input((ItemLike)Items.IRON_INGOT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.INK_SQUID_PRO_QUO).input((ItemLike)MSItems.PAPER_SWORD).or().namedInput((ItemLike)Items.INK_SAC).build(consumer);
        CombinationRecipeBuilder.of(MSItems.EIGHTBALL).input((ItemLike)MSItems.DICE).or().namedInput((ItemLike)Items.WATER_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PHLEGM_GUSHERS).input((ItemLike)MSItems.BUILD_GUSHERS).and().namedInput((ItemLike)Items.SLIME_BALL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SORROW_GUSHERS).input((ItemLike)MSItems.PHLEGM_GUSHERS).and().namedInput((ItemLike)MSItems.INK_SQUID_PRO_QUO).build(consumer);
        CombinationRecipeBuilder.of(MSItems.BARBASOL_BOMB).input((ItemLike)MSItems.BUILD_GUSHERS).and().input((ItemLike)MSItems.BARBASOL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_APPLESCAB).input((ItemLike)Items.RED_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_BERRYBREATH).input((ItemLike)Items.BLUE_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_CINNAMONWHIFF).input((ItemLike)Items.BROWN_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_HONEYTONGUE).input((ItemLike)Items.YELLOW_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_LEMONSNOUT).input((ItemLike)Items.LIME_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_PINESNORT).input((ItemLike)Items.LIGHT_BLUE_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_PUCEFOOT).input((ItemLike)Items.PINK_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_PUMPKINSNUFFLE).input((ItemLike)Items.ORANGE_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_PYRALSPITE).input((ItemLike)Items.WHITE_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SCALEMATE_WITNESS).input((ItemLike)Items.GREEN_WOOL).and().input((ItemLike)Items.DRAGON_BREATH).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PLUSH_SALAMANDER).input((ItemLike)Items.YELLOW_WOOL).and().input((ItemLike)Items.AXOLOTL_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PLUSH_NAKAGATOR).input((ItemLike)Items.RED_WOOL).and().input((ItemLike)MSItems.NAKAGATOR_STATUE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PLUSH_TURTLE).input((ItemLike)Items.PINK_WOOL).and().input((ItemLike)Items.TURTLE_SCUTE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PLUSH_IGUANA).input((ItemLike)Items.BLUE_WOOL).and().input((ItemLike)Items.MANGROVE_ROOTS).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ENERGY_CORE).input((ItemLike)MSItems.RAW_CRUXITE).and().input((ItemLike)MSItems.RAW_URANIUM).build(consumer);
        CombinationRecipeBuilder.of(MSItems.IRRADIATED_STEAK).input((ItemLike)MSItems.RAW_URANIUM).or().input((ItemLike)Items.COOKED_BEEF).build(consumer);
        CombinationRecipeBuilder.of(MSItems.QUANTUM_SABRE).input((ItemLike)MSItems.URANIUM_POWERED_STICK).and().input((ItemLike)MSItems.ENERGY_CORE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.SOPOR_SLIME_PIE).input((ItemLike)MSItems.BATTERY).or().input((ItemLike)MSItems.HORN).build(consumer);
        CombinationRecipeBuilder.of(MSItems.APPLE_JUICE).input((ItemLike)Items.GLASS_BOTTLE).and().input((ItemLike)Items.APPLE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.TAB).input((ItemLike)Items.POTION).or().input((ItemLike)Items.SUGAR).build(consumer);
        CombinationRecipeBuilder.of(MSItems.ORANGE_FAYGO).input((ItemLike)Items.POTION).or().input((ItemLike)Items.ORANGE_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CANDY_APPLE_FAYGO).input((ItemLike)MSItems.ORANGE_FAYGO).or().input((ItemLike)Items.APPLE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.FAYGO_COLA).input((ItemLike)MSItems.ORANGE_FAYGO).or().input((ItemLike)MSItems.TAB).build(consumer);
        CombinationRecipeBuilder.of(MSItems.COTTON_CANDY_FAYGO).input((ItemLike)MSItems.ORANGE_FAYGO).or().input((ItemLike)Items.LIGHT_BLUE_WOOL).build(consumer);
        CombinationRecipeBuilder.of(MSItems.CREME_SODA_FAYGO).input((ItemLike)MSItems.ORANGE_FAYGO).or().input((ItemLike)Items.MILK_BUCKET).build(consumer);
        CombinationRecipeBuilder.of(MSItems.GRAPE_FAYGO).input((ItemLike)MSItems.ORANGE_FAYGO).or().input((ItemLike)Items.CHORUS_FRUIT).build(consumer);
        CombinationRecipeBuilder.of(MSItems.MOON_MIST_FAYGO).input((ItemLike)MSItems.ORANGE_FAYGO).or().input((ItemLike)Items.LIME_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.PEACH_FAYGO).input((ItemLike)MSItems.CANDY_APPLE_FAYGO).and().input((ItemLike)Items.PINK_DYE).build(consumer);
        CombinationRecipeBuilder.of(MSItems.REDPOP_FAYGO).input((ItemLike)MSItems.ORANGE_FAYGO).or().input((ItemLike)Items.TNT).build(consumer);
    }
}

