/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.tag;

import com.mraof.minestuck.util.MSTags;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MSEffectTagsProvider
extends IntrinsicHolderTagsProvider<MobEffect> {
    public MSEffectTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, Registries.MOB_EFFECT, lookupProvider, MSEffectTagsProvider::keyForMobEffects, "minestuck", existingFileHelper);
    }

    private static ResourceKey<MobEffect> keyForMobEffects(MobEffect landType) {
        return (ResourceKey)BuiltInRegistries.MOB_EFFECT.getResourceKey((Object)landType).orElseThrow();
    }

    protected void addTags(HolderLookup.Provider provider) {
        ArrayList<Holder> ignoredEffects = new ArrayList<Holder>();
        ignoredEffects.add(MobEffects.HERO_OF_THE_VILLAGE);
        ignoredEffects.add(MobEffects.BAD_OMEN);
        ignoredEffects.add(MobEffects.CONDUIT_POWER);
        ignoredEffects.add(MobEffects.DOLPHINS_GRACE);
        ignoredEffects.add(MobEffects.LUCK);
        ignoredEffects.add(MobEffects.UNLUCK);
        BuiltInRegistries.MOB_EFFECT.holders().forEach(mobEffect -> {
            if (mobEffect.key().location().getNamespace().equals("minecraft") && !ignoredEffects.contains(mobEffect)) {
                this.tag(MSTags.Effects.SOPOR_SICKNESS_WHITELIST).add(mobEffect.key());
            }
        });
    }

    public String getName() {
        return "Minestuck Effect Tags";
    }
}

