/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.tag;

import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypeSpawnCategory;
import com.mraof.minestuck.api.alchemy.GristTypes;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class MSGristTypeTagsProvider
extends IntrinsicHolderTagsProvider<GristType> {
    public MSGristTypeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, GristTypes.REGISTRY_KEY, lookupProvider, MSGristTypeTagsProvider::keyForGristType, "minestuck", existingFileHelper);
    }

    private static ResourceKey<GristType> keyForGristType(GristType gristType) {
        return (ResourceKey)GristTypes.REGISTRY.getResourceKey((Object)gristType).orElseThrow();
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(GristTypeSpawnCategory.COMMON.getTagKey()).add((Object[])new GristType[]{GristTypes.AMBER.get(), GristTypes.CAULK.get(), GristTypes.CHALK.get(), GristTypes.IODINE.get(), GristTypes.SHALE.get(), GristTypes.TAR.get()}).add((Object[])new GristType[]{GristTypes.COBALT.get(), GristTypes.MARBLE.get(), GristTypes.MERCURY.get(), GristTypes.QUARTZ.get(), GristTypes.SULFUR.get()});
        this.tag(GristTypeSpawnCategory.UNCOMMON.getTagKey()).add((Object[])new GristType[]{GristTypes.COBALT.get(), GristTypes.MARBLE.get(), GristTypes.MERCURY.get(), GristTypes.QUARTZ.get(), GristTypes.SULFUR.get()}).add((Object[])new GristType[]{GristTypes.AMETHYST.get(), GristTypes.GARNET.get(), GristTypes.RUBY.get(), GristTypes.RUST.get()}).add((Object[])new GristType[]{GristTypes.DIAMOND.get(), GristTypes.GOLD.get(), GristTypes.URANIUM.get()});
        this.tag(GristTypeSpawnCategory.ANY.getTagKey()).addTags(new TagKey[]{GristTypeSpawnCategory.COMMON.getTagKey(), GristTypeSpawnCategory.UNCOMMON.getTagKey()});
        this.tag(GristTypes.AMBER.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.RUST.get(), GristTypes.SULFUR.get()});
        this.tag(GristTypes.CAULK.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.IODINE.get(), GristTypes.CHALK.get()});
        this.tag(GristTypes.CHALK.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.SHALE.get(), GristTypes.MARBLE.get()});
        this.tag(GristTypes.IODINE.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.AMBER.get(), GristTypes.CHALK.get()});
        this.tag(GristTypes.SHALE.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.MERCURY.get(), GristTypes.TAR.get()});
        this.tag(GristTypes.TAR.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.AMBER.get(), GristTypes.COBALT.get()});
        this.tag(GristTypes.COBALT.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.RUBY.get(), GristTypes.AMETHYST.get()});
        this.tag(GristTypes.MARBLE.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.CAULK.get(), GristTypes.AMETHYST.get()});
        this.tag(GristTypes.MERCURY.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.COBALT.get(), GristTypes.RUST.get()});
        this.tag(GristTypes.QUARTZ.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.MARBLE.get(), GristTypes.URANIUM.get()});
        this.tag(GristTypes.SULFUR.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.IODINE.get(), GristTypes.TAR.get()});
        this.tag(GristTypes.AMETHYST.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.QUARTZ.get(), GristTypes.GARNET.get()});
        this.tag(GristTypes.GARNET.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.RUBY.get(), GristTypes.GOLD.get()});
        this.tag(GristTypes.RUBY.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.QUARTZ.get(), GristTypes.DIAMOND.get()});
        this.tag(GristTypes.RUST.get().getSecondaryTypesTag()).add((Object[])new GristType[]{GristTypes.SHALE.get(), GristTypes.GARNET.get()});
        this.tag(GristTypes.DIAMOND.get().getSecondaryTypesTag()).add((Object)GristTypes.GOLD.get());
        this.tag(GristTypes.GOLD.get().getSecondaryTypesTag()).add((Object)GristTypes.URANIUM.get());
        this.tag(GristTypes.URANIUM.get().getSecondaryTypesTag()).add((Object)GristTypes.DIAMOND.get());
    }

    public String getName() {
        return "Minestuck Grist Type Tags";
    }
}

