/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.tag;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.item.MSItemTypes;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.weapon.MSToolType;
import com.mraof.minestuck.item.weapon.MagicAOERightClickEffect;
import com.mraof.minestuck.item.weapon.MagicRangedRightClickEffect;
import com.mraof.minestuck.item.weapon.WeaponItem;
import com.mraof.minestuck.item.weapon.projectiles.ConsumableProjectileWeaponItem;
import com.mraof.minestuck.item.weapon.projectiles.ReturningProjectileWeaponItem;
import com.mraof.minestuck.util.ExtraModTags;
import com.mraof.minestuck.util.MSTags;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MinestuckItemTagsProvider
extends ItemTagsProvider {
    public MinestuckItemTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, lookupProvider, blockTagProvider, "minestuck", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.copy(BlockTags.PLANKS, ItemTags.PLANKS);
        this.copy(BlockTags.STONE_BRICKS, ItemTags.STONE_BRICKS);
        this.copy(BlockTags.WOODEN_BUTTONS, ItemTags.WOODEN_BUTTONS);
        this.copy(BlockTags.BUTTONS, ItemTags.BUTTONS);
        this.copy(BlockTags.WOODEN_STAIRS, ItemTags.WOODEN_STAIRS);
        this.copy(BlockTags.WOODEN_SLABS, ItemTags.WOODEN_SLABS);
        this.copy(BlockTags.SAPLINGS, ItemTags.SAPLINGS);
        this.copy(BlockTags.STAIRS, ItemTags.STAIRS);
        this.copy(BlockTags.SLABS, ItemTags.SLABS);
        this.copy(BlockTags.LOGS, ItemTags.LOGS);
        this.copy(BlockTags.LEAVES, ItemTags.LEAVES);
        this.copy(Tags.Blocks.COBBLESTONES, Tags.Items.COBBLESTONES);
        this.copy(Tags.Blocks.ORES, Tags.Items.ORES);
        this.copy(BlockTags.COAL_ORES, Tags.Items.ORES_COAL);
        this.copy(BlockTags.DIAMOND_ORES, Tags.Items.ORES_DIAMOND);
        this.copy(BlockTags.GOLD_ORES, Tags.Items.ORES_GOLD);
        this.copy(BlockTags.IRON_ORES, Tags.Items.ORES_IRON);
        this.copy(BlockTags.LAPIS_ORES, Tags.Items.ORES_LAPIS);
        this.copy(Tags.Blocks.ORES_QUARTZ, Tags.Items.ORES_QUARTZ);
        this.copy(BlockTags.REDSTONE_ORES, Tags.Items.ORES_REDSTONE);
        this.copy(BlockTags.EMERALD_ORES, Tags.Items.ORES_EMERALD);
        this.copy(Tags.Blocks.STONES, Tags.Items.STONES);
        this.copy(Tags.Blocks.STORAGE_BLOCKS, Tags.Items.STORAGE_BLOCKS);
        this.copy(ExtraModTags.Blocks.URANIUM_ORES, ExtraModTags.Items.URANIUM_ORES);
        this.copy(ExtraModTags.Blocks.URANIUM_STORAGE_BLOCKS, ExtraModTags.Items.URANIUM_STORAGE_BLOCKS);
        this.copy(MSTags.Blocks.GLOWING_LOGS, MSTags.Items.GLOWING_LOGS);
        this.copy(MSTags.Blocks.FROST_LOGS, MSTags.Items.FROST_LOGS);
        this.copy(MSTags.Blocks.RAINBOW_LOGS, MSTags.Items.RAINBOW_LOGS);
        this.copy(MSTags.Blocks.END_LOGS, MSTags.Items.END_LOGS);
        this.copy(MSTags.Blocks.VINE_LOGS, MSTags.Items.VINE_LOGS);
        this.copy(MSTags.Blocks.FLOWERY_VINE_LOGS, MSTags.Items.FLOWERY_VINE_LOGS);
        this.copy(MSTags.Blocks.DEAD_LOGS, MSTags.Items.DEAD_LOGS);
        this.copy(MSTags.Blocks.CINDERED_LOGS, MSTags.Items.CINDERED_LOGS);
        this.copy(MSTags.Blocks.PETRIFIED_LOGS, MSTags.Items.PETRIFIED_LOGS);
        this.copy(MSTags.Blocks.ASPECT_LOGS, MSTags.Items.ASPECT_LOGS);
        this.copy(MSTags.Blocks.ASPECT_WOOD, MSTags.Items.ASPECT_WOOD);
        this.copy(MSTags.Blocks.ASPECT_PLANKS, MSTags.Items.ASPECT_PLANKS);
        this.copy(MSTags.Blocks.ASPECT_SLABS, MSTags.Items.ASPECT_SLABS);
        this.copy(MSTags.Blocks.ASPECT_LEAVES, MSTags.Items.ASPECT_LEAVES);
        this.copy(MSTags.Blocks.ASPECT_SAPLINGS, MSTags.Items.ASPECT_SAPLINGS);
        this.copy(MSTags.Blocks.SHADEWOOD_LOGS, MSTags.Items.SHADEWOOD_LOGS);
        this.copy(MSTags.Blocks.SHADEWOOD_LEAVES, MSTags.Items.SHADEWOOD_LEAVES);
        this.copy(MSTags.Blocks.CRUXITE_ORES, MSTags.Items.CRUXITE_ORES);
        this.copy(MSTags.Blocks.URANIUM_ORES, MSTags.Items.URANIUM_ORES);
        this.copy(MSTags.Blocks.COAL_ORES, MSTags.Items.COAL_ORES);
        this.copy(MSTags.Blocks.IRON_ORES, MSTags.Items.IRON_ORES);
        this.copy(MSTags.Blocks.GOLD_ORES, MSTags.Items.GOLD_ORES);
        this.copy(MSTags.Blocks.REDSTONE_ORES, MSTags.Items.REDSTONE_ORES);
        this.copy(MSTags.Blocks.QUARTZ_ORES, MSTags.Items.QUARTZ_ORES);
        this.copy(MSTags.Blocks.LAPIS_ORES, MSTags.Items.LAPIS_ORES);
        this.copy(MSTags.Blocks.DIAMOND_ORES, MSTags.Items.DIAMOND_ORES);
        this.copy(MSTags.Blocks.EMERALD_ORES, MSTags.Items.EMERALD_ORES);
        this.copy(MSTags.Blocks.CRUXITE_STORAGE_BLOCKS, MSTags.Items.CRUXITE_STORAGE_BLOCKS);
        List<MSToolType> minestuckMiningToolTypes = List.of(MSItemTypes.SICKLE_TOOL, MSItemTypes.SCYTHE_TOOL, MSItemTypes.CLAWS_TOOL, MSItemTypes.HAMMER_TOOL, MSItemTypes.FORK_TOOL);
        List<MSToolType> minestuckMeleeToolTypes = List.of(MSItemTypes.LANCE_TOOL, MSItemTypes.CLUB_TOOL, MSItemTypes.KNIFE_TOOL, MSItemTypes.KEY_TOOL, MSItemTypes.FAN_TOOL, MSItemTypes.BATON_TOOL, MSItemTypes.STAFF_TOOL, MSItemTypes.CANE_TOOL, MSItemTypes.WAND_TOOL);
        List minestuckToolTypes = Stream.concat(minestuckMiningToolTypes.stream(), minestuckMeleeToolTypes.stream()).toList();
        this.tag(ItemTags.SWORDS).add((Object)((Item)MSItems.EMERALD_SWORD.get())).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, List.of(MSItemTypes.SWORD_TOOL))));
        this.tag(ItemTags.AXES).add((Object)((Item)MSItems.EMERALD_AXE.get())).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, List.of(MSItemTypes.AXE_TOOL, MSItemTypes.CHAINSAW_TOOL))));
        this.tag(ItemTags.PICKAXES).add((Object)((Item)MSItems.EMERALD_PICKAXE.get())).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, List.of(MSItemTypes.PICKAXE_TOOL))));
        this.tag(ItemTags.SHOVELS).add((Object)((Item)MSItems.EMERALD_SHOVEL.get())).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, List.of(MSItemTypes.SHOVEL_TOOL, MSItemTypes.SPOON_TOOL))));
        this.tag(ItemTags.HOES).add((Object[])new Item[]{(Item)MSItems.EMERALD_HOE.get(), (Item)MSItems.HELLBRINGERS_HOE_INACTIVE.get(), (Item)MSItems.HELLBRINGERS_HOE_ACTIVE.get()});
        this.tag(ItemTags.HEAD_ARMOR).add((Object[])new Item[]{(Item)MSItems.PRISMARINE_HELMET.get(), (Item)MSItems.IRON_LASS_GLASSES.get(), (Item)MSItems.PROSPIT_CIRCLET.get(), (Item)MSItems.DERSE_CIRCLET.get(), (Item)MSItems.AMPHIBEANIE.get(), (Item)MSItems.NOSTRILDAMUS.get(), (Item)MSItems.PONYTAIL.get()});
        this.tag(ItemTags.CHEST_ARMOR).add((Object[])new Item[]{(Item)MSItems.PRISMARINE_CHESTPLATE.get(), (Item)MSItems.IRON_LASS_CHESTPLATE.get(), (Item)MSItems.PROSPIT_SHIRT.get(), (Item)MSItems.DERSE_SHIRT.get()});
        this.tag(ItemTags.LEG_ARMOR).add((Object[])new Item[]{(Item)MSItems.PRISMARINE_LEGGINGS.get(), (Item)MSItems.IRON_LASS_SKIRT.get(), (Item)MSItems.PROSPIT_PANTS.get(), (Item)MSItems.DERSE_PANTS.get()});
        this.tag(ItemTags.FOOT_ARMOR).add((Object[])new Item[]{(Item)MSItems.PRISMARINE_BOOTS.get(), (Item)MSItems.IRON_LASS_SHOES.get(), (Item)MSItems.PROSPIT_SHOES.get(), (Item)MSItems.DERSE_SHOES.get()});
        this.tag(ItemTags.CLUSTER_MAX_HARVESTABLES).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, List.of(MSItemTypes.PICKAXE_TOOL, MSItemTypes.HAMMER_TOOL))));
        this.tag(ItemTags.BREAKS_DECORATED_POTS).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, minestuckToolTypes)));
        this.tag(Tags.Items.MINING_TOOL_TOOLS).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, List.of(MSItemTypes.PICKAXE_TOOL, MSItemTypes.HAMMER_TOOL))));
        this.tag(Tags.Items.MELEE_WEAPON_TOOLS).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> item instanceof WeaponItem));
        this.tag(Tags.Items.TOOLS_SPEAR).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, List.of(MSItemTypes.LANCE_TOOL))));
        this.tag(Tags.Items.RANGED_WEAPON_TOOLS).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> {
            WeaponItem weapon;
            return item instanceof ConsumableProjectileWeaponItem || item instanceof WeaponItem && ((weapon = (WeaponItem)((Object)item)).getItemRightClickEffect() instanceof MagicRangedRightClickEffect || weapon.getItemRightClickEffect() instanceof MagicAOERightClickEffect);
        }));
        this.tag(ItemTags.DURABILITY_ENCHANTABLE).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> item instanceof WeaponItem && item.isDamageable(item.getDefaultInstance()) || item instanceof ReturningProjectileWeaponItem));
        this.tag(ItemTags.MINING_ENCHANTABLE).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, minestuckMiningToolTypes)));
        this.tag(ItemTags.MINING_LOOT_ENCHANTABLE).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> MinestuckItemTagsProvider.hasToolType(item, minestuckMiningToolTypes)));
        this.tag(ItemTags.SWORD_ENCHANTABLE).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> item instanceof WeaponItem));
        this.tag(ItemTags.SHARP_WEAPON_ENCHANTABLE).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> item instanceof WeaponItem));
        this.tag(ItemTags.VANISHING_ENCHANTABLE).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> item instanceof WeaponItem));
        this.tag(Tags.Items.MUSIC_DISCS).add((Object[])new Item[]{(Item)MSItems.MUSIC_DISC_DANCE_STAB_DANCE.get(), (Item)MSItems.MUSIC_DISC_EMISSARY_OF_DANCE.get(), (Item)MSItems.MUSIC_DISC_RETRO_BATTLE.get()});
        this.tag(Tags.Items.DUSTS).add((Object)((Block)MSBlocks.GLOWYSTONE_DUST.get()).asItem());
        this.tag(Tags.Items.RODS).add((Object)((Item)MSItems.URANIUM_POWERED_STICK.get()));
        this.tag(ExtraModTags.Items.URANIUM_CHUNKS).add((Object)((Item)MSItems.RAW_URANIUM.get()));
        this.tag(ExtraModTags.Items.TIN_ORES);
        this.tag(ExtraModTags.Items.SILVER_ORES);
        this.tag(ExtraModTags.Items.LEAD_ORES);
        this.tag(ExtraModTags.Items.GALENA_ORES);
        this.tag(ExtraModTags.Items.ZINC_ORES);
        this.tag(ExtraModTags.Items.NICKEL_ORES);
        this.tag(ExtraModTags.Items.ALUMINIUM_ORES);
        this.tag(ExtraModTags.Items.ALUMINUM_ORES);
        this.tag(ExtraModTags.Items.COBALT_ORES);
        this.tag(ExtraModTags.Items.ARDITE_ORES);
        this.tag(ExtraModTags.Items.TIN_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.SILVER_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.LEAD_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.GALENA_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.ZINC_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.NICKEL_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.ALUMINIUM_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.ALUMINUM_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.COBALT_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.ARDITE_RAW_MATERIALS);
        this.tag(ExtraModTags.Items.URANIUM_INGOTS);
        this.tag(ExtraModTags.Items.TIN_INGOTS);
        this.tag(ExtraModTags.Items.BRASS_INGOTS);
        this.tag(ExtraModTags.Items.SILVER_INGOTS);
        this.tag(ExtraModTags.Items.ELECTRUM_INGOTS);
        this.tag(ExtraModTags.Items.LEAD_INGOTS);
        this.tag(ExtraModTags.Items.NICKEL_INGOTS);
        this.tag(ExtraModTags.Items.ZINC_INGOTS);
        this.tag(ExtraModTags.Items.INVAR_INGOTS);
        this.tag(ExtraModTags.Items.ALUMINIUM_INGOTS);
        this.tag(ExtraModTags.Items.COBALT_INGOTS);
        this.tag(ExtraModTags.Items.ARDITE_INGOTS);
        this.tag(ExtraModTags.Items.RED_ALLOY_INGOTS);
        this.tag(MSTags.Items.GRIST_CANDY).add((Object[])new Item[]{(Item)MSItems.BUILD_GUSHERS.get(), (Item)MSItems.AMBER_GUMMY_WORM.get(), (Item)MSItems.CAULK_PRETZEL.get(), (Item)MSItems.CHALK_CANDY_CIGARETTE.get(), (Item)MSItems.IODINE_LICORICE.get(), (Item)MSItems.SHALE_PEEP.get(), (Item)MSItems.TAR_LICORICE.get(), (Item)MSItems.COBALT_GUM.get(), (Item)MSItems.MARBLE_JAWBREAKER.get(), (Item)MSItems.MERCURY_SIXLETS.get(), (Item)MSItems.QUARTZ_JELLY_BEAN.get(), (Item)MSItems.SULFUR_CANDY_APPLE.get(), (Item)MSItems.AMETHYST_HARD_CANDY.get(), (Item)MSItems.GARNET_TWIX.get(), (Item)MSItems.RUBY_LOLLIPOP.get(), (Item)MSItems.RUST_GUMMY_EYE.get(), (Item)MSItems.DIAMOND_MINT.get(), (Item)MSItems.GOLD_CANDY_RIBBON.get(), (Item)MSItems.URANIUM_GUMMY_BEAR.get(), (Item)MSItems.ARTIFACT_WARHEAD.get(), (Item)MSItems.ZILLIUM_SKITTLES.get()});
        this.tag(MSTags.Items.FAYGO).add((Object[])new Item[]{(Item)MSItems.ORANGE_FAYGO.get(), (Item)MSItems.CANDY_APPLE_FAYGO.get(), (Item)MSItems.FAYGO_COLA.get(), (Item)MSItems.COTTON_CANDY_FAYGO.get(), (Item)MSItems.CREME_SODA_FAYGO.get(), (Item)MSItems.GRAPE_FAYGO.get(), (Item)MSItems.MOON_MIST_FAYGO.get(), (Item)MSItems.PEACH_FAYGO.get(), (Item)MSItems.REDPOP_FAYGO.get()});
        this.tag(MSTags.Items.MODUS_CARD).add((Object[])new Item[]{(Item)MSItems.STACK_MODUS_CARD.get(), (Item)MSItems.QUEUE_MODUS_CARD.get(), (Item)MSItems.QUEUESTACK_MODUS_CARD.get(), (Item)MSItems.TREE_MODUS_CARD.get(), (Item)MSItems.HASHMAP_MODUS_CARD.get(), (Item)MSItems.SET_MODUS_CARD.get()});
        this.tag(MSTags.Items.CASSETTES).add((Object[])new Item[]{(Item)MSItems.CASSETTE_MELLOHI.get(), (Item)MSItems.CASSETTE_13.get(), (Item)MSItems.CASSETTE_BLOCKS.get(), (Item)MSItems.CASSETTE_CAT.get(), (Item)MSItems.CASSETTE_CHIRP.get(), (Item)MSItems.CASSETTE_FAR.get(), (Item)MSItems.CASSETTE_MALL.get(), (Item)MSItems.CASSETTE_DANCE_STAB.get(), (Item)MSItems.CASSETTE_RETRO_BATTLE.get(), (Item)MSItems.CASSETTE_EMISSARY.get(), (Item)MSItems.CASSETTE_11.get(), (Item)MSItems.CASSETTE_PIGSTEP.get(), (Item)MSItems.CASSETTE_STAL.get(), (Item)MSItems.CASSETTE_STRAD.get(), (Item)MSItems.CASSETTE_WAIT.get(), (Item)MSItems.CASSETTE_WARD.get(), (Item)MSItems.CASSETTE_OTHERSIDE.get(), (Item)MSItems.CASSETTE_5.get()});
        this.tag(MSTags.Items.BUGS).add((Object[])new Item[]{(Item)MSItems.BUG_ON_A_STICK.get(), (Item)MSItems.CHOCOLATE_BEETLE.get(), (Item)MSItems.CONE_OF_FLIES.get(), (Item)MSItems.GRASSHOPPER.get(), (Item)MSItems.CICADA.get(), (Item)MSItems.JAR_OF_BUGS.get()});
        this.tag(MSTags.Items.CONSORT_SNACKS).add((Object)Items.COOKIE).addTag(MSTags.Items.BUGS);
        this.tag(MSTags.Items.MAGIC_WEAPON).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> {
            WeaponItem weapon;
            return item instanceof WeaponItem && ((weapon = (WeaponItem)((Object)item)).getItemRightClickEffect() instanceof MagicRangedRightClickEffect || weapon.getItemRightClickEffect() instanceof MagicAOERightClickEffect);
        }));
        this.tag(MSTags.Items.CREATIVE_SHOCK_RIGHT_CLICK_LIMIT).add((Object)Items.CHORUS_FRUIT);
        this.tag(MSTags.Items.UNREADABLE).add((Object[])new Item[]{(Item)MSItems.CRUEL_FATE_CRUCIBLE.get(), (Item)MSItems.ROYAL_DERINGER.get(), (Item)MSItems.TRANSPORTALIZER.get(), (Item)MSItems.TRANS_PORTALIZER.get(), (Item)MSItems.FEAR_NO_ANVIL.get(), (Item)MSItems.TYPHONIC_TRIVIALIZER.get(), (Item)MSItems.QUILL_OF_ECHIDNA.get(), (Item)MSItems.UMBRAL_INFILTRATOR.get(), (Item)MSItems.FLUORITE_OCTET.get(), (Item)MSItems.CLIENT_DISK.get(), (Item)MSItems.SERVER_DISK.get(), (Item)MSItems.GUTTER_THUMB_DRIVE.get(), (Item)MSItems.GUTTER_BALL.get(), (Item)MSItems.CAPTCHA_CARD.get(), (Item)MSItems.CUEBALL.get(), (Item)MSItems.BLACK_QUEENS_RING.get(), (Item)MSItems.WHITE_QUEENS_RING.get(), (Item)MSItems.BLACK_KINGS_SCEPTER.get(), (Item)MSItems.WHITE_KINGS_SCEPTER.get()}).add((Object)Items.DRAGON_EGG).add((Object)Items.DRAGON_HEAD).add((Object)Items.DRAGON_BREATH).add((Object)Items.NETHER_STAR).add((Object)Items.COMMAND_BLOCK).add((Object)Items.COMMAND_BLOCK_MINECART).add((Object)Items.CHAIN_COMMAND_BLOCK).add((Object)Items.REPEATING_COMMAND_BLOCK).add((Object)Items.END_CRYSTAL).add((Object)Items.EXPERIENCE_BOTTLE).add((Object)Items.ELYTRA).add((Object)Items.TOTEM_OF_UNDYING).add((Object)Items.BEACON).add((Object)Items.BEDROCK).add((Object)Items.PUMPKIN);
        this.tag(MSTags.Items.LEGENDARY).add((Object[])MinestuckItemTagsProvider.relevantWeapons(item -> {
            WeaponItem weapon;
            return item instanceof WeaponItem && ((weapon = (WeaponItem)((Object)item)).getTier() == MSItemTypes.DENIZEN_TIER || weapon.getTier() == MSItemTypes.ZILLY_TIER || weapon.getTier() == MSItemTypes.WELSH_TIER);
        }));
    }

    private static Item[] relevantWeapons(Predicate<Item> predicate) {
        return (Item[])MSItems.REGISTER.getEntries().stream().map(Supplier::get).filter(predicate).toArray(Item[]::new);
    }

    private static boolean hasToolType(Item item, List<MSToolType> toolTypes) {
        WeaponItem weaponItem;
        if (!(item instanceof WeaponItem) || (weaponItem = (WeaponItem)item).getToolTypes() == null) {
            return false;
        }
        List<MSToolType> weaponTypes = weaponItem.getToolTypes();
        for (MSToolType toolType : toolTypes) {
            if (!weaponTypes.contains(toolType)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return "Minestuck Item Tags";
    }
}

