/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.tag;

import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class TerrainLandTypeTagsProvider
extends IntrinsicHolderTagsProvider<TerrainLandType> {
    public TerrainLandTypeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, LandTypes.TERRAIN_KEY, lookupProvider, TerrainLandTypeTagsProvider::keyForLandType, "minestuck", existingFileHelper);
    }

    private static ResourceKey<TerrainLandType> keyForLandType(TerrainLandType landType) {
        return (ResourceKey)LandTypes.TERRAIN_REGISTRY.getResourceKey((Object)landType).orElseThrow();
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(MSTags.TerrainLandTypes.FOREST).add((Object[])new TerrainLandType[]{LandTypes.FOREST.get(), LandTypes.TAIGA.get()});
        this.tag(MSTags.TerrainLandTypes.ROCK).add((Object[])new TerrainLandType[]{LandTypes.ROCK.get(), LandTypes.PETRIFICATION.get()});
        this.tag(MSTags.TerrainLandTypes.SAND).add((Object[])new TerrainLandType[]{LandTypes.SAND.get(), LandTypes.RED_SAND.get(), LandTypes.LUSH_DESERTS.get()});
        this.tag(MSTags.TerrainLandTypes.SANDSTONE).add((Object[])new TerrainLandType[]{LandTypes.SANDSTONE.get(), LandTypes.RED_SANDSTONE.get()});
        this.tag(MSTags.TerrainLandTypes.IS_DESOLATE).addTags(new TagKey[]{MSTags.TerrainLandTypes.SAND, MSTags.TerrainLandTypes.SANDSTONE, MSTags.TerrainLandTypes.ROCK});
        this.tag(MSTags.TerrainLandTypes.IS_DANGEROUS).add((Object)LandTypes.HEAT.get());
        this.tag(MSTags.TerrainLandTypes.IS_FLUID_IMPORTANT).add((Object)LandTypes.HEAT.get());
    }

    public String getName() {
        return "Minestuck Terrain Land Type Tags";
    }
}

