/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.tag;

import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.concurrent.CompletableFuture;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceKey;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class TitleLandTypeTagsProvider
extends IntrinsicHolderTagsProvider<TitleLandType> {
    public TitleLandTypeTagsProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> lookupProvider, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, LandTypes.TITLE_KEY, lookupProvider, TitleLandTypeTagsProvider::keyForLandType, "minestuck", existingFileHelper);
    }

    private static ResourceKey<TitleLandType> keyForLandType(TitleLandType landType) {
        return (ResourceKey)LandTypes.TITLE_REGISTRY.getResourceKey((Object)landType).orElseThrow();
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.tag(MSTags.TitleLandTypes.MONSTERS).add((Object[])new TitleLandType[]{LandTypes.MONSTERS.get(), LandTypes.UNDEAD.get()});
    }

    public String getName() {
        return "Minestuck Title Land Type Tags";
    }
}

