/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.worldgen;

import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.world.biome.MSBiomes;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public final class MSBiomeProvider {
    public static void register(BootstrapContext<Biome> context) {
        HolderGetter features = context.lookup(Registries.PLACED_FEATURE);
        context.register(MSBiomes.SKAIA, (Object)MSBiomeProvider.skaiaBiome((HolderGetter<PlacedFeature>)features));
        context.register(MSBiomes.PROSPIT, (Object)MSBiomeProvider.prospitBiome());
        context.register(MSBiomes.DERSE, (Object)MSBiomeProvider.derseBiome());
        context.register(MSBiomes.VEIL, (Object)MSBiomeProvider.veilBiome((HolderGetter<PlacedFeature>)features));
        MSBiomes.DEFAULT_LAND.createForDataGen(context);
        MSBiomes.HIGH_HUMID_LAND.createForDataGen(context);
        MSBiomes.NO_RAIN_LAND.createForDataGen(context);
        MSBiomes.SNOW_LAND.createForDataGen(context);
    }

    private static Biome skaiaBiome(HolderGetter<PlacedFeature> features) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(MSEntityTypes.DERSITE_PAWN.get(), 2, 1, 10));
        spawnInfo.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(MSEntityTypes.DERSITE_BISHOP.get(), 1, 1, 1));
        spawnInfo.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(MSEntityTypes.DERSITE_ROOK.get(), 1, 1, 1));
        spawnInfo.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(MSEntityTypes.PROSPITIAN_PAWN.get(), 2, 1, 10));
        spawnInfo.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(MSEntityTypes.PROSPITIAN_BISHOP.get(), 1, 1, 1));
        spawnInfo.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(MSEntityTypes.PROSPITIAN_ROOK.get(), 1, 1, 1));
        BiomeGenerationSettings.PlainBuilder genSettings = new BiomeGenerationSettings.PlainBuilder();
        BiomeSpecialEffects.Builder ambience = new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011);
        ambience.fogColor(0xCDCDFF).skyColor(8037631);
        genSettings.addFeature(GenerationStep.Decoration.SURFACE_STRUCTURES, (Holder)features.getOrThrow(MSPlacedFeatures.ROOK_OUTPOST));
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(ambience.build()).mobSpawnSettings(spawnInfo.build()).generationSettings(genSettings.build()).build();
    }

    private static Biome prospitBiome() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(MSEntityTypes.PROSPITIAN_PAWN.get(), 2, 1, 10));
        BiomeGenerationSettings.PlainBuilder genSettings = new BiomeGenerationSettings.PlainBuilder();
        BiomeSpecialEffects.Builder ambience = new BiomeSpecialEffects.Builder().waterColor(65488).waterFogColor(49848).grassColorOverride(16757504).foliageColorOverride(15450368);
        ambience.fogColor(0).skyColor(0);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(ambience.build()).mobSpawnSettings(spawnInfo.build()).generationSettings(genSettings.build()).build();
    }

    private static Biome derseBiome() {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        spawnInfo.addSpawn(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(MSEntityTypes.DERSITE_PAWN.get(), 2, 1, 10));
        BiomeGenerationSettings.PlainBuilder genSettings = new BiomeGenerationSettings.PlainBuilder();
        BiomeSpecialEffects.Builder ambience = new BiomeSpecialEffects.Builder().waterColor(2490620).waterFogColor(2097366);
        ambience.fogColor(0).skyColor(0);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(ambience.build()).mobSpawnSettings(spawnInfo.build()).generationSettings(genSettings.build()).build();
    }

    private static Biome veilBiome(HolderGetter<PlacedFeature> features) {
        MobSpawnSettings.Builder spawnInfo = new MobSpawnSettings.Builder();
        BiomeGenerationSettings.PlainBuilder genSettings = new BiomeGenerationSettings.PlainBuilder();
        genSettings.addFeature(GenerationStep.Decoration.LOCAL_MODIFICATIONS, (Holder)features.getOrThrow(MSPlacedFeatures.VEIL_CRATER));
        BiomeSpecialEffects.Builder ambience = new BiomeSpecialEffects.Builder().waterColor(4159204).waterFogColor(329011);
        ambience.fogColor(0).skyColor(0);
        return new Biome.BiomeBuilder().hasPrecipitation(false).temperature(0.5f).downfall(0.5f).specialEffects(ambience.build()).mobSpawnSettings(spawnInfo.build()).generationSettings(genSettings.build()).build();
    }
}

