/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.worldgen;

import com.mraof.minestuck.world.gen.MSDensityFunctions;
import com.mraof.minestuck.world.gen.MSNoiseParameters;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.CubicSpline;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public final class MSDensityFunctionProvider {
    public static void register(BootstrapContext<DensityFunction> context) {
        HolderGetter noise = context.lookup(Registries.NOISE);
        DensityFunction shiftX = MSDensityFunctionProvider.registerAndGet(context, MSDensityFunctions.SHIFT_X, DensityFunctions.flatCache((DensityFunction)DensityFunctions.cache2d((DensityFunction)DensityFunctions.shiftA((Holder)noise.getOrThrow(Noises.SHIFT)))));
        DensityFunction shiftZ = MSDensityFunctionProvider.registerAndGet(context, MSDensityFunctions.SHIFT_Z, DensityFunctions.flatCache((DensityFunction)DensityFunctions.cache2d((DensityFunction)DensityFunctions.shiftB((Holder)noise.getOrThrow(Noises.SHIFT)))));
        Holder.Reference skaiaRidges = context.register(MSDensityFunctions.SKAIA_RIDGES, (Object)MSDensityFunctionProvider.base2dNoise(shiftX, shiftZ, (Holder<NormalNoise.NoiseParameters>)noise.getOrThrow(MSNoiseParameters.SKAIA_RIDGES)));
        DensityFunction skaiaOffset = MSDensityFunctionProvider.registerAndGet(context, MSDensityFunctions.SKAIA_OFFSET, MSDensityFunctionProvider.skaiaOffset((Holder<DensityFunction>)skaiaRidges));
        DensityFunction skaiaDepth = MSDensityFunctionProvider.registerAndGet(context, MSDensityFunctions.SKAIA_DEPTH, MSDensityFunctions.depth(skaiaOffset));
        DensityFunction skaiaFactor = DensityFunctions.constant((double)5.0);
        context.register(MSDensityFunctions.SKAIA_INITIAL_DENSITY, (Object)MSDensityFunctions.initialDensity(skaiaDepth, skaiaFactor));
        context.register(MSDensityFunctions.SKAIA_FINAL_DENSITY, (Object)MSDensityFunctions.finalDensity(skaiaDepth, skaiaFactor, DensityFunctions.zero(), (Holder<NormalNoise.NoiseParameters>)noise.getOrThrow(Noises.JAGGED), 256, 0.25f));
        Holder.Reference veilRidges = context.register(MSDensityFunctions.VEIL_RIDGES, (Object)MSDensityFunctionProvider.base2dNoise(shiftX, shiftZ, (Holder<NormalNoise.NoiseParameters>)noise.getOrThrow(MSNoiseParameters.VEIL_RIDGES)));
        DensityFunction veilOffset = MSDensityFunctionProvider.registerAndGet(context, MSDensityFunctions.VEIL_OFFSET, MSDensityFunctionProvider.veilOffset((Holder<DensityFunction>)veilRidges));
        DensityFunction veilDepth = MSDensityFunctionProvider.registerAndGet(context, MSDensityFunctions.VEIL_DEPTH, MSDensityFunctions.depth(veilOffset, 0, 208));
        DensityFunction veilFactor = DensityFunctions.constant((double)6.0);
        context.register(MSDensityFunctions.VEIL_INITIAL_DENSITY, (Object)MSDensityFunctions.initialDensity(veilDepth, veilFactor));
        context.register(MSDensityFunctions.VEIL_FINAL_DENSITY, (Object)MSDensityFunctions.finalDensity(veilDepth, veilFactor, DensityFunctions.zero(), (Holder<NormalNoise.NoiseParameters>)noise.getOrThrow(Noises.JAGGED), 208, 0.23f));
        context.register(MSDensityFunctions.LAND_CONTINENTS, (Object)MSDensityFunctionProvider.base2dNoise(shiftX, shiftZ, (Holder<NormalNoise.NoiseParameters>)noise.getOrThrow(MSNoiseParameters.LAND_CONTINENTS)));
        context.register(MSDensityFunctions.LAND_EROSION, (Object)MSDensityFunctionProvider.base2dNoise(shiftX, shiftZ, (Holder<NormalNoise.NoiseParameters>)noise.getOrThrow(MSNoiseParameters.LAND_EROSION)));
    }

    private static DensityFunction registerAndGet(BootstrapContext<DensityFunction> context, ResourceKey<DensityFunction> key, DensityFunction function) {
        return new DensityFunctions.HolderHolder((Holder)context.register(key, (Object)function));
    }

    private static DensityFunction skaiaOffset(Holder<DensityFunction> ridges) {
        CubicSpline.Builder builder = CubicSpline.builder((ToFloatFunction)new DensityFunctions.Spline.Coordinate(ridges));
        builder.addPoint(-1.5f, -0.2f);
        builder.addPoint(-0.5f, 1.0f);
        builder.addPoint(0.5f, -0.2f);
        builder.addPoint(1.5f, 1.0f);
        return DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.50375), (DensityFunction)DensityFunctions.spline((CubicSpline)builder.build()));
    }

    private static DensityFunction veilOffset(Holder<DensityFunction> ridges) {
        CubicSpline.Builder builder = CubicSpline.builder((ToFloatFunction)new DensityFunctions.Spline.Coordinate(ridges));
        builder.addPoint(-1.5f, -0.2f);
        builder.addPoint(-0.5f, 1.0f);
        builder.addPoint(0.5f, -0.2f);
        builder.addPoint(1.5f, 1.0f);
        return DensityFunctions.add((DensityFunction)DensityFunctions.constant((double)-0.50375), (DensityFunction)DensityFunctions.spline((CubicSpline)builder.build()));
    }

    private static DensityFunction base2dNoise(DensityFunction shiftX, DensityFunction shiftZ, Holder<NormalNoise.NoiseParameters> noise) {
        return DensityFunctions.flatCache((DensityFunction)DensityFunctions.shiftedNoise2d((DensityFunction)shiftX, (DensityFunction)shiftZ, (double)0.25, noise));
    }
}

