/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.worldgen;

import com.google.common.collect.ImmutableList;
import com.mraof.minestuck.block.AspectTreeBlocks;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.world.gen.feature.MSCFeatures;
import com.mraof.minestuck.world.gen.feature.MSPlacedFeatures;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.CaveFeatures;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraft.world.level.levelgen.placement.SurfaceWaterDepthFilter;

public final class MSPlacedFeatureProvider {
    public static void register(BootstrapContext<PlacedFeature> context) {
        HolderGetter features = context.lookup(Registries.CONFIGURED_FEATURE);
        context.register(MSPlacedFeatures.RETURN_NODE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RETURN_NODE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.VEIL_CRATER, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.VEIL_CRATER, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)35), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.ROOK_OUTPOST, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.ROOK_OUTPOST, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-4))})));
        context.register(MSPlacedFeatures.COG, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.COG, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)2), new PlacementModifier[0])));
        context.register(MSPlacedFeatures.UNCOMMON_COG, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.COG, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)10), new PlacementModifier[0])));
        context.register(MSPlacedFeatures.FLOOR_COG, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.FLOOR_COG, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)3), new PlacementModifier[0])));
        context.register(MSPlacedFeatures.UNCOMMON_FLOOR_COG, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.FLOOR_COG, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)20), new PlacementModifier[0])));
        context.register(MSPlacedFeatures.SURFACE_FOSSIL, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SURFACE_FOSSIL, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)5), new PlacementModifier[0])));
        context.register(MSPlacedFeatures.BROKEN_SWORD, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.BROKEN_SWORD, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)10), new PlacementModifier[0])));
        context.register(MSPlacedFeatures.UNCOMMON_BROKEN_SWORD, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.BROKEN_SWORD, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)50), new PlacementModifier[0])));
        context.register(MSPlacedFeatures.BUCKET, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.BUCKET, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)16), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.noFluid((Vec3i)Direction.DOWN.getNormal())), RandomOffsetPlacement.vertical((IntProvider)UniformInt.of((int)-2, (int)0))})));
        context.register(MSPlacedFeatures.CAKE_PEDESTAL, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CAKE_PEDESTAL, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)100), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.SMALL_LIBRARY, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SMALL_LIBRARY, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)64), new PlacementModifier[0])));
        context.register(MSPlacedFeatures.TOWER, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TOWER, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)20), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.PARCEL_PYXIS, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.PARCEL_PYXIS, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)60), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.noFluid())})));
        context.register(MSPlacedFeatures.FROG_RUINS, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.FROG_RUINS, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)60), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-3))})));
        context.register(MSPlacedFeatures.CARVED_CHERRY_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CARVED_CHERRY_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)64), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.CARVED_HOUSE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CARVED_HOUSE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.CARVED_LOG, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CARVED_LOG, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)64), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.LARGE_CARVED_LOG, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.LARGE_CARVED_LOG, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)512), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SPARSE_TREATED_CHAIR, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREATED_CHAIR, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)512), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.TREATED_CHAIR, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREATED_CHAIR, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.SPARSE_TREATED_TABLE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREATED_TABLE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)512), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.TREATED_TABLE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREATED_TABLE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.UNFINISHED_CARVED_BOOKSHELF, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_BOOKSHELF, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)256), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.SPARSE_UNFINISHED_CARVED_CHAIR, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_CHAIR, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)512), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.UNFINISHED_CARVED_CHAIR, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_CHAIR, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)64), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.UNFINISHED_CARVED_CREEPER, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_CREEPER, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.SPARSE_UNFINISHED_CARVED_DRAWER, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_DRAWER, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)512), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.UNFINISHED_CARVED_DRAWER, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_DRAWER, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)256), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.UNFINISHED_CARVED_SALAMANDER, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_SALAMANDER, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.SPARSE_UNFINISHED_CARVED_TABLE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_TABLE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)512), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.UNFINISHED_CARVED_TABLE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_TABLE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)64), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.UNFINISHED_CARVED_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)64), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.UNFINISHED_CARVED_TUNNEL, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.UNFINISHED_CARVED_TUNNEL, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.WOOD_SHAVINGS_PILE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.WOOD_SHAVINGS_PILE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)48), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.WOODEN_CACTUS_PAIR, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.WOODEN_CACTUS_PAIR, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)16), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.MASSIVE_CHAIR, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.MASSIVE_CHAIR, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.MASSIVE_STOOL, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.MASSIVE_STOOL, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)8), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.SULFUR_POOL, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SULFUR_POOL, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)4), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, RandomOffsetPlacement.vertical((IntProvider)UniformInt.of((int)-3, (int)0))})));
        context.register(MSPlacedFeatures.CAST_IRON_BUILDING, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CAST_IRON_BUILDING, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_WORLD_SURFACE, RandomOffsetPlacement.vertical((IntProvider)UniformInt.of((int)-1, (int)0))})));
        context.register(MSPlacedFeatures.CAST_IRON_PLATFORM, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CAST_IRON_PLATFORM, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)64), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.LARGE_CAKE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.LARGE_CAKE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)50), new PlacementModifier[0])));
        context.register(MSPlacedFeatures.BLOOD_POOL, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.BLOOD_POOL, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)5), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.OIL_POOL, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.OIL_POOL, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)12), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.OASIS, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.OASIS, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.OCEAN_RUNDOWN, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.OCEAN_RUNDOWN, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)3), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.FIRE_FIELD, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.FIRE_FIELD, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)7), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)256))})));
        context.register(MSPlacedFeatures.EXTRA_FIRE_FIELD, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.FIRE_FIELD, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)10), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)256))})));
        context.register(MSPlacedFeatures.COARSE_DIRT_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.COARSE_DIRT_DISK, MSPlacedFeatureProvider.singlePlacementModifiers(PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.SNOW_BLOCK_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SNOW_BLOCK_DISK, MSPlacedFeatureProvider.singlePlacementModifiers(PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.SMALL_SNOW_BLOCK_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SMALL_SNOW_BLOCK_DISK, MSPlacedFeatureProvider.singlePlacementModifiers(PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.ICE_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.ICE_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.SAND_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SAND_DISK, MSPlacedFeatureProvider.singlePlacementModifiers(PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.RED_SAND_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RED_SAND_DISK, MSPlacedFeatureProvider.singlePlacementModifiers(PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.SLIME_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SLIME_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.EXTRA_SLIME_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SLIME_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.NETHERRACK_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.NETHERRACK_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.MAGMATIC_IGNEOUS_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.MAGMATIC_IGNEOUS_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.BLACK_SAND_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.BLACK_SAND_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)8), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.PUMICE_STONE_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.PUMICE_STONE_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.TREATED_PLANKS_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREATED_PLANKS_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)16), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.LACQUERED_PLANKS_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.LACQUERED_PLANKS_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.TREATED_UNCARVED_WOOD_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREATED_UNCARVED_WOOD_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)2), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.TREATED_CHIPBOARD_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREATED_CHIPBOARD_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)8), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.CHIPBOARD_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREATED_CHIPBOARD_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)16), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.CARVED_PLANKS_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CARVED_PLANKS_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)2), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.COAGULATED_BLOOD_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.COAGULATED_BLOOD_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)56), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.COBBLESTONE_SURFACE_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.COBBLESTONE_SURFACE_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)20), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.STONE_SURFACE_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.STONE_SURFACE_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)20), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.END_GRASS_SURFACE_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.END_GRASS_SURFACE_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)5), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.END_STONE_SURFACE_DISK, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.END_STONE_SURFACE_DISK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)4), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.DRIPSTONE_CLUSTER, (Object)MSPlacedFeatureProvider.placed(features, CaveFeatures.DRIPSTONE_CLUSTER, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)22, (int)74)), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)60))})));
        context.register(MSPlacedFeatures.OCEANIC_DRIPSTONE_CLUSTER, (Object)MSPlacedFeatureProvider.placed(features, CaveFeatures.DRIPSTONE_CLUSTER, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)42, (int)96)), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)48))})));
        context.register(MSPlacedFeatures.LARGE_DRIPSTONE, (Object)MSPlacedFeatureProvider.placed(features, CaveFeatures.LARGE_DRIPSTONE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)10, (int)48)), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64))})));
        context.register(MSPlacedFeatures.POINTED_DRIPSTONE, (Object)MSPlacedFeatureProvider.placed(features, CaveFeatures.POINTED_DRIPSTONE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)100, (int)200)), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)60))})));
        context.register(MSPlacedFeatures.OCEANIC_POINTED_DRIPSTONE, (Object)MSPlacedFeatureProvider.placed(features, CaveFeatures.POINTED_DRIPSTONE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)164, (int)256)), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)48))})));
        context.register(MSPlacedFeatures.LUSH_CAVES_VEGETATION, (Object)MSPlacedFeatureProvider.placed(features, CaveFeatures.MOSS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)125), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), EnvironmentScanPlacement.scanningFor((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)1))})));
        context.register(MSPlacedFeatures.LUSH_CAVES_CEILING_VEGETATION, (Object)MSPlacedFeatureProvider.placed(features, CaveFeatures.MOSS_PATCH_CEILING, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)125), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1))})));
        context.register(MSPlacedFeatures.SPARSE_LUSH_CAVES_CEILING_VEGETATION, (Object)MSPlacedFeatureProvider.placed(features, CaveFeatures.MOSS_PATCH_CEILING, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)35), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)12), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-1))})));
        context.register(MSPlacedFeatures.CEILING_ROOTS, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CEILING_ROOTS, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)150), new PlacementModifier[]{HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.bottom(), (VerticalAnchor)VerticalAnchor.absolute((int)64)), EnvironmentScanPlacement.scanningFor((Direction)Direction.UP, (BlockPredicate)BlockPredicate.solid(), (BlockPredicate)BlockPredicate.ONLY_IN_AIR_PREDICATE, (int)1)})));
        context.register(MSPlacedFeatures.MESA, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.MESA, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)25), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.STONE_MOUND, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.STONE_MOUND, MSPlacedFeatureProvider.singlePlacementModifiers(PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.COBBLESTONE_BLOCK_BLOB, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.COBBLESTONE_BLOCK_BLOB, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)30), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SANDSTONE_BLOCK_BLOB, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SANDSTONE_BLOCK_BLOB, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)3)), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.EXTRA_SANDSTONE_BLOCK_BLOB, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SANDSTONE_BLOCK_BLOB, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)5)), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.RED_SANDSTONE_BLOCK_BLOB, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RED_SANDSTONE_BLOCK_BLOB, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)3)), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.EXTRA_RED_SANDSTONE_BLOCK_BLOB, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RED_SANDSTONE_BLOCK_BLOB, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((IntProvider)UniformInt.of((int)0, (int)5)), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.RANDOM_ROCK_BLOCK_BLOB, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RANDOM_ROCK_BLOCK_BLOB, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)20), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.LARGE_RANDOM_ROCK_BLOCK_BLOB, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.LARGE_RANDOM_ROCK_BLOCK_BLOB, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)30), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SHADE_STONE_BLOCK_BLOB, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SHADE_STONE_BLOCK_BLOB, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)12), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR)));
        context.register(MSPlacedFeatures.FOREST_ROCK, (Object)MSPlacedFeatureProvider.placed(features, MiscOverworldFeatures.FOREST_ROCK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)12), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.SMALL_PILLAR, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SMALL_PILLAR, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)4), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.MIXED_PILLARS, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.MIXED_PILLARS, MSPlacedFeatureProvider.singlePlacementModifiers(PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.MIXED_PILLARS_EXTRA, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.MIXED_PILLARS, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)3), PlacementUtils.HEIGHTMAP_TOP_SOLID)));
        context.register(MSPlacedFeatures.ICE_SPIKE, (Object)MSPlacedFeatureProvider.placed(features, MiscOverworldFeatures.ICE_SPIKE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)16), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.DARK_OAK, (Object)MSPlacedFeatureProvider.placed(features, TreeFeatures.DARK_OAK, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)10), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)Blocks.DARK_OAK_SAPLING)})));
        context.register(MSPlacedFeatures.RAINBOW_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RAINBOW_TREE, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.RAINBOW_SAPLING.get()))})));
        context.register(MSPlacedFeatures.EXTRA_RAINBOW_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RAINBOW_TREE, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)4, (float)0.1f, (int)1), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.RAINBOW_SAPLING.get()))})));
        context.register(MSPlacedFeatures.END_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.END_TREE, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.END_SAPLING.get()))})));
        BlockPredicate onBlueDirt = BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)MSBlocks.BLUE_DIRT.get()});
        context.register(MSPlacedFeatures.GLOWING_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.GLOWING_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)2), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, BlockPredicateFilter.forPredicate((BlockPredicate)onBlueDirt)})));
        context.register(MSPlacedFeatures.SHADEWOOD_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SHADEWOOD_TREE, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)3, (float)0.1f, (int)2), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)onBlueDirt)})));
        context.register(MSPlacedFeatures.SCARRED_SHADEWOOD_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SCARRED_SHADEWOOD_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)15), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)onBlueDirt)})));
        context.register(MSPlacedFeatures.ORNATE_SHADEWOOD_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.ORNATE_SHADEWOOD_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)6), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)onBlueDirt)})));
        BlockPredicate onDirt = BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{Blocks.DIRT, Blocks.GRASS_BLOCK, Blocks.PODZOL, Blocks.ROOTED_DIRT});
        context.register(MSPlacedFeatures.TREE_STUMP, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREE_STUMP, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)40), new PlacementModifier[]{PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)onDirt), RandomOffsetPlacement.vertical((IntProvider)ConstantInt.of((int)-4))})));
        context.register(MSPlacedFeatures.PETRIFIED_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.PETRIFIED_TREE, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)2, (float)0.5f, (int)1), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.PETRIFIED_GRASS.get()))})));
        context.register(MSPlacedFeatures.SPARSE_PETRIFIED_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.PETRIFIED_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)20), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.PETRIFIED_GRASS.get()))})));
        context.register(MSPlacedFeatures.DEAD_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.DEAD_TREE, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)1, (float)0.1f, (int)1), new PlacementModifier[]{SurfaceWaterDepthFilter.forMaxDepth((int)2), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)MSBlocks.CHALK.get()}))})));
        context.register(MSPlacedFeatures.EXTRA_DEAD_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.DEAD_TREE, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)2, (float)0.1f, (int)1), new PlacementModifier[]{SurfaceWaterDepthFilter.forMaxDepth((int)2), PlacementUtils.HEIGHTMAP_OCEAN_FLOOR, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.matchesBlocks((Vec3i)Direction.DOWN.getNormal(), (Block[])new Block[]{(Block)MSBlocks.CHALK.get()}))})));
        context.register(MSPlacedFeatures.CINDERED_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CINDERED_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)20), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.SINGED_GRASS.get()))})));
        context.register(MSPlacedFeatures.FROST_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.FROST_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)5), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.FROST_SAPLING.get()))})));
        context.register(MSPlacedFeatures.BLOOD_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.BLOOD_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.BLOOD_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.BREATH_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.BREATH_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.BREATH_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.DOOM_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.DOOM_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.DOOM_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.HEART_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.HEART_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.HEART_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.HOPE_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.HOPE_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.HOPE_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.LIFE_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.LIFE_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.LIFE_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.LIGHT_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.LIGHT_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.LIGHT_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.MIND_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.MIND_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.MIND_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.RAGE_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RAGE_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.RAGE_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.SPACE_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SPACE_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.SPACE_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.TIME_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TIME_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.TIME_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.VOID_TREE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.VOID_TREE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)350), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)AspectTreeBlocks.VOID_ASPECT_SAPLING.asBlock())})));
        context.register(MSPlacedFeatures.FOREST_LAND_TREES, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.FOREST_LAND_TREES, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)5, (float)0.1f, (int)1), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.DENSE_FOREST_LAND_TREES, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.FOREST_LAND_TREES, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)12, (float)0.1f, (int)1), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.TAIGA_LAND_TREES, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TAIGA_LAND_TREES, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)5, (float)0.1f, (int)1), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.DENSE_TAIGA_LAND_TREES, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TAIGA_LAND_TREES, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)12, (float)0.1f, (int)1), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.HUGE_MUSHROOMS, (Object)MSPlacedFeatureProvider.placed(features, VegetationFeatures.MUSHROOM_ISLAND_VEGETATION, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)3), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SPARSE_JUNGLE_GRASS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, VegetationFeatures.PATCH_GRASS_JUNGLE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)15), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.STRAWBERRY_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.STRAWBERRY_PATCH, MSPlacedFeatureProvider.singlePlacementModifiers(PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.RARE_STRAWBERRY_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.STRAWBERRY_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)60), PlacementUtils.HEIGHTMAP_WORLD_SURFACE)));
        context.register(MSPlacedFeatures.GLOWING_MUSHROOM_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.GLOWING_MUSHROOM_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)1), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SPARSE_GLOWING_MUSHROOM_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.GLOWING_MUSHROOM_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)4), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.BROWN_MUSHROOM_PATCH, (Object)MSPlacedFeatureProvider.placed(features, VegetationFeatures.PATCH_BROWN_MUSHROOM, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)120), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.RED_MUSHROOM_PATCH, (Object)MSPlacedFeatureProvider.placed(features, VegetationFeatures.PATCH_RED_MUSHROOM, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)120), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.WOODEN_GRASS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.WOODEN_GRASS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)1), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.TREATED_WOODEN_GRASS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TREATED_WOODEN_GRASS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)1), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.LACQUERED_WOODEN_MUSHROOM_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.LACQUERED_WOODEN_MUSHROOM_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)30), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.CARVED_BUSH_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CARVED_BUSH_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)30), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.TALL_END_GRASS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TALL_END_GRASS_PATCH, MSPlacedFeatureProvider.worldGenModifiers(PlacementUtils.countExtra((int)4, (float)0.1f, (int)1), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.TALL_END_GRASS.get()))})));
        context.register(MSPlacedFeatures.PETRIFIED_GRASS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.PETRIFIED_GRASS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)30), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SPARSE_PETRIFIED_GRASS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.PETRIFIED_GRASS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)60), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.PETRIFIED_POPPY_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.PETRIFIED_POPPY_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)15), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SPARSE_PETRIFIED_POPPY_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.PETRIFIED_POPPY_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)30), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SINGED_GRASS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SINGED_GRASS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)8), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.SINGED_GRASS.get()))})));
        context.register(MSPlacedFeatures.SINGED_FOLIAGE_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SINGED_FOLIAGE_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)8), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.SINGED_GRASS.get()))})));
        context.register(MSPlacedFeatures.IGNEOUS_SPIKE_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.IGNEOUS_SPIKE_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)32), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SULFUR_BUBBLE_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SULFUR_BUBBLE_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)64), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.SULFUR_BUBBLE.get()))})));
        context.register(MSPlacedFeatures.DESERT_BUSH_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.DESERT_BUSH_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)30), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SANDY_GRASS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.SANDY_GRASS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)25), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.TALL_SANDY_GRASS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TALL_SANDY_GRASS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)25), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.TALL_SANDY_GRASS.get()))})));
        context.register(MSPlacedFeatures.TALL_DEAD_BUSH_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.TALL_DEAD_BUSH_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)45), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, PlacementUtils.filteredByBlockSurvival((Block)((Block)MSBlocks.TALL_DEAD_BUSH.get()))})));
        context.register(MSPlacedFeatures.SPARSE_DESERT_BUSH_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.DESERT_BUSH_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)120), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.MOSS_CARPET_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.MOSS_CARPET_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)6), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.SPARSE_MOSS_CARPET_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.MOSS_CARPET_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)16), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.AZALEA_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.AZALEA_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)16), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.BLOOMING_CACTUS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.BLOOMING_CACTUS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)30), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.WATERLILY_PATCH, (Object)MSPlacedFeatureProvider.placed(features, VegetationFeatures.PATCH_WATERLILY, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)15), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.CRIMSON_FUNGUS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CRIMSON_FUNGUS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)12), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.WARPED_FUNGUS_PATCH, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.WARPED_FUNGUS_PATCH, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)12), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.PUMPKIN, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.PUMPKIN, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)128), PlacementUtils.HEIGHTMAP)));
        context.register(MSPlacedFeatures.RABBIT_PLACEMENT, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RABBIT_PLACEMENT, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)2), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.noFluid())})));
        context.register(MSPlacedFeatures.SMALL_RABBIT_PLACEMENT, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.RABBIT_PLACEMENT, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)RarityFilter.onAverageOnceEvery((int)20), new PlacementModifier[]{PlacementUtils.HEIGHTMAP, BlockPredicateFilter.forPredicate((BlockPredicate)BlockPredicate.noFluid())})));
        context.register(MSPlacedFeatures.CRUXITE_ORE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.CRUXITE_ORE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)21), new PlacementModifier[]{HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)128))})));
        context.register(MSPlacedFeatures.URANIUM_ORE, (Object)MSPlacedFeatureProvider.placed(features, MSCFeatures.URANIUM_ORE, MSPlacedFeatureProvider.worldGenModifiers((PlacementModifier)CountPlacement.of((int)13), new PlacementModifier[]{HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.aboveBottom((int)-60), (VerticalAnchor)VerticalAnchor.aboveBottom((int)96))})));
    }

    private static PlacedFeature placed(HolderGetter<ConfiguredFeature<?, ?>> registry, ResourceKey<ConfiguredFeature<?, ?>> key, List<PlacementModifier> modifiers) {
        return new PlacedFeature((Holder)registry.getOrThrow(key), modifiers);
    }

    private static List<PlacementModifier> singlePlacementModifiers(PlacementModifier ... afterSquareModifiers) {
        return MSPlacedFeatureProvider.worldGenModifiers(null, afterSquareModifiers);
    }

    private static List<PlacementModifier> worldGenModifiers(@Nullable PlacementModifier frequency, PlacementModifier ... afterSquareModifiers) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        if (frequency != null) {
            builder.add((Object)frequency);
        }
        builder.add((Object)InSquarePlacement.spread());
        for (PlacementModifier modifier : afterSquareModifiers) {
            builder.add((Object)modifier);
        }
        builder.add((Object)BiomeFilter.biome());
        return builder.build();
    }
}

