/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.data.worldgen;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.util.MSTags;
import com.mraof.minestuck.world.gen.structure.FrogTempleStructure;
import com.mraof.minestuck.world.gen.structure.ImpDungeonStructure;
import com.mraof.minestuck.world.gen.structure.LargeWoodObjectStructure;
import com.mraof.minestuck.world.gen.structure.MSStructures;
import com.mraof.minestuck.world.gen.structure.PinkTowerStructure;
import com.mraof.minestuck.world.gen.structure.SmallRuinStructure;
import com.mraof.minestuck.world.gen.structure.castle.CastleStructure;
import com.mraof.minestuck.world.gen.structure.gate.GateStructure;
import com.mraof.minestuck.world.gen.structure.gate.LandGatePlacement;
import com.mraof.minestuck.world.gen.structure.village.ConsortVillageStructure;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public final class MSStructureProvider {
    public static void registerStructures(BootstrapContext<Structure> context) {
        HolderGetter biomes = context.lookup(Registries.BIOME);
        HolderGetter pools = context.lookup(Registries.TEMPLATE_POOL);
        context.register(MSStructures.FROG_TEMPLE, (Object)new FrogTempleStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MSTags.Biomes.HAS_FROG_TEMPLE), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.register(MSStructures.LAND_GATE, (Object)new GateStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MSTags.Biomes.HAS_LAND_GATE), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.register(MSStructures.SMALL_RUIN, (Object)new SmallRuinStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MSTags.Biomes.HAS_SMALL_RUIN), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.register(MSStructures.ImpDungeon.KEY, (Object)new ImpDungeonStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MSTags.Biomes.HAS_IMP_DUNGEON), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.register(MSStructures.ConsortVillage.KEY, (Object)new ConsortVillageStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MSTags.Biomes.HAS_CONSORT_VILLAGE), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.register(MSStructures.LARGE_WOOD_OBJECT, (Object)new LargeWoodObjectStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MSTags.Biomes.LAND_ROUGH), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.register(MSStructures.PINK_TOWER, (Object)new PinkTowerStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MSTags.Biomes.LAND_NORMAL), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.BEARD_THIN)));
        context.register(MSStructures.SkaiaCastle.KEY, (Object)new CastleStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MSTags.Biomes.HAS_SKAIA_CASTLE), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE)));
        context.register(MSStructures.SKAIAN_CATHEDRAL, (Object)new JigsawStructure(new Structure.StructureSettings((HolderSet)biomes.getOrThrow(MSTags.Biomes.HAS_SKAIAN_CATHEDRAL), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), (Holder)pools.getOrThrow(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)Minestuck.id("skaian_cathedral/front"))), 7, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)-6)), false, Heightmap.Types.WORLD_SURFACE_WG));
    }

    public static void registerStructureSets(BootstrapContext<StructureSet> context) {
        HolderGetter structures = context.lookup(Registries.STRUCTURE);
        context.register(MSStructureProvider.key("frog_temple"), (Object)new StructureSet((Holder)structures.getOrThrow(MSStructures.FROG_TEMPLE), (StructurePlacement)new RandomSpreadStructurePlacement(140, 92, RandomSpreadType.LINEAR, 41361201)));
        context.register(MSStructureProvider.key("land_gate"), (Object)new StructureSet((Holder)structures.getOrThrow(MSStructures.LAND_GATE), (StructurePlacement)new LandGatePlacement()));
        context.register(MSStructureProvider.key("skaia_castle"), (Object)new StructureSet((Holder)structures.getOrThrow(MSStructures.SkaiaCastle.KEY), (StructurePlacement)new RandomSpreadStructurePlacement(50, 40, RandomSpreadType.LINEAR, 6729346)));
        context.register(MSStructureProvider.key("skaian_cathedral"), (Object)new StructureSet((Holder)structures.getOrThrow(MSStructures.SKAIAN_CATHEDRAL), (StructurePlacement)new RandomSpreadStructurePlacement(40, 10, RandomSpreadType.LINEAR, 1481098009)));
    }

    private static ResourceKey<StructureSet> key(String path) {
        return ResourceKey.create((ResourceKey)Registries.STRUCTURE_SET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)path));
    }
}

