/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.effects;

import com.mraof.minestuck.effects.MSEffects;
import com.mraof.minestuck.item.artifact.CruxiteArtifactItem;
import com.mraof.minestuck.network.StopCreativeShockEffectPacket;
import com.mraof.minestuck.util.MSTags;
import java.util.Set;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnderpearlItem;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.EffectCure;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class CreativeShockEffect
extends MobEffect {
    public static final int LIMIT_BLOCK_PLACEMENT_AND_BREAKING = 0;
    public static final int LIMIT_MACHINE_INTERACTIONS = 1;
    public static final int LIMIT_MOBILITY_ITEMS = 2;

    protected CreativeShockEffect() {
        super(MobEffectCategory.NEUTRAL, 4670781);
    }

    public static boolean doesCreativeShockLimit(Player player, int survivalAmplifierThreshold) {
        return CreativeShockEffect.doesCreativeShockLimit(player, survivalAmplifierThreshold, survivalAmplifierThreshold + 3);
    }

    public static boolean doesCreativeShockLimit(Player player, int survivalAmplifierThreshold, int creativeAmplifierThreshold) {
        if (player.hasEffect(MSEffects.CREATIVE_SHOCK)) {
            return player.getEffect(MSEffects.CREATIVE_SHOCK).getAmplifier() >= (player.isCreative() ? creativeAmplifierThreshold : survivalAmplifierThreshold);
        }
        return false;
    }

    public static void stopElytraFlying(Player player, int survivalAmplifierThreshold) {
        if (CreativeShockEffect.doesCreativeShockLimit(player, survivalAmplifierThreshold)) {
            player.stopFallFlying();
        }
    }

    public void fillEffectCures(Set<EffectCure> cures, MobEffectInstance effectInstance) {
    }

    public boolean applyEffectTick(LivingEntity entityLivingBaseIn, int amplifier) {
        if (!(entityLivingBaseIn instanceof Player)) {
            return false;
        }
        Player player = (Player)entityLivingBaseIn;
        if (CreativeShockEffect.doesCreativeShockLimit(player, 0)) {
            player.getAbilities().mayBuild = false;
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 5 == 0;
    }

    @SubscribeEvent
    public static void onPlayerTickEvent(PlayerTickEvent.Pre event) {
        if (event.getEntity().hasEffect(MSEffects.CREATIVE_SHOCK)) {
            int duration = event.getEntity().getEffect(MSEffects.CREATIVE_SHOCK).getDuration();
            if (duration >= 5) {
                if (CreativeShockEffect.doesCreativeShockLimit(event.getEntity(), 0)) {
                    event.getEntity().getAbilities().mayBuild = false;
                }
                CreativeShockEffect.stopElytraFlying(event.getEntity(), 2);
            } else {
                Player player = event.getEntity();
                if (player instanceof ServerPlayer) {
                    ServerPlayer player2 = (ServerPlayer)player;
                    event.getEntity().getAbilities().mayBuild = player2.gameMode.getGameModeForPlayer().isBlockPlacingRestricted();
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (CreativeShockEffect.doesCreativeShockLimit(event.getEntity(), 0)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (CreativeShockEffect.doesCreativeShockLimit(event.getEntity(), 0)) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public static void onHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (CreativeShockEffect.doesCreativeShockLimit(event.getEntity(), 0)) {
            event.setCanHarvest(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=false)
    public static void onExplosionCreativeShock(ExplosionEvent.Start event) {
        Player player;
        LivingEntity sourceEntity = event.getExplosion().getIndirectSourceEntity();
        if (sourceEntity instanceof Player && CreativeShockEffect.doesCreativeShockLimit(player = (Player)sourceEntity, 0)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        if (CreativeShockEffect.doesCreativeShockLimit(event.getEntity(), 0) && (event.getItemStack().getItem() instanceof CruxiteArtifactItem || event.getItemStack().getItem() instanceof EnderpearlItem || event.getItemStack().is(MSTags.Items.CREATIVE_SHOCK_RIGHT_CLICK_LIMIT))) {
            event.setCanceled(true);
        }
    }

    public static void onEffectEnd(ServerPlayer serverPlayerEntity) {
        serverPlayerEntity.getAbilities().mayBuild = !serverPlayerEntity.gameMode.getGameModeForPlayer().isBlockPlacingRestricted();
        StopCreativeShockEffectPacket packet = new StopCreativeShockEffectPacket(serverPlayerEntity.gameMode.getGameModeForPlayer().isBlockPlacingRestricted());
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayerEntity, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

