/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.effects;

import com.mraof.minestuck.effects.MSEffects;
import com.mraof.minestuck.util.MSTags;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class SoporSicknessEffect
extends MobEffect {
    protected SoporSicknessEffect() {
        super(MobEffectCategory.NEUTRAL, 4670781);
    }

    public boolean applyEffectTick(LivingEntity target, int effectLevel) {
        if (target.getHealth() > 5.0f) {
            target.hurt(target.damageSources().generic(), 0.5f);
        }
        return true;
    }

    @SubscribeEvent
    public static void effectApplicabilityEvent(MobEffectEvent.Applicable event) {
        MobEffectInstance soporEffect;
        boolean inWhitelist;
        LivingEntity entity = event.getEntity();
        MobEffectInstance effectInstance = event.getEffectInstance();
        Holder effect = effectInstance.getEffect();
        Optional tag = BuiltInRegistries.MOB_EFFECT.getTag(MSTags.Effects.SOPOR_SICKNESS_WHITELIST);
        boolean bl = inWhitelist = tag.isPresent() && ((HolderSet.Named)tag.get()).contains(effect);
        if (entity.hasEffect(MSEffects.SOPOR_SICKNESS) && inWhitelist && (soporEffect = entity.getEffect(MSEffects.SOPOR_SICKNESS)) != null && effectInstance.getAmplifier() <= soporEffect.getAmplifier()) {
            event.setResult(MobEffectEvent.Applicable.Result.DO_NOT_APPLY);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        int durationInterval = (int)(Math.pow((double)amplifier / 100.0 + 0.015, -1.0) + 10.0);
        return duration % durationInterval == 0;
    }
}

