/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.effects;

import com.mraof.minestuck.effects.MSEffects;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityMountEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class SuspicionEffect
extends MobEffect {
    private static final float RANGE_SCALE = 1.0f;

    protected SuspicionEffect() {
        super(MobEffectCategory.HARMFUL, 2884745);
    }

    private static boolean isPushable(Entity entity) {
        Mob mob;
        return !(entity instanceof Player || entity instanceof ArmorStand || entity instanceof Mob && (mob = (Mob)entity).isNoAi());
    }

    private static boolean isFlying(Entity entity) {
        return entity instanceof FlyingMob || entity instanceof FlyingAnimal;
    }

    private static boolean hasEffect(Entity entity) {
        LivingEntity livingEntity;
        return SuspicionEffect.isPushable(entity) && entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).hasEffect(MSEffects.SUSPICION);
    }

    @SubscribeEvent
    public static void onMount(EntityMountEvent event) {
        Entity entityBeingMounted;
        Entity entityMounting = event.getEntityMounting();
        if (SuspicionEffect.hasEffect(entityMounting)) {
            event.setCanceled(true);
        }
        if (SuspicionEffect.hasEffect(entityBeingMounted = event.getEntityBeingMounted())) {
            event.setCanceled(true);
        }
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 2 == 0;
    }

    public boolean applyEffectTick(@NotNull LivingEntity pLivingEntity, int pAmplifier) {
        super.applyEffectTick(pLivingEntity, pAmplifier);
        if (!SuspicionEffect.isPushable((Entity)pLivingEntity)) {
            return false;
        }
        if (pLivingEntity.getVehicle() != null) {
            pLivingEntity.dismountTo(pLivingEntity.getX(), pLivingEntity.getY(), pLivingEntity.getZ());
        }
        if (!pLivingEntity.getPassengers().isEmpty()) {
            pLivingEntity.ejectPassengers();
        }
        if (!pLivingEntity.onGround() && !SuspicionEffect.isFlying((Entity)pLivingEntity)) {
            return true;
        }
        double range = 1.0 * Math.pow(pAmplifier, 0.6);
        for (LivingEntity otherEntity : pLivingEntity.level().getEntitiesOfClass(LivingEntity.class, pLivingEntity.getBoundingBox().inflate(range, 1.0, range))) {
            if (otherEntity == pLivingEntity || !otherEntity.hasEffect(MSEffects.SUSPICION)) continue;
            Vec3 push = otherEntity.position().vectorTo(pLivingEntity.position()).multiply(1.0, 0.0, 1.0);
            double pushForce = 1.0 / Math.max(push.length(), 1.0);
            push = push.normalize().scale(pushForce);
            pLivingEntity.push(push.x, 0.0, push.z);
        }
        return true;
    }
}

